﻿## SA1517

<table>
<tr>
  <td>TypeName</td>
  <td>SA1517CodeMustNotContainBlankLinesAtStartOfFile</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1517</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

The code file has blank lines at the start.

## Rule description

To improve the layout of the code, StyleCop requires no blank lines at the start of files.

A violation of this rule occurs when one or more blank lines are at the start of the file.

## How to fix violations

To fix a violation of this rule, remove the blank lines from the start of the file.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1517:CodeMustNotContainBlankLinesAtStartOfFile", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1517 // CodeMustNotContainBlankLinesAtStartOfFile
#pragma warning restore SA1517 // CodeMustNotContainBlankLinesAtStartOfFile
```
