## SA1642

<table>
<tr>
  <td>TypeName</td>
  <td>SA1642ConstructorSummaryDocumentationMustBeginWithStandardText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1642</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The XML documentation header for a C# constructor does not contain the appropriate summary text.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the
use of XML documentation headers. For an introduction to these headers and a description of the header syntax, see the
following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when the summary tag within the documentation header for a constructor does not begin
with the proper text.

The rule is intended to standardize the summary text for a constructor based on the access level of the constructor. The
summary for an instance constructor should begin with "Initializes a new instance of the {class name} class." For example,
the following shows the constructor for the `Customer` class.

```csharp
/// <summary>
/// Initializes a new instance of the <see cref="Customer"/> class.
/// </summary>
public Customer()
{
}
```

If documenting a struct, the summary should contain the word 'struct' instead of 'class'. For example, the following shows the constructor for the `MyStruct` struct.

```csharp
/// <summary>
/// Initializes a new instance of the <see cref="MyStruct"/> struct.
/// </summary>
public MyStruct()
{
}
```

If the class contains generic parameters, these can be annotated within the `cref` link using either of the following
two formats:

```csharp
/// <summary>
/// Initializes a new instance of the <see cref="Customer`1"/> class.
/// </summary>
public Customer()
{
}

/// <summary>
/// Initializes a new instance of the <see cref="Customer{T}"/> class.
/// </summary>
public Customer()
{
}
```

If the constructor is static, the summary text should begin with "Initializes static members of the {class name} class."
For example:

```csharp
/// <summary>
/// Initializes static members of the <see cref="Customer"/> class.
/// </summary>
public static Customer()
{
}
```

For compatibility with StyleCop Classic, private instance constructors are allowed to use the summary text "Prevents a
default instance of the {class name} class from being created." New code is encouraged to use the form above instead for
all instance constructors.

```csharp
/// <summary>
/// Prevents a default instance of the <see cref="Customer"/> class from being created.
/// </summary>
private Customer()
{
}
```

## How to fix violations

To fix a violation of this rule, edit the summary text for the constructor as described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1642:ConstructorSummaryDocumentationMustBeginWithStandardText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1642 // ConstructorSummaryDocumentationMustBeginWithStandardText
#pragma warning restore SA1642 // ConstructorSummaryDocumentationMustBeginWithStandardText
```
