<h2>Why is this an issue?</h2>
<p>As documented in <code>Enumeration</code> 's Javadoc, you should favor the <code>Iterator</code> interface over <code>Enumeration</code>.
<code>Iterator</code> offers a similar contract to <code>Enumeration</code> with the addition of a method for removal and shorter method names.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass implements Enumeration {  // Noncompliant
  /* ... */
}
```
<h3>Compliant solution</h3>

```java
public class MyClass implements Iterator {     // Compliant
  /* ... */
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/8/docs/api/java/util/Enumeration.html">docs.oracle.com</a> - Enumeration </li>
</ul>