<h2>Why is this an issue?</h2>
<p><code>switch</code> statements are useful when there are many different cases depending on the value of the same expression.</p>
<p>For just one or two cases, however, the code will be more readable with <code>if</code> statements.</p>
<h3>Noncompliant code example</h3>

```java
switch (variable) {
  case 0:
    doSomething();
    break;
  default:
    doSomethingElse();
    break;
}
```
<h3>Compliant solution</h3>

```java
if (variable == 0) {
  doSomething();
} else {
  doSomethingElse();
}
```