<h2>Why is this an issue?</h2>
<p>The requirement for a final <code>default</code> clause is defensive programming. The clause should either take appropriate action, or contain a
suitable comment as to why no action is taken.</p>
<h3>Noncompliant code example</h3>

```java
switch (param) {  //missing default clause
  case 0:
    doSomething();
    break;
  case 1:
    doSomethingElse();
    break;
}

switch (param) {
  default: // default clause should be the last one
    error();
    break;
  case 0:
    doSomething();
    break;
  case 1:
    doSomethingElse();
    break;
}
```
<h3>Compliant solution</h3>

```java
switch (param) {
  case 0:
    doSomething();
    break;
  case 1:
    doSomethingElse();
    break;
  default:
    error();
    break;
}
```
<h3>Exceptions</h3>
<p>If the <code>switch</code> parameter is an <code>Enum</code> and if all the constants of this enum are used in the <code>case</code> statements,
then no <code>default</code> clause is expected.</p>
<p>Example:</p>

```java
public enum Day {
    SUNDAY, MONDAY
}
...
switch(day) {
  case SUNDAY:
    doSomething();
    break;
  case MONDAY:
    doSomethingElse();
    break;
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/478">CWE-478 - Missing Default Case in Switch Statement</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/RtYxBQ">CERT, MSC01-C.</a> - Strive for logical completeness </li>
</ul>