<h2>Why is this an issue?</h2>
<p>It’s confusing to have a class member with the same name (case differences aside) as its enclosing class. This is particularly so when you consider
the common practice of naming a class instance for the class itself.</p>
<p>Best practice dictates that any field or member with the same name as the enclosing class be renamed to be more descriptive of the particular
aspect of the class it represents or holds.</p>
<h3>Noncompliant code example</h3>

```java
public class Foo {
  private String foo;

  public String getFoo() { }
}

Foo foo = new Foo();
foo.getFoo() // what does this return?
```
<h3>Compliant solution</h3>

```java
public class Foo {
  private String name;

  public String getName() { }
}

//...

Foo foo = new Foo();
foo.getName()
```
<h3>Exceptions</h3>
<p>When the type of the field is the containing class and that field is static, no issue is raised to allow singletons named like the type.</p>

```java
public class Foo {
  ...
  private static Foo foo;
  public Foo getInstance() {
    if(foo==null) {
      foo = new Foo();
    }
    return foo;
  }
  ...
}
```