<h2>Why is this an issue?</h2>
<p>If a lock is acquired and released within a method, then it must be released along all execution paths of that method.</p>
<p>Failing to do so will expose the conditional locking logic to the method’s callers and hence be deadlock-prone.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass {
  public void doSomething() {
    Lock lock = new Lock();
    lock.lock(); // Noncompliant
    if (isInitialized()) {
      // ...
      lock.unlock();
    }
  }
}
```
<h3>Compliant solution</h3>

```java
public class MyClass {
  public void doSomething() {
    Lock lock = new Lock();
    if (isInitialized()) {
      lock.lock();
      // ...
      lock.unlock();
    }
  }
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/459">CWE-459 - Incomplete Cleanup</a> </li>
</ul>