<h2>Why is this an issue?</h2>
<p>There is no good reason to have a mutable object as the <code>public</code> (by default), <code>static</code> member of an <code>interface</code>.
Such variables should be moved into classes and their visibility lowered.</p>
<p>Similarly, mutable <code>static</code> members of classes and enumerations which are accessed directly, rather than through getters and setters,
should be protected to the degree possible. That can be done by reducing visibility or making the field <code>final</code> if appropriate.</p>
<p>Note that making a mutable field, such as an array, <code>final</code> will keep the variable from being reassigned, but doing so has no effect on
the mutability of the internal state of the array (i.e. it doesn’t accomplish the goal).</p>
<p>This rule raises issues for <code>public static</code> array, <code>Collection</code>, <code>Date</code>, and <code>awt.Point</code> members.</p>
<h3>Noncompliant code example</h3>

```java
public interface MyInterface {
  public static String [] strings; // Noncompliant
}

public class A {
  public static String [] strings1 = {"first","second"};  // Noncompliant
  public static String [] strings2 = {"first","second"};  // Noncompliant
  public static List<String> strings3 = new ArrayList<>();  // Noncompliant
  // ...
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/582">CWE-582 - Array Declared Public, Final, and Static</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/607">CWE-607 - Public Static Final Field References Mutable Object</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/LjdGBQ">CERT, OBJ01-J.</a> - Limit accessibility of fields </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/VzZGBQ">CERT, OBJ13-J.</a> - Ensure that references to mutable objects are not exposed </li>
</ul>