<h2>Why is this an issue?</h2>
<p>In Java, an enum is a special data type that allows you to define a set of constants. Nested enum types, also known as inner enum types, are enum
types that are defined within another class or interface.</p>
<p>Nested enum types are implicitly static, so there is no need to declare them <code>static</code> explicitly.</p>
<h3>Noncompliant code example</h3>

```java
public class Flower {
  static enum Color { // Noncompliant; static is redundant here
    RED, YELLOW, BLUE, ORANGE
  }
  // ...
}
```
<h3>Compliant solution</h3>

```java
public class Flower {
  enum Color { // Compliant
    RED, YELLOW, BLUE, ORANGE
  }
  // ...
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/specs/jls/se20/html/jls-8.html#jls-8.9">Java Language Specification-8.9</a> </li>
</ul>