<h2>Why is this an issue?</h2>
<p>The use of Unicode escape sequences should be reserved for characters that would otherwise be ambiguous, such as unprintable characters.</p>
<p>This rule ignores sequences composed entirely of Unicode characters, but otherwise raises an issue for each Unicode character that represents a
printable character.</p>
<h3>Noncompliant code example</h3>

```java
String prefix = "n\u00E9e"; // Noncompliant
```
<h3>Compliant solution</h3>

```java
String prefix = "née";
```