<h2>Why is this an issue?</h2>
<p>By definition, primitive types are not Objects and so they can’t be <code>null</code>. Adding <code>@CheckForNull</code> or <code>@Nullable</code>
on primitive types adds confusion and is useless.</p>
<p>This rule raises an issue when <code>@CheckForNull</code> or <code>@Nullable</code> is set on a method returning a primitive type: byte, short,
int, long, float, double, boolean, char.</p>
<h3>Noncompliant code example</h3>

```java
@CheckForNull
boolean isFoo() {
 ...
}
```
<h3>Compliant solution</h3>

```java
boolean isFoo() {
 ...
}
```