<h2>Why is this an issue?</h2>
<p>The <code>catch</code> block of a checked exception "E" may be hidden because the corresponding <code>try</code> block only throws exceptions
derived from E.</p>
<p>These derived exceptions are handled in dedicated <code>catch</code> blocks prior to the <code>catch</code> block of the base exception E.</p>
<p>The <code>catch</code> block of E is unreachable and should be considered dead code. It should be removed, or the entire try-catch structure should
be refactored.</p>
<p>It is also possible that a single exception type in a multi-catch block may be hidden while the catch block itself is still reachable. In that case
it is enough to only remove the hidden exception type or to replace it with another type.</p>
<h3>Noncompliant code example</h3>

```java
public class HiddenCatchBlock {

  public static class CustomException extends Exception {
  }

  public static class CustomDerivedException extends CustomException {
  }

  public static void main(String[] args) {
    try {
      throwCustomDerivedException();
    } catch(CustomDerivedException e) {
      // ...
    } catch(CustomException e) { // Noncompliant; this code is unreachable
      // ...
    }
  }

  private static void throwCustomDerivedException() throws CustomDerivedException {
    throw new CustomDerivedException();
  }
}
```
<h3>Compliant solution</h3>

```java
public class HiddenCatchBlock {

  public static class CustomException extends Exception {
  }

  public static class CustomDerivedException extends CustomException {
  }

  public static void main(String[] args) {
    try {
      throwCustomDerivedException();
    } catch(CustomDerivedException e) { // Compliant; try-catch block is "catching" only the Exception that can be thrown in the "try"
      //...
    }
  }
}
```