<p>This rule is deprecated; use <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S2755'>java:S2755</a> instead.</p>
<h2>Why is this an issue?</h2>
<p>By default XML processors attempt to load all XML schemas and DTD (their locations are defined with <code>xsi:schemaLocation</code> attributes and
<code>DOCTYPE</code> declarations), potentially from an external storage such as file system or network, which may lead, if no restrictions are put in
place, to <a href="https://owasp.org/www-community/attacks/Server_Side_Request_Forgery">server-side request forgery (SSRF)</a> vulnerabilities.</p>
<h3>Noncompliant code example</h3>
<p>For <a href="https://docs.oracle.com/javase/9/docs/api/javax/xml/parsers/DocumentBuilderFactory.html">DocumentBuilder</a>, <a
href="https://docs.oracle.com/javase/9/docs/api/javax/xml/parsers/SAXParserFactory.html">SAXParser</a> and <a
href="https://docs.oracle.com/javase/9/docs/api/javax/xml/validation/SchemaFactory.html">Schema</a> JAPX factories:</p>

```java
DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
factory.setValidating(true); // Noncompliant
factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true); // Noncompliant

SAXParserFactory factory = SAXParserFactory.newInstance();
factory.setValidating(true); // Noncompliant
factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true); // Noncompliant

SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
schemaFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true); // Noncompliant
```
<p>For <a href="https://dom4j.github.io/">Dom4j</a> library:</p>

```java
SAXReader xmlReader = new SAXReader(); // Noncompliant
xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);  // Noncompliant
```
<p>For <a href="http://www.jdom.org/">Jdom2</a> library:</p>

```java
SAXBuilder builder = new SAXBuilder();
builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true); // Noncompliant
```
<h3>Compliant solution</h3>
<p>For <a href="https://docs.oracle.com/javase/9/docs/api/javax/xml/parsers/DocumentBuilderFactory.html">DocumentBuilder</a>, <a
href="https://docs.oracle.com/javase/9/docs/api/javax/xml/parsers/SAXParserFactory.html">SAXParser</a> and <a
href="https://docs.oracle.com/javase/9/docs/api/javax/xml/validation/SchemaFactory.html">Schema</a> JAPX factories:</p>

```java
DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);

SAXParserFactory factory = SAXParserFactory.newInstance();
factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);

SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
schemaFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
```
<p>For <a href="https://dom4j.github.io/">Dom4j</a> library:</p>

```java
SAXReader xmlReader = new SAXReader(); // Noncompliant
xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
```
<p>For <a href="http://www.jdom.org/">Jdom2</a> library:</p>

```java
SAXBuilder builder = new SAXBuilder();
builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
```
<h3>Exceptions</h3>
<p>This rules does not raise an issue when an <code>EntityResolver</code> is set.</p>

```java
DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
factory.setValidating(true);
DocumentBuilder builder = factory.newDocumentBuilder();
builder.setEntityResolver(new MyEntityResolver());

SAXBuilder builder = new SAXBuilder();
builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
builder.setEntityResolver(new EntityResolver());
```
<h2>Resources</h2>
<ul>
  <li> <a
  href="https://docs.oracle.com/en/java/javase/13/security/java-api-xml-processing-jaxp-security-guide.html#GUID-8CD65EF5-D113-4D5C-A564-B875C8625FAC">Oracle Java Documentation</a> - XML External Entity Injection Attack </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A4_2017-XML_External_Entities_(XXE)">Top 10 2017 Category A4 - XML External
  Entities (XXE)</a> </li>
  <li> <a href="https://cheatsheetseries.owasp.org/cheatsheets/XML_External_Entity_Prevention_Cheat_Sheet.html#java">OWASP XXE Prevention Cheat
  Sheet</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/611">CWE-611 - Information Exposure Through XML External Entity Reference</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/827">CWE-827 - Improper Control of Document Type Definition</a> </li>
</ul>