<h2>Why is this an issue?</h2>
<p>Nested code blocks can be used to create a new scope: variables declared within that block cannot be accessed from the outside, and their lifetime
end at the end of the block. However, this only happens when you use ES6 <code>let</code> or <code>const</code> keywords, a class declaration or a
function declaration (in strict mode). Otherwise, the nested block is redundant and should be removed.</p>
<h3>Exceptions</h3>
<p>The rule does not apply to the following cases:</p>
<ul>
  <li> Block statements containing variable declarations using <code>let</code> or <code>const</code> keywords or class declarations are not redundant
  as they create a new scope. </li>
</ul>

```js
{
    let x = 1;
}
```
<ul>
  <li> The same applies to function declarations in <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode">strict
  mode</a> </li>
</ul>

```js
"use strict";
{
    function foo() {}
}
```
<ul>
  <li> The rule also does not apply to the blocks that are part of the <a
  href="https://developer.mozilla.org/en-US/docs/Glossary/Control_flow">control flow</a>. </li>
</ul>

```js
if (condition) {
    doSomething();
}
```
<h2>How to fix it</h2>
<p>The nested code blocks should be extracted into separate methods.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
{   // Noncompliant: redundant code block
    var foo = bar();
}

if (condition) {
    doSomething();
    {   // Noncompliant: redundant code block
        doOtherStuff();
    }
}
```
<h4>Compliant solution</h4>

```js
var foo = bar();

if (condition) {
    doSomething();
    doOtherStuff();
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Single-responsibility_principle">Single Responsibility Principle</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/block">block statement</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var">var</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/let">let</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/const">const</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/class">class declaration</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/function">function declaration</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode">strict mode</a> </li>
</ul>