<h2>Why is this an issue?</h2>
<p>Consistent naming between arguments and parameters reduces the chances of making mistakes, such as passing the wrong value to a parameter or
omitting an argument in a function call. When the names of arguments in a function call match the names of the function parameters, it contributes to
clearer, more readable code.</p>
<p>However, when the names match but are passed in a different order than their declaration in the function signature, it may indicate a mistake in
the parameter order, likely leading to unexpected results.</p>

```js
function divide(dividend, divisor) {
  return dividend / divisor;
}

function doTheThing() {
  const dividend = 15;
  const divisor = 5;

  const result = divide(divisor, dividend); // Noncompliant: not the expected result
  //...
}
```
<p>Ensure that the arguments passed to the function are in the correct order, according to the function signature.</p>

```js
function divide(dividend, divisor) {
  return dividend / divisor;
}

function doTheThing() {
  const dividend = 15;
  const divisor = 5;

  const result = divide(dividend, divisor);
  //...
}
```
<h3>Exceptions</h3>
<p>Swapped arguments that are compared beforehand in an enclosing <code>if</code> statement are ignored:</p>

```js
function divide(dividend, divisor) {
  return dividend / divisor;
}

function doTheThing() {
  const dividend = 5;
  const divisor = 15;
  if (divisor > dividend) {
    const result = divide(divisor, dividend);
    //...
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions">Functions</a> </li>
</ul>