<h2>Why is this an issue?</h2>
<p>Functions with a long parameter list are difficult to use, as maintainers must figure out the role of each parameter and keep track of their
position.</p>

```kotlin
fun setCoordinates(x1: Int, y1: Int, z1: Int, x2: Int, y2: Int, z2: Int) { // Noncompliant
    // ...
}
```
<p>The solution can be to:</p>
<ul>
  <li> Split the function into smaller ones </li>
</ul>

```kotlin
// Each function does a part of what the original setCoordinates function was doing, so confusion risks are lower
fun setOrigin(x: Int, y: Int, z: Int) {
   // ...
}

fun setSize(width: Int, height: Int, depth: Int) {
   // ...
}
```
<ul>
  <li> Find a better data structure for the parameters that group data in a way that makes sense for the specific application domain </li>
</ul>

```kotlin
data class Point(val x: Int, val y: Int, val z: Int) // In geometry, Point is a logical structure to group data

fun setCoordinates(p1: Point, p2: Point) {
    // ...
}
```
<p>This rule raises an issue when a function has more parameters than the provided threshold.</p>
<h3>Exceptions</h3>
<p>Methods annotated with Spring’s <code>@RequestMapping</code> (and related shortcut annotations, like <code>@GetRequest</code>) or
<code>@JsonCreator</code> may have a lot of parameters, encapsulation being possible. Therefore the rule ignores such methods.</p>