<h2>Why is this an issue?</h2>
<p>Unnecessary imports refer to importing types that are not used or referenced anywhere in the code.</p>
<p>Although they don’t affect the runtime behavior of the application after compilation, removing them will:</p>
<ul>
  <li> Improve the readability and maintainability of the code. </li>
  <li> Help avoid potential naming conflicts. </li>
  <li> Improve the build time, as the compiler has fewer lines to read and fewer types to resolve. </li>
  <li> Reduce the number of items the code editor will show for auto-completion, thereby showing fewer irrelevant suggestions. </li>
</ul>
<h3>Exceptions</h3>
<p>Imports for types mentioned in KDoc are ignored.</p>
<h2>How to fix it</h2>
<p>While it’s not difficult to remove these unneeded lines manually, modern code editors support the removal of every unnecessary import with a single
click from every file of the project.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```kotlin
package myapp.helpers

import java.io.IOException
import java.nio.file.*
import java.nio.file.*     // Noncompliant - package is imported twice
import java.nio.*          // Noncompliant - nothing is used from that package

object FileHelper {
    fun readFirstLine(filePath: String)
        = Files.readAllLines(Paths.get(filePath)).first()
}
```
<h4>Compliant solution</h4>

```kotlin
package myapp.helpers

import java.io.IOException
import java.nio.file.*

object FileHelper {
    fun readFirstLine(filePath: String)
        = Files.readAllLines(Paths.get(filePath)).first()
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://kotlinlang.org/docs/packages.html">Kotlin packages and imports</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=KOTLIN&tools=SONAR_LINT&rule=kotlin:S1144'>kotlin:S1144</a> - Unused "private" methods should be removed </li>
  <li> <a href='checks/checks/?languages=KOTLIN&tools=SONAR_LINT&rule=kotlin:S1481'>kotlin:S1481</a> - Unused local variables should be removed </li>
</ul>