<h2>Why is this an issue?</h2>
<p>The use of <code>break</code> and <code>continue</code> statements increases the complexity of the control flow and makes it harder to understand
the program logic. In order to keep a good program structure, they should not be applied more than once per loop.</p>
<p>This rule reports an issue when there is more than one <code>break</code> or <code>continue</code> statement in a loop. The code should be
refactored to increase readability if there is more than one.</p>
<h3>Noncompliant code example</h3>

```ts
for (var i = 1; i <= 10; i++) {  // Noncompliant - 2 continue - one might be tempted to add some logic in between
  if (i % 2 == 0) {
    continue;
  }

  if (i % 3 == 0) {
    continue;
  }

  alert("i = " + i);
}
```