<h2>Why is this an issue?</h2>
<p>Character classes in regular expressions will match any of the characters enclosed in the square brackets (<code>[abc]</code> will match
<code>a</code>, <code>b</code> or <code>c</code>).</p>
<p>You can specify a range of characters using a hyphen (<code>-</code>). If the hyphen appears as the first or last character, it will be matched as
a literal hyphen.</p>
<p>An empty character class (<code>[]</code>) will not match any character because the set of matching characters is empty. So the regular expression
will not work as you intended.</p>

```ts
/^foo[]/.test(str); // Noncompliant: always returns "false"
```
<p>Use a non-empty character class or a different regular expression pattern that achieves the desired result.</p>

```ts
/^foo/.test(str);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_expressions/Character_classes">Character
  classes</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_expressions">Regular expressions</a> </li>
</ul>