<h2>Why is this an issue?</h2>
<p>Captions in HTML media elements are text versions of the audio content, synchronized with the video. They are essential for individuals who are
deaf or hard of hearing, as they provide a text alternative for the audio information. They can also be beneficial for individuals who are not native
speakers of the language of the video, or for situations where the audio cannot be heard.</p>
<p>In the context of accessibility, providing captions for media elements is a requirement under the Web Content Accessibility Guidelines (WCAG).
Without captions, you are excluding a portion of your audience who rely on them to understand the content of your media.</p>
<h2>How to fix it</h2>
<p>If captions are missing from your media elements, you can fix this by adding a <code>&lt;track&gt;</code> element with the
<code>kind="captions"</code> attribute inside your <code>&lt;audio&gt;</code> or <code>&lt;video&gt;</code> element. However, for video elements that
have the <code>muted</code> attribute, captions are not required.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
<audio {...props} />; // Noncompliant
<video {...props} />; // Noncompliant
```
<h4>Compliant solution</h4>

```ts
<audio><track kind="captions" {...props} /></audio>
<video><track kind="captions" {...props} /></video>
<video muted {...props} ></video>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio">audio element</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video">video element</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/track">track element</a> </li>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/captions-prerecorded.html">Captions</a> </li>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/audio-description-or-media-alternative-prerecorded.html">Audio Description or Media
  Alternative</a> </li>
</ul>