<h2>Why is this an issue?</h2>
<p>TypeScript allows assigning values to enum members. However, it does not enforce uniqueness between the values of such members. As a result,
assigning the same value to different members is possible.</p>
<p>The rule raises issues on duplicate values because they are misleading and can lead to bugs that are hard to track down.</p>
<h2>How to fix it</h2>
<p>Assign a unique value for each enum member or don’t assign any values.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
enum E {
  X = 0,
  Y = 0,
}
```
<h4>Compliant solution</h4>

```ts
enum E {
  X = 0,
  Y = 1,
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> TypeScript Documentation - <a href="https://www.typescriptlang.org/docs/handbook/enums.html">Enums</a> </li>
</ul>