<h2>Why is this an issue?</h2>
<p>Non-interactive DOM elements are those that do not have built-in interactivity or do not require user interaction. Examples include
<code>&lt;div&gt;</code>, <code>&lt;p&gt;</code>, <code>&lt;img&gt;</code>, <code>&lt;h1&gt;</code> to <code>&lt;h6&gt;</code>, and
<code>&lt;ul&gt;</code>, among others. These elements are typically used to structure content and layout but do not have any inherent interactive
behavior.</p>
<p>Interactive ARIA roles, on the other hand, are used to make elements interactive and accessible. These roles include <code>button</code>,
<code>link</code>, <code>checkbox</code>, <code>menuitem</code>, <code>tab</code>, and others. They are used to communicate the type of interaction
that users can expect from an element.</p>
<p>Non-interactive DOM elements should not use interactive ARIA roles because it can confuse assistive technologies and their users. For example, if a
<code>&lt;div&gt;</code> (a non-interactive element) is given an interactive role like "button", assistive technologies like screen readers will
announce it as a button. However, since <code>&lt;div&gt;</code> doesn’t have the inherent behavior of a button, it can confuse users who expect it to
behave like a button when interacted with.</p>
<p>This can lead to a poor user experience and can make the website less accessible for users relying on assistive technologies. Therefore, it’s
important to ensure that non-interactive DOM elements are not given interactive ARIA roles.</p>
<h2>How to fix it</h2>
<p>Ensure that non-interactive DOM elements do not use interactive ARIA roles.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
function myListElement() {
    return <li role="button">Foo</li>; // Noncompliant; "li" isn't interactive, but "button" is
}
```
<h4>Compliant solution</h4>

```ts
function myListElement() {
    return <li role="listitem">Foo</li>;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/name-role-value">Name, Role, Value</a> </li>
  <li> WCAG - <a href="https://www.w3.org/TR/wai-aria-1.1/#usage_intro">WAI-ARIA Roles</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">WAI-ARIA Roles</a> </li>
</ul>