/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./build/src/apack_dependency_provider.js":
/*!************************************************!*\
  !*** ./build/src/apack_dependency_provider.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApackDependencyProvider = void 0;
const xml_js_1 = __webpack_require__(/*! xml-js */ "./node_modules/xml-js/lib/index.js");
class ApackDependencyProvider {
    static fromManifest(manifestContents) {
        var _a, _b;
        if (!manifestContents || !manifestContents.length) {
            return [];
        }
        const result = [];
        const manifest = (0, xml_js_1.xml2js)(manifestContents, { compact: true });
        let apackDependencies = (_b = (_a = manifest["asx:abap"]["asx:values"]["DATA"]) === null || _a === void 0 ? void 0 : _a["DEPENDENCIES"]) === null || _b === void 0 ? void 0 : _b.item;
        if (!apackDependencies) {
            return [];
        }
        else if (!apackDependencies.length) {
            apackDependencies = [apackDependencies];
        }
        for (const dependency of apackDependencies) {
            result.push({
                files: "/src/**/*.*",
                url: dependency["GIT_URL"]["_text"],
            });
        }
        return result;
    }
}
exports.ApackDependencyProvider = ApackDependencyProvider;
//# sourceMappingURL=apack_dependency_provider.js.map

/***/ }),

/***/ "./build/src/compressed_file.js":
/*!**************************************!*\
  !*** ./build/src/compressed_file.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompressedFile = void 0;
const core_1 = __webpack_require__(/*! @abaplint/core */ "./node_modules/@abaplint/core/build/src/index.js");
const zlib = __webpack_require__(/*! zlib */ "zlib");
class CompressedFile extends core_1.AbstractFile {
    constructor(filename, compressed) {
        super(filename);
        this.compressed = compressed;
    }
    getRaw() {
        return this.decompress(this.compressed);
    }
    getRawRows() {
        return this.decompress(this.compressed).split("\n");
    }
    decompress(compressed) {
        return zlib.inflateSync(Buffer.from(compressed, "base64")).toString("utf8");
    }
}
exports.CompressedFile = CompressedFile;
//# sourceMappingURL=compressed_file.js.map

/***/ }),

/***/ "./build/src/file_operations.js":
/*!**************************************!*\
  !*** ./build/src/file_operations.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileOperations = void 0;
const fs = __webpack_require__(/*! fs */ "fs");
const path = __webpack_require__(/*! path */ "path");
const zlib = __webpack_require__(/*! zlib */ "zlib");
const glob = __webpack_require__(/*! glob */ "./node_modules/glob/glob.js");
const core_1 = __webpack_require__(/*! @abaplint/core */ "./node_modules/@abaplint/core/build/src/index.js");
const compressed_file_1 = __webpack_require__(/*! ./compressed_file */ "./build/src/compressed_file.js");
class FileOperations {
    static deleteFolderRecursive(dir) {
        if (fs.existsSync(dir) === false) {
            return;
        }
        fs.rmSync(dir, { recursive: true });
    }
    static loadFileNames(arg, error = true) {
        const files = glob.sync(arg, { nosort: true, nodir: true });
        if (files.length === 0 && error) {
            throw "Error: No files found";
        }
        return files;
    }
    static async loadFiles(compress, input, bar) {
        const files = [];
        bar.set(input.length, "Reading files");
        for (const filename of input) {
            bar.tick("Reading files - " + path.basename(filename));
            const base = filename.split("/").reverse()[0];
            if (base.split(".").length <= 2) {
                continue; // not a abapGit file
            }
            // note that readFileSync is typically faster than async readFile,
            // https://medium.com/@adamhooper/node-synchronous-code-runs-faster-than-asynchronous-code-b0553d5cf54e
            const raw = fs.readFileSync(filename, "utf8");
            if (compress === true) {
                // todo, util.promisify(zlib.deflate) does not seem to work?
                files.push(new compressed_file_1.CompressedFile(filename, zlib.deflateSync(raw).toString("base64")));
            }
            else {
                files.push(new core_1.MemoryFile(filename, raw));
            }
        }
        return files;
    }
}
exports.FileOperations = FileOperations;
//# sourceMappingURL=file_operations.js.map

/***/ }),

/***/ "./build/src/fixes.js":
/*!****************************!*\
  !*** ./build/src/fixes.js ***!
  \****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ApplyFixes = void 0;
const core_1 = __webpack_require__(/*! @abaplint/core */ "./node_modules/@abaplint/core/build/src/index.js");
class ApplyFixes {
    constructor() {
        this.changedFiles = new Set();
    }
    // Strategy:
    // Execute one rule at a time and apply fixes for that rule
    // Some rules are quite expensive to initialize(like downport),
    // so running all rules every time is expensive.
    async applyFixes(reg, fs, extra) {
        let iteration = 0;
        this.changedFiles.clear();
        const MAX_ITERATIONS = 50000;
        const objects = new core_1.RulesRunner(reg).objectsToCheck(reg.getObjects());
        const rules = reg.getConfig().getEnabledRules();
        while (iteration <= MAX_ITERATIONS) {
            let changed = 0;
            for (const rule of rules) {
                while (iteration <= MAX_ITERATIONS) {
                    const before = Date.now();
                    rule.initialize(reg);
                    let issues = [];
                    for (const obj of objects) {
                        issues.push(...rule.run(obj));
                    }
                    issues = new core_1.RulesRunner(reg).excludeIssues(issues);
                    iteration++;
                    const applied = this.applyList(issues, reg);
                    const appliedCount = applied.files.length;
                    const runtime = Date.now() - before;
                    if ((extra === null || extra === void 0 ? void 0 : extra.quiet) !== true) {
                        process.stderr.write(`\tIteration ${iteration.toString().padStart(3, " ")}, ${appliedCount.toString().padStart(3, " ")} fixes applied, ${runtime.toString().padStart(4, " ")}ms, rule ${rule.getMetadata().key}\n`);
                        if ((extra === null || extra === void 0 ? void 0 : extra.extraInfo) === true) {
                            for (const i of applied.appliedIssues) {
                                process.stderr.write("\t\t" + i.getKey() + ": " + i.getMessage() + "\n");
                            }
                        }
                    }
                    if (appliedCount > 0) {
                        changed += appliedCount;
                        const before = Date.now();
                        reg.parse();
                        const runtime = Date.now() - before;
                        if ((extra === null || extra === void 0 ? void 0 : extra.quiet) !== true) {
                            process.stderr.write(`\tParse, ${runtime}ms\n`);
                        }
                    }
                    else {
                        break;
                    }
                }
            }
            if (changed === 0) {
                break;
            }
        }
        this.writeChangesToFS(fs, reg);
        this.clearSyntaxCache(reg);
    }
    ///////////////////////////////////////////////////
    clearSyntaxCache(reg) {
        for (const obj of reg.getObjects()) {
            if (obj instanceof core_1.ABAPObject) {
                obj.setDirty();
            }
        }
    }
    writeChangesToFS(fs, reg) {
        for (const filename of this.changedFiles.values()) {
            const file = reg.getFileByName(filename);
            if (file === undefined) {
                continue;
            }
            fs.writeFileSync(file.getFilename(), file.getRaw());
        }
    }
    possibleOverlap(edit, list) {
        // only checks if the edits have changes in the same rows
        for (const e of list) {
            for (const file1 of Object.keys(e)) {
                for (const file2 of Object.keys(edit)) {
                    if (file1 === file2) {
                        for (const list1 of e[file1]) {
                            for (const list2 of edit[file2]) {
                                if (list2.range.start.getRow() <= list1.range.start.getRow()
                                    && list2.range.end.getRow() >= list1.range.start.getRow()) {
                                    return true;
                                }
                                if (list2.range.start.getRow() <= list1.range.start.getRow()
                                    && list2.range.end.getRow() >= list1.range.end.getRow()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
    applyList(issues, reg) {
        const edits = [];
        const appliedIssues = [];
        for (const i of issues) {
            const edit = i.getFix();
            if (edit === undefined) {
                continue;
            }
            else if (this.possibleOverlap(edit, edits) === true) {
                continue;
            }
            appliedIssues.push(i);
            edits.push(edit);
        }
        const changed = (0, core_1.applyEditList)(reg, edits);
        for (const filename of changed) {
            this.changedFiles.add(filename);
        }
        return {
            files: changed,
            appliedIssues: appliedIssues,
        };
    }
}
exports.ApplyFixes = ApplyFixes;
//# sourceMappingURL=fixes.js.map

/***/ }),

/***/ "./build/src/formatters/_format.js":
/*!*****************************************!*\
  !*** ./build/src/formatters/_format.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Formatter = void 0;
const Formatters = __webpack_require__(/*! . */ "./build/src/formatters/index.js");
class Formatter {
    static format(issues, format, fileCount) {
        // todo, this can be done more generic, move to artifacts.ts?
        switch (format) {
            case "total":
                return new Formatters.Total().output(issues, fileCount);
            case "json":
                return new Formatters.Json().output(issues, fileCount);
            case "junit":
                return new Formatters.Junit().output(issues, fileCount);
            case "codeframe":
                return new Formatters.CodeFrame().output(issues, fileCount);
            case "checkstyle":
                return new Formatters.Checkstyle().output(issues, fileCount);
            case "sonarqube":
                return new Formatters.Sonarqube().output(issues, fileCount);
            case "codeclimate":
                return new Formatters.CodeClimate().output(issues, fileCount);
            default:
                return new Formatters.Standard().output(issues, fileCount);
        }
    }
}
exports.Formatter = Formatter;
//# sourceMappingURL=_format.js.map

/***/ }),

/***/ "./build/src/formatters/checkstyle.js":
/*!********************************************!*\
  !*** ./build/src/formatters/checkstyle.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Checkstyle = void 0;
const xml_js_1 = __webpack_require__(/*! xml-js */ "./node_modules/xml-js/lib/index.js");
class Checkstyle {
    output(issues, _fileCount) {
        const outputObj = {
            _declaration: {
                _attributes: {
                    version: "1.0",
                    encoding: "UTF-8",
                },
            },
            checkstyle: {
                _attributes: {
                    version: "8.36",
                },
                file: [],
            },
        };
        if (issues.length > 0) {
            for (const issue of issues) {
                outputObj.checkstyle.file.push({
                    _attributes: {
                        name: issue.getFilename(),
                    },
                    error: {
                        _attributes: {
                            line: issue.getStart().getRow(),
                            column: issue.getStart().getCol(),
                            severity: issue.getSeverity().toString(),
                            message: issue.getMessage(),
                            source: "abaplint",
                        },
                    },
                });
            }
        }
        const xml = (0, xml_js_1.js2xml)(outputObj, { compact: true, spaces: 2 });
        return xml;
    }
}
exports.Checkstyle = Checkstyle;
//# sourceMappingURL=checkstyle.js.map

/***/ }),

/***/ "./build/src/formatters/codeclimate.js":
/*!*********************************************!*\
  !*** ./build/src/formatters/codeclimate.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CodeClimate = void 0;
const node_crypto_1 = __webpack_require__(/*! node:crypto */ "node:crypto");
function md5(content) {
    return (0, node_crypto_1.createHash)("md5").update(content).digest("hex");
}
class CodeClimate {
    output(issues, _fileCount) {
        const out = [];
        const defaultSeverity = "info";
        const severityArray = ["info", "minor", "major", "critical", "blocker"];
        for (const issue of issues) {
            const single = {
                type: "issue",
                check_name: issue.getKey(),
                description: issue.getMessage(),
                categories: ["Code Quality"],
                location: {
                    path: issue.getFilename(),
                    lines: {
                        begin: issue.getStart().getRow(),
                        end: issue.getEnd().getRow(),
                    },
                },
                severity: (severityArray.includes(issue.getSeverity().toLowerCase())) ? issue.getSeverity().toLowerCase() : defaultSeverity,
                fingerprint: md5(issue.getKey() + issue.getMessage() + issue.getFilename() + issue.getStart().getRow() + issue.getEnd().getRow()),
            };
            out.push(single);
        }
        return JSON.stringify(out) + "\n";
    }
}
exports.CodeClimate = CodeClimate;
//# sourceMappingURL=codeclimate.js.map

/***/ }),

/***/ "./build/src/formatters/codeframe.js":
/*!*******************************************!*\
  !*** ./build/src/formatters/codeframe.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CodeFrame = void 0;
const total_1 = __webpack_require__(/*! ./total */ "./build/src/formatters/total.js");
const fs = __webpack_require__(/*! fs */ "fs");
const chalk_1 = __webpack_require__(/*! chalk */ "./node_modules/chalk/source/index.js");
function issueSort(a, b) {
    return a.filename.localeCompare(b.filename)
        || (a.row - b.row)
        || (a.col - b.col);
}
class CodeFrame {
    constructor() {
        this.currentFilename = "";
        this.currentFileLinesCount = 0;
        this.fileContent = [];
    }
    output(issues, fileCount) {
        const builtIssues = this.convertAllIssues(issues).sort(issueSort); // Make sure it is sorted by filename for caching to work
        return [
            ...builtIssues.map(i => this.renderIssue(i)),
            (issues.length > 0 ? chalk_1.default.red(new total_1.Total().output(issues, fileCount)) : chalk_1.default.green(new total_1.Total().output(issues, fileCount))),
        ].join("\n");
    }
    convertAllIssues(issues) {
        return issues.map(i => this.convertIssue(i));
    }
    cacheFile(filename) {
        if (filename !== this.currentFilename) {
            this.currentFilename = filename;
            this.fileContent = fs.readFileSync(filename, "utf8").split(/\r?\n/);
            this.currentFileLinesCount = this.fileContent.length;
        }
    }
    renderIssue(issue) {
        this.cacheFile(issue.filename);
        const frameSize = 1;
        const lineFrom = Math.max(issue.row - frameSize, 1);
        const lineTo = Math.min(issue.row + frameSize, this.currentFileLinesCount);
        const issueLineIndex = issue.row - 1;
        const padSize = Math.ceil(Math.log10(lineTo)) + 4;
        const code = [];
        for (let lineIndex = lineFrom - 1; lineIndex < lineTo; lineIndex++) {
            const prefix = `${ /*(lineIndex === issueLineIndex) ? ">" :*/" "}${lineIndex + 1} |`.padStart(padSize);
            code.push(prefix + this.fileContent[lineIndex]);
            if (lineIndex === issueLineIndex) {
                code.push("|".padStart(padSize) + " ".repeat(issue.col - 1) + "^");
            }
        }
        const severityStr = issue.severity === "E"
            ? chalk_1.default.red(issue.severity)
            : chalk_1.default.yellow(issue.severity);
        return `[${severityStr}] ${issue.description} (${issue.issueKey}) @ ${issue.location}`
            + "\n"
            + code.map(str => chalk_1.default.grey(str)).join("\n")
            + "\n";
    }
    renderLocation(issue) {
        return issue.getFilename() + "[" + issue.getStart().getRow() + ", " + issue.getStart().getCol() + "]";
    }
    convertIssue(issue) {
        return {
            location: this.renderLocation(issue),
            description: issue.getMessage(),
            issueKey: issue.getKey(),
            filename: issue.getFilename(),
            severity: issue.getSeverity().toString().charAt(0), //E/W/I
            row: issue.getStart().getRow(),
            col: issue.getStart().getCol(),
        };
    }
}
exports.CodeFrame = CodeFrame;
//# sourceMappingURL=codeframe.js.map

/***/ }),

/***/ "./build/src/formatters/index.js":
/*!***************************************!*\
  !*** ./build/src/formatters/index.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./json */ "./build/src/formatters/json.js"), exports);
__exportStar(__webpack_require__(/*! ./junit */ "./build/src/formatters/junit.js"), exports);
__exportStar(__webpack_require__(/*! ./standard */ "./build/src/formatters/standard.js"), exports);
__exportStar(__webpack_require__(/*! ./total */ "./build/src/formatters/total.js"), exports);
__exportStar(__webpack_require__(/*! ./codeframe */ "./build/src/formatters/codeframe.js"), exports);
__exportStar(__webpack_require__(/*! ./checkstyle */ "./build/src/formatters/checkstyle.js"), exports);
__exportStar(__webpack_require__(/*! ./sonarqube */ "./build/src/formatters/sonarqube.js"), exports);
__exportStar(__webpack_require__(/*! ./codeclimate */ "./build/src/formatters/codeclimate.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./build/src/formatters/json.js":
/*!**************************************!*\
  !*** ./build/src/formatters/json.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Json = void 0;
class Json {
    output(issues, _fileCount) {
        const out = [];
        for (const issue of issues) {
            const single = {
                description: issue.getMessage(),
                key: issue.getKey(),
                file: issue.getFilename(),
                start: {
                    row: issue.getStart().getRow(),
                    col: issue.getStart().getCol(),
                },
                end: {
                    row: issue.getEnd().getRow(),
                    col: issue.getEnd().getCol(),
                },
                severity: issue.getSeverity(),
            };
            out.push(single);
        }
        return JSON.stringify(out) + "\n";
    }
}
exports.Json = Json;
//# sourceMappingURL=json.js.map

/***/ }),

/***/ "./build/src/formatters/junit.js":
/*!***************************************!*\
  !*** ./build/src/formatters/junit.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Junit = void 0;
const xml_js_1 = __webpack_require__(/*! xml-js */ "./node_modules/xml-js/lib/index.js");
const fs = __webpack_require__(/*! fs */ "fs");
class Junit {
    constructor() {
        this.currentFilename = "";
        this.currentFileLinesCount = 0;
        this.fileContent = [];
    }
    output(issues, _fileCount) {
        const outputObj = {
            _declaration: {
                _attributes: {
                    version: "1.0",
                    encoding: "UTF-8",
                },
            },
            testsuites: {
                testsuite: {
                    _attributes: {
                        name: "abaplint",
                        tests: issues.length || 1,
                        failures: issues.length,
                        errors: 0,
                        skipped: 0,
                    },
                    testcase: [],
                },
            },
        };
        if (issues.length > 0) {
            for (const issue of issues) {
                outputObj.testsuites.testsuite.testcase.push({
                    _attributes: {
                        classname: issue.getFilename().split(".")[0],
                        file: issue.getFilename(),
                        name: `${issue.getFilename()}: [${issue.getStart().getRow()}, ${issue.getStart().getCol()}] - ${issue.getKey()}`,
                    },
                    failure: {
                        _attributes: {
                            message: this.formatFailureMessage(issue.getMessage()),
                            type: issue.getSeverity().toString(),
                        },
                        _cdata: `${this.renderIssue(issue)}`,
                    },
                });
            }
        }
        else {
            outputObj.testsuites.testsuite.testcase.push({
                _attributes: {
                    classname: "none",
                    name: "OK",
                },
            });
        }
        const xml = (0, xml_js_1.js2xml)(outputObj, { compact: true, spaces: 2 });
        return xml;
    }
    cacheFile(filename) {
        if (filename !== this.currentFilename) {
            this.currentFilename = filename;
            this.fileContent = fs.readFileSync(filename, "utf8").split(/\r?\n/);
            this.currentFileLinesCount = this.fileContent.length;
        }
    }
    renderIssue(issue) {
        this.cacheFile(issue.getFilename());
        const frameSize = 1;
        const lineFrom = Math.max(issue.getStart().getRow() - frameSize, 1);
        const lineTo = Math.min(issue.getStart().getRow() + frameSize, this.currentFileLinesCount);
        const issueLineIndex = issue.getStart().getRow() - 1;
        const padSize = Math.ceil(Math.log10(lineTo)) + 4;
        const code = [];
        for (let lineIndex = lineFrom - 1; lineIndex < lineTo; lineIndex++) {
            const prefix = `${lineIndex + 1} | `.padStart(padSize, "0");
            code.push(prefix + this.fileContent[lineIndex]);
            if (lineIndex === issueLineIndex) {
                code.push("| ".padStart(padSize) + " ".repeat(issue.getStart().getCol() - 1) + "^");
            }
        }
        return code.map(str => str).join("\n");
    }
    formatFailureMessage(message) {
        return message.replace("<", "").replace(">", "");
    }
}
exports.Junit = Junit;
//# sourceMappingURL=junit.js.map

/***/ }),

/***/ "./build/src/formatters/sonarqube.js":
/*!*******************************************!*\
  !*** ./build/src/formatters/sonarqube.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Sonarqube = void 0;
class Sonarqube {
    output(issues, _fileCount) {
        const out = {};
        const issueArray = [];
        const defaultSeverity = "INFO";
        const severityArray = ["INFO", "MINOR", "MAJOR", "CRITICAL", "BLOCKER"];
        for (const issue of issues) {
            const startOffset = issue.getStart().getCol() - 1;
            const endOffset = issue.getEnd().getCol() - 2;
            const single = {
                engineId: "abaplint",
                ruleId: issue.getKey(),
                severity: (severityArray.includes(issue.getSeverity().toUpperCase())) ? issue.getSeverity().toUpperCase() : defaultSeverity,
                type: "CODE_SMELL",
                primaryLocation: {
                    message: issue.getMessage(),
                    filePath: issue.getFilename(),
                    textRange: {
                        startLine: issue.getStart().getRow(),
                        endLine: issue.getEnd().getRow(),
                        startColumn: startOffset,
                        endColumn: endOffset,
                    },
                },
                effortMinutes: 10,
            };
            if (startOffset >= endOffset) {
                delete single.primaryLocation.textRange.startColumn;
                delete single.primaryLocation.textRange.endColumn;
            }
            issueArray.push(single);
        }
        out.issues = issueArray;
        return JSON.stringify(out) + "\n";
    }
}
exports.Sonarqube = Sonarqube;
//# sourceMappingURL=sonarqube.js.map

/***/ }),

/***/ "./build/src/formatters/standard.js":
/*!******************************************!*\
  !*** ./build/src/formatters/standard.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Standard = void 0;
const total_1 = __webpack_require__(/*! ./total */ "./build/src/formatters/total.js");
class Standard {
    output(issues, fileCount) {
        const tuples = [];
        for (const issue of issues) {
            tuples.push(this.build(issue));
        }
        tuples.sort((a, b) => {
            const nameCompare = a.rawFilename.localeCompare(b.rawFilename);
            if (nameCompare === 0) {
                const rowCompare = a.startPos.getRow() - b.startPos.getRow();
                if (rowCompare === 0) {
                    return a.startPos.getCol() - b.startPos.getCol();
                }
                else {
                    return rowCompare;
                }
            }
            else {
                return nameCompare;
            }
        });
        const result = this.columns(tuples);
        return result + new total_1.Total().output(issues, fileCount);
    }
    columns(issues) {
        let max = 0;
        issues.forEach((tuple) => { if (max < tuple.filename.length) {
            max = tuple.filename.length;
        } });
        let result = "";
        issues.forEach((issue) => {
            result = result +
                this.pad(issue.filename, max - issue.filename.length) +
                issue.description +
                ` [${issue.severity.charAt(0)}]\n`; //E/W/I
        });
        return result;
    }
    pad(input, length) {
        let output = input;
        for (let i = 0; i < length; i++) {
            output = output + " ";
        }
        return output + " - ";
    }
    build(issue) {
        return {
            filename: issue.getFilename() + "[" + issue.getStart().getRow() + ", " + issue.getStart().getCol() + "]",
            description: issue.getMessage() + " (" + issue.getKey() + ")",
            startPos: issue.getStart(),
            rawFilename: issue.getFilename(),
            severity: issue.getSeverity().toString(),
        };
    }
}
exports.Standard = Standard;
//# sourceMappingURL=standard.js.map

/***/ }),

/***/ "./build/src/formatters/total.js":
/*!***************************************!*\
  !*** ./build/src/formatters/total.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Total = void 0;
class Total {
    output(issues, fileCount) {
        return "abaplint: " + issues.length + " issue(s) found, " + fileCount + " file(s) analyzed\n";
    }
}
exports.Total = Total;
//# sourceMappingURL=total.js.map

/***/ }),

/***/ "./build/src/index.js":
/*!****************************!*\
  !*** ./build/src/index.js ***!
  \****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.run = exports.GENERIC_ERROR = void 0;
const fs = __webpack_require__(/*! fs */ "fs");
const os = __webpack_require__(/*! os */ "os");
const path = __webpack_require__(/*! path */ "path");
const ProgressBar = __webpack_require__(/*! progress */ "./node_modules/progress/index.js");
const childProcess = __webpack_require__(/*! child_process */ "child_process");
const JSON5 = __webpack_require__(/*! json5 */ "./node_modules/json5/dist/index.mjs");
const core_1 = __webpack_require__(/*! @abaplint/core */ "./node_modules/@abaplint/core/build/src/index.js");
const _format_1 = __webpack_require__(/*! ./formatters/_format */ "./build/src/formatters/_format.js");
const file_operations_1 = __webpack_require__(/*! ./file_operations */ "./build/src/file_operations.js");
const apack_dependency_provider_1 = __webpack_require__(/*! ./apack_dependency_provider */ "./build/src/apack_dependency_provider.js");
const fixes_1 = __webpack_require__(/*! ./fixes */ "./build/src/fixes.js");
const rename_1 = __webpack_require__(/*! ./rename */ "./build/src/rename.js");
exports.GENERIC_ERROR = "generic_error";
class Progress {
    set(total, _text) {
        this.bar = new ProgressBar(":percent - :elapseds - :text", { total, renderThrottle: 100 });
    }
    async tick(text) {
        this.bar.tick({ text });
        this.bar.render();
    }
    tickSync(text) {
        this.bar.tick({ text });
        this.bar.render();
    }
}
function loadConfig(filename) {
    // possible cases:
    // a) nothing specified, using abaplint.json from cwd
    // b) nothing specified, no abaplint.json in cwd
    // c) specified and found
    // d) specified and not found => use default
    // e) supplied but a directory => use default
    let f = "";
    if (filename === undefined) {
        f = process.cwd() + path.sep + "abaplint.json";
        if (fs.existsSync(f) === false) {
            f = process.cwd() + path.sep + "abaplint.jsonc";
        }
        if (fs.existsSync(f) === false) {
            f = process.cwd() + path.sep + "abaplint.json5";
        }
        if (fs.existsSync(f) === false) {
            process.stderr.write("Using default config\n");
            return { config: core_1.Config.getDefault(), base: "." };
        }
    }
    else {
        if (fs.existsSync(filename) === false) {
            process.stderr.write("ERROR: Specified abaplint configuration file does not exist, using default config\n");
            return { config: core_1.Config.getDefault(), base: "." };
        }
        else if (fs.statSync(filename).isDirectory() === true) {
            process.stderr.write("Supply filename, not directory, using default config\n");
            return { config: core_1.Config.getDefault(), base: "." };
        }
        f = filename;
    }
    // evil hack to get JSON5 working
    if (JSON5.parse === undefined) {
        // @ts-ignore
        JSON5.parse = JSON5.default.parse;
    }
    process.stderr.write("Using config: " + f + "\n");
    const json = fs.readFileSync(f, "utf8");
    const parsed = JSON5.parse(json);
    const vers = core_1.Version;
    if (Object.keys(core_1.Version).some(v => vers[v] === parsed.syntax.version) === false) {
        throw "Error: Unknown version in abaplint.json";
    }
    return {
        config: new core_1.Config(json),
        base: path.dirname(f) === process.cwd() ? "." : path.dirname(f),
    };
}
async function loadDependencies(config, compress, bar, base) {
    let files = [];
    const deps = config.get().dependencies || [];
    const useApack = config.get().global.useApackDependencies;
    if (useApack) {
        const apackPath = path.join(base, ".apack-manifest.xml");
        if (fs.existsSync(apackPath)) {
            const apackManifest = fs.readFileSync(apackPath, "utf8");
            deps.push(...apack_dependency_provider_1.ApackDependencyProvider.fromManifest(apackManifest));
        }
    }
    if (!deps) {
        return [];
    }
    for (const d of deps) {
        if (d.folder) {
            const g = base + d.folder + d.files;
            const names = file_operations_1.FileOperations.loadFileNames(g, false);
            if (names.length > 0) {
                process.stderr.write("Using dependency from: " + g + "\n");
                files = files.concat(await file_operations_1.FileOperations.loadFiles(compress, names, bar));
                continue;
            }
        }
        if (d.url) {
            process.stderr.write("Clone: " + d.url + "\n");
            const dir = fs.mkdtempSync(path.join(os.tmpdir(), "abaplint-"));
            childProcess.execSync("git clone --quiet --depth 1 " + d.url + " .", { cwd: dir, stdio: "inherit" });
            const names = file_operations_1.FileOperations.loadFileNames(dir + d.files);
            files = files.concat(await file_operations_1.FileOperations.loadFiles(compress, names, bar));
            file_operations_1.FileOperations.deleteFolderRecursive(dir);
        }
    }
    return files;
}
function displayHelp() {
    // follow https://docopt.org conventions,
    return "Usage:\n" +
        "  abaplint [<abaplint.json> -f <format> -c --outformat <format> --outfile <file> --fix --file <file>] \n" +
        "  abaplint -h | --help      show this help\n" +
        "  abaplint -v | --version   show version\n" +
        "  abaplint -d | --default   show default configuration\n" +
        "\n" +
        "Options:\n" +
        "  -f, --format <format>  output format (standard, total, json, summary, junit, codeframe, checkstyle)\n" +
        "  --outformat <format>   output format, use in combination with outfile\n" +
        "  --outfile <file>       output issues to file in format\n" +
        "  --fix                  apply quick fixes to files\n" +
        "  --rename               rename object according to rules in abaplint.json\n" +
        "  -p                     output performance information\n" +
        "  -c                     compress files in memory\n" +
        "  --file                 input file, glob format\n";
}
function out(issues, length, arg) {
    const output = _format_1.Formatter.format(issues, arg.format, length);
    if (arg.outFormat && arg.outFile) {
        const fileContents = _format_1.Formatter.format(issues, arg.outFormat, length);
        fs.writeFileSync(arg.outFile, fileContents, "utf-8");
    }
    return output;
}
async function run(arg) {
    var _a, _b;
    // evil hack to get JSON5 working
    if (JSON5.parse === undefined) {
        // @ts-ignore
        JSON5.parse = JSON5.default.parse;
    }
    if (JSON5.stringify === undefined) {
        // @ts-ignore
        JSON5.stringify = JSON5.default.stringify;
    }
    let output = "";
    let issues = [];
    let reg = undefined;
    const progress = new Progress();
    if (arg.showHelp === true) {
        output = output + displayHelp();
    }
    else if (arg.showVersion === true) {
        output = output + core_1.Registry.abaplintVersion() + "\n";
    }
    else if (arg.outputDefaultConfig === true) {
        output = output + JSON.stringify(core_1.Config.getDefault().get(), undefined, 2) + "\n";
    }
    else {
        process.stderr.write("abaplint " + core_1.Registry.abaplintVersion() + "\n");
        let loaded = [];
        let deps = [];
        const { config, base } = loadConfig(arg.configFilename);
        try {
            if (config.get().global.files === undefined) {
                throw "Error: Update abaplint configuration file to latest format";
            }
            const files = (arg.file)
                ? file_operations_1.FileOperations.loadFileNames(base + arg.file)
                : file_operations_1.FileOperations.loadFileNames(base + config.get().global.files);
            loaded = await file_operations_1.FileOperations.loadFiles(arg.compress, files, progress);
            deps = await loadDependencies(config, arg.compress, progress, base);
            reg = new core_1.Registry(config);
            reg.addDependencies(deps);
            reg.addFiles(loaded); // if the object exists in repo, it should take precedence over deps
            await reg.parseAsync({ progress, outputPerformance: arg.performanceInformation });
            if (arg.runFix !== true) {
                issues = issues.concat(reg.findIssues({ progress, outputPerformance: arg.performanceInformation }));
                // require('v8').writeHeapSnapshot();
            }
        }
        catch (error) {
            const file = new core_1.MemoryFile("generic", "dummy");
            const message = error.toString() + " " + ((_b = (_a = error.stack) === null || _a === void 0 ? void 0 : _a.split("\n")[1]) === null || _b === void 0 ? void 0 : _b.trim());
            const issue = core_1.Issue.atPosition(file, new core_1.Position(1, 1), message, exports.GENERIC_ERROR);
            issues = [issue];
        }
        let extra = "";
        if (arg.runFix === true && reg) {
            await new fixes_1.ApplyFixes().applyFixes(reg, fs, { quiet: false, extraInfo: arg.performanceInformation });
            issues = [...reg.findIssues()]; // used in exercism ABAP test runner
            extra = "Fixes applied";
        }
        else if (arg.runRename === true && reg) {
            if (issues.length === 0) {
                new rename_1.Rename(reg).run(config.get(), base, fs);
                extra = "Renames applied";
            }
            else {
                extra = "Renames NOT applied, issues found";
            }
        }
        output = out(issues, loaded.length, arg) + extra;
    }
    return { output, issues, reg };
}
exports.run = run;
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./build/src/rename.js":
/*!*****************************!*\
  !*** ./build/src/rename.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Rename = void 0;
const abaplint = __webpack_require__(/*! @abaplint/core */ "./node_modules/@abaplint/core/build/src/index.js");
const path = __webpack_require__(/*! path */ "path");
const file_operations_1 = __webpack_require__(/*! ./file_operations */ "./build/src/file_operations.js");
class Rename {
    constructor(reg) {
        this.reg = reg;
        this.deletedFiles = new Set();
        this.addedFiles = new Set();
        this.updatedFiles = new Set();
    }
    run(config, base, fs, quiet) {
        const rconfig = config.rename;
        if (rconfig === undefined) {
            return;
        }
        this.skip(rconfig);
        this.rename(rconfig, quiet);
        if (rconfig.output === undefined || rconfig.output === "") {
            // write changes inline
            this.deletedFiles.forEach(f => {
                if (quiet !== true) {
                    console.log("rm " + f);
                }
                fs.rmSync(f);
            });
            this.addedFiles.forEach(f => {
                if (quiet !== true) {
                    console.log("write " + f);
                }
                const file = this.reg.getFileByName(f);
                if (file !== undefined) {
                    fs.writeFileSync(file.getFilename(), file.getRaw());
                }
            });
            this.updatedFiles.forEach(f => {
                if (quiet !== true) {
                    console.log("update " + f);
                }
                const file = this.reg.getFileByName(f);
                if (file !== undefined) {
                    fs.writeFileSync(file.getFilename(), file.getRaw());
                }
            });
        }
        else {
            // output full registry contents to output folder
            this.write(rconfig, base, fs);
        }
    }
    ////////////////////////
    write(rconfig, base, fs) {
        const outputFolder = base + path.sep + rconfig.output;
        console.log("Base: " + base);
        console.log("Output folder: " + outputFolder);
        file_operations_1.FileOperations.deleteFolderRecursive(outputFolder);
        for (const o of this.reg.getObjects()) {
            if (this.reg.isDependency(o) === true) {
                continue;
            }
            for (const f of o.getFiles()) {
                const n = outputFolder + f.getFilename().replace(base, "");
                console.log("Write " + n);
                fs.mkdirSync(path.dirname(n), { recursive: true });
                fs.writeFileSync(n, f.getRaw());
            }
        }
    }
    rename(rconfig, quiet) {
        const renamer = new abaplint.Rename(this.reg);
        for (const o of this.reg.getObjects()) {
            if (this.reg.isDependency(o) === true) {
                continue;
            }
            for (const p of rconfig.patterns || []) {
                if (!(o.getType().match(p.type))) {
                    continue;
                }
                const regex = new RegExp(p.oldName, "i");
                const match = regex.exec(o.getName());
                if (!match) {
                    continue;
                }
                const newStr = o.getName().replace(regex, p.newName);
                if (quiet !== true) {
                    console.log("Renaming " + o.getType() + " " + o.getName().padEnd(30, " ") + " -> " + newStr);
                }
                const result = renamer.rename(o.getType(), o.getName(), newStr);
                result.updatedFiles.forEach(f => { this.updatedFiles.add(f); });
                result.deletedFiles.forEach(f => { this.deletedFiles.add(f); });
                result.addedFiles.forEach(f => { this.addedFiles.add(f); });
            }
        }
    }
    skip(rconfig) {
        if (rconfig.skip) {
            for (const s of rconfig.skip) {
                const all = [];
                for (const f of this.reg.getFiles()) {
                    all.push(f);
                }
                for (const n of all) {
                    if (n.getFilename().match(s)) {
                        console.log(n.getFilename() + " skipped");
                        this.reg.removeFile(n);
                    }
                }
            }
            this.reg.parse();
        }
    }
}
exports.Rename = Rename;
//# sourceMappingURL=rename.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Lexer = void 0;
const position_1 = __webpack_require__(/*! ../../position */ "./node_modules/@abaplint/core/build/src/position.js");
const virtual_position_1 = __webpack_require__(/*! ../../virtual_position */ "./node_modules/@abaplint/core/build/src/virtual_position.js");
const tokens_1 = __webpack_require__(/*! ./tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const lexer_buffer_1 = __webpack_require__(/*! ./lexer_buffer */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer_buffer.js");
const lexer_stream_1 = __webpack_require__(/*! ./lexer_stream */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer_stream.js");
class Lexer {
    constructor() {
        this.ModeNormal = 1;
        this.ModePing = 2;
        this.ModeStr = 3;
        this.ModeTemplate = 4;
        this.ModeComment = 5;
        this.ModePragma = 6;
    }
    run(file, virtual) {
        this.virtual = virtual;
        this.tokens = [];
        this.m = this.ModeNormal;
        this.process(file.getRaw());
        return { file, tokens: this.tokens };
    }
    add() {
        const s = this.buffer.get().trim();
        if (s.length > 0) {
            const col = this.stream.getCol();
            const row = this.stream.getRow();
            let whiteBefore = false;
            if (this.stream.getOffset() - s.length >= 0) {
                const prev = this.stream.getRaw().substr(this.stream.getOffset() - s.length, 1);
                if (prev === " " || prev === "\n" || prev === "\t" || prev === ":") {
                    whiteBefore = true;
                }
            }
            let whiteAfter = false;
            const next = this.stream.nextChar();
            if (next === " " || next === "\n" || next === "\t" || next === ":" || next === "," || next === "." || next === "" || next === "\"") {
                whiteAfter = true;
            }
            let pos = new position_1.Position(row, col - s.length);
            if (this.virtual) {
                pos = new virtual_position_1.VirtualPosition(this.virtual, pos.getRow(), pos.getCol());
            }
            let tok = undefined;
            if (this.m === this.ModeComment) {
                tok = new tokens_1.Comment(pos, s);
            }
            else if (this.m === this.ModePing || this.m === this.ModeStr) {
                tok = new tokens_1.StringToken(pos, s);
            }
            else if (this.m === this.ModeTemplate) {
                const first = s.charAt(0);
                const last = s.charAt(s.length - 1);
                if (first === "|" && last === "|") {
                    tok = new tokens_1.StringTemplate(pos, s);
                }
                else if (first === "|" && last === "{" && whiteAfter === true) {
                    tok = new tokens_1.StringTemplateBegin(pos, s);
                }
                else if (first === "}" && last === "|" && whiteBefore === true) {
                    tok = new tokens_1.StringTemplateEnd(pos, s);
                }
                else if (first === "}" && last === "{" && whiteAfter === true && whiteBefore === true) {
                    tok = new tokens_1.StringTemplateMiddle(pos, s);
                }
                else {
                    tok = new tokens_1.Identifier(pos, s);
                }
            }
            else if (s.length > 2 && s.substr(0, 2) === "##") {
                tok = new tokens_1.Pragma(pos, s);
            }
            else if (s.length === 1) {
                if (s === "." || s === ",") {
                    tok = new tokens_1.Punctuation(pos, s);
                }
                else if (s === "[") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WBracketLeftW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WBracketLeft(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.BracketLeftW(pos, s);
                    }
                    else {
                        tok = new tokens_1.BracketLeft(pos, s);
                    }
                }
                else if (s === "(") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WParenLeftW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WParenLeft(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.ParenLeftW(pos, s);
                    }
                    else {
                        tok = new tokens_1.ParenLeft(pos, s);
                    }
                }
                else if (s === "]") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WBracketRightW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WBracketRight(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.BracketRightW(pos, s);
                    }
                    else {
                        tok = new tokens_1.BracketRight(pos, s);
                    }
                }
                else if (s === ")") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WParenRightW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WParenRight(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.ParenRightW(pos, s);
                    }
                    else {
                        tok = new tokens_1.ParenRight(pos, s);
                    }
                }
                else if (s === "-") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WDashW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WDash(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.DashW(pos, s);
                    }
                    else {
                        tok = new tokens_1.Dash(pos, s);
                    }
                }
                else if (s === "+") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WPlusW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WPlus(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.PlusW(pos, s);
                    }
                    else {
                        tok = new tokens_1.Plus(pos, s);
                    }
                }
                else if (s === "@") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WAtW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WAt(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.AtW(pos, s);
                    }
                    else {
                        tok = new tokens_1.At(pos, s);
                    }
                }
            }
            else if (s.length === 2) {
                if (s === "->") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WInstanceArrowW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WInstanceArrow(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.InstanceArrowW(pos, s);
                    }
                    else {
                        tok = new tokens_1.InstanceArrow(pos, s);
                    }
                }
                else if (s === "=>") {
                    if (whiteBefore === true && whiteAfter === true) {
                        tok = new tokens_1.WStaticArrowW(pos, s);
                    }
                    else if (whiteBefore === true) {
                        tok = new tokens_1.WStaticArrow(pos, s);
                    }
                    else if (whiteAfter === true) {
                        tok = new tokens_1.StaticArrowW(pos, s);
                    }
                    else {
                        tok = new tokens_1.StaticArrow(pos, s);
                    }
                }
            }
            if (tok === undefined) {
                tok = new tokens_1.Identifier(pos, s);
            }
            this.tokens.push(tok);
        }
        this.buffer.clear();
    }
    process(raw) {
        this.stream = new lexer_stream_1.LexerStream(raw.replace(/\r/g, ""));
        this.buffer = new lexer_buffer_1.LexerBuffer();
        const splits = {};
        splits[" "] = true;
        splits[":"] = true;
        splits["."] = true;
        splits[","] = true;
        splits["-"] = true;
        splits["+"] = true;
        splits["("] = true;
        splits[")"] = true;
        splits["["] = true;
        splits["]"] = true;
        splits["\t"] = true;
        splits["\n"] = true;
        const bufs = {};
        bufs["."] = true;
        bufs[","] = true;
        bufs[":"] = true;
        bufs["("] = true;
        bufs[")"] = true;
        bufs["["] = true;
        bufs["]"] = true;
        bufs["+"] = true;
        bufs["@"] = true;
        for (;;) {
            const current = this.stream.currentChar();
            const buf = this.buffer.add(current);
            const ahead = this.stream.nextChar();
            const aahead = this.stream.nextNextChar();
            if (this.m === this.ModeNormal) {
                if (splits[ahead]) {
                    this.add();
                }
                else if (ahead === "'") {
                    // start string
                    this.add();
                    this.m = this.ModeStr;
                }
                else if (ahead === "|" || ahead === "}") {
                    // start template
                    this.add();
                    this.m = this.ModeTemplate;
                }
                else if (ahead === "`") {
                    // start ping
                    this.add();
                    this.m = this.ModePing;
                }
                else if (aahead === "##") {
                    // start pragma
                    this.add();
                    this.m = this.ModePragma;
                }
                else if (ahead === "\""
                    || (ahead === "*" && current === "\n")) {
                    // start comment
                    this.add();
                    this.m = this.ModeComment;
                }
                else if (ahead === "@" && buf.trim().length === 0) {
                    this.add();
                }
                else if (aahead === "->"
                    || aahead === "=>") {
                    this.add();
                }
                else if (current === ">"
                    && ahead !== " "
                    && (this.stream.prevChar() === "-" || this.stream.prevChar() === "=")) {
                    // arrows
                    this.add();
                }
                else if (buf.length === 1
                    && (bufs[buf]
                        || (buf === "-" && ahead !== ">"))) {
                    this.add();
                }
            }
            else if (this.m === this.ModePragma && (ahead === "," || ahead === ":" || ahead === "." || ahead === " " || ahead === "\n")) {
                // end of pragma
                this.add();
                this.m = this.ModeNormal;
            }
            else if (this.m === this.ModePing
                && buf.length > 1
                && current === "`"
                && aahead !== "``"
                && ahead !== "`"
                && this.buffer.countIsEven("`")) {
                // end of ping
                this.add();
                if (ahead === `"`) {
                    this.m = this.ModeComment;
                }
                else {
                    this.m = this.ModeNormal;
                }
            }
            else if (this.m === this.ModeTemplate
                && buf.length > 1
                && (current === "|" || current === "{")
                && (this.stream.prevChar() !== "\\" || this.stream.prevPrevChar() === "\\\\")) {
                // end of template
                this.add();
                this.m = this.ModeNormal;
            }
            else if (this.m === this.ModeTemplate
                && ahead === "}"
                && current !== "\\") {
                this.add();
            }
            else if (this.m === this.ModeStr
                && current === "'"
                && buf.length > 1
                && aahead !== "''"
                && ahead !== "'"
                && this.buffer.countIsEven("'")) {
                // end of string
                this.add();
                if (ahead === "\"") {
                    this.m = this.ModeComment;
                }
                else {
                    this.m = this.ModeNormal;
                }
            }
            else if (ahead === "\n" && this.m !== this.ModeTemplate) {
                this.add();
                this.m = this.ModeNormal;
            }
            else if (this.m === this.ModeTemplate && current === "\n") {
                this.add();
            }
            if (!this.stream.advance()) {
                break;
            }
        }
        this.add();
    }
}
exports.Lexer = Lexer;
//# sourceMappingURL=lexer.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer_buffer.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer_buffer.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LexerBuffer = void 0;
class LexerBuffer {
    constructor() {
        this.buf = "";
    }
    add(s) {
        this.buf = this.buf + s;
        return this.buf;
    }
    get() {
        return this.buf;
    }
    clear() {
        this.buf = "";
    }
    countIsEven(char) {
        let count = 0;
        for (let i = 0; i < this.buf.length; i += 1) {
            if (this.buf.charAt(i) === char) {
                count += 1;
            }
        }
        return count % 2 === 0;
    }
}
exports.LexerBuffer = LexerBuffer;
//# sourceMappingURL=lexer_buffer.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer_stream.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer_stream.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LexerStream = void 0;
class LexerStream {
    constructor(raw) {
        this.offset = -1;
        this.raw = raw;
        this.row = 0;
        this.col = 0;
    }
    advance() {
        if (this.currentChar() === "\n") {
            this.col = 1;
            this.row = this.row + 1;
        }
        if (this.offset === this.raw.length) {
            return false;
        }
        this.col = this.col + 1;
        this.offset = this.offset + 1;
        return true;
    }
    getCol() {
        return this.col;
    }
    getRow() {
        return this.row;
    }
    prevChar() {
        if (this.offset - 1 < 0) {
            return "";
        }
        return this.raw.substr(this.offset - 1, 1);
    }
    prevPrevChar() {
        if (this.offset - 2 < 0) {
            return "";
        }
        return this.raw.substr(this.offset - 2, 2);
    }
    currentChar() {
        if (this.offset < 0) {
            return "\n"; // simulate newline at start of file to handle star(*) comments
        }
        else if (this.offset >= this.raw.length) {
            return "";
        }
        return this.raw.substr(this.offset, 1);
    }
    nextChar() {
        if (this.offset + 2 > this.raw.length) {
            return "";
        }
        return this.raw.substr(this.offset + 1, 1);
    }
    nextNextChar() {
        if (this.offset + 3 > this.raw.length) {
            return this.nextChar();
        }
        return this.raw.substr(this.offset + 1, 2);
    }
    getRaw() {
        return this.raw;
    }
    getOffset() {
        return this.offset;
    }
}
exports.LexerStream = LexerStream;
//# sourceMappingURL=lexer_stream.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AbstractToken = void 0;
const position_1 = __webpack_require__(/*! ../../../position */ "./node_modules/@abaplint/core/build/src/position.js");
class AbstractToken {
    constructor(start, str) {
        this.start = start;
        this.str = str;
    }
    // special function, for debugging purposes, see https://github.com/abaplint/abaplint/pull/3137
    [Symbol.for("debug.description")]() {
        return `${this.constructor.name} ${this.str}`;
    }
    getStr() {
        return this.str;
    }
    getRow() {
        return this.start.getRow();
    }
    getCol() {
        return this.start.getCol();
    }
    getStart() {
        return this.start;
    }
    getEnd() {
        return new position_1.Position(this.start.getRow(), this.start.getCol() + this.str.length);
    }
}
exports.AbstractToken = AbstractToken;
//# sourceMappingURL=abstract_token.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/at.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/at.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.At = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class At extends abstract_token_1.AbstractToken {
    static railroad() {
        return "@";
    }
}
exports.At = At;
//# sourceMappingURL=at.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/atw.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/atw.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AtW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class AtW extends abstract_token_1.AbstractToken {
    static railroad() {
        return "@ ";
    }
}
exports.AtW = AtW;
//# sourceMappingURL=atw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_left.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_left.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BracketLeft = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class BracketLeft extends abstract_token_1.AbstractToken {
    static railroad() {
        return "[";
    }
}
exports.BracketLeft = BracketLeft;
//# sourceMappingURL=bracket_left.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_leftw.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_leftw.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BracketLeftW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class BracketLeftW extends abstract_token_1.AbstractToken {
    static railroad() {
        return "[ ";
    }
}
exports.BracketLeftW = BracketLeftW;
//# sourceMappingURL=bracket_leftw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_right.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_right.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BracketRight = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class BracketRight extends abstract_token_1.AbstractToken {
    static railroad() {
        return "]";
    }
}
exports.BracketRight = BracketRight;
//# sourceMappingURL=bracket_right.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_rightw.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_rightw.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BracketRightW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class BracketRightW extends abstract_token_1.AbstractToken {
    static railroad() {
        return "] ";
    }
}
exports.BracketRightW = BracketRightW;
//# sourceMappingURL=bracket_rightw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/colon.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/colon.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Colon = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class Colon extends abstract_token_1.AbstractToken {
}
exports.Colon = Colon;
//# sourceMappingURL=colon.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/comment.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/comment.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Comment = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class Comment extends abstract_token_1.AbstractToken {
}
exports.Comment = Comment;
//# sourceMappingURL=comment.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/dash.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/dash.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Dash = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class Dash extends abstract_token_1.AbstractToken {
    static railroad() {
        return "-";
    }
}
exports.Dash = Dash;
//# sourceMappingURL=dash.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/dashw.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/dashw.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DashW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class DashW extends abstract_token_1.AbstractToken {
    static railroad() {
        return "- ";
    }
}
exports.DashW = DashW;
//# sourceMappingURL=dashw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/identifier.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/identifier.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Identifier = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class Identifier extends abstract_token_1.AbstractToken {
}
exports.Identifier = Identifier;
//# sourceMappingURL=identifier.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./at */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/at.js"), exports);
__exportStar(__webpack_require__(/*! ./atw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/atw.js"), exports);
__exportStar(__webpack_require__(/*! ./wat */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wat.js"), exports);
__exportStar(__webpack_require__(/*! ./watw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/watw.js"), exports);
__exportStar(__webpack_require__(/*! ./bracket_left */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_left.js"), exports);
__exportStar(__webpack_require__(/*! ./wbracket_left */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_left.js"), exports);
__exportStar(__webpack_require__(/*! ./bracket_leftw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_leftw.js"), exports);
__exportStar(__webpack_require__(/*! ./wbracket_leftw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_leftw.js"), exports);
__exportStar(__webpack_require__(/*! ./bracket_right */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_right.js"), exports);
__exportStar(__webpack_require__(/*! ./wbracket_right */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_right.js"), exports);
__exportStar(__webpack_require__(/*! ./bracket_rightw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/bracket_rightw.js"), exports);
__exportStar(__webpack_require__(/*! ./wbracket_rightw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_rightw.js"), exports);
__exportStar(__webpack_require__(/*! ./instance_arrow */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/instance_arrow.js"), exports);
__exportStar(__webpack_require__(/*! ./winstance_arrow */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/winstance_arrow.js"), exports);
__exportStar(__webpack_require__(/*! ./instance_arroww */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/instance_arroww.js"), exports);
__exportStar(__webpack_require__(/*! ./winstance_arroww */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/winstance_arroww.js"), exports);
__exportStar(__webpack_require__(/*! ./paren_left */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_left.js"), exports);
__exportStar(__webpack_require__(/*! ./wparen_left */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_left.js"), exports);
__exportStar(__webpack_require__(/*! ./paren_leftw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_leftw.js"), exports);
__exportStar(__webpack_require__(/*! ./wparen_leftw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_leftw.js"), exports);
__exportStar(__webpack_require__(/*! ./paren_right */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_right.js"), exports);
__exportStar(__webpack_require__(/*! ./wparen_right */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_right.js"), exports);
__exportStar(__webpack_require__(/*! ./paren_rightw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_rightw.js"), exports);
__exportStar(__webpack_require__(/*! ./wparen_rightw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_rightw.js"), exports);
__exportStar(__webpack_require__(/*! ./dash */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/dash.js"), exports);
__exportStar(__webpack_require__(/*! ./wdash */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wdash.js"), exports);
__exportStar(__webpack_require__(/*! ./dashw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/dashw.js"), exports);
__exportStar(__webpack_require__(/*! ./wdashw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wdashw.js"), exports);
__exportStar(__webpack_require__(/*! ./plus */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/plus.js"), exports);
__exportStar(__webpack_require__(/*! ./wplus */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wplus.js"), exports);
__exportStar(__webpack_require__(/*! ./plusw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/plusw.js"), exports);
__exportStar(__webpack_require__(/*! ./wplusw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wplusw.js"), exports);
__exportStar(__webpack_require__(/*! ./static_arrow */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/static_arrow.js"), exports);
__exportStar(__webpack_require__(/*! ./wstatic_arrow */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wstatic_arrow.js"), exports);
__exportStar(__webpack_require__(/*! ./static_arroww */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/static_arroww.js"), exports);
__exportStar(__webpack_require__(/*! ./wstatic_arroww */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wstatic_arroww.js"), exports);
__exportStar(__webpack_require__(/*! ./string */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string.js"), exports);
__exportStar(__webpack_require__(/*! ./string_template */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template.js"), exports);
__exportStar(__webpack_require__(/*! ./string_template_begin */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_begin.js"), exports);
__exportStar(__webpack_require__(/*! ./string_template_end */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_end.js"), exports);
__exportStar(__webpack_require__(/*! ./string_template_middle */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_middle.js"), exports);
__exportStar(__webpack_require__(/*! ./colon */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/colon.js"), exports);
__exportStar(__webpack_require__(/*! ./comment */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/comment.js"), exports);
__exportStar(__webpack_require__(/*! ./identifier */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/identifier.js"), exports);
__exportStar(__webpack_require__(/*! ./pragma */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/pragma.js"), exports);
__exportStar(__webpack_require__(/*! ./punctuation */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/punctuation.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/instance_arrow.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/instance_arrow.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InstanceArrow = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class InstanceArrow extends abstract_token_1.AbstractToken {
    static railroad() {
        return "->";
    }
}
exports.InstanceArrow = InstanceArrow;
//# sourceMappingURL=instance_arrow.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/instance_arroww.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/instance_arroww.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InstanceArrowW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class InstanceArrowW extends abstract_token_1.AbstractToken {
    static railroad() {
        return "-> ";
    }
}
exports.InstanceArrowW = InstanceArrowW;
//# sourceMappingURL=instance_arroww.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_left.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_left.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParenLeft = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class ParenLeft extends abstract_token_1.AbstractToken {
    static railroad() {
        return "(";
    }
}
exports.ParenLeft = ParenLeft;
//# sourceMappingURL=paren_left.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_leftw.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_leftw.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParenLeftW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class ParenLeftW extends abstract_token_1.AbstractToken {
    static railroad() {
        return "( ";
    }
}
exports.ParenLeftW = ParenLeftW;
//# sourceMappingURL=paren_leftw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_right.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_right.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParenRight = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class ParenRight extends abstract_token_1.AbstractToken {
    static railroad() {
        return ")";
    }
}
exports.ParenRight = ParenRight;
//# sourceMappingURL=paren_right.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_rightw.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/paren_rightw.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParenRightW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class ParenRightW extends abstract_token_1.AbstractToken {
    static railroad() {
        return ") ";
    }
}
exports.ParenRightW = ParenRightW;
//# sourceMappingURL=paren_rightw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/plus.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/plus.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Plus = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class Plus extends abstract_token_1.AbstractToken {
    static railroad() {
        return "+";
    }
}
exports.Plus = Plus;
//# sourceMappingURL=plus.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/plusw.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/plusw.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PlusW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class PlusW extends abstract_token_1.AbstractToken {
    static railroad() {
        return "+ ";
    }
}
exports.PlusW = PlusW;
//# sourceMappingURL=plusw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/pragma.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/pragma.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Pragma = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class Pragma extends abstract_token_1.AbstractToken {
}
exports.Pragma = Pragma;
//# sourceMappingURL=pragma.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/punctuation.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/punctuation.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Punctuation = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class Punctuation extends abstract_token_1.AbstractToken {
}
exports.Punctuation = Punctuation;
//# sourceMappingURL=punctuation.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/static_arrow.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/static_arrow.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StaticArrow = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class StaticArrow extends abstract_token_1.AbstractToken {
    static railroad() {
        return "=>";
    }
}
exports.StaticArrow = StaticArrow;
//# sourceMappingURL=static_arrow.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/static_arroww.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/static_arroww.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StaticArrowW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class StaticArrowW extends abstract_token_1.AbstractToken {
    static railroad() {
        return "=> ";
    }
}
exports.StaticArrowW = StaticArrowW;
//# sourceMappingURL=static_arroww.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringToken = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class StringToken extends abstract_token_1.AbstractToken {
}
exports.StringToken = StringToken;
//# sourceMappingURL=string.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringTemplate = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class StringTemplate extends abstract_token_1.AbstractToken {
}
exports.StringTemplate = StringTemplate;
//# sourceMappingURL=string_template.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_begin.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_begin.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringTemplateBegin = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class StringTemplateBegin extends abstract_token_1.AbstractToken {
}
exports.StringTemplateBegin = StringTemplateBegin;
//# sourceMappingURL=string_template_begin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_end.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_end.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringTemplateEnd = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class StringTemplateEnd extends abstract_token_1.AbstractToken {
}
exports.StringTemplateEnd = StringTemplateEnd;
//# sourceMappingURL=string_template_end.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_middle.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/string_template_middle.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringTemplateMiddle = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class StringTemplateMiddle extends abstract_token_1.AbstractToken {
}
exports.StringTemplateMiddle = StringTemplateMiddle;
//# sourceMappingURL=string_template_middle.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wat.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wat.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WAt = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WAt extends abstract_token_1.AbstractToken {
    static railroad() {
        return " @";
    }
}
exports.WAt = WAt;
//# sourceMappingURL=wat.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/watw.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/watw.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WAtW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WAtW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " @ ";
    }
}
exports.WAtW = WAtW;
//# sourceMappingURL=watw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_left.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_left.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WBracketLeft = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WBracketLeft extends abstract_token_1.AbstractToken {
    static railroad() {
        return " [";
    }
}
exports.WBracketLeft = WBracketLeft;
//# sourceMappingURL=wbracket_left.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_leftw.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_leftw.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WBracketLeftW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WBracketLeftW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " [ ";
    }
}
exports.WBracketLeftW = WBracketLeftW;
//# sourceMappingURL=wbracket_leftw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_right.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_right.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WBracketRight = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WBracketRight extends abstract_token_1.AbstractToken {
    static railroad() {
        return " ]";
    }
}
exports.WBracketRight = WBracketRight;
//# sourceMappingURL=wbracket_right.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_rightw.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wbracket_rightw.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WBracketRightW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WBracketRightW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " ] ";
    }
}
exports.WBracketRightW = WBracketRightW;
//# sourceMappingURL=wbracket_rightw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wdash.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wdash.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WDash = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WDash extends abstract_token_1.AbstractToken {
    static railroad() {
        return " -";
    }
}
exports.WDash = WDash;
//# sourceMappingURL=wdash.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wdashw.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wdashw.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WDashW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WDashW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " - ";
    }
}
exports.WDashW = WDashW;
//# sourceMappingURL=wdashw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/winstance_arrow.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/winstance_arrow.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WInstanceArrow = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WInstanceArrow extends abstract_token_1.AbstractToken {
    static railroad() {
        return " ->";
    }
}
exports.WInstanceArrow = WInstanceArrow;
//# sourceMappingURL=winstance_arrow.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/winstance_arroww.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/winstance_arroww.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WInstanceArrowW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WInstanceArrowW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " -> ";
    }
}
exports.WInstanceArrowW = WInstanceArrowW;
//# sourceMappingURL=winstance_arroww.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_left.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_left.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WParenLeft = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WParenLeft extends abstract_token_1.AbstractToken {
    static railroad() {
        return " (";
    }
}
exports.WParenLeft = WParenLeft;
//# sourceMappingURL=wparen_left.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_leftw.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_leftw.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WParenLeftW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WParenLeftW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " ( ";
    }
}
exports.WParenLeftW = WParenLeftW;
//# sourceMappingURL=wparen_leftw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_right.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_right.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WParenRight = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WParenRight extends abstract_token_1.AbstractToken {
    static railroad() {
        return " )";
    }
}
exports.WParenRight = WParenRight;
//# sourceMappingURL=wparen_right.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_rightw.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_rightw.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WParenRightW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WParenRightW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " ) ";
    }
}
exports.WParenRightW = WParenRightW;
//# sourceMappingURL=wparen_rightw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wplus.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wplus.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WPlus = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WPlus extends abstract_token_1.AbstractToken {
    static railroad() {
        return " +";
    }
}
exports.WPlus = WPlus;
//# sourceMappingURL=wplus.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wplusw.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wplusw.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WPlusW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WPlusW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " + ";
    }
}
exports.WPlusW = WPlusW;
//# sourceMappingURL=wplusw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wstatic_arrow.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wstatic_arrow.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WStaticArrow = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WStaticArrow extends abstract_token_1.AbstractToken {
    static railroad() {
        return " =>";
    }
}
exports.WStaticArrow = WStaticArrow;
//# sourceMappingURL=wstatic_arrow.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wstatic_arroww.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wstatic_arroww.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WStaticArrowW = void 0;
const abstract_token_1 = __webpack_require__(/*! ./abstract_token */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/abstract_token.js");
class WStaticArrowW extends abstract_token_1.AbstractToken {
    static railroad() {
        return " => ";
    }
}
exports.WStaticArrowW = WStaticArrowW;
//# sourceMappingURL=wstatic_arroww.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.failStar = exports.failCombinator = exports.verNot = exports.ver = exports.plusPrio = exports.plus = exports.starPrio = exports.star = exports.per = exports.optPrio = exports.opt = exports.altPrio = exports.alt = exports.seq = exports.tok = exports.regex = exports.str = exports.Combi = exports.Expression = void 0;
const Tokens = __webpack_require__(/*! ../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const nodes_1 = __webpack_require__(/*! ../nodes */ "./node_modules/@abaplint/core/build/src/abap/nodes/index.js");
const version_1 = __webpack_require__(/*! ../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const result_1 = __webpack_require__(/*! ./result */ "./node_modules/@abaplint/core/build/src/abap/2_statements/result.js");
class Regex {
    constructor(r) {
        this.regexp = r;
    }
    listKeywords() {
        return [];
    }
    getUsing() {
        return [];
    }
    run(r) {
        const result = [];
        for (const input of r) {
            if (input.remainingLength() === 0) {
                continue;
            }
            const token = input.peek();
            if (this.regexp.test(token.getStr()) === true) {
                result.push(input.shift(new nodes_1.TokenNodeRegex(token)));
            }
        }
        return result;
    }
    railroad() {
        return "Railroad.Terminal(\"" + this.regexp.source.replace(/\\/g, "\\\\") + "\")";
    }
    toStr() {
        return this.regexp.toString();
    }
    first() {
        return [""];
    }
}
class Word {
    constructor(s) {
        this.s = s.toUpperCase();
    }
    listKeywords() {
        return [this.s];
    }
    getUsing() {
        return [];
    }
    run(r) {
        const result = [];
        for (const input of r) {
            if (input.remainingLength() !== 0
                && input.peek().getStr().toUpperCase() === this.s) {
                //        console.log("match, " + this.s + result.length);
                result.push(input.shift(new nodes_1.TokenNode(input.peek())));
            }
        }
        return result;
    }
    railroad() {
        return "Railroad.Terminal('\"" + this.s + "\"')";
    }
    toStr() {
        return "\"" + this.s + "\"";
    }
    first() {
        return [this.s];
    }
}
class Token {
    constructor(s) {
        this.name = s.toUpperCase();
    }
    listKeywords() {
        return [];
    }
    getUsing() {
        return [];
    }
    run(r) {
        const result = [];
        for (const input of r) {
            if (input.remainingLength() !== 0
                && input.peek().constructor.name.toUpperCase() === this.name) {
                result.push(input.shift(new nodes_1.TokenNode(input.peek())));
            }
        }
        return result;
    }
    railroad() {
        let text = this.name;
        const toke = Tokens;
        for (const token in Tokens) {
            if (token.toUpperCase() === this.name && toke[token].railroad) {
                text = toke[token].railroad();
                break;
            }
        }
        return "Railroad.Terminal('!\"" + text + "\"')";
    }
    toStr() {
        return "Token \"" + this.name + "\"";
    }
    first() {
        return [""];
    }
}
class Vers {
    constructor(version, runnable, or) {
        this.version = version;
        this.runnable = runnable;
        this.or = or;
    }
    listKeywords() {
        return this.runnable.listKeywords();
    }
    run(r) {
        const targetVersion = Combi.getVersion();
        if (this.or && targetVersion === this.or) {
            return this.runnable.run(r);
        }
        else if (targetVersion === version_1.Version.OpenABAP) {
            if (this.version > version_1.Version.v702) {
                return [];
            }
            else {
                return this.runnable.run(r);
            }
        }
        else if (targetVersion >= this.version || targetVersion === version_1.Version.Cloud) {
            return this.runnable.run(r);
        }
        else {
            return [];
        }
    }
    getUsing() {
        return this.runnable.getUsing();
    }
    railroad() {
        let text = this.version;
        if (this.or) {
            text += " or " + this.or;
        }
        return "Railroad.Sequence(Railroad.Comment(\"" +
            text +
            "\", {}), " +
            this.runnable.railroad() +
            ")";
    }
    toStr() {
        return "Version(" + this.runnable.toStr() + ")";
    }
    first() {
        return this.runnable.first();
    }
}
class VersNot {
    constructor(version, runnable) {
        this.version = version;
        this.runnable = runnable;
    }
    listKeywords() {
        return this.runnable.listKeywords();
    }
    getUsing() {
        return this.runnable.getUsing();
    }
    run(r) {
        if (Combi.getVersion() !== this.version) {
            return this.runnable.run(r);
        }
        else {
            return [];
        }
    }
    railroad() {
        return "Railroad.Sequence(Railroad.Comment(\"not " +
            this.version +
            "\", {}), " +
            this.runnable.railroad() +
            ")";
    }
    toStr() {
        return "VersionNot(" + this.runnable.toStr() + ")";
    }
    first() {
        return this.runnable.first();
    }
}
class OptionalPriority {
    constructor(optional) {
        this.optional = optional;
    }
    listKeywords() {
        return this.optional.listKeywords();
    }
    getUsing() {
        return this.optional.getUsing();
    }
    run(r) {
        const result = [];
        for (const input of r) {
            const res = this.optional.run([input]);
            if (res.length > 1) {
                result.push(...res);
            }
            else if (res.length === 0) {
                result.push(input);
            }
            else if (res[0].remainingLength() < input.remainingLength()) {
                result.push(...res);
            }
            else {
                result.push(input);
            }
        }
        return result;
    }
    railroad() {
        return "Railroad.Optional(" + this.optional.railroad() + ")";
    }
    toStr() {
        return "opt(" + this.optional.toStr() + ")";
    }
    first() {
        return [""];
    }
}
class Optional {
    constructor(optional) {
        this.optional = optional;
    }
    listKeywords() {
        return this.optional.listKeywords();
    }
    getUsing() {
        return this.optional.getUsing();
    }
    run(r) {
        const result = [];
        for (const input of r) {
            result.push(input);
            const res = this.optional.run([input]);
            result.push(...res);
        }
        return result;
    }
    railroad() {
        return "Railroad.Optional(" + this.optional.railroad() + ")";
    }
    toStr() {
        return "opt(" + this.optional.toStr() + ")";
    }
    first() {
        return [""];
    }
}
class Star {
    constructor(sta) {
        this.sta = sta;
    }
    listKeywords() {
        return this.sta.listKeywords();
    }
    getUsing() {
        return this.sta.getUsing();
    }
    run(r) {
        const result = r;
        try {
            let res = r;
            let input = [];
            for (;;) {
                input = res;
                res = this.sta.run(input);
                if (res.length === 0) {
                    break;
                }
                result.push(...res);
            }
        }
        catch (err) {
            if (err instanceof FailStarError) {
                return result;
            }
            throw err;
        }
        //    console.dir(result);
        return result;
    }
    railroad() {
        return "Railroad.ZeroOrMore(" + this.sta.railroad() + ")";
    }
    toStr() {
        return "star(" + this.sta.toStr() + ")";
    }
    first() {
        return [""];
    }
}
class StarPriority {
    constructor(sta) {
        this.sta = sta;
    }
    listKeywords() {
        return this.sta.listKeywords();
    }
    getUsing() {
        return this.sta.getUsing();
    }
    run(r) {
        let result = r;
        let res = r;
        //    let input: Result[] = [];
        let prev;
        for (;;) {
            //      input = res;
            res = this.sta.run(res);
            if (res.length === 0) {
                if (prev !== undefined) {
                    //          console.log("star length: " + prev.length);
                    let best = Number.MAX_SAFE_INTEGER;
                    for (const p of prev) {
                        if (p.remainingLength() < best) {
                            result = [p];
                            best = p.remainingLength();
                        }
                    }
                }
                break;
            }
            prev = res;
        }
        return result;
    }
    railroad() {
        return "Railroad.ZeroOrMore(" + this.sta.railroad() + ")";
    }
    toStr() {
        return "star(" + this.sta.toStr() + ")";
    }
    first() {
        return [""];
    }
}
class Plus {
    constructor(plu) {
        this.plu = plu;
        this.sub = new Sequence([this.plu, new Star(this.plu)]);
    }
    listKeywords() {
        return this.plu.listKeywords();
    }
    getUsing() {
        return this.plu.getUsing();
    }
    run(r) {
        return this.sub.run(r);
    }
    railroad() {
        return "Railroad.OneOrMore(" + this.plu.railroad() + ")";
    }
    toStr() {
        return "plus(" + this.plu.toStr() + ")";
    }
    first() {
        return this.plu.first();
    }
}
class PlusPriority {
    constructor(plu) {
        this.plu = plu;
        this.sub = new Sequence([this.plu, new StarPriority(this.plu)]);
    }
    listKeywords() {
        return this.plu.listKeywords();
    }
    getUsing() {
        return this.plu.getUsing();
    }
    run(r) {
        return this.sub.run(r);
    }
    railroad() {
        return "Railroad.OneOrMore(" + this.plu.railroad() + ")";
    }
    toStr() {
        return "plus(" + this.plu.toStr() + ")";
    }
    first() {
        return this.plu.first();
    }
}
class Sequence {
    constructor(list) {
        if (list.length < 2) {
            throw new Error("Sequence, length error");
        }
        this.list = list;
    }
    listKeywords() {
        const ret = [];
        for (const i of this.list) {
            ret.push(...i.listKeywords());
        }
        return ret;
    }
    getUsing() {
        return this.list.reduce((a, c) => { return a.concat(c.getUsing()); }, []);
    }
    run(r) {
        const result = [];
        for (const input of r) {
            let temp = [input];
            let match = true;
            for (const sequence of this.list) {
                temp = sequence.run(temp);
                if (temp.length === 0) {
                    match = false;
                    break;
                }
            }
            if (match === true) {
                result.push(...temp);
            }
        }
        return result;
    }
    railroad() {
        const children = this.list.map((e) => { return e.railroad(); });
        return "Railroad.Sequence(" + children.join() + ")";
    }
    toStr() {
        let ret = "";
        for (const i of this.list) {
            ret = ret + i.toStr() + ",";
        }
        return "seq(" + ret + ")";
    }
    first() {
        return this.list[0].first();
    }
}
class WordSequence {
    constructor(stri) {
        this.words = [];
        this.stri = stri;
        const foo = this.stri.replace(/-/g, " - ");
        const split = foo.split(" ");
        for (const st of split) {
            // todo, use Dash token
            this.words.push(new Word(st));
        }
        this.seq = new Sequence(this.words);
    }
    listKeywords() {
        return [this.stri.toString()];
    }
    getUsing() {
        return [];
    }
    run(r) {
        return this.seq.run(r);
    }
    railroad() {
        return "Railroad.Terminal('\"" + this.stri + "\"')";
    }
    toStr() {
        return "str(" + this.stri + ")";
    }
    first() {
        return this.words[0].first();
    }
}
class Expression {
    constructor() {
        this.runnable = undefined;
    }
    run(r) {
        const results = [];
        if (this.runnable === undefined) {
            this.runnable = this.getRunnable();
        }
        for (const input of r) {
            const temp = this.runnable.run([input]);
            for (const t of temp) {
                let consumed = input.remainingLength() - t.remainingLength();
                if (consumed > 0) {
                    const originalLength = t.getNodes().length;
                    const children = [];
                    while (consumed > 0) {
                        const sub = t.popNode();
                        if (sub) {
                            children.push(sub);
                            consumed = consumed - sub.countTokens();
                        }
                    }
                    const re = new nodes_1.ExpressionNode(this);
                    re.setChildren(children.reverse());
                    const n = t.getNodes().slice(0, originalLength - consumed);
                    n.push(re);
                    t.setNodes(n);
                }
                results.push(t);
            }
        }
        //    console.dir(results);
        return results;
    }
    listKeywords() {
        // do not recurse, all Expressions are evaluated only on first level
        return [];
    }
    getUsing() {
        return ["expression/" + this.getName()];
    }
    getName() {
        return this.constructor.name;
    }
    railroad() {
        return "Railroad.NonTerminal('" + this.getName() + "', {href: '#/expression/" + this.getName() + "'})";
    }
    toStr() {
        return "expression(" + this.getName() + ")";
    }
    first() {
        return this.getRunnable().first();
    }
}
exports.Expression = Expression;
class Permutation {
    constructor(list) {
        if (list.length < 2) {
            throw new Error("Permutation, length error, got " + list.length);
        }
        this.list = list;
    }
    listKeywords() {
        const ret = [];
        for (const i of this.list) {
            ret.push(...i.listKeywords());
        }
        return ret;
    }
    getUsing() {
        return this.list.reduce((a, c) => { return a.concat(c.getUsing()); }, []);
    }
    run(r) {
        const result = [];
        const copy = this.list.slice();
        for (let index = 0; index < this.list.length; index++) {
            const temp = this.list[index].run(r);
            if (temp.length !== 0) {
                // match
                result.push(...temp);
                const left = copy;
                left.splice(index, 1);
                if (left.length === 1) {
                    result.push(...left[0].run(temp));
                }
                else {
                    result.push(...new Permutation(left).run(temp));
                }
            }
        }
        return result;
    }
    railroad() {
        const children = this.list.map((e) => { return e.railroad(); });
        return "Railroad.MultipleChoice(0, 'any'," + children.join() + ")";
    }
    toStr() {
        const children = this.list.map((e) => { return e.toStr(); });
        return "per(" + children.join() + ")";
    }
    first() {
        return [""];
    }
}
class FailCombinatorError extends Error {
}
class FailStarError extends Error {
}
class FailCombinator {
    listKeywords() {
        return [];
    }
    getUsing() {
        return [];
    }
    run(_r) {
        throw new FailCombinatorError();
    }
    railroad() {
        return "Railroad.Terminal('!FailCombinator')";
    }
    toStr() {
        return "fail()";
    }
    first() {
        return [];
    }
}
// Note that Plus is implemented with Star
class FailStar {
    listKeywords() {
        return [];
    }
    getUsing() {
        return [];
    }
    run(_r) {
        throw new FailStarError();
    }
    railroad() {
        return "Railroad.Terminal('!FailStar')";
    }
    toStr() {
        return "fail()";
    }
    first() {
        return [];
    }
}
class Alternative {
    constructor(list) {
        if (list.length < 2) {
            throw new Error("Alternative, length error");
        }
        this.list = list;
    }
    listKeywords() {
        const ret = [];
        for (const i of this.list) {
            ret.push(...i.listKeywords());
        }
        return ret;
    }
    getUsing() {
        return this.list.reduce((a, c) => { return a.concat(c.getUsing()); }, []);
    }
    run(r) {
        const result = [];
        for (const sequ of this.list) {
            const temp = sequ.run(r);
            result.push(...temp);
        }
        return result;
    }
    railroad() {
        const children = this.list.map((e) => { return e.railroad(); });
        return "Railroad.Choice(0, " + children.join() + ")";
    }
    toStr() {
        let ret = "";
        for (const i of this.list) {
            ret = ret + i.toStr() + ",";
        }
        return "alt(" + ret + ")";
    }
    first() {
        if (this.list.length !== 2) {
            return [""];
        }
        const f1 = this.list[0].first();
        const f2 = this.list[1].first();
        if (f1.length === 1 && f1[0] === "") {
            return f1;
        }
        if (f2.length === 1 && f2[0] === "") {
            return f2;
        }
        if (f1.length === 1 && f2.length === 1 && f1[0] === f2[0]) {
            return f1;
        }
        f1.push(...f2);
        return f1;
    }
}
// prioritized alternative, skip others if match found
class AlternativePriority {
    constructor(list) {
        if (list.length < 2) {
            throw new Error("Alternative, length error");
        }
        this.list = list;
    }
    listKeywords() {
        const ret = [];
        for (const i of this.list) {
            ret.push(...i.listKeywords());
        }
        return ret;
    }
    getUsing() {
        return this.list.reduce((a, c) => { return a.concat(c.getUsing()); }, []);
    }
    run(r) {
        const result = [];
        for (const sequ of this.list) {
            //      console.log(seq.toStr());
            const temp = sequ.run(r);
            if (temp.length > 0) {
                result.push(...temp);
                break;
            }
        }
        return result;
    }
    railroad() {
        const children = this.list.map((e) => { return e.railroad(); });
        return "Railroad.Choice(0, " + children.join() + ")";
    }
    toStr() {
        let ret = "";
        for (const i of this.list) {
            ret = ret + i.toStr() + ",";
        }
        return "alt(" + ret + ")";
    }
    first() {
        if (this.list.length !== 2) {
            return [""];
        }
        const f1 = this.list[0].first();
        const f2 = this.list[1].first();
        if (f1.length === 1 && f1[0] === "") {
            return f1;
        }
        if (f2.length === 1 && f2[0] === "") {
            return f2;
        }
        if (f1.length === 1 && f2.length === 1 && f1[0] === f2[0]) {
            return f1;
        }
        f1.push(...f2);
        return f1;
    }
}
class Combi {
    static railroad(runnable, complex = false) {
        // todo, move method to graph.js?
        let type = "Railroad.Diagram(";
        if (complex === true) {
            type = "Railroad.ComplexDiagram(";
        }
        const result = "Railroad.Diagram.INTERNAL_ALIGNMENT = 'left';\n" +
            type +
            runnable.railroad() +
            ").toString();";
        return result;
    }
    static listKeywords(runnable) {
        // todo, move these walkers of the syntax tree to some abstraction?
        let res = runnable.listKeywords();
        // remove duplicates
        res = res.filter((x, i, a) => { return a.indexOf(x) === i; });
        return res;
    }
    // assumption: no pragmas supplied in tokens input
    static run(runnable, tokens, version) {
        this.ver = version;
        const input = new result_1.Result(tokens, 0);
        try {
            const result = runnable.run([input]);
            /*
                console.log("res: " + result.length);
                for (const res of result) {
                  console.dir(res.getNodes().map(n => n.get().constructor.name));
                  console.dir(res.getNodes().map(n => n.concatTokens()));
                }
            */
            for (const res of result) {
                if (res.remainingLength() === 0) {
                    return res.getNodes();
                }
            }
        }
        catch (err) {
            if (err instanceof FailCombinatorError) {
                return undefined;
            }
            throw err;
        }
        return undefined;
    }
    static getVersion() {
        return this.ver;
    }
}
exports.Combi = Combi;
// -----------------------------------------------------------------------------
function str(s) {
    if (s.indexOf(" ") > 0 || s.indexOf("-") > 0) {
        return new WordSequence(s);
    }
    else {
        return new Word(s);
    }
}
exports.str = str;
function regex(r) {
    return new Regex(r);
}
exports.regex = regex;
function tok(t) {
    return new Token(t.name);
}
exports.tok = tok;
const expressionSingletons = {};
const stringSingletons = {};
function map(s) {
    const type = typeof s;
    if (type === "string") {
        if (stringSingletons[s] === undefined) {
            stringSingletons[s] = str(s);
        }
        return stringSingletons[s];
    }
    else if (type === "function") {
        // @ts-ignore
        const name = s.name;
        if (expressionSingletons[name] === undefined) {
            // @ts-ignore
            expressionSingletons[name] = new s();
        }
        return expressionSingletons[name];
    }
    else {
        return s;
    }
}
function seq(first, second, ...rest) {
    const list = [map(first), map(second)];
    list.push(...rest.map(map));
    return new Sequence(list);
}
exports.seq = seq;
function alt(first, second, ...rest) {
    const list = [map(first), map(second)];
    list.push(...rest.map(map));
    return new Alternative(list);
}
exports.alt = alt;
function altPrio(first, second, ...rest) {
    const list = [map(first), map(second)];
    list.push(...rest.map(map));
    return new AlternativePriority(list);
}
exports.altPrio = altPrio;
function opt(first) {
    return new Optional(map(first));
}
exports.opt = opt;
function optPrio(first) {
    return new OptionalPriority(map(first));
}
exports.optPrio = optPrio;
function per(first, second, ...rest) {
    const list = [map(first), map(second)];
    list.push(...rest.map(map));
    return new Permutation(list);
}
exports.per = per;
function star(first) {
    return new Star(map(first));
}
exports.star = star;
function starPrio(first) {
    return new StarPriority(map(first));
}
exports.starPrio = starPrio;
function plus(first) {
    return new Plus(map(first));
}
exports.plus = plus;
function plusPrio(first) {
    return new PlusPriority(map(first));
}
exports.plusPrio = plusPrio;
function ver(version, first, or) {
    return new Vers(version, map(first), or);
}
exports.ver = ver;
function verNot(version, first) {
    return new VersNot(version, map(first));
}
exports.verNot = verNot;
function failCombinator() {
    return new FailCombinator();
}
exports.failCombinator = failCombinator;
function failStar() {
    return new FailStar();
}
exports.failStar = failStar;
//# sourceMappingURL=combi.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expand_macros.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expand_macros.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExpandMacros = void 0;
const Statements = __webpack_require__(/*! ./statements */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js");
const Expressions = __webpack_require__(/*! ./expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const Tokens = __webpack_require__(/*! ../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _statement_1 = __webpack_require__(/*! ./statements/_statement */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/_statement.js");
const statement_node_1 = __webpack_require__(/*! ../nodes/statement_node */ "./node_modules/@abaplint/core/build/src/abap/nodes/statement_node.js");
const token_node_1 = __webpack_require__(/*! ../nodes/token_node */ "./node_modules/@abaplint/core/build/src/abap/nodes/token_node.js");
const statement_parser_1 = __webpack_require__(/*! ./statement_parser */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statement_parser.js");
const memory_file_1 = __webpack_require__(/*! ../../files/memory_file */ "./node_modules/@abaplint/core/build/src/files/memory_file.js");
const lexer_1 = __webpack_require__(/*! ../1_lexer/lexer */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/lexer.js");
const virtual_position_1 = __webpack_require__(/*! ../../virtual_position */ "./node_modules/@abaplint/core/build/src/virtual_position.js");
class Macros {
    constructor(globalMacros) {
        this.macros = {};
        for (const m of globalMacros) {
            this.macros[m.toUpperCase()] = [];
        }
    }
    addMacro(name, contents) {
        if (this.isMacro(name)) {
            return;
        }
        this.macros[name.toUpperCase()] = contents;
    }
    getContents(name) {
        return this.macros[name.toUpperCase()];
    }
    listMacroNames() {
        return Object.keys(this.macros);
    }
    isMacro(name) {
        if (this.macros[name.toUpperCase()]) {
            return true;
        }
        return false;
    }
}
class ExpandMacros {
    // "reg" must be supplied if there are cross object macros via INCLUDE
    constructor(globalMacros, version, reg) {
        this.macros = new Macros(globalMacros);
        this.version = version;
        this.globalMacros = globalMacros;
        this.reg = reg;
    }
    find(statements) {
        var _a, _b;
        let name = undefined;
        let contents = [];
        for (let i = 0; i < statements.length; i++) {
            const statement = statements[i];
            const type = statement.get();
            if (type instanceof Statements.Define) {
                // todo, will this break if first token is a pragma?
                name = statement.getTokens()[1].getStr();
                contents = [];
            }
            else if (type instanceof Statements.Include) {
                const includeName = (_a = statement.findDirectExpression(Expressions.IncludeName)) === null || _a === void 0 ? void 0 : _a.concatTokens();
                // todo, this does not take function module includes into account
                const prog = (_b = this.reg) === null || _b === void 0 ? void 0 : _b.getObject("PROG", includeName);
                if (prog) {
                    prog.parse(this.version, this.globalMacros, this.reg);
                    const main = prog.getMainABAPFile();
                    if (main) {
                        // slow, this copies everything,
                        this.find([...main.getStatements()]);
                    }
                }
            }
            else if (name) {
                if (type instanceof Statements.EndOfDefinition) {
                    this.macros.addMacro(name, contents);
                    name = undefined;
                }
                else if (!(type instanceof _statement_1.Comment)) {
                    statements[i] = new statement_node_1.StatementNode(new _statement_1.MacroContent()).setChildren(this.tokensToNodes(statement.getTokens()));
                    contents.push(statements[i]);
                }
            }
        }
    }
    handleMacros(statements) {
        const result = [];
        let containsUnknown = false;
        for (const statement of statements) {
            const type = statement.get();
            if (type instanceof _statement_1.Unknown || type instanceof _statement_1.MacroCall) {
                const macroName = this.findName(statement.getTokens());
                if (macroName && this.macros.isMacro(macroName)) {
                    result.push(new statement_node_1.StatementNode(new _statement_1.MacroCall(), statement.getColon()).setChildren(this.tokensToNodes(statement.getTokens())));
                    const expanded = this.expandContents(macroName, statement);
                    const handled = this.handleMacros(expanded);
                    for (const e of handled.statements) {
                        result.push(e);
                    }
                    if (handled.containsUnknown === true) {
                        containsUnknown = true;
                    }
                    continue;
                }
                else {
                    containsUnknown = true;
                }
            }
            result.push(statement);
        }
        return { statements: result, containsUnknown };
    }
    //////////////
    expandContents(name, statement) {
        const contents = this.macros.getContents(name);
        if (contents === undefined || contents.length === 0) {
            return [];
        }
        let str = "";
        for (const c of contents) {
            let concat = c.concatTokens();
            if (c.getTerminator() === ",") {
                // workaround for chained statements
                concat = concat.replace(/,$/, ".");
            }
            str += concat + "\n";
        }
        const inputs = this.buildInput(statement);
        let i = 1;
        for (const input of inputs) {
            const search = "&" + i;
            const reg = new RegExp(search, "g");
            str = str.replace(reg, input);
            i++;
        }
        const file = new memory_file_1.MemoryFile("expand_macros.abap.prog", str);
        const lexerResult = new lexer_1.Lexer().run(file, statement.getFirstToken().getStart());
        const result = new statement_parser_1.StatementParser(this.version, this.reg).run([lexerResult], this.macros.listMacroNames());
        return result[0].statements;
    }
    buildInput(statement) {
        const result = [];
        const tokens = statement.getTokens();
        let build = "";
        for (let i = 1; i < tokens.length - 1; i++) {
            const now = tokens[i];
            let next = tokens[i + 1];
            if (i + 2 === tokens.length) {
                next = undefined; // dont take the punctuation
            }
            // argh, macros is a nightmare
            let end = now.getStart();
            if (end instanceof virtual_position_1.VirtualPosition) {
                end = new virtual_position_1.VirtualPosition(end, end.vrow, end.vcol + now.getStr().length);
            }
            else {
                end = now.getEnd();
            }
            if (next && next.getStart().equals(end)) {
                build += now.getStr();
            }
            else {
                build += now.getStr();
                result.push(build);
                build = "";
            }
        }
        return result;
    }
    findName(tokens) {
        let macroName = undefined;
        let previous = undefined;
        for (const i of tokens) {
            if (previous && (previous === null || previous === void 0 ? void 0 : previous.getEnd().getCol()) !== i.getStart().getCol()) {
                break;
            }
            else if (i instanceof Tokens.Identifier || i.getStr() === "-") {
                if (macroName === undefined) {
                    macroName = i.getStr();
                }
                else {
                    macroName += i.getStr();
                }
            }
            else if (i instanceof Tokens.Pragma) {
                continue;
            }
            else {
                break;
            }
            previous = i;
        }
        return macroName;
    }
    tokensToNodes(tokens) {
        const ret = [];
        for (const t of tokens) {
            ret.push(new token_node_1.TokenNode(t));
        }
        return ret;
    }
}
exports.ExpandMacros = ExpandMacros;
//# sourceMappingURL=expand_macros.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/abstract.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/abstract.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Abstract = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Abstract extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.str)("ABSTRACT");
    }
}
exports.Abstract = Abstract;
//# sourceMappingURL=abstract.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/abstract_methods.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/abstract_methods.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AbstractMethods = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const method_name_1 = __webpack_require__(/*! ./method_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_name.js");
class AbstractMethods extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("ABSTRACT METHODS", (0, combi_1.plusPrio)(method_name_1.MethodName));
    }
}
exports.AbstractMethods = AbstractMethods;
//# sourceMappingURL=abstract_methods.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/and_return.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/and_return.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AndReturn = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class AndReturn extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.str)("AND RETURN");
    }
}
exports.AndReturn = AndReturn;
//# sourceMappingURL=and_return.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arith_operator.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arith_operator.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ArithOperator = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class ArithOperator extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WPlusW), (0, combi_1.tok)(tokens_1.WDashW), "*", "**", "/", "BIT-XOR", "BIT-AND", "BIT-OR", "DIV", "MOD");
        return ret;
    }
}
exports.ArithOperator = ArithOperator;
//# sourceMappingURL=arith_operator.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arrow.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arrow.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Arrow = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class Arrow extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.InstanceArrow), (0, combi_1.tok)(tokens_1.StaticArrow));
    }
}
exports.Arrow = Arrow;
//# sourceMappingURL=arrow.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arrow_or_dash.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arrow_or_dash.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ArrowOrDash = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class ArrowOrDash extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.InstanceArrow), (0, combi_1.tok)(tokens_1.StaticArrow), (0, combi_1.tok)(tokens_1.Dash));
    }
}
exports.ArrowOrDash = ArrowOrDash;
//# sourceMappingURL=arrow_or_dash.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/assign_source.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/assign_source.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AssignSource = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
const field_1 = __webpack_require__(/*! ./field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field.js");
const simple_source3_1 = __webpack_require__(/*! ./simple_source3 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source3.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class AssignSource extends combi_1.Expression {
    getRunnable() {
        const component = (0, combi_1.seq)("COMPONENT", (0, combi_1.alt)(simple_source3_1.SimpleSource3, (0, combi_1.ver)(version_1.Version.v740sp02, source_1.Source)), "OF STRUCTURE", source_1.Source);
        const tableField = (0, combi_1.seq)("TABLE FIELD", (0, combi_1.alt)(source_1.Source, dynamic_1.Dynamic));
        const arrow = (0, combi_1.alt)((0, combi_1.tok)(tokens_1.InstanceArrow), (0, combi_1.tok)(tokens_1.StaticArrow));
        const source = (0, combi_1.alt)((0, combi_1.seq)(source_1.Source, (0, combi_1.opt)((0, combi_1.seq)(arrow, dynamic_1.Dynamic))), component, tableField, (0, combi_1.seq)(dynamic_1.Dynamic, (0, combi_1.opt)((0, combi_1.seq)(arrow, (0, combi_1.alt)(field_1.Field, dynamic_1.Dynamic)))));
        return source;
    }
}
exports.AssignSource = AssignSource;
//# sourceMappingURL=assign_source.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/association_name.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/association_name.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AssociationName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class AssociationName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^\\_[\w]+$/);
    }
}
exports.AssociationName = AssociationName;
//# sourceMappingURL=association_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_chain.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_chain.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AttributeChain = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const table_body_1 = __webpack_require__(/*! ./table_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_body.js");
class AttributeChain extends combi_1.Expression {
    getRunnable() {
        const chain = (0, combi_1.seq)(_1.AttributeName, (0, combi_1.starPrio)((0, combi_1.altPrio)((0, combi_1.seq)(_1.ArrowOrDash, (0, combi_1.altPrio)("*", _1.ComponentName)), _1.TableExpression)));
        const ret = (0, combi_1.seq)(chain, (0, combi_1.optPrio)(table_body_1.TableBody), (0, combi_1.optPrio)(_1.FieldOffset), (0, combi_1.optPrio)(_1.FieldLength));
        return ret;
    }
}
exports.AttributeChain = AttributeChain;
//# sourceMappingURL=attribute_chain.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_name.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_name.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AttributeName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class AttributeName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^(\/\w+\/)?[\w\d_\*\~%]+$/);
    }
}
exports.AttributeName = AttributeName;
//# sourceMappingURL=attribute_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/behavior_definition_name.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/behavior_definition_name.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BehaviorDefinitionName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class BehaviorDefinitionName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^((\w*\/\w+\/)|(\w*\/\w+\/)?[\w\*$%]+)$/);
    }
}
exports.BehaviorDefinitionName = BehaviorDefinitionName;
//# sourceMappingURL=behavior_definition_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/block_name.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/block_name.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BlockName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class BlockName extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)((0, combi_1.regex)(/^[\w%\$\*]+$/), (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.regex)(/^[\w%\$\*]+$/))));
        return ret;
    }
}
exports.BlockName = BlockName;
//# sourceMappingURL=block_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/call_transformation_options.js":
/*!************************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/call_transformation_options.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallTransformationOptions = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const field_1 = __webpack_require__(/*! ./field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field.js");
const integer_1 = __webpack_require__(/*! ./integer */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/integer.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
class CallTransformationOptions extends combi_1.Expression {
    getRunnable() {
        const field = (0, combi_1.seq)((0, combi_1.alt)(field_1.Field, integer_1.Integer), "=", source_1.Source);
        return (0, combi_1.plus)(field);
    }
}
exports.CallTransformationOptions = CallTransformationOptions;
//# sourceMappingURL=call_transformation_options.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/call_transformation_parameters.js":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/call_transformation_parameters.js ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallTransformationParameters = void 0;
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
const field_1 = __webpack_require__(/*! ./field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field.js");
const integer_1 = __webpack_require__(/*! ./integer */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/integer.js");
class CallTransformationParameters extends combi_1.Expression {
    getRunnable() {
        const field = (0, combi_1.seq)((0, combi_1.alt)(field_1.Field, integer_1.Integer), "=", _1.SimpleSource3);
        return (0, combi_1.alt)((0, combi_1.plus)(field), dynamic_1.Dynamic);
    }
}
exports.CallTransformationParameters = CallTransformationParameters;
//# sourceMappingURL=call_transformation_parameters.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cast.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cast.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Cast = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const let_1 = __webpack_require__(/*! ./let */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/let.js");
class Cast extends combi_1.Expression {
    getRunnable() {
        const rparen = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRightW), (0, combi_1.tok)(tokens_1.WParenRight));
        const cast = (0, combi_1.seq)("CAST", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), (0, combi_1.optPrio)(let_1.Let), _1.Source, rparen);
        return (0, combi_1.ver)(version_1.Version.v740sp02, cast);
    }
}
exports.Cast = Cast;
//# sourceMappingURL=cast.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_final.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_final.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassFinal = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class ClassFinal extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.str)("FINAL");
    }
}
exports.ClassFinal = ClassFinal;
//# sourceMappingURL=class_final.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_friends.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_friends.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassFriends = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const class_name_1 = __webpack_require__(/*! ./class_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_name.js");
class ClassFriends extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)((0, combi_1.optPrio)("GLOBAL"), "FRIENDS", (0, combi_1.plus)(class_name_1.ClassName));
    }
}
exports.ClassFriends = ClassFriends;
//# sourceMappingURL=class_friends.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_global.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_global.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassGlobal = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class ClassGlobal extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.str)("PUBLIC");
    }
}
exports.ClassGlobal = ClassGlobal;
//# sourceMappingURL=class_global.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_name.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_name.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class ClassName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^\w*(\/\w{3,}\/)?\w+$/);
    }
}
exports.ClassName = ClassName;
//# sourceMappingURL=class_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/color.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/color.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Color = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
class Color extends combi_1.Expression {
    getRunnable() {
        const eq = (0, combi_1.seq)("=", source_1.Source);
        const integers = (0, combi_1.altPrio)("1", "2", "3", "4", "5", "6", "7");
        const texts = (0, combi_1.altPrio)("COL_BACKGROUND", "COL_HEADING", "COL_NORMAL", "COL_TOTAL", "COL_KEY", "COL_POSITIVE", "COL_NEGATIVE", "COL_GROUP");
        const value = (0, combi_1.alt)(eq, (0, combi_1.altPrio)("ON", "OFF", (0, combi_1.altPrio)(integers, texts)));
        const toggle = (0, combi_1.altPrio)("ON", "OFF");
        return (0, combi_1.seq)("COLOR", value, (0, combi_1.opt)(toggle));
    }
}
exports.Color = Color;
//# sourceMappingURL=color.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/compare.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/compare.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Compare = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Compare extends combi_1.Expression {
    getRunnable() {
        const val = (0, combi_1.altPrio)(_1.FieldSub, _1.Constant);
        const list = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeft), val, (0, combi_1.plus)((0, combi_1.seq)(",", val)), (0, combi_1.tok)(tokens_1.ParenRightW));
        const inn = (0, combi_1.seq)((0, combi_1.optPrio)("NOT"), "IN", (0, combi_1.altPrio)(_1.Source, list));
        const sopt = (0, combi_1.seq)("IS", (0, combi_1.optPrio)("NOT"), (0, combi_1.altPrio)("SUPPLIED", "BOUND", (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("INSTANCE OF", _1.ClassName), version_1.Version.OpenABAP), "REQUESTED", "INITIAL"));
        const between = (0, combi_1.seq)((0, combi_1.optPrio)("NOT"), "BETWEEN", _1.Source, "AND", _1.Source);
        const predicate = (0, combi_1.ver)(version_1.Version.v740sp08, _1.MethodCallChain);
        const rett = (0, combi_1.seq)(_1.Source, (0, combi_1.altPrio)((0, combi_1.seq)(_1.CompareOperator, _1.Source), inn, between, sopt));
        const fsassign = (0, combi_1.seq)(_1.SourceFieldSymbol, "IS", (0, combi_1.optPrio)("NOT"), "ASSIGNED");
        const ret = (0, combi_1.seq)((0, combi_1.opt)("NOT"), (0, combi_1.altPrio)(rett, predicate, fsassign));
        return ret;
    }
}
exports.Compare = Compare;
//# sourceMappingURL=compare.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/compare_operator.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/compare_operator.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompareOperator = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class CompareOperator extends combi_1.Expression {
    getRunnable() {
        const operator = (0, combi_1.altPrio)("=", "<>", "><", "<", ">", "<=", ">=", "=>", "=<", "CA", "CO", "CP", "EQ", "NE", "CN", "GE", "GT", "LT", "LE", "CS", "NS", "NA", "NP", "BYTE-CO", "BYTE-CA", "BYTE-CS", "BYTE-CN", "BYTE-NA", "BYTE-NS", "O", // hex comparison operator
        "Z", // hex comparison operator
        "M");
        return operator;
    }
}
exports.CompareOperator = CompareOperator;
//# sourceMappingURL=compare_operator.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentChain = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const table_body_1 = __webpack_require__(/*! ./table_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_body.js");
class ComponentChain extends combi_1.Expression {
    getRunnable() {
        const chain = (0, combi_1.seq)(_1.ComponentName, (0, combi_1.star)((0, combi_1.altPrio)((0, combi_1.seq)(_1.ArrowOrDash, (0, combi_1.altPrio)("*", _1.ComponentName)), _1.TableExpression)));
        const ret = (0, combi_1.seq)(chain, (0, combi_1.optPrio)(table_body_1.TableBody), (0, combi_1.optPrio)(_1.FieldOffset), (0, combi_1.optPrio)(_1.FieldLength));
        return ret;
    }
}
exports.ComponentChain = ComponentChain;
//# sourceMappingURL=component_chain.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain_simple.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain_simple.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentChainSimple = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ComponentChainSimple extends combi_1.Expression {
    getRunnable() {
        const chain = (0, combi_1.seq)(_1.ComponentName, (0, combi_1.starPrio)((0, combi_1.seq)(_1.ArrowOrDash, _1.ComponentName)));
        const ret = (0, combi_1.seq)(chain, (0, combi_1.optPrio)(_1.FieldOffset), (0, combi_1.optPrio)(_1.FieldLength));
        return ret;
    }
}
exports.ComponentChainSimple = ComponentChainSimple;
//# sourceMappingURL=component_chain_simple.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentCompare = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ComponentCompare extends combi_1.Expression {
    getRunnable() {
        const val = (0, combi_1.alt)(_1.FieldSub, _1.Constant);
        const list = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeft), val, (0, combi_1.plus)((0, combi_1.seq)(",", val)), (0, combi_1.tok)(tokens_1.ParenRightW));
        const inn = (0, combi_1.seq)((0, combi_1.opt)("NOT"), "IN", (0, combi_1.altPrio)(_1.Source, list));
        const sopt = (0, combi_1.seq)("IS", (0, combi_1.opt)("NOT"), (0, combi_1.altPrio)("SUPPLIED", "BOUND", (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("INSTANCE OF", _1.Source)), "REQUESTED", "ASSIGNED", "INITIAL"));
        const between = (0, combi_1.seq)((0, combi_1.opt)("NOT"), "BETWEEN", _1.Source, "AND", _1.Source);
        const rett = (0, combi_1.seq)(_1.ComponentChainSimple, (0, combi_1.altPrio)((0, combi_1.seq)(_1.CompareOperator, _1.Source), inn, between, sopt));
        const ret = (0, combi_1.seq)((0, combi_1.opt)("NOT"), rett);
        return ret;
    }
}
exports.ComponentCompare = ComponentCompare;
//# sourceMappingURL=component_compare.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare_simple.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare_simple.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentCompareSimple = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const component_chain_simple_1 = __webpack_require__(/*! ./component_chain_simple */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain_simple.js");
class ComponentCompareSimple extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)((0, combi_1.altPrio)(component_chain_simple_1.ComponentChainSimple, _1.Dynamic), "=", _1.Source);
        return (0, combi_1.plus)(ret);
    }
}
exports.ComponentCompareSimple = ComponentCompareSimple;
//# sourceMappingURL=component_compare_simple.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare_single.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare_single.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentCompareSingle = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const component_chain_simple_1 = __webpack_require__(/*! ./component_chain_simple */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain_simple.js");
class ComponentCompareSingle extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)((0, combi_1.altPrio)(component_chain_simple_1.ComponentChainSimple, _1.Dynamic), "=", _1.Source);
        return ret;
    }
}
exports.ComponentCompareSingle = ComponentCompareSingle;
//# sourceMappingURL=component_compare_single.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_cond.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_cond.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentCond = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ComponentCond extends combi_1.Expression {
    getRunnable() {
        const operator = (0, combi_1.alt)("AND", "OR");
        const cnd = (0, combi_1.alt)(_1.ComponentCompare, _1.ComponentCondSub);
        const ret = (0, combi_1.seq)(cnd, (0, combi_1.star)((0, combi_1.seq)(operator, cnd)));
        return ret;
    }
}
exports.ComponentCond = ComponentCond;
//# sourceMappingURL=component_cond.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_cond_sub.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_cond_sub.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentCondSub = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ComponentCondSub extends combi_1.Expression {
    getRunnable() {
        const another = (0, combi_1.seq)((0, combi_1.opt)("NOT"), (0, combi_1.tok)(tokens_1.WParenLeftW), _1.ComponentCond, (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRightW), (0, combi_1.tok)(tokens_1.ParenRightW)));
        return another;
    }
}
exports.ComponentCondSub = ComponentCondSub;
//# sourceMappingURL=component_cond_sub.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_name.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_name.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class ComponentName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^(\/\w+\/)?[\w\d_%$\*\~]+$/);
    }
}
exports.ComponentName = ComponentName;
//# sourceMappingURL=component_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/concatenated_constant.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/concatenated_constant.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConcatenatedConstant = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class ConcatenatedConstant extends combi_1.Expression {
    getRunnable() {
        const str = (0, combi_1.seq)((0, combi_1.regex)(/^`.*`$/), (0, combi_1.plusPrio)((0, combi_1.seq)("&", (0, combi_1.regex)(/^`.*`$/))));
        const char = (0, combi_1.seq)((0, combi_1.regex)(/^'.*'$/), (0, combi_1.plusPrio)((0, combi_1.seq)("&", (0, combi_1.regex)(/^'.*'$/))));
        return (0, combi_1.altPrio)(str, char);
    }
}
exports.ConcatenatedConstant = ConcatenatedConstant;
//# sourceMappingURL=concatenated_constant.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Cond = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const cond_sub_1 = __webpack_require__(/*! ./cond_sub */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond_sub.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Cond extends combi_1.Expression {
    getRunnable() {
        const operator = (0, combi_1.altPrio)("AND", "OR", (0, combi_1.ver)(version_1.Version.v702, "EQUIV"));
        const cnd = (0, combi_1.altPrio)(_1.Compare, cond_sub_1.CondSub);
        const ret = (0, combi_1.seq)(cnd, (0, combi_1.starPrio)((0, combi_1.seq)(operator, cnd)));
        return ret;
    }
}
exports.Cond = Cond;
//# sourceMappingURL=cond.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond_body.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond_body.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CondBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class CondBody extends combi_1.Expression {
    getRunnable() {
        const when = (0, combi_1.seq)("WHEN", (0, combi_1.alt)(_1.Cond, _1.Source), "THEN", (0, combi_1.alt)(_1.Source, _1.Throw));
        const elsee = (0, combi_1.seq)("ELSE", (0, combi_1.alt)(_1.Source, _1.Throw));
        return (0, combi_1.seq)((0, combi_1.opt)(_1.Let), (0, combi_1.plus)(when), (0, combi_1.opt)(elsee));
    }
}
exports.CondBody = CondBody;
//# sourceMappingURL=cond_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond_sub.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond_sub.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CondSub = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class CondSub extends combi_1.Expression {
    getRunnable() {
        // rule ParserMissingSpace makes sure the whitespace is correct
        const another = (0, combi_1.seq)((0, combi_1.optPrio)("NOT"), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenLeftW), (0, combi_1.tok)(tokens_1.WParenLeft)), _1.Cond, (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRightW), (0, combi_1.tok)(tokens_1.ParenRightW)));
        return another;
    }
}
exports.CondSub = CondSub;
//# sourceMappingURL=cond_sub.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Constant = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Constant extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)(_1.TextElementString, _1.ConcatenatedConstant, _1.ConstantString, _1.Integer);
    }
}
exports.Constant = Constant;
//# sourceMappingURL=constant.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant_field_length.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant_field_length.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConstantFieldLength = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ConstantFieldLength extends combi_1.Expression {
    getRunnable() {
        const length = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.altPrio)(_1.Integer, _1.SimpleFieldChain), (0, combi_1.tok)(tokens_1.ParenRightW));
        return length;
    }
}
exports.ConstantFieldLength = ConstantFieldLength;
//# sourceMappingURL=constant_field_length.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant_string.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant_string.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConstantString = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class ConstantString extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^('.*')|(`.*`)$/);
    }
}
exports.ConstantString = ConstantString;
//# sourceMappingURL=constant_string.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/conv_body.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/conv_body.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConvBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ConvBody extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)((0, combi_1.optPrio)(_1.Let), _1.Source);
    }
}
exports.ConvBody = ConvBody;
//# sourceMappingURL=conv_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/corresponding_body.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/corresponding_body.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CorrespondingBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const component_chain_1 = __webpack_require__(/*! ./component_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain.js");
class CorrespondingBody extends combi_1.Expression {
    getRunnable() {
        const mapping = (0, combi_1.seq)("MAPPING", (0, combi_1.plus)((0, combi_1.seq)(_1.ComponentName, "=", component_chain_1.ComponentChain)));
        const baseParen = (0, combi_1.seq)("BASE", (0, combi_1.tok)(tokens_1.WParenLeftW), _1.Source, (0, combi_1.tok)(tokens_1.WParenRightW));
        const discarding = (0, combi_1.ver)(version_1.Version.v751, "DISCARDING DUPLICATES");
        return (0, combi_1.seq)((0, combi_1.optPrio)("DEEP"), (0, combi_1.optPrio)(baseParen), _1.Source, (0, combi_1.optPrio)(discarding), (0, combi_1.optPrio)(mapping), (0, combi_1.optPrio)((0, combi_1.seq)("EXCEPT", (0, combi_1.alt)((0, combi_1.plus)(_1.Field), "*"))));
    }
}
exports.CorrespondingBody = CorrespondingBody;
//# sourceMappingURL=corresponding_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/data_definition.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/data_definition.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataDefinition = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const Expressions = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class DataDefinition extends combi_1.Expression {
    getRunnable() {
        const simple = (0, combi_1.opt)((0, combi_1.per)("READ-ONLY", Expressions.Type, Expressions.Length, Expressions.Decimals, Expressions.Value));
        const table = (0, combi_1.seq)(Expressions.TypeTable, (0, combi_1.optPrio)("READ-ONLY"));
        return (0, combi_1.seq)(Expressions.DefinitionName, (0, combi_1.optPrio)(Expressions.ConstantFieldLength), (0, combi_1.alt)(simple, table, Expressions.TypeStructure));
    }
}
exports.DataDefinition = DataDefinition;
//# sourceMappingURL=data_definition.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/database_connection.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/database_connection.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DatabaseConnection = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class DatabaseConnection extends combi_1.Expression {
    getRunnable() {
        const name = (0, combi_1.regex)(/[\w\/]+/);
        return (0, combi_1.seq)("CONNECTION", (0, combi_1.altPrio)(name, _1.Dynamic));
    }
}
exports.DatabaseConnection = DatabaseConnection;
//# sourceMappingURL=database_connection.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/database_table.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/database_table.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DatabaseTable = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
class DatabaseTable extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)(dynamic_1.Dynamic, (0, combi_1.regex)(/^\*?(\/\w+\/)?\w+$/));
    }
}
exports.DatabaseTable = DatabaseTable;
//# sourceMappingURL=database_table.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/decimals.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/decimals.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Decimals = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Decimals extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)("DECIMALS", _1.Integer);
        return ret;
    }
}
exports.Decimals = Decimals;
//# sourceMappingURL=decimals.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/default.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/default.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Default = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Default extends combi_1.Expression {
    getRunnable() {
        // todo, DEFAULT is only valid for definitions in relation to method parameters
        const def = (0, combi_1.seq)("DEFAULT", (0, combi_1.altPrio)(_1.Constant, _1.FieldChain));
        return def;
    }
}
exports.Default = Default;
//# sourceMappingURL=default.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/definition_name.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/definition_name.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefinitionName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class DefinitionName extends combi_1.Expression {
    getRunnable() {
        const r = (0, combi_1.regex)(/^((\w*\/\w+\/)|(\w*\/\w+\/)?[\w\*$%]+)$/);
        return (0, combi_1.seq)(r, (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.optPrio)(r))), (0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.DashW)));
    }
}
exports.DefinitionName = DefinitionName;
//# sourceMappingURL=definition_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dereference.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dereference.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Dereference = void 0;
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Dereference extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)((0, combi_1.tok)(tokens_1.InstanceArrow), "*");
    }
}
exports.Dereference = Dereference;
//# sourceMappingURL=dereference.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/destination.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/destination.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Destination = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Destination extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("DESTINATION", (0, combi_1.optPrio)("IN GROUP"), (0, combi_1.altPrio)("DEFAULT", _1.Source));
    }
}
exports.Destination = Destination;
//# sourceMappingURL=destination.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Dynamic = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Dynamic extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)((0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenLeft), (0, combi_1.tok)(tokens_1.ParenLeft)), (0, combi_1.altPrio)(_1.FieldChain, _1.Constant), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenRightW), (0, combi_1.tok)(tokens_1.ParenRight)));
        return ret;
    }
}
exports.Dynamic = Dynamic;
//# sourceMappingURL=dynamic.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/entity_association.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/entity_association.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EntityAssociation = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EntityAssociation extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^[\w]+\\_[\w]+$/);
    }
}
exports.EntityAssociation = EntityAssociation;
//# sourceMappingURL=entity_association.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/event_handler.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/event_handler.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventHandler = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class EventHandler extends combi_1.Expression {
    getRunnable() {
        const event = (0, combi_1.seq)("FOR EVENT", _1.EventName, "OF", _1.ClassName, (0, combi_1.optPrio)((0, combi_1.seq)("IMPORTING", (0, combi_1.plusPrio)(_1.MethodParamName))));
        return event;
    }
}
exports.EventHandler = EventHandler;
//# sourceMappingURL=event_handler.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/event_name.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/event_name.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EventName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^[&_!]?\*?\w*(\/\w+\/)?\d*[a-zA-Z_%\$][\w\*%\$\?#]*(~\w+)?$/);
    }
}
exports.EventName = EventName;
//# sourceMappingURL=event_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/exception_name.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/exception_name.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExceptionName = void 0;
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const field_1 = __webpack_require__(/*! ./field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field.js");
/** non class based exception name */
class ExceptionName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)(field_1.Field, (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), field_1.Field)));
    }
}
exports.ExceptionName = ExceptionName;
//# sourceMappingURL=exception_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Field = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Field extends combi_1.Expression {
    getRunnable() {
        // "&1" can be used for almost anything(field names, method names etc.) in macros
        // field names with only digits should not be possible
        return (0, combi_1.regex)(/^[&_!]?\*?\w*(\/\w+\/)?\d*[a-zA-Z_%\$][\w\*%\$\?#]*(~\w+)?$/);
    }
}
exports.Field = Field;
//# sourceMappingURL=field.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_all.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_all.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldAll = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class FieldAll extends combi_1.Expression {
    getRunnable() {
        // "&1" can be used for almost anything(field names, method names etc.) in macros
        // field names with only digits should not be possible
        return (0, combi_1.regex)(/^&?\*?(\/\w+\/)?[\w\*\$]+(~\w+)?$/);
    }
}
exports.FieldAll = FieldAll;
//# sourceMappingURL=field_all.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_assignment.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_assignment.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldAssignment = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const field_sub_1 = __webpack_require__(/*! ./field_sub */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_sub.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
class FieldAssignment extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)(field_sub_1.FieldSub, "=", source_1.Source);
        return ret;
    }
}
exports.FieldAssignment = FieldAssignment;
//# sourceMappingURL=field_assignment.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_chain.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_chain.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldChain = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class FieldChain extends combi_1.Expression {
    getRunnable() {
        const attr = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.InstanceArrow), _1.AttributeName);
        const comp = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.optPrio)(_1.ComponentName));
        const chain = (0, combi_1.star)((0, combi_1.altPrio)(_1.Dereference, attr, comp, _1.TableExpression));
        const clas = (0, combi_1.seq)(_1.ClassName, (0, combi_1.tok)(tokens_1.StaticArrow), _1.AttributeName);
        const start = (0, combi_1.altPrio)(clas, _1.SourceField, _1.SourceFieldSymbol);
        const after = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.DashW), (0, combi_1.seq)((0, combi_1.optPrio)(_1.TableBody), (0, combi_1.optPrio)(_1.FieldOffset), (0, combi_1.optPrio)(_1.FieldLength)));
        const ret = (0, combi_1.seq)(start, chain, after);
        return ret;
    }
}
exports.FieldChain = FieldChain;
//# sourceMappingURL=field_chain.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_length.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_length.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldLength = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FieldLength extends combi_1.Expression {
    getRunnable() {
        const normal = (0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.Plus)), (0, combi_1.altPrio)((0, combi_1.regex)(/^\d+$/), _1.SimpleFieldChain2));
        const length = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.altPrio)(normal, "*"), (0, combi_1.tok)(tokens_1.ParenRightW));
        return length;
    }
}
exports.FieldLength = FieldLength;
//# sourceMappingURL=field_length.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_offset.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_offset.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldOffset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FieldOffset extends combi_1.Expression {
    getRunnable() {
        const offset = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Plus), (0, combi_1.altPrio)((0, combi_1.regex)(/^\d+$/), _1.SimpleFieldChain2));
        return offset;
    }
}
exports.FieldOffset = FieldOffset;
//# sourceMappingURL=field_offset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_sub.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_sub.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldSub = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const table_body_1 = __webpack_require__(/*! ./table_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_body.js");
class FieldSub extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)((0, combi_1.regex)(/^\*?!?(\/\w+\/)?[a-zA-Z_%$][\w%$\$\*]*$/), (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.regex)(/^[\w%$\$\*]+$/))), (0, combi_1.opt)(table_body_1.TableBody));
        return ret;
    }
}
exports.FieldSub = FieldSub;
//# sourceMappingURL=field_sub.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_symbol.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_symbol.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldSymbol = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class FieldSymbol extends combi_1.Expression {
    getRunnable() {
        // todo, this only allows one dash in the name
        const dashes = (0, combi_1.seq)((0, combi_1.regex)(/^<[\w\/%$\*]+$/), (0, combi_1.tok)(tokens_1.Dash), (0, combi_1.regex)(/^[\w\/%$\*]+>$/));
        return (0, combi_1.altPrio)((0, combi_1.regex)(/^<[\w\/%$\*]+>$/), dashes);
    }
}
exports.FieldSymbol = FieldSymbol;
//# sourceMappingURL=field_symbol.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/filter_body.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/filter_body.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FilterBody extends combi_1.Expression {
    getRunnable() {
        const inn = (0, combi_1.seq)("IN", _1.Source);
        const using = (0, combi_1.seq)("USING KEY", _1.SimpleName);
        return (0, combi_1.seq)(_1.Source, (0, combi_1.optPrio)("EXCEPT"), (0, combi_1.optPrio)((0, combi_1.per)(inn, using)), (0, combi_1.seq)("WHERE", _1.ComponentCond));
    }
}
exports.FilterBody = FilterBody;
//# sourceMappingURL=filter_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/final_methods.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/final_methods.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FinalMethods = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const method_name_1 = __webpack_require__(/*! ./method_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_name.js");
class FinalMethods extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("FINAL METHODS", (0, combi_1.plus)(method_name_1.MethodName));
    }
}
exports.FinalMethods = FinalMethods;
//# sourceMappingURL=final_methods.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/find_type.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/find_type.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FindType = void 0;
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class FindType extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.opt)((0, combi_1.alt)("REGEX", "SUBSTRING", (0, combi_1.ver)(version_1.Version.v755, "PCRE", version_1.Version.OpenABAP)));
    }
}
exports.FindType = FindType;
//# sourceMappingURL=find_type.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/for.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/for.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.For = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const field_chain_1 = __webpack_require__(/*! ./field_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_chain.js");
class For extends combi_1.Expression {
    getRunnable() {
        const where = (0, combi_1.seq)("WHERE (", _1.ComponentCond, ")");
        const from = (0, combi_1.seq)("FROM", _1.Source);
        const to = (0, combi_1.seq)("TO", _1.Source);
        const inn = (0, combi_1.seq)(_1.InlineLoopDefinition, (0, combi_1.optPrio)(from), (0, combi_1.optPrio)(to), (0, combi_1.optPrio)(where));
        const then = (0, combi_1.seq)("THEN", _1.Source);
        const whil = (0, combi_1.seq)((0, combi_1.altPrio)("UNTIL", "WHILE"), _1.Cond);
        const itera = (0, combi_1.seq)(_1.InlineFieldDefinition, (0, combi_1.opt)(then), whil);
        const groupBy = (0, combi_1.seq)("GROUP BY", (0, combi_1.alt)(field_chain_1.FieldChain, (0, combi_1.seq)("(", (0, combi_1.plus)(_1.LoopGroupByComponent), ")")), (0, combi_1.opt)((0, combi_1.seq)((0, combi_1.alt)("ASCENDING", "DESCENDING"), (0, combi_1.opt)("AS TEXT"))), (0, combi_1.opt)("WITHOUT MEMBERS"));
        const t = (0, combi_1.alt)(_1.TargetField, _1.TargetFieldSymbol);
        const groups = (0, combi_1.ver)(version_1.Version.v740sp08, (0, combi_1.seq)("GROUPS", t, "OF", t, "IN", _1.Source, (0, combi_1.optPrio)(groupBy)));
        const f = (0, combi_1.seq)("FOR", (0, combi_1.alt)(itera, inn, groups), (0, combi_1.optPrio)(_1.Let));
        return (0, combi_1.ver)(version_1.Version.v740sp05, f);
    }
}
exports.For = For;
//# sourceMappingURL=for.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_changing.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_changing.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormChanging = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FormChanging extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("CHANGING", (0, combi_1.plus)(_1.FormParam));
    }
}
exports.FormChanging = FormChanging;
//# sourceMappingURL=form_changing.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_name.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_name.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class FormName extends combi_1.Expression {
    getRunnable() {
        // todo, does not handle namespaces properly
        return (0, combi_1.seq)((0, combi_1.regex)(/^[\w%$\*\/\?]+$/), (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.optPrio)((0, combi_1.regex)(/^\w+$/)))), (0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.DashW)));
    }
}
exports.FormName = FormName;
//# sourceMappingURL=form_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormParam = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FormParam extends combi_1.Expression {
    getRunnable() {
        const stru = (0, combi_1.seq)("STRUCTURE", _1.SimpleFieldChain);
        const ret = (0, combi_1.seq)((0, combi_1.altPrio)(_1.PassByValue, _1.FormParamName), (0, combi_1.optPrio)((0, combi_1.altPrio)(_1.FormParamType, stru)));
        return ret;
    }
}
exports.FormParam = FormParam;
//# sourceMappingURL=form_param.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param_name.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param_name.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormParamName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class FormParamName extends combi_1.Expression {
    getRunnable() {
        const r = (0, combi_1.regex)(/^[\w$&\*%\/]+$/);
        // dashes in form parameter names allowed, intention is not to support this
        // but avoid the structural errors
        return (0, combi_1.seq)(r, (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), r)));
    }
}
exports.FormParamName = FormParamName;
//# sourceMappingURL=form_param_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param_type.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param_type.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormParamType = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FormParamType extends combi_1.Expression {
    getRunnable() {
        const def = (0, combi_1.seq)("DEFAULT", (0, combi_1.alt)(_1.Constant, _1.FieldChain));
        const table = (0, combi_1.seq)((0, combi_1.alt)("STANDARD", "HASHED", "INDEX", "SORTED", "ANY"), "TABLE");
        const tabseq = (0, combi_1.seq)(table, (0, combi_1.optPrio)((0, combi_1.seq)("OF", _1.TypeName)));
        const ret = (0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.alt)("REF TO", "LINE OF")), _1.TypeName, (0, combi_1.opt)(def));
        const like = (0, combi_1.seq)("LIKE", (0, combi_1.optPrio)((0, combi_1.alt)("REF TO", "LINE OF")), _1.FieldChain);
        return (0, combi_1.alt)((0, combi_1.seq)("TYPE", (0, combi_1.altPrio)(tabseq, ret)), like);
    }
}
exports.FormParamType = FormParamType;
//# sourceMappingURL=form_param_type.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_raising.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_raising.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormRaising = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class FormRaising extends combi_1.Expression {
    getRunnable() {
        const resume = (0, combi_1.seq)("RESUMABLE", (0, combi_1.tok)(tokens_1.ParenLeft), _1.ClassName, (0, combi_1.tok)(tokens_1.ParenRightW));
        const raising = (0, combi_1.seq)("RAISING", (0, combi_1.plus)((0, combi_1.alt)(_1.ClassName, resume)));
        return raising;
    }
}
exports.FormRaising = FormRaising;
//# sourceMappingURL=form_raising.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_tables.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_tables.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormTables = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FormTables extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("TABLES", (0, combi_1.plus)(_1.FormParam));
    }
}
exports.FormTables = FormTables;
//# sourceMappingURL=form_tables.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_using.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_using.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormUsing = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FormUsing extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("USING", (0, combi_1.plus)(_1.FormParam));
    }
}
exports.FormUsing = FormUsing;
//# sourceMappingURL=form_using.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/fstarget.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/fstarget.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FSTarget = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FSTarget extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)(_1.InlineFS, _1.TargetFieldSymbol);
    }
}
exports.FSTarget = FSTarget;
//# sourceMappingURL=fstarget.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_exporting.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_exporting.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FunctionExporting = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FunctionExporting extends combi_1.Expression {
    getRunnable() {
        const exp = (0, combi_1.plusPrio)(_1.FunctionExportingParameter);
        return exp;
    }
}
exports.FunctionExporting = FunctionExporting;
//# sourceMappingURL=function_exporting.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_exporting_parameter.js":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_exporting_parameter.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FunctionExportingParameter = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const parameter_name_1 = __webpack_require__(/*! ./parameter_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_name.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const simple_source3_1 = __webpack_require__(/*! ./simple_source3 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source3.js");
class FunctionExportingParameter extends combi_1.Expression {
    getRunnable() {
        const s = (0, combi_1.altPrio)((0, combi_1.ver)(version_1.Version.v740sp02, source_1.Source), simple_source3_1.SimpleSource3);
        const exp = (0, combi_1.seq)(parameter_name_1.ParameterName, "=", s);
        return exp;
    }
}
exports.FunctionExportingParameter = FunctionExportingParameter;
//# sourceMappingURL=function_exporting_parameter.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_name.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_name.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FunctionName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FunctionName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)(_1.Constant, _1.FieldChain);
    }
}
exports.FunctionName = FunctionName;
//# sourceMappingURL=function_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_parameters.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_parameters.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FunctionParameters = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FunctionParameters extends combi_1.Expression {
    getRunnable() {
        const exporting = (0, combi_1.seq)("EXPORTING", _1.FunctionExporting);
        const importing = (0, combi_1.seq)("IMPORTING", _1.ParameterListT);
        const changing = (0, combi_1.seq)("CHANGING", _1.ParameterListT);
        const tables = (0, combi_1.seq)("TABLES", _1.ParameterListT);
        const exceptions = (0, combi_1.seq)("EXCEPTIONS", (0, combi_1.optPrio)((0, combi_1.altPrio)(_1.ParameterListExceptions, _1.Field)));
        const long = (0, combi_1.seq)((0, combi_1.optPrio)(exporting), (0, combi_1.optPrio)(importing), (0, combi_1.optPrio)(tables), (0, combi_1.optPrio)(changing), (0, combi_1.optPrio)(exceptions));
        return long;
    }
}
exports.FunctionParameters = FunctionParameters;
//# sourceMappingURL=function_parameters.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/include_name.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/include_name.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IncludeName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class IncludeName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)((0, combi_1.regex)(/^<?(\/\w+\/)?[\w%]+(~\w+)?>?$/), (0, combi_1.optPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.regex)(/^\w+$/))));
    }
}
exports.IncludeName = IncludeName;
//# sourceMappingURL=include_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./abstract_methods */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/abstract_methods.js"), exports);
__exportStar(__webpack_require__(/*! ./abstract */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/abstract.js"), exports);
__exportStar(__webpack_require__(/*! ./and_return */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/and_return.js"), exports);
__exportStar(__webpack_require__(/*! ./arith_operator */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arith_operator.js"), exports);
__exportStar(__webpack_require__(/*! ./arrow_or_dash */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arrow_or_dash.js"), exports);
__exportStar(__webpack_require__(/*! ./arrow */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/arrow.js"), exports);
__exportStar(__webpack_require__(/*! ./assign_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/assign_source.js"), exports);
__exportStar(__webpack_require__(/*! ./association_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/association_name.js"), exports);
__exportStar(__webpack_require__(/*! ./attribute_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_chain.js"), exports);
__exportStar(__webpack_require__(/*! ./attribute_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_name.js"), exports);
__exportStar(__webpack_require__(/*! ./behavior_definition_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/behavior_definition_name.js"), exports);
__exportStar(__webpack_require__(/*! ./block_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/block_name.js"), exports);
__exportStar(__webpack_require__(/*! ./call_transformation_options */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/call_transformation_options.js"), exports);
__exportStar(__webpack_require__(/*! ./call_transformation_parameters */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/call_transformation_parameters.js"), exports);
__exportStar(__webpack_require__(/*! ./cast */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cast.js"), exports);
__exportStar(__webpack_require__(/*! ./class_final */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_final.js"), exports);
__exportStar(__webpack_require__(/*! ./class_friends */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_friends.js"), exports);
__exportStar(__webpack_require__(/*! ./class_global */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_global.js"), exports);
__exportStar(__webpack_require__(/*! ./class_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_name.js"), exports);
__exportStar(__webpack_require__(/*! ./color */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/color.js"), exports);
__exportStar(__webpack_require__(/*! ./compare_operator */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/compare_operator.js"), exports);
__exportStar(__webpack_require__(/*! ./compare */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/compare.js"), exports);
__exportStar(__webpack_require__(/*! ./component_chain_simple */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain_simple.js"), exports);
__exportStar(__webpack_require__(/*! ./component_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_chain.js"), exports);
__exportStar(__webpack_require__(/*! ./component_compare_simple */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare_simple.js"), exports);
__exportStar(__webpack_require__(/*! ./component_compare_single */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare_single.js"), exports);
__exportStar(__webpack_require__(/*! ./component_compare */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare.js"), exports);
__exportStar(__webpack_require__(/*! ./component_cond_sub */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_cond_sub.js"), exports);
__exportStar(__webpack_require__(/*! ./component_cond */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_cond.js"), exports);
__exportStar(__webpack_require__(/*! ./component_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_name.js"), exports);
__exportStar(__webpack_require__(/*! ./concatenated_constant */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/concatenated_constant.js"), exports);
__exportStar(__webpack_require__(/*! ./cond_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond_body.js"), exports);
__exportStar(__webpack_require__(/*! ./cond_sub */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond_sub.js"), exports);
__exportStar(__webpack_require__(/*! ./cond */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/cond.js"), exports);
__exportStar(__webpack_require__(/*! ./constant_field_length */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant_field_length.js"), exports);
__exportStar(__webpack_require__(/*! ./constant_string */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant_string.js"), exports);
__exportStar(__webpack_require__(/*! ./constant */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant.js"), exports);
__exportStar(__webpack_require__(/*! ./conv_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/conv_body.js"), exports);
__exportStar(__webpack_require__(/*! ./corresponding_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/corresponding_body.js"), exports);
__exportStar(__webpack_require__(/*! ./data_definition */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/data_definition.js"), exports);
__exportStar(__webpack_require__(/*! ./database_connection */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/database_connection.js"), exports);
__exportStar(__webpack_require__(/*! ./database_table */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/database_table.js"), exports);
__exportStar(__webpack_require__(/*! ./decimals */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/decimals.js"), exports);
__exportStar(__webpack_require__(/*! ./default */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/default.js"), exports);
__exportStar(__webpack_require__(/*! ./definition_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/definition_name.js"), exports);
__exportStar(__webpack_require__(/*! ./dereference */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dereference.js"), exports);
__exportStar(__webpack_require__(/*! ./destination */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/destination.js"), exports);
__exportStar(__webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js"), exports);
__exportStar(__webpack_require__(/*! ./entity_association */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/entity_association.js"), exports);
__exportStar(__webpack_require__(/*! ./entity_association */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/entity_association.js"), exports);
__exportStar(__webpack_require__(/*! ./event_handler */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/event_handler.js"), exports);
__exportStar(__webpack_require__(/*! ./event_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/event_name.js"), exports);
__exportStar(__webpack_require__(/*! ./exception_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/exception_name.js"), exports);
__exportStar(__webpack_require__(/*! ./field_all */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_all.js"), exports);
__exportStar(__webpack_require__(/*! ./field_assignment */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_assignment.js"), exports);
__exportStar(__webpack_require__(/*! ./field_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_chain.js"), exports);
__exportStar(__webpack_require__(/*! ./field_length */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_length.js"), exports);
__exportStar(__webpack_require__(/*! ./field_offset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_offset.js"), exports);
__exportStar(__webpack_require__(/*! ./field_sub */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_sub.js"), exports);
__exportStar(__webpack_require__(/*! ./field_symbol */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_symbol.js"), exports);
__exportStar(__webpack_require__(/*! ./field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field.js"), exports);
__exportStar(__webpack_require__(/*! ./filter_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/filter_body.js"), exports);
__exportStar(__webpack_require__(/*! ./final_methods */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/final_methods.js"), exports);
__exportStar(__webpack_require__(/*! ./find_type */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/find_type.js"), exports);
__exportStar(__webpack_require__(/*! ./for */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/for.js"), exports);
__exportStar(__webpack_require__(/*! ./form_changing */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_changing.js"), exports);
__exportStar(__webpack_require__(/*! ./form_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_name.js"), exports);
__exportStar(__webpack_require__(/*! ./form_param_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param_name.js"), exports);
__exportStar(__webpack_require__(/*! ./form_param_type */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param_type.js"), exports);
__exportStar(__webpack_require__(/*! ./form_param */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_param.js"), exports);
__exportStar(__webpack_require__(/*! ./form_raising */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_raising.js"), exports);
__exportStar(__webpack_require__(/*! ./form_tables */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_tables.js"), exports);
__exportStar(__webpack_require__(/*! ./form_using */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/form_using.js"), exports);
__exportStar(__webpack_require__(/*! ./fstarget */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/fstarget.js"), exports);
__exportStar(__webpack_require__(/*! ./function_exporting_parameter */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_exporting_parameter.js"), exports);
__exportStar(__webpack_require__(/*! ./function_exporting */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_exporting.js"), exports);
__exportStar(__webpack_require__(/*! ./function_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_name.js"), exports);
__exportStar(__webpack_require__(/*! ./function_parameters */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/function_parameters.js"), exports);
__exportStar(__webpack_require__(/*! ./include_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/include_name.js"), exports);
__exportStar(__webpack_require__(/*! ./inline_field_definition */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_field_definition.js"), exports);
__exportStar(__webpack_require__(/*! ./inline_field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_field.js"), exports);
__exportStar(__webpack_require__(/*! ./inline_loop_definition */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_loop_definition.js"), exports);
__exportStar(__webpack_require__(/*! ./inlinedata */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inlinedata.js"), exports);
__exportStar(__webpack_require__(/*! ./inlinefs */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inlinefs.js"), exports);
__exportStar(__webpack_require__(/*! ./integer */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/integer.js"), exports);
__exportStar(__webpack_require__(/*! ./interface_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/interface_name.js"), exports);
__exportStar(__webpack_require__(/*! ./kernel_id */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/kernel_id.js"), exports);
__exportStar(__webpack_require__(/*! ./language */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/language.js"), exports);
__exportStar(__webpack_require__(/*! ./length */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/length.js"), exports);
__exportStar(__webpack_require__(/*! ./let */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/let.js"), exports);
__exportStar(__webpack_require__(/*! ./loop_group_by_component */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by_component.js"), exports);
__exportStar(__webpack_require__(/*! ./loop_group_by_target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by_target.js"), exports);
__exportStar(__webpack_require__(/*! ./loop_group_by */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by.js"), exports);
__exportStar(__webpack_require__(/*! ./loop_target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_target.js"), exports);
__exportStar(__webpack_require__(/*! ./macro_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/macro_name.js"), exports);
__exportStar(__webpack_require__(/*! ./message_class */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_class.js"), exports);
__exportStar(__webpack_require__(/*! ./message_number */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_number.js"), exports);
__exportStar(__webpack_require__(/*! ./message_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_source.js"), exports);
__exportStar(__webpack_require__(/*! ./message_type_and_number */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_type_and_number.js"), exports);
__exportStar(__webpack_require__(/*! ./method_call_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_body.js"), exports);
__exportStar(__webpack_require__(/*! ./method_call_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_chain.js"), exports);
__exportStar(__webpack_require__(/*! ./method_call_param */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_param.js"), exports);
__exportStar(__webpack_require__(/*! ./method_call */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call.js"), exports);
__exportStar(__webpack_require__(/*! ./method_def_changing */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_changing.js"), exports);
__exportStar(__webpack_require__(/*! ./method_def_exceptions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_exceptions.js"), exports);
__exportStar(__webpack_require__(/*! ./method_def_exporting */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_exporting.js"), exports);
__exportStar(__webpack_require__(/*! ./method_def_importing */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_importing.js"), exports);
__exportStar(__webpack_require__(/*! ./method_def_raising */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_raising.js"), exports);
__exportStar(__webpack_require__(/*! ./method_def_returning */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_returning.js"), exports);
__exportStar(__webpack_require__(/*! ./method_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_name.js"), exports);
__exportStar(__webpack_require__(/*! ./method_param_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param_name.js"), exports);
__exportStar(__webpack_require__(/*! ./method_param_optional */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param_optional.js"), exports);
__exportStar(__webpack_require__(/*! ./method_param */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param.js"), exports);
__exportStar(__webpack_require__(/*! ./method_parameters */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_parameters.js"), exports);
__exportStar(__webpack_require__(/*! ./method_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_source.js"), exports);
__exportStar(__webpack_require__(/*! ./modif */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/modif.js"), exports);
__exportStar(__webpack_require__(/*! ./namespace_simple_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/namespace_simple_name.js"), exports);
__exportStar(__webpack_require__(/*! ./new_object */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/new_object.js"), exports);
__exportStar(__webpack_require__(/*! ./ole_exporting */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/ole_exporting.js"), exports);
__exportStar(__webpack_require__(/*! ./or */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/or.js"), exports);
__exportStar(__webpack_require__(/*! ./parameter_exception */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_exception.js"), exports);
__exportStar(__webpack_require__(/*! ./parameter_list_exceptions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_exceptions.js"), exports);
__exportStar(__webpack_require__(/*! ./parameter_list_s */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_s.js"), exports);
__exportStar(__webpack_require__(/*! ./parameter_list_t */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_t.js"), exports);
__exportStar(__webpack_require__(/*! ./parameter_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_name.js"), exports);
__exportStar(__webpack_require__(/*! ./parameter_s */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_s.js"), exports);
__exportStar(__webpack_require__(/*! ./parameter_t */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_t.js"), exports);
__exportStar(__webpack_require__(/*! ./pass_by_value */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/pass_by_value.js"), exports);
__exportStar(__webpack_require__(/*! ./perform_changing */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_changing.js"), exports);
__exportStar(__webpack_require__(/*! ./perform_tables */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_tables.js"), exports);
__exportStar(__webpack_require__(/*! ./perform_using */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_using.js"), exports);
__exportStar(__webpack_require__(/*! ./radio_group_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/radio_group_name.js"), exports);
__exportStar(__webpack_require__(/*! ./raise_with */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/raise_with.js"), exports);
__exportStar(__webpack_require__(/*! ./read_table_target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/read_table_target.js"), exports);
__exportStar(__webpack_require__(/*! ./receive_parameters */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/receive_parameters.js"), exports);
__exportStar(__webpack_require__(/*! ./redefinition */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/redefinition.js"), exports);
__exportStar(__webpack_require__(/*! ./reduce_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/reduce_body.js"), exports);
__exportStar(__webpack_require__(/*! ./reduce_next */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/reduce_next.js"), exports);
__exportStar(__webpack_require__(/*! ./report_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/report_name.js"), exports);
__exportStar(__webpack_require__(/*! ./select_loop */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/select_loop.js"), exports);
__exportStar(__webpack_require__(/*! ./select */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/select.js"), exports);
__exportStar(__webpack_require__(/*! ./simple_field_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_field_chain.js"), exports);
__exportStar(__webpack_require__(/*! ./simple_field_chain2 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_field_chain2.js"), exports);
__exportStar(__webpack_require__(/*! ./simple_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_name.js"), exports);
__exportStar(__webpack_require__(/*! ./simple_source1 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source1.js"), exports);
__exportStar(__webpack_require__(/*! ./simple_source2 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source2.js"), exports);
__exportStar(__webpack_require__(/*! ./simple_source3 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source3.js"), exports);
__exportStar(__webpack_require__(/*! ./simple_source4 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source4.js"), exports);
__exportStar(__webpack_require__(/*! ./simple_target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_target.js"), exports);
__exportStar(__webpack_require__(/*! ./source_field_symbol */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source_field_symbol.js"), exports);
__exportStar(__webpack_require__(/*! ./source_field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source_field.js"), exports);
__exportStar(__webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_aggregation */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_aggregation.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_alias_field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_alias_field.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_arithmetic_operator */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetic_operator.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_arithmetics */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetics.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_as_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_as_name.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_case */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_case.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_cds_parameters */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_cds_parameters.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_client */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_client.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_compare_operator */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_compare_operator.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_compare */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_compare.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_cond */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_cond.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_field_and_value */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_and_value.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_field_list_loop */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_list_loop.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_field_list */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_list.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_field_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_fields */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_fields.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_for_all_entries */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_for_all_entries.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_from_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_from_source.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_from */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_from.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_function */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_function.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_group_by */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_group_by.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_having */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_having.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_hints */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_hints.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_in */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_in.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_into_list */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_list.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_into_structure */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_structure.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_into_table */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_table.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_join */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_join.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_order_by */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_order_by.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_path */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_path.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_source_simple */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source_simple.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_source_no_space */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source_no_space.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_target.js"), exports);
__exportStar(__webpack_require__(/*! ./sql_up_to */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_up_to.js"), exports);
__exportStar(__webpack_require__(/*! ./string_template_formatting */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template_formatting.js"), exports);
__exportStar(__webpack_require__(/*! ./string_template_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template_source.js"), exports);
__exportStar(__webpack_require__(/*! ./string_template */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template.js"), exports);
__exportStar(__webpack_require__(/*! ./super_class_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/super_class_name.js"), exports);
__exportStar(__webpack_require__(/*! ./type_structure */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_structure.js"), exports);
__exportStar(__webpack_require__(/*! ./switch_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/switch_body.js"), exports);
__exportStar(__webpack_require__(/*! ./table_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_body.js"), exports);
__exportStar(__webpack_require__(/*! ./table_expression */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_expression.js"), exports);
__exportStar(__webpack_require__(/*! ./target_field_symbol */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target_field_symbol.js"), exports);
__exportStar(__webpack_require__(/*! ./target_field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target_field.js"), exports);
__exportStar(__webpack_require__(/*! ./target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target.js"), exports);
__exportStar(__webpack_require__(/*! ./test_seam_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/test_seam_name.js"), exports);
__exportStar(__webpack_require__(/*! ./text_element_key */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element_key.js"), exports);
__exportStar(__webpack_require__(/*! ./text_element_string */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element_string.js"), exports);
__exportStar(__webpack_require__(/*! ./text_element */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element.js"), exports);
__exportStar(__webpack_require__(/*! ./throw */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/throw.js"), exports);
__exportStar(__webpack_require__(/*! ./transporting_fields */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/transporting_fields.js"), exports);
__exportStar(__webpack_require__(/*! ./type_name_or_infer */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_name_or_infer.js"), exports);
__exportStar(__webpack_require__(/*! ./type_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_name.js"), exports);
__exportStar(__webpack_require__(/*! ./type_param */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_param.js"), exports);
__exportStar(__webpack_require__(/*! ./type_table_key */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_table_key.js"), exports);
__exportStar(__webpack_require__(/*! ./type_table */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_table.js"), exports);
__exportStar(__webpack_require__(/*! ./type */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type.js"), exports);
__exportStar(__webpack_require__(/*! ./value_body_line */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body_line.js"), exports);
__exportStar(__webpack_require__(/*! ./value_body_lines */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body_lines.js"), exports);
__exportStar(__webpack_require__(/*! ./value_body */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body.js"), exports);
__exportStar(__webpack_require__(/*! ./value */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value.js"), exports);
__exportStar(__webpack_require__(/*! ./with_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/with_name.js"), exports);
__exportStar(__webpack_require__(/*! ./write_offset_length */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/write_offset_length.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_field.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_field.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InlineField = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class InlineField extends combi_1.Expression {
    getRunnable() {
        return new _1.Field();
    }
}
exports.InlineField = InlineField;
//# sourceMappingURL=inline_field.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_field_definition.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_field_definition.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InlineFieldDefinition = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class InlineFieldDefinition extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)((0, combi_1.seq)(_1.Field, "=", _1.Source), (0, combi_1.seq)(_1.Field, "TYPE", _1.TypeName));
    }
}
exports.InlineFieldDefinition = InlineFieldDefinition;
//# sourceMappingURL=inline_field_definition.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_loop_definition.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inline_loop_definition.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InlineLoopDefinition = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class InlineLoopDefinition extends combi_1.Expression {
    getRunnable() {
        const index = (0, combi_1.seq)("INDEX INTO", _1.TargetField);
        return (0, combi_1.seq)((0, combi_1.altPrio)(_1.TargetFieldSymbol, _1.TargetField), "IN", (0, combi_1.opt)("GROUP"), _1.Source, (0, combi_1.optPrio)(index));
    }
}
exports.InlineLoopDefinition = InlineLoopDefinition;
//# sourceMappingURL=inline_loop_definition.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inlinedata.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inlinedata.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InlineData = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class InlineData extends combi_1.Expression {
    getRunnable() {
        const right = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenRightW), (0, combi_1.tok)(tokens_1.ParenRight));
        const left = (0, combi_1.tok)(tokens_1.ParenLeft);
        const data = (0, combi_1.seq)("DATA", left, _1.TargetField, right);
        const final = (0, combi_1.seq)("FINAL", left, _1.TargetField, right);
        return (0, combi_1.altPrio)((0, combi_1.ver)(version_1.Version.v740sp02, data), (0, combi_1.ver)(version_1.Version.v757, final));
    }
}
exports.InlineData = InlineData;
//# sourceMappingURL=inlinedata.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inlinefs.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/inlinefs.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InlineFS = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class InlineFS extends combi_1.Expression {
    getRunnable() {
        const right = (0, combi_1.tok)(tokens_1.ParenRightW);
        const left = (0, combi_1.tok)(tokens_1.ParenLeft);
        const fs = (0, combi_1.seq)("FIELD-SYMBOL", left, _1.TargetFieldSymbol, right);
        return (0, combi_1.ver)(version_1.Version.v740sp02, fs);
    }
}
exports.InlineFS = InlineFS;
//# sourceMappingURL=inlinefs.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/integer.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/integer.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Integer = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class Integer extends combi_1.Expression {
    getRunnable() {
        const modifier = (0, combi_1.optPrio)((0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WDash), (0, combi_1.tok)(tokens_1.WDashW), (0, combi_1.tok)(tokens_1.WPlus)));
        return (0, combi_1.seq)(modifier, (0, combi_1.regex)(/^\d+$/));
    }
}
exports.Integer = Integer;
//# sourceMappingURL=integer.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/interface_name.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/interface_name.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InterfaceName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class InterfaceName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^\w*(\/\w{3,}\/)?\w+$/);
    }
}
exports.InterfaceName = InterfaceName;
//# sourceMappingURL=interface_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/kernel_id.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/kernel_id.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KernelId = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
class KernelId extends combi_1.Expression {
    getRunnable() {
        const field = (0, combi_1.seq)("ID", source_1.Source, "FIELD", source_1.Source);
        return field;
    }
}
exports.KernelId = KernelId;
//# sourceMappingURL=kernel_id.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/language.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/language.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Language = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Language extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("LANGUAGE", (0, combi_1.altPrio)("SQLSCRIPT", "SQL", "GRAPH"));
    }
}
exports.Language = Language;
//# sourceMappingURL=language.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/length.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/length.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Length = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Length extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)("LENGTH", (0, combi_1.altPrio)(_1.Integer, _1.ConstantString, _1.SimpleFieldChain));
        return ret;
    }
}
exports.Length = Length;
//# sourceMappingURL=length.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/let.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/let.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Let = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Let extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("LET", (0, combi_1.plusPrio)(_1.InlineFieldDefinition), "IN");
    }
}
exports.Let = Let;
//# sourceMappingURL=let.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoopGroupBy = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
const loop_group_by_target_1 = __webpack_require__(/*! ./loop_group_by_target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by_target.js");
const loop_group_by_component_1 = __webpack_require__(/*! ./loop_group_by_component */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by_component.js");
class LoopGroupBy extends combi_1.Expression {
    getRunnable() {
        const components = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeftW), (0, combi_1.plus)(loop_group_by_component_1.LoopGroupByComponent), (0, combi_1.tok)(tokens_1.WParenRightW));
        const ret = (0, combi_1.seq)((0, combi_1.alt)(source_1.Source, components), (0, combi_1.optPrio)("ASCENDING"), (0, combi_1.optPrio)("WITHOUT MEMBERS"), loop_group_by_target_1.LoopGroupByTarget);
        return ret;
    }
}
exports.LoopGroupBy = LoopGroupBy;
//# sourceMappingURL=loop_group_by.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by_component.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by_component.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoopGroupByComponent = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const component_name_1 = __webpack_require__(/*! ./component_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_name.js");
const component_compare_single_1 = __webpack_require__(/*! ./component_compare_single */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/component_compare_single.js");
class LoopGroupByComponent extends combi_1.Expression {
    getRunnable() {
        const groupSize = (0, combi_1.seq)(component_name_1.ComponentName, "=", "GROUP SIZE");
        const groupIndex = (0, combi_1.seq)(component_name_1.ComponentName, "=", "GROUP INDEX");
        const components = (0, combi_1.alt)(component_compare_single_1.ComponentCompareSingle, groupSize, groupIndex);
        return components;
    }
}
exports.LoopGroupByComponent = LoopGroupByComponent;
//# sourceMappingURL=loop_group_by_component.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by_target.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by_target.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoopGroupByTarget = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const target_1 = __webpack_require__(/*! ./target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target.js");
const fstarget_1 = __webpack_require__(/*! ./fstarget */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/fstarget.js");
class LoopGroupByTarget extends combi_1.Expression {
    getRunnable() {
        const into = (0, combi_1.seq)((0, combi_1.opt)("REFERENCE"), "INTO", target_1.Target);
        const assigning = (0, combi_1.seq)("ASSIGNING", fstarget_1.FSTarget);
        return (0, combi_1.optPrio)((0, combi_1.alt)(into, assigning));
    }
}
exports.LoopGroupByTarget = LoopGroupByTarget;
//# sourceMappingURL=loop_group_by_target.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_target.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_target.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoopTarget = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class LoopTarget extends combi_1.Expression {
    getRunnable() {
        const into = (0, combi_1.seq)((0, combi_1.opt)("REFERENCE"), "INTO", _1.Target);
        const assigning = (0, combi_1.seq)("ASSIGNING", _1.FSTarget);
        const target = (0, combi_1.alt)((0, combi_1.seq)((0, combi_1.alt)(into, assigning), (0, combi_1.optPrio)("CASTING")), "TRANSPORTING NO FIELDS");
        return target;
    }
}
exports.LoopTarget = LoopTarget;
//# sourceMappingURL=loop_target.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/macro_name.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/macro_name.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MacroName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class MacroName extends combi_1.Expression {
    getRunnable() {
        const r = /^(\/\w+\/)?[\w\*%\?$&]+>?$/;
        return (0, combi_1.seq)((0, combi_1.regex)(r), (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.regex)(r))));
    }
}
exports.MacroName = MacroName;
//# sourceMappingURL=macro_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_class.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_class.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MessageClass = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class MessageClass extends combi_1.Expression {
    getRunnable() {
        // "&1" can be used for almost anything(field names, method names etc.) in macros
        return (0, combi_1.regex)(/^>?(\/\w+\/)?\w+#?@?\/?!?&?>?\$?$/);
    }
}
exports.MessageClass = MessageClass;
//# sourceMappingURL=message_class.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_number.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_number.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MessageNumber = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class MessageNumber extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^\d\d\d$/i);
    }
}
exports.MessageNumber = MessageNumber;
//# sourceMappingURL=message_number.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_source.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_source.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MessageSource = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MessageSource extends combi_1.Expression {
    getRunnable() {
        const msgid = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeft), _1.MessageClass, (0, combi_1.tok)(tokens_1.ParenRightW));
        const simple = (0, combi_1.seq)(_1.MessageTypeAndNumber, (0, combi_1.opt)(msgid));
        const mess1 = (0, combi_1.seq)("ID", _1.Source, "TYPE", _1.Source, "NUMBER", (0, combi_1.altPrio)(_1.MessageNumber, _1.Source));
        return (0, combi_1.altPrio)(simple, mess1);
    }
}
exports.MessageSource = MessageSource;
//# sourceMappingURL=message_source.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_type_and_number.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/message_type_and_number.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MessageTypeAndNumber = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class MessageTypeAndNumber extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^[iweaxs]\d\d\d$/i);
    }
}
exports.MessageTypeAndNumber = MessageTypeAndNumber;
//# sourceMappingURL=message_type_and_number.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodCall = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const method_call_param_1 = __webpack_require__(/*! ./method_call_param */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_param.js");
class MethodCall extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)(_1.MethodName, method_call_param_1.MethodCallParam);
        return ret;
    }
}
exports.MethodCall = MethodCall;
//# sourceMappingURL=method_call.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_body.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_body.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodCallBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const method_call_param_1 = __webpack_require__(/*! ./method_call_param */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_param.js");
class MethodCallBody extends combi_1.Expression {
    getRunnable() {
        const dynamicPar = (0, combi_1.seq)("PARAMETER-TABLE", _1.Source);
        const dynamicExc = (0, combi_1.seq)("EXCEPTION-TABLE", _1.Source);
        const dynamic = (0, combi_1.seq)(dynamicPar, (0, combi_1.optPrio)(dynamicExc));
        return (0, combi_1.alt)(method_call_param_1.MethodCallParam, _1.MethodParameters, dynamic);
    }
}
exports.MethodCallBody = MethodCallBody;
//# sourceMappingURL=method_call_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_chain.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_chain.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodCallChain = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodCallChain extends combi_1.Expression {
    getRunnable() {
        const attr = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.InstanceArrow), _1.AttributeName);
        const comp = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), _1.ComponentName);
        const fields = (0, combi_1.star)((0, combi_1.altPrio)(attr, comp));
        const after = (0, combi_1.star)((0, combi_1.seq)(fields, (0, combi_1.tok)(tokens_1.InstanceArrow), _1.MethodCall));
        const localVariable = (0, combi_1.seq)(_1.FieldChain, (0, combi_1.tok)(tokens_1.InstanceArrow));
        const staticClass = (0, combi_1.seq)(_1.ClassName, (0, combi_1.tok)(tokens_1.StaticArrow));
        const ret = (0, combi_1.seq)((0, combi_1.altPrio)((0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.altPrio)(localVariable, staticClass)), _1.MethodCall), _1.NewObject, _1.Cast), after);
        return ret;
    }
}
exports.MethodCallChain = MethodCallChain;
//# sourceMappingURL=method_call_chain.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_param.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_param.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodCallParam = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const constant_string_1 = __webpack_require__(/*! ./constant_string */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant_string.js");
class MethodCallParam extends combi_1.Expression {
    getRunnable() {
        const param = (0, combi_1.alt)(_1.Source, _1.ParameterListS, _1.MethodParameters);
        // rule ParserMissingSpace makes sure the whitespace is correct
        const right1 = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRight), (0, combi_1.tok)(tokens_1.WParenRightW), (0, combi_1.tok)(tokens_1.ParenRight), (0, combi_1.tok)(tokens_1.ParenRightW));
        const right2 = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRight), (0, combi_1.tok)(tokens_1.WParenRightW));
        // note: make sure this does not overlap with FieldLength expression
        const ret = (0, combi_1.altPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeftW), param, right1), (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeft), param, right2), (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeft), constant_string_1.ConstantString, (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenRight), (0, combi_1.tok)(tokens_1.ParenRightW))));
        return ret;
    }
}
exports.MethodCallParam = MethodCallParam;
//# sourceMappingURL=method_call_param.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_changing.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_changing.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodDefChanging = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodDefChanging extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("CHANGING", (0, combi_1.plus)(_1.MethodParamOptional));
    }
}
exports.MethodDefChanging = MethodDefChanging;
//# sourceMappingURL=method_def_changing.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_exceptions.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_exceptions.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodDefExceptions = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodDefExceptions extends combi_1.Expression {
    getRunnable() {
        const exceptions = (0, combi_1.seq)("EXCEPTIONS", (0, combi_1.plusPrio)(_1.NamespaceSimpleName));
        return exceptions;
    }
}
exports.MethodDefExceptions = MethodDefExceptions;
//# sourceMappingURL=method_def_exceptions.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_exporting.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_exporting.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodDefExporting = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodDefExporting extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("EXPORTING", (0, combi_1.plus)(_1.MethodParam));
    }
}
exports.MethodDefExporting = MethodDefExporting;
//# sourceMappingURL=method_def_exporting.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_importing.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_importing.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodDefImporting = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodDefImporting extends combi_1.Expression {
    getRunnable() {
        const field = (0, combi_1.regex)(/^!?(\/\w+\/)?\w+$/);
        return (0, combi_1.seq)("IMPORTING", (0, combi_1.plus)(_1.MethodParamOptional), (0, combi_1.optPrio)((0, combi_1.seq)("PREFERRED PARAMETER", field)));
    }
}
exports.MethodDefImporting = MethodDefImporting;
//# sourceMappingURL=method_def_importing.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_raising.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_raising.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodDefRaising = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const class_name_1 = __webpack_require__(/*! ./class_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/class_name.js");
class MethodDefRaising extends combi_1.Expression {
    getRunnable() {
        const resumable = (0, combi_1.seq)("RESUMABLE", (0, combi_1.tok)(tokens_1.ParenLeft), class_name_1.ClassName, (0, combi_1.tok)(tokens_1.ParenRightW));
        const raising = (0, combi_1.seq)("RAISING", (0, combi_1.plus)((0, combi_1.altPrio)(resumable, class_name_1.ClassName)));
        return raising;
    }
}
exports.MethodDefRaising = MethodDefRaising;
//# sourceMappingURL=method_def_raising.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_returning.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_def_returning.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodDefReturning = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const Expressions = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class MethodDefReturning extends combi_1.Expression {
    getRunnable() {
        const value = (0, combi_1.seq)("VALUE", (0, combi_1.tok)(tokens_1.ParenLeft), Expressions.MethodParamName, (0, combi_1.tok)(tokens_1.ParenRightW));
        return (0, combi_1.seq)("RETURNING", value, Expressions.TypeParam);
    }
}
exports.MethodDefReturning = MethodDefReturning;
//# sourceMappingURL=method_def_returning.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_name.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_name.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class MethodName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^(\/\w+\/)?\w+(~\w+)?$/);
    }
}
exports.MethodName = MethodName;
//# sourceMappingURL=method_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodParam = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const Expressions = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class MethodParam extends combi_1.Expression {
    getRunnable() {
        const ref = (0, combi_1.seq)("REFERENCE", (0, combi_1.tok)(tokens_1.ParenLeft), Expressions.MethodParamName, (0, combi_1.tok)(tokens_1.ParenRightW));
        const value = (0, combi_1.seq)("VALUE", (0, combi_1.tok)(tokens_1.ParenLeft), Expressions.MethodParamName, (0, combi_1.tok)(tokens_1.ParenRightW));
        const fieldsOrValue = (0, combi_1.seq)((0, combi_1.altPrio)(value, ref, Expressions.MethodParamName), Expressions.TypeParam);
        return fieldsOrValue;
    }
}
exports.MethodParam = MethodParam;
//# sourceMappingURL=method_param.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param_name.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param_name.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodParamName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class MethodParamName extends combi_1.Expression {
    getRunnable() {
        const field = (0, combi_1.regex)(/^!?\w*(\/\w+\/)?\w+$/);
        return field;
    }
}
exports.MethodParamName = MethodParamName;
//# sourceMappingURL=method_param_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param_optional.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_param_optional.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodParamOptional = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodParamOptional extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)(_1.MethodParam, (0, combi_1.optPrio)("OPTIONAL"));
    }
}
exports.MethodParamOptional = MethodParamOptional;
//# sourceMappingURL=method_param_optional.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_parameters.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_parameters.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodParameters = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodParameters extends combi_1.Expression {
    getRunnable() {
        const exporting = (0, combi_1.seq)("EXPORTING", _1.ParameterListS);
        const importing = (0, combi_1.seq)("IMPORTING", _1.ParameterListT);
        const changing = (0, combi_1.seq)("CHANGING", _1.ParameterListT);
        const receiving = (0, combi_1.seq)("RECEIVING", _1.ParameterT);
        const exceptions = (0, combi_1.seq)("EXCEPTIONS", _1.ParameterListExceptions);
        const long = (0, combi_1.seq)((0, combi_1.optPrio)(exporting), (0, combi_1.optPrio)(importing), (0, combi_1.optPrio)(changing), (0, combi_1.optPrio)(receiving), (0, combi_1.optPrio)(exceptions));
        return long;
    }
}
exports.MethodParameters = MethodParameters;
//# sourceMappingURL=method_parameters.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_source.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_source.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodSource = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodSource extends combi_1.Expression {
    getRunnable() {
        // note: AttributeName can be both an attribute and a method name, the syntax check will tell
        // note: its allowed to end with MethodCall, however if this is done it will give a syntax error via syntax check
        const afterArrow = (0, combi_1.alt)(_1.AttributeName, _1.MethodCall, _1.Dynamic);
        const arrow = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.InstanceArrow), (0, combi_1.tok)(tokens_1.StaticArrow));
        const attr = (0, combi_1.seq)(arrow, afterArrow);
        const comp = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), _1.ComponentName);
        const attrOrComp = (0, combi_1.altPrio)(attr, comp);
        const staticClass = (0, combi_1.seq)(_1.ClassName, (0, combi_1.tok)(tokens_1.StaticArrow));
        const clas = (0, combi_1.seq)(staticClass, afterArrow);
        const start = (0, combi_1.seq)((0, combi_1.altPrio)(clas, _1.SourceField, _1.SourceFieldSymbol, _1.Dynamic), (0, combi_1.star)(attrOrComp));
        return start;
    }
}
exports.MethodSource = MethodSource;
//# sourceMappingURL=method_source.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/modif.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/modif.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Modif = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Modif extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^[\w\*]{1,3}$/);
    }
}
exports.Modif = Modif;
//# sourceMappingURL=modif.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/namespace_simple_name.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/namespace_simple_name.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NamespaceSimpleName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class NamespaceSimpleName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^((\w*\/\w+\/)|(\w*\/\w+\/)?[\w\*$%]+)$/);
    }
}
exports.NamespaceSimpleName = NamespaceSimpleName;
//# sourceMappingURL=namespace_simple_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/new_object.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/new_object.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NewObject = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const field_assignment_1 = __webpack_require__(/*! ./field_assignment */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_assignment.js");
// note: this can also be new data reference
class NewObject extends combi_1.Expression {
    getRunnable() {
        const lines = (0, combi_1.plus)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeftW), _1.Source, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const linesFields = (0, combi_1.plus)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeftW), (0, combi_1.plus)(field_assignment_1.FieldAssignment), (0, combi_1.tok)(tokens_1.WParenRightW)));
        const neww = (0, combi_1.seq)("NEW", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), (0, combi_1.optPrio)((0, combi_1.alt)(_1.Source, _1.ParameterListS, lines, linesFields)), ")");
        return (0, combi_1.ver)(version_1.Version.v740sp02, neww);
    }
}
exports.NewObject = NewObject;
//# sourceMappingURL=new_object.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/ole_exporting.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/ole_exporting.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OLEExporting = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class OLEExporting extends combi_1.Expression {
    getRunnable() {
        const fields = (0, combi_1.seq)((0, combi_1.regex)(/^[&_!#\*]?[\w\d\*%\$\?#]+$/), "=", _1.Source);
        return (0, combi_1.seq)("EXPORTING", (0, combi_1.plus)(fields));
    }
}
exports.OLEExporting = OLEExporting;
//# sourceMappingURL=ole_exporting.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/or.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/or.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Or = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Or extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("OR", _1.Source);
    }
}
exports.Or = Or;
//# sourceMappingURL=or.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_exception.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_exception.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParameterException = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ParameterException extends combi_1.Expression {
    getRunnable() {
        const name = (0, combi_1.altPrio)("OTHERS", _1.ParameterName);
        return (0, combi_1.seq)(name, "=", _1.SimpleName, (0, combi_1.optPrio)((0, combi_1.seq)("MESSAGE", _1.Target)));
    }
}
exports.ParameterException = ParameterException;
//# sourceMappingURL=parameter_exception.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_exceptions.js":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_exceptions.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParameterListExceptions = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ParameterListExceptions extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.plus)(_1.ParameterException);
    }
}
exports.ParameterListExceptions = ParameterListExceptions;
//# sourceMappingURL=parameter_list_exceptions.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_s.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_s.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParameterListS = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ParameterListS extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.plus)(_1.ParameterS);
    }
}
exports.ParameterListS = ParameterListS;
//# sourceMappingURL=parameter_list_s.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_t.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_list_t.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParameterListT = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ParameterListT extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.plus)(_1.ParameterT);
    }
}
exports.ParameterListT = ParameterListT;
//# sourceMappingURL=parameter_list_t.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_name.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_name.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParameterName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class ParameterName extends combi_1.Expression {
    getRunnable() {
        // todo, think this can be reduced,
        return (0, combi_1.regex)(/^[&_!]?\*?\w*(\/\w+\/)?\d*[a-zA-Z_%\$][\w\*%\$\?]*(~\w+)?$/);
    }
}
exports.ParameterName = ParameterName;
//# sourceMappingURL=parameter_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_s.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_s.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParameterS = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ParameterS extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)(_1.ParameterName, "=", _1.Source);
    }
}
exports.ParameterS = ParameterS;
//# sourceMappingURL=parameter_s.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_t.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/parameter_t.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ParameterT = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ParameterT extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)(_1.ParameterName, "=", _1.Target);
    }
}
exports.ParameterT = ParameterT;
//# sourceMappingURL=parameter_t.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/pass_by_value.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/pass_by_value.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PassByValue = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class PassByValue extends combi_1.Expression {
    getRunnable() {
        const value = (0, combi_1.seq)("VALUE", (0, combi_1.tok)(tokens_1.ParenLeft), _1.FormParamName, (0, combi_1.tok)(tokens_1.ParenRightW));
        return value;
    }
}
exports.PassByValue = PassByValue;
//# sourceMappingURL=pass_by_value.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_changing.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_changing.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PerformChanging = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const target_1 = __webpack_require__(/*! ./target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target.js");
class PerformChanging extends combi_1.Expression {
    getRunnable() {
        const changing = (0, combi_1.seq)("CHANGING", (0, combi_1.plus)(target_1.Target));
        return changing;
    }
}
exports.PerformChanging = PerformChanging;
//# sourceMappingURL=perform_changing.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_tables.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_tables.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PerformTables = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
class PerformTables extends combi_1.Expression {
    getRunnable() {
        const tables = (0, combi_1.seq)("TABLES", (0, combi_1.plus)(source_1.Source));
        return tables;
    }
}
exports.PerformTables = PerformTables;
//# sourceMappingURL=perform_tables.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_using.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/perform_using.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PerformUsing = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
class PerformUsing extends combi_1.Expression {
    getRunnable() {
        const using = (0, combi_1.seq)("USING", (0, combi_1.plus)(source_1.Source));
        return using;
    }
}
exports.PerformUsing = PerformUsing;
//# sourceMappingURL=perform_using.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/radio_group_name.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/radio_group_name.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RadioGroupName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class RadioGroupName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^[\w\d%]+$/);
    }
}
exports.RadioGroupName = RadioGroupName;
//# sourceMappingURL=radio_group_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/raise_with.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/raise_with.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RaiseWith = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class RaiseWith extends combi_1.Expression {
    getRunnable() {
        const wit = (0, combi_1.seq)("WITH", _1.Source, (0, combi_1.opt)(_1.Source), (0, combi_1.opt)(_1.Source), (0, combi_1.opt)(_1.Source));
        return wit;
    }
}
exports.RaiseWith = RaiseWith;
//# sourceMappingURL=raise_with.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/read_table_target.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/read_table_target.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReadTableTarget = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const fstarget_1 = __webpack_require__(/*! ./fstarget */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/fstarget.js");
const target_1 = __webpack_require__(/*! ./target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target.js");
class ReadTableTarget extends combi_1.Expression {
    getRunnable() {
        const target = (0, combi_1.altPrio)((0, combi_1.seq)("ASSIGNING", fstarget_1.FSTarget), (0, combi_1.seq)((0, combi_1.optPrio)("REFERENCE"), "INTO", target_1.Target), "TRANSPORTING NO FIELDS");
        return target;
    }
}
exports.ReadTableTarget = ReadTableTarget;
//# sourceMappingURL=read_table_target.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/receive_parameters.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/receive_parameters.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReceiveParameters = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ReceiveParameters extends combi_1.Expression {
    getRunnable() {
        const importing = (0, combi_1.seq)("IMPORTING", _1.ParameterListT);
        const tables = (0, combi_1.seq)("TABLES", _1.ParameterListT);
        const changing = (0, combi_1.seq)("CHANGING", _1.ParameterListT);
        const exceptions = (0, combi_1.seq)("EXCEPTIONS", (0, combi_1.opt)(_1.ParameterListExceptions), (0, combi_1.opt)(_1.Field));
        const long = (0, combi_1.seq)((0, combi_1.opt)(importing), (0, combi_1.opt)(changing), (0, combi_1.opt)(tables), (0, combi_1.opt)(exceptions));
        return long;
    }
}
exports.ReceiveParameters = ReceiveParameters;
//# sourceMappingURL=receive_parameters.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/redefinition.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/redefinition.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Redefinition = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Redefinition extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)((0, combi_1.opt)("FINAL"), "REDEFINITION");
    }
}
exports.Redefinition = Redefinition;
//# sourceMappingURL=redefinition.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/reduce_body.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/reduce_body.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReduceBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const reduce_next_1 = __webpack_require__(/*! ./reduce_next */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/reduce_next.js");
class ReduceBody extends combi_1.Expression {
    getRunnable() {
        const init = (0, combi_1.seq)("INIT", (0, combi_1.plus)(_1.InlineFieldDefinition));
        return (0, combi_1.seq)((0, combi_1.opt)(_1.Let), init, (0, combi_1.plus)(_1.For), reduce_next_1.ReduceNext);
    }
}
exports.ReduceBody = ReduceBody;
//# sourceMappingURL=reduce_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/reduce_next.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/reduce_next.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReduceNext = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ReduceNext extends combi_1.Expression {
    getRunnable() {
        const calcAssign = (0, combi_1.ver)(version_1.Version.v754, (0, combi_1.alt)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.WPlus), "="), (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WDash), "="), "/=", "*=", "&&="));
        const fields = (0, combi_1.seq)(_1.SimpleTarget, (0, combi_1.altPrio)("=", calcAssign), _1.Source);
        return (0, combi_1.seq)("NEXT", (0, combi_1.plus)(fields));
    }
}
exports.ReduceNext = ReduceNext;
//# sourceMappingURL=reduce_next.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/report_name.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/report_name.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReportName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class ReportName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)((0, combi_1.regex)(/^[\w/$%]+$/), (0, combi_1.star)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.regex)(/^\w+$/))));
    }
}
exports.ReportName = ReportName;
//# sourceMappingURL=report_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/select.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/select.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Select = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const sql_group_by_1 = __webpack_require__(/*! ./sql_group_by */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_group_by.js");
const sql_into_structure_1 = __webpack_require__(/*! ./sql_into_structure */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_structure.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const sql_field_name_1 = __webpack_require__(/*! ./sql_field_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js");
const sql_up_to_1 = __webpack_require__(/*! ./sql_up_to */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_up_to.js");
class Select extends combi_1.Expression {
    getRunnable() {
        const into = (0, combi_1.altPrio)(_1.SQLIntoTable, sql_into_structure_1.SQLIntoStructure, _1.SQLIntoList);
        const where = (0, combi_1.seq)("WHERE", _1.SQLCond);
        const offset = (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("OFFSET", _1.SQLSource));
        const bypass = (0, combi_1.str)("BYPASSING BUFFER");
        const fields = (0, combi_1.ver)(version_1.Version.v750, _1.SQLFields);
        // todo, HINTS cannot be anywhere, need an expression dedicated for strict sql
        const perm = (0, combi_1.per)(_1.SQLFrom, into, _1.SQLForAllEntries, where, _1.SQLOrderBy, sql_up_to_1.SQLUpTo, offset, _1.SQLClient, _1.SQLHaving, bypass, sql_group_by_1.SQLGroupBy, fields, _1.DatabaseConnection, _1.SQLHints);
        const permSingle = (0, combi_1.per)(_1.SQLFrom, (0, combi_1.altPrio)(sql_into_structure_1.SQLIntoStructure, _1.SQLIntoList), where, _1.SQLClient, bypass, fields, _1.DatabaseConnection, _1.SQLHints);
        const paren = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeftW), sql_field_name_1.SQLFieldName, (0, combi_1.tok)(tokens_1.WParenRightW));
        const fieldList = (0, combi_1.optPrio)((0, combi_1.altPrio)(_1.SQLFieldList, paren));
        const single = (0, combi_1.seq)("SINGLE", (0, combi_1.optPrio)("FOR UPDATE"), fieldList, permSingle);
        const other = (0, combi_1.seq)((0, combi_1.optPrio)("DISTINCT"), fieldList, perm);
        const ret = (0, combi_1.seq)("SELECT", (0, combi_1.altPrio)(single, other));
        return ret;
    }
}
exports.Select = Select;
//# sourceMappingURL=select.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/select_loop.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/select_loop.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectLoop = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const sql_order_by_1 = __webpack_require__(/*! ./sql_order_by */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_order_by.js");
const sql_having_1 = __webpack_require__(/*! ./sql_having */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_having.js");
const sql_into_structure_1 = __webpack_require__(/*! ./sql_into_structure */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_structure.js");
const sql_hints_1 = __webpack_require__(/*! ./sql_hints */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_hints.js");
const sql_field_list_loop_1 = __webpack_require__(/*! ./sql_field_list_loop */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_list_loop.js");
const sql_up_to_1 = __webpack_require__(/*! ./sql_up_to */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_up_to.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SelectLoop extends combi_1.Expression {
    getRunnable() {
        const where = (0, combi_1.seq)("WHERE", _1.SQLCond);
        const bypass = "BYPASSING BUFFER";
        const pack = (0, combi_1.seq)("PACKAGE SIZE", _1.SQLSource);
        const tab = (0, combi_1.seq)(_1.SQLIntoTable, (0, combi_1.alt)(pack, (0, combi_1.seq)(_1.SQLFrom, pack), (0, combi_1.seq)(pack, _1.SQLFrom)));
        const packTab = (0, combi_1.seq)(pack, _1.SQLIntoTable);
        const into = (0, combi_1.altPrio)(sql_into_structure_1.SQLIntoStructure, _1.SQLIntoList);
        const perm = (0, combi_1.per)(_1.SQLFrom, where, sql_up_to_1.SQLUpTo, sql_order_by_1.SQLOrderBy, sql_having_1.SQLHaving, _1.SQLClient, bypass, _1.SQLGroupBy, _1.SQLForAllEntries, (0, combi_1.alt)(tab, into, packTab));
        const strict = (0, combi_1.seq)(_1.SQLFrom, (0, combi_1.ver)(version_1.Version.v750, _1.SQLFields), where, into, sql_up_to_1.SQLUpTo);
        const ret = (0, combi_1.seq)("SELECT", (0, combi_1.altPrio)((0, combi_1.seq)((0, combi_1.optPrio)("DISTINCT"), sql_field_list_loop_1.SQLFieldListLoop, perm), strict), (0, combi_1.optPrio)(sql_hints_1.SQLHints));
        return ret;
    }
}
exports.SelectLoop = SelectLoop;
//# sourceMappingURL=select_loop.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_field_chain.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_field_chain.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleFieldChain = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const attribute_name_1 = __webpack_require__(/*! ./attribute_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_name.js");
class SimpleFieldChain extends combi_1.Expression {
    getRunnable() {
        const chain = (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), _1.ComponentName));
        const clas = (0, combi_1.seq)(_1.ClassName, (0, combi_1.tok)(tokens_1.StaticArrow), attribute_name_1.AttributeName);
        const start = (0, combi_1.altPrio)(clas, _1.Field);
        const ret = (0, combi_1.seq)(start, chain);
        return ret;
    }
}
exports.SimpleFieldChain = SimpleFieldChain;
//# sourceMappingURL=simple_field_chain.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_field_chain2.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_field_chain2.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleFieldChain2 = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const attribute_name_1 = __webpack_require__(/*! ./attribute_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_name.js");
class SimpleFieldChain2 extends combi_1.Expression {
    getRunnable() {
        const attr = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.InstanceArrow), attribute_name_1.AttributeName);
        const comp = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), _1.ComponentName);
        const chain = (0, combi_1.star)((0, combi_1.altPrio)(attr, comp));
        const clas = (0, combi_1.seq)(_1.ClassName, (0, combi_1.tok)(tokens_1.StaticArrow), attribute_name_1.AttributeName);
        const start = (0, combi_1.altPrio)(clas, _1.SourceField, _1.SourceFieldSymbol);
        const ret = (0, combi_1.seq)(start, chain);
        return ret;
    }
}
exports.SimpleFieldChain2 = SimpleFieldChain2;
//# sourceMappingURL=simple_field_chain2.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_name.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_name.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class SimpleName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^[\w$%]+$/);
    }
}
exports.SimpleName = SimpleName;
//# sourceMappingURL=simple_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source1.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source1.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleSource1 = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SimpleSource1 extends combi_1.Expression {
    getRunnable() {
        const concat = (0, combi_1.seq)("&&", _1.StringTemplate);
        const template = (0, combi_1.seq)(_1.StringTemplate, (0, combi_1.star)(concat));
        return (0, combi_1.alt)(_1.Constant, _1.TextElement, _1.MethodCallChain, template, _1.FieldChain);
    }
}
exports.SimpleSource1 = SimpleSource1;
//# sourceMappingURL=simple_source1.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source2.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source2.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleSource2 = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
/** Reduced version of SimpleSource, omits MethodCallChains. */
class SimpleSource2 extends combi_1.Expression {
    getRunnable() {
        const concat = (0, combi_1.seq)("&&", _1.StringTemplate);
        const template = (0, combi_1.seq)(_1.StringTemplate, (0, combi_1.star)(concat));
        return (0, combi_1.altPrio)(_1.Constant, _1.TextElement, template, _1.FieldChain);
    }
}
exports.SimpleSource2 = SimpleSource2;
//# sourceMappingURL=simple_source2.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source3.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source3.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleSource3 = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SimpleSource3 extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)(_1.Constant, _1.TextElement, _1.FieldChain);
    }
}
exports.SimpleSource3 = SimpleSource3;
//# sourceMappingURL=simple_source3.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source4.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source4.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleSource4 = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const method_call_chain_1 = __webpack_require__(/*! ./method_call_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/method_call_chain.js");
class SimpleSource4 extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.alt)(_1.Constant, _1.TextElement, _1.FieldChain, method_call_chain_1.MethodCallChain);
    }
}
exports.SimpleSource4 = SimpleSource4;
//# sourceMappingURL=simple_source4.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_target.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_target.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleTarget = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const attribute_name_1 = __webpack_require__(/*! ./attribute_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_name.js");
const dereference_1 = __webpack_require__(/*! ./dereference */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dereference.js");
class SimpleTarget extends combi_1.Expression {
    getRunnable() {
        const attr = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.InstanceArrow), attribute_name_1.AttributeName);
        const comp = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), _1.ComponentName);
        const something = (0, combi_1.starPrio)((0, combi_1.altPrio)(dereference_1.Dereference, attr, comp, _1.TableExpression));
        const cast = (0, combi_1.seq)((0, combi_1.altPrio)(_1.Cast, _1.NewObject), _1.Arrow, _1.FieldAll);
        const clas = (0, combi_1.seq)(_1.ClassName, (0, combi_1.tok)(tokens_1.StaticArrow), attribute_name_1.AttributeName);
        const start = (0, combi_1.altPrio)(cast, clas, _1.TargetField, _1.TargetFieldSymbol);
        const fields = (0, combi_1.seq)((0, combi_1.optPrio)(_1.FieldOffset), (0, combi_1.optPrio)(_1.FieldLength));
        const optional = (0, combi_1.altPrio)(_1.TableBody, fields);
        return (0, combi_1.seq)(start, something, optional);
    }
}
exports.SimpleTarget = SimpleTarget;
//# sourceMappingURL=simple_target.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Source = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const text_element_1 = __webpack_require__(/*! ./text_element */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element.js");
const attribute_chain_1 = __webpack_require__(/*! ./attribute_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_chain.js");
const dereference_1 = __webpack_require__(/*! ./dereference */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dereference.js");
// todo, COND and SWITCH are quite similar?
// this class is used quite often, so its nice to have the differentiating tokens part of it
class Source extends combi_1.Expression {
    getRunnable() {
        const comp = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), _1.ComponentChain);
        const attr = (0, combi_1.seq)(_1.Arrow, attribute_chain_1.AttributeChain);
        const method = (0, combi_1.seq)(_1.MethodCallChain, (0, combi_1.optPrio)((0, combi_1.altPrio)(attr, comp)), (0, combi_1.optPrio)(dereference_1.Dereference));
        const rparen = (0, combi_1.tok)(tokens_1.WParenRightW);
        const rparenNoSpace = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenRightW), (0, combi_1.tok)(tokens_1.WParenRightW));
        // paren used for eg. "( 2 + 1 ) * 4"
        const paren = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeftW), Source, rparen);
        const after = (0, combi_1.seq)((0, combi_1.altPrio)("&", "&&", _1.ArithOperator), Source);
        const bool = (0, combi_1.seq)((0, combi_1.altPrio)((0, combi_1.ver)(version_1.Version.v702, (0, combi_1.regex)(/^BOOLC$/i)), (0, combi_1.ver)(version_1.Version.v740sp08, (0, combi_1.regex)(/^XSDBOOL$/i))), (0, combi_1.tok)(tokens_1.ParenLeftW), _1.Cond, ")");
        const prefix = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WPlus), "BIT-NOT");
        const old = (0, combi_1.seq)((0, combi_1.optPrio)(prefix), (0, combi_1.altPrio)(_1.Constant, _1.StringTemplate, text_element_1.TextElement, bool, method, (0, combi_1.seq)(_1.FieldChain, (0, combi_1.optPrio)(dereference_1.Dereference)), paren), (0, combi_1.optPrio)(after));
        const corr = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("CORRESPONDING", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), _1.CorrespondingBody, rparen, (0, combi_1.optPrio)(after)));
        const conv = (0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.seq)("CONV", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), _1.ConvBody, rparenNoSpace, (0, combi_1.optPrio)(after)));
        const swit = (0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.seq)("SWITCH", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), _1.SwitchBody, rparenNoSpace, (0, combi_1.optPrio)(after)));
        const value = (0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.seq)("VALUE", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), _1.ValueBody, rparenNoSpace, (0, combi_1.optPrio)(after)));
        const cond = (0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.seq)("COND", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), _1.CondBody, rparenNoSpace, (0, combi_1.optPrio)(after)));
        const reff = (0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.seq)("REF", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), Source, (0, combi_1.optPrio)("OPTIONAL"), rparen));
        const exact = (0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.seq)("EXACT", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), Source, rparen, (0, combi_1.optPrio)(after)));
        const filter = (0, combi_1.ver)(version_1.Version.v740sp08, (0, combi_1.seq)("FILTER", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), _1.FilterBody, rparen));
        const reduce = (0, combi_1.ver)(version_1.Version.v740sp08, (0, combi_1.seq)("REDUCE", _1.TypeNameOrInfer, (0, combi_1.tok)(tokens_1.ParenLeftW), _1.ReduceBody, rparen, (0, combi_1.optPrio)(after)));
        const prefix1 = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WDashW), (0, combi_1.tok)(tokens_1.WPlusW));
        const ret = (0, combi_1.seq)((0, combi_1.starPrio)(prefix1), (0, combi_1.altPrio)(filter, reff, corr, conv, value, cond, exact, swit, reduce, old));
        return ret;
    }
}
exports.Source = Source;
//# sourceMappingURL=source.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source_field.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source_field.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SourceField = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SourceField extends combi_1.Expression {
    getRunnable() {
        return new _1.Field();
    }
}
exports.SourceField = SourceField;
//# sourceMappingURL=source_field.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source_field_symbol.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source_field_symbol.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SourceFieldSymbol = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SourceFieldSymbol extends combi_1.Expression {
    getRunnable() {
        return new _1.FieldSymbol();
    }
}
exports.SourceFieldSymbol = SourceFieldSymbol;
//# sourceMappingURL=source_field_symbol.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_aggregation.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_aggregation.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLAggregation = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
const sql_arithmetics_1 = __webpack_require__(/*! ./sql_arithmetics */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetics.js");
class SQLAggregation extends combi_1.Expression {
    getRunnable() {
        const f = (0, combi_1.seq)((0, combi_1.optPrio)("DISTINCT"), (0, combi_1.altPrio)(sql_arithmetics_1.SQLArithmetics, dynamic_1.Dynamic, _1.SQLFunction));
        const fparen = (0, combi_1.seq)("(", _1.Field, ")");
        const count = (0, combi_1.seq)("COUNT", (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.tok)(tokens_1.ParenLeftW)), (0, combi_1.optPrio)("DISTINCT"), (0, combi_1.altPrio)("*", _1.Field, fparen), ")");
        const max = (0, combi_1.seq)("MAX", (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.tok)(tokens_1.ParenLeftW)), f, ")");
        const min = (0, combi_1.seq)("MIN", (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.tok)(tokens_1.ParenLeftW)), f, ")");
        const sum = (0, combi_1.seq)("SUM", (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.tok)(tokens_1.ParenLeftW)), f, ")");
        const avg = (0, combi_1.seq)("AVG", (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.tok)(tokens_1.ParenLeftW)), f, ")");
        return (0, combi_1.altPrio)(count, max, min, sum, avg);
    }
}
exports.SQLAggregation = SQLAggregation;
//# sourceMappingURL=sql_aggregation.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_alias_field.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_alias_field.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLAliasField = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class SQLAliasField extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^(\/\w+\/)?\w+~\w+$/);
    }
}
exports.SQLAliasField = SQLAliasField;
//# sourceMappingURL=sql_alias_field.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetic_operator.js":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetic_operator.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLArithmeticOperator = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class SQLArithmeticOperator extends combi_1.Expression {
    getRunnable() {
        const operator = (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WPlusW), (0, combi_1.tok)(tokens_1.WDashW), "*", "/");
        return operator;
    }
}
exports.SQLArithmeticOperator = SQLArithmeticOperator;
//# sourceMappingURL=sql_arithmetic_operator.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetics.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetics.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLArithmetics = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const sql_arithmetic_operator_1 = __webpack_require__(/*! ./sql_arithmetic_operator */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetic_operator.js");
class SQLArithmetics extends combi_1.Expression {
    getRunnable() {
        const field = (0, combi_1.alt)(_1.SQLFieldName, _1.SQLFunction);
        return (0, combi_1.seq)(field, (0, combi_1.starPrio)((0, combi_1.seq)(sql_arithmetic_operator_1.SQLArithmeticOperator, field)));
    }
}
exports.SQLArithmetics = SQLArithmetics;
//# sourceMappingURL=sql_arithmetics.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_as_name.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_as_name.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLAsName = void 0;
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class SQLAsName extends combi_1.Expression {
    getRunnable() {
        // todo, below allows too much?
        const field = (0, combi_1.regex)(/^[&_!]?\*?\w*(\/\w+\/)?\d*[a-zA-Z_%\$][\w\*%\$\?]*(~\w+)?$/);
        return (0, combi_1.seq)(field, (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), field)));
    }
}
exports.SQLAsName = SQLAsName;
//# sourceMappingURL=sql_as_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_case.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_case.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLCase = void 0;
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const constant_1 = __webpack_require__(/*! ./constant */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant.js");
const sql_cond_1 = __webpack_require__(/*! ./sql_cond */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_cond.js");
const sql_field_name_1 = __webpack_require__(/*! ./sql_field_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js");
const sql_source_1 = __webpack_require__(/*! ./sql_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source.js");
class SQLCase extends combi_1.Expression {
    getRunnable() {
        const field = (0, combi_1.altPrio)(_1.SQLAggregation, SQLCase, _1.SQLFunction, _1.SQLPath, sql_field_name_1.SQLFieldName, constant_1.Constant);
        const sub = (0, combi_1.seq)((0, combi_1.altPrio)("+", "-", "*", "/", "&&"), (0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.WParenLeftW)), field, (0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.WParenRightW)));
        const when = (0, combi_1.seq)("WHEN", (0, combi_1.alt)(constant_1.Constant, sql_cond_1.SQLCond), "THEN", (0, combi_1.altPrio)(_1.SQLAggregation, _1.SQLFunction, sql_source_1.SQLSource), (0, combi_1.starPrio)(sub));
        const els = (0, combi_1.seq)("ELSE", sql_source_1.SQLSource);
        return (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("CASE", (0, combi_1.opt)(sql_field_name_1.SQLFieldName), (0, combi_1.plus)(when), (0, combi_1.optPrio)(els), "END"));
    }
}
exports.SQLCase = SQLCase;
//# sourceMappingURL=sql_case.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_cds_parameters.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_cds_parameters.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLCDSParameters = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const field_chain_1 = __webpack_require__(/*! ./field_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_chain.js");
class SQLCDSParameters extends combi_1.Expression {
    getRunnable() {
        const param = (0, combi_1.seq)(_1.Field, "=", (0, combi_1.alt)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.WAt), field_chain_1.FieldChain), _1.Constant));
        return (0, combi_1.seq)("(", param, (0, combi_1.starPrio)((0, combi_1.seq)(",", param)), ")");
    }
}
exports.SQLCDSParameters = SQLCDSParameters;
//# sourceMappingURL=sql_cds_parameters.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_client.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_client.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLClient = void 0;
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const sql_source_simple_1 = __webpack_require__(/*! ./sql_source_simple */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source_simple.js");
class SQLClient extends combi_1.Expression {
    getRunnable() {
        const client = (0, combi_1.alt)((0, combi_1.verNot)(version_1.Version.Cloud, "CLIENT SPECIFIED"), (0, combi_1.seq)("USING", (0, combi_1.alt)((0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("CLIENT", sql_source_simple_1.SQLSourceSimple)), (0, combi_1.ver)(version_1.Version.v754, (0, combi_1.seq)("CLIENTS IN", (0, combi_1.alt)(sql_source_simple_1.SQLSourceSimple, "T000"))), (0, combi_1.ver)(version_1.Version.v754, "ALL CLIENTS"))));
        return client;
    }
}
exports.SQLClient = SQLClient;
//# sourceMappingURL=sql_client.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_compare.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_compare.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLCompare = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SQLCompare extends combi_1.Expression {
    getRunnable() {
        const subSelect = (0, combi_1.seq)("(", _1.Select, ")");
        const between = (0, combi_1.seq)("BETWEEN", _1.SQLSource, "AND", _1.SQLSource);
        const like = (0, combi_1.seq)("LIKE", _1.SQLSource, (0, combi_1.optPrio)((0, combi_1.seq)("ESCAPE", _1.SQLSource)));
        const nul = (0, combi_1.seq)("IS", (0, combi_1.optPrio)("NOT"), (0, combi_1.altPrio)("NULL", (0, combi_1.ver)(version_1.Version.v753, "INITIAL")));
        const source = new _1.SQLSource();
        const sub = (0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.altPrio)("ALL", "ANY", "SOME")), subSelect);
        const arith = (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.plusPrio)((0, combi_1.seq)((0, combi_1.altPrio)("+", "-", "*", "/"), _1.SQLFieldName)));
        const rett = (0, combi_1.seq)((0, combi_1.altPrio)(_1.SQLFunction, (0, combi_1.seq)(_1.SQLFieldName, (0, combi_1.optPrio)(arith))), (0, combi_1.altPrio)((0, combi_1.seq)(_1.SQLCompareOperator, (0, combi_1.altPrio)(sub, source)), (0, combi_1.seq)((0, combi_1.optPrio)("NOT"), (0, combi_1.altPrio)(_1.SQLIn, like, between)), nul));
        const exists = (0, combi_1.seq)("EXISTS", subSelect);
        return (0, combi_1.altPrio)(exists, _1.Dynamic, rett);
    }
}
exports.SQLCompare = SQLCompare;
//# sourceMappingURL=sql_compare.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_compare_operator.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_compare_operator.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLCompareOperator = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class SQLCompareOperator extends combi_1.Expression {
    getRunnable() {
        const operator = (0, combi_1.altPrio)("=", "<>", "<", ">", "<=", ">=", "EQ", "NE", "GE", "GT", "LT", "LE", "><", "=>", "=<");
        return operator;
    }
}
exports.SQLCompareOperator = SQLCompareOperator;
//# sourceMappingURL=sql_compare_operator.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_cond.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_cond.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLCond = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLCond extends combi_1.Expression {
    getRunnable() {
        const operator = (0, combi_1.altPrio)("AND", "OR");
        const paren = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeftW), SQLCond, (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRightW), (0, combi_1.tok)(tokens_1.ParenRightW)));
        const cnd = (0, combi_1.seq)((0, combi_1.optPrio)("NOT"), (0, combi_1.altPrio)(_1.SQLCompare, paren));
        const ret = (0, combi_1.seq)(cnd, (0, combi_1.starPrio)((0, combi_1.seq)(operator, cnd)));
        return ret;
    }
}
exports.SQLCond = SQLCond;
//# sourceMappingURL=sql_cond.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLField = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const sql_function_1 = __webpack_require__(/*! ./sql_function */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_function.js");
const simple_field_chain_1 = __webpack_require__(/*! ./simple_field_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_field_chain.js");
const sql_path_1 = __webpack_require__(/*! ./sql_path */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_path.js");
class SQLField extends combi_1.Expression {
    getRunnable() {
        const abap = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WAt), simple_field_chain_1.SimpleFieldChain));
        const as = (0, combi_1.seq)("AS", _1.SQLAsName);
        const field = (0, combi_1.altPrio)(_1.SQLAggregation, _1.SQLCase, sql_function_1.SQLFunction, sql_path_1.SQLPath, _1.SQLFieldName, abap, _1.Constant);
        const sub = (0, combi_1.plusPrio)((0, combi_1.seq)((0, combi_1.altPrio)("+", "-", "*", "/", "&&"), (0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.WParenLeftW)), field, (0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.WParenRightW))));
        const arith = (0, combi_1.ver)(version_1.Version.v740sp05, sub);
        return (0, combi_1.seq)(field, (0, combi_1.optPrio)(arith), (0, combi_1.optPrio)(as));
    }
}
exports.SQLField = SQLField;
//# sourceMappingURL=sql_field.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_and_value.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_and_value.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLFieldAndValue = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const integer_1 = __webpack_require__(/*! ./integer */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/integer.js");
const sql_arithmetic_operator_1 = __webpack_require__(/*! ./sql_arithmetic_operator */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_arithmetic_operator.js");
const sql_field_name_1 = __webpack_require__(/*! ./sql_field_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js");
const sql_source_1 = __webpack_require__(/*! ./sql_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source.js");
class SQLFieldAndValue extends combi_1.Expression {
    getRunnable() {
        const opt1 = (0, combi_1.seq)((0, combi_1.altPrio)(integer_1.Integer, sql_field_name_1.SQLFieldName), sql_arithmetic_operator_1.SQLArithmeticOperator, sql_source_1.SQLSource);
        const param = (0, combi_1.seq)(sql_field_name_1.SQLFieldName, "=", (0, combi_1.altPrio)(opt1, sql_source_1.SQLSource));
        return param;
    }
}
exports.SQLFieldAndValue = SQLFieldAndValue;
//# sourceMappingURL=sql_field_and_value.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_list.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_list.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLFieldList = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SQLFieldList extends combi_1.Expression {
    getRunnable() {
        const nev = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.starPrio)((0, combi_1.seq)(",", _1.SQLField)));
        const old = (0, combi_1.starPrio)(_1.SQLField);
        return (0, combi_1.altPrio)("*", _1.Dynamic, (0, combi_1.seq)(_1.SQLField, (0, combi_1.alt)(nev, old)));
    }
}
exports.SQLFieldList = SQLFieldList;
//# sourceMappingURL=sql_field_list.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_list_loop.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_list_loop.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLFieldListLoop = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const sql_path_1 = __webpack_require__(/*! ./sql_path */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_path.js");
// loop must include one field from the database table
class SQLFieldListLoop extends combi_1.Expression {
    getRunnable() {
        const comma = (0, combi_1.opt)((0, combi_1.ver)(version_1.Version.v740sp05, ","));
        const as = (0, combi_1.seq)("AS", _1.SQLAsName);
        const someField = (0, combi_1.seq)(_1.SQLField, comma);
        const fieldList = (0, combi_1.seq)((0, combi_1.star)(someField), (0, combi_1.alt)(_1.SQLFieldName, sql_path_1.SQLPath, _1.Constant), (0, combi_1.optPrio)(as), comma, (0, combi_1.star)(someField));
        const fields = (0, combi_1.alt)("*", _1.Dynamic, fieldList);
        return fields;
    }
}
exports.SQLFieldListLoop = SQLFieldListLoop;
//# sourceMappingURL=sql_field_list_loop.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLFieldName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class SQLFieldName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^(?!(?:SINGLE|INTO|DISTINCT|AS|WHERE|FOR|HAVING|APPENDING|UP|FROM)$)(\/\w+\/)?(\w+~(\w+|\*)|\w+)$/i);
    }
}
exports.SQLFieldName = SQLFieldName;
//# sourceMappingURL=sql_field_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_fields.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_fields.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLFields = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLFields extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("FIELDS", (0, combi_1.opt)("DISTINCT"), _1.SQLFieldList);
    }
}
exports.SQLFields = SQLFields;
//# sourceMappingURL=sql_fields.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_for_all_entries.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_for_all_entries.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLForAllEntries = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const sql_source_1 = __webpack_require__(/*! ./sql_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source.js");
class SQLForAllEntries extends combi_1.Expression {
    getRunnable() {
        const forAll = (0, combi_1.seq)("FOR ALL ENTRIES IN", sql_source_1.SQLSource);
        return forAll;
    }
}
exports.SQLForAllEntries = SQLForAllEntries;
//# sourceMappingURL=sql_for_all_entries.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_from.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_from.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLFrom = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLFrom extends combi_1.Expression {
    getRunnable() {
        const from = (0, combi_1.seq)("FROM", (0, combi_1.starPrio)((0, combi_1.tok)(tokens_1.WParenLeftW)), _1.SQLFromSource);
        const source = (0, combi_1.seq)(from, (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.WParenRightW)), _1.SQLJoin, (0, combi_1.optPrio)((0, combi_1.tok)(tokens_1.WParenRightW)))));
        return source;
    }
}
exports.SQLFrom = SQLFrom;
//# sourceMappingURL=sql_from.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_from_source.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_from_source.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLFromSource = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const with_name_1 = __webpack_require__(/*! ./with_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/with_name.js");
class SQLFromSource extends combi_1.Expression {
    getRunnable() {
        // https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-US/abennews-752-open_sql.htm#!ABAP_MODIFICATION_1@1@
        const tab = (0, combi_1.ver)(version_1.Version.v752, (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WAt), _1.FieldChain));
        const aas = (0, combi_1.seq)("AS", _1.SQLAsName);
        return (0, combi_1.seq)((0, combi_1.altPrio)(with_name_1.WithName, (0, combi_1.seq)(_1.DatabaseTable, (0, combi_1.optPrio)(_1.SQLCDSParameters)), tab), (0, combi_1.optPrio)((0, combi_1.ver)(version_1.Version.v752, "WITH PRIVILEGED ACCESS")), (0, combi_1.optPrio)(aas));
    }
}
exports.SQLFromSource = SQLFromSource;
//# sourceMappingURL=sql_from_source.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_function.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_function.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLFunction = void 0;
const constant_1 = __webpack_require__(/*! ./constant */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/constant.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const integer_1 = __webpack_require__(/*! ./integer */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/integer.js");
const sql_alias_field_1 = __webpack_require__(/*! ./sql_alias_field */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_alias_field.js");
const sql_field_name_1 = __webpack_require__(/*! ./sql_field_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js");
const simple_source3_1 = __webpack_require__(/*! ./simple_source3 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source3.js");
const source_1 = __webpack_require__(/*! ./source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
const sql_aggregation_1 = __webpack_require__(/*! ./sql_aggregation */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_aggregation.js");
class SQLFunction extends combi_1.Expression {
    getRunnable() {
        const paren = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeftW), source_1.Source, (0, combi_1.tok)(tokens_1.WParenRightW));
        const at = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WAt), (0, combi_1.alt)(simple_source3_1.SimpleSource3, paren)));
        const param = (0, combi_1.alt)(sql_field_name_1.SQLFieldName, sql_alias_field_1.SQLAliasField, SQLFunction, constant_1.Constant, sql_aggregation_1.SQLAggregation, at);
        const castTypes = (0, combi_1.altPrio)((0, combi_1.seq)("CHAR", (0, combi_1.tok)(tokens_1.ParenLeftW), integer_1.Integer, (0, combi_1.tok)(tokens_1.WParenRightW)), (0, combi_1.seq)("DEC", (0, combi_1.tok)(tokens_1.ParenLeftW), integer_1.Integer, ",", integer_1.Integer, (0, combi_1.tok)(tokens_1.WParenRightW)), "FLTP", "NUMC", "INT8");
        const abs = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("abs", (0, combi_1.tok)(tokens_1.ParenLeftW), param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const cast = (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("cast", (0, combi_1.tok)(tokens_1.ParenLeftW), param, "AS", castTypes, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const ceil = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("ceil", (0, combi_1.tok)(tokens_1.ParenLeftW), param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const coalesce = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("coalesce", (0, combi_1.tok)(tokens_1.ParenLeftW), param, ",", param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const concat = (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("concat", (0, combi_1.tok)(tokens_1.ParenLeftW), param, ",", param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const div = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("div", (0, combi_1.tok)(tokens_1.ParenLeftW), param, ",", param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const floor = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("floor", (0, combi_1.tok)(tokens_1.ParenLeftW), param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const length = (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("length", (0, combi_1.tok)(tokens_1.ParenLeftW), param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const lower = (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("lower", (0, combi_1.tok)(tokens_1.ParenLeftW), param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const mod = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("mod", (0, combi_1.tok)(tokens_1.ParenLeftW), param, ",", param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const replace = (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("replace", (0, combi_1.tok)(tokens_1.ParenLeftW), param, ",", param, ",", param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const round = (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("round", (0, combi_1.tok)(tokens_1.ParenLeftW), param, ",", param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const upper = (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("upper", (0, combi_1.tok)(tokens_1.ParenLeftW), param, (0, combi_1.tok)(tokens_1.WParenRightW)));
        const uuid = (0, combi_1.ver)(version_1.Version.v754, (0, combi_1.seq)("uuid", (0, combi_1.tok)(tokens_1.ParenLeftW), (0, combi_1.tok)(tokens_1.WParenRightW)));
        return (0, combi_1.altPrio)(uuid, abs, ceil, floor, cast, div, mod, coalesce, concat, replace, length, lower, upper, round);
    }
}
exports.SQLFunction = SQLFunction;
//# sourceMappingURL=sql_function.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_group_by.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_group_by.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLGroupBy = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
const sql_field_name_1 = __webpack_require__(/*! ./sql_field_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js");
class SQLGroupBy extends combi_1.Expression {
    getRunnable() {
        const f = (0, combi_1.alt)(sql_field_name_1.SQLFieldName, dynamic_1.Dynamic);
        const strict = (0, combi_1.seq)((0, combi_1.plus)((0, combi_1.seq)(f, ",")), f);
        const group = (0, combi_1.seq)("GROUP BY", (0, combi_1.altPrio)(strict, (0, combi_1.plus)(f)));
        return group;
    }
}
exports.SQLGroupBy = SQLGroupBy;
//# sourceMappingURL=sql_group_by.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_having.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_having.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLHaving = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
class SQLHaving extends combi_1.Expression {
    getRunnable() {
        const having = (0, combi_1.seq)("HAVING", dynamic_1.Dynamic);
        return having;
    }
}
exports.SQLHaving = SQLHaving;
//# sourceMappingURL=sql_having.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_hints.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_hints.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLHints = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLHints extends combi_1.Expression {
    getRunnable() {
        const type = (0, combi_1.altPrio)("ORACLE", "ADABAS", "AS400", "DB2", "HDB", "MSSQLNT", "SYBASE", "DB6");
        const ret = (0, combi_1.seq)("%_HINTS", (0, combi_1.plus)((0, combi_1.seq)(type, _1.Constant)));
        return ret;
    }
}
exports.SQLHints = SQLHints;
//# sourceMappingURL=sql_hints.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_in.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_in.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLIn = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SQLIn extends combi_1.Expression {
    getRunnable() {
        const val = new _1.SQLSource();
        const short = new _1.SQLSourceNoSpace();
        const listOld = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeft), (0, combi_1.alt)((0, combi_1.ver)(version_1.Version.v740sp05, short), val), (0, combi_1.starPrio)((0, combi_1.seq)(",", val)), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenRight), (0, combi_1.tok)(tokens_1.ParenRightW), (0, combi_1.tok)(tokens_1.WParenRightW)));
        const listNew = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeftW), val, (0, combi_1.starPrio)((0, combi_1.seq)(",", (0, combi_1.altPrio)(short, val))), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRight), (0, combi_1.tok)(tokens_1.WParenRightW)));
        const list = (0, combi_1.alt)(listOld, (0, combi_1.ver)(version_1.Version.v740sp02, listNew)); // version is a guess, https://github.com/abaplint/abaplint/issues/2530
        const subSelect = (0, combi_1.seq)("(", _1.Select, ")");
        const inn = (0, combi_1.seq)("IN", (0, combi_1.altPrio)(_1.SQLSource, list, subSelect));
        return inn;
    }
}
exports.SQLIn = SQLIn;
//# sourceMappingURL=sql_in.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_list.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_list.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLIntoList = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const wparen_leftw_1 = __webpack_require__(/*! ../../1_lexer/tokens/wparen_leftw */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_leftw.js");
const wparen_left_1 = __webpack_require__(/*! ../../1_lexer/tokens/wparen_left */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/wparen_left.js");
class SQLIntoList extends combi_1.Expression {
    getRunnable() {
        const intoList = (0, combi_1.seq)((0, combi_1.altPrio)((0, combi_1.tok)(wparen_left_1.WParenLeft), (0, combi_1.tok)(wparen_leftw_1.WParenLeftW)), (0, combi_1.starPrio)((0, combi_1.seq)(_1.SQLTarget, ",")), _1.SQLTarget, ")");
        return (0, combi_1.seq)("INTO", intoList);
    }
}
exports.SQLIntoList = SQLIntoList;
//# sourceMappingURL=sql_into_list.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_structure.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_structure.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLIntoStructure = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLIntoStructure extends combi_1.Expression {
    getRunnable() {
        const intoSimple = (0, combi_1.seq)((0, combi_1.optPrio)("CORRESPONDING FIELDS OF"), _1.SQLTarget);
        return (0, combi_1.seq)("INTO", intoSimple);
    }
}
exports.SQLIntoStructure = SQLIntoStructure;
//# sourceMappingURL=sql_into_structure.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_table.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_table.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLIntoTable = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLIntoTable extends combi_1.Expression {
    getRunnable() {
        const into = (0, combi_1.seq)((0, combi_1.altPrio)("INTO", "APPENDING"), (0, combi_1.optPrio)("CORRESPONDING FIELDS OF"), "TABLE", _1.SQLTarget);
        return into;
    }
}
exports.SQLIntoTable = SQLIntoTable;
//# sourceMappingURL=sql_into_table.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_join.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_join.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLJoin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLJoin extends combi_1.Expression {
    getRunnable() {
        const joinType = (0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.altPrio)("INNER", "LEFT OUTER", "LEFT", "RIGHT OUTER", "RIGHT")), "JOIN");
        const join = (0, combi_1.seq)(joinType, _1.SQLFromSource, "ON", _1.SQLCond);
        return join;
    }
}
exports.SQLJoin = SQLJoin;
//# sourceMappingURL=sql_join.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_order_by.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_order_by.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLOrderBy = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
const sql_field_name_1 = __webpack_require__(/*! ./sql_field_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_field_name.js");
class SQLOrderBy extends combi_1.Expression {
    getRunnable() {
        const ding = (0, combi_1.alt)("ASCENDING", "DESCENDING");
        const ofields = (0, combi_1.plus)((0, combi_1.seq)(sql_field_name_1.SQLFieldName, (0, combi_1.opt)(ding), (0, combi_1.opt)(",")));
        const order = (0, combi_1.seq)("ORDER BY", (0, combi_1.altPrio)("PRIMARY KEY", dynamic_1.Dynamic, ofields));
        return order;
    }
}
exports.SQLOrderBy = SQLOrderBy;
//# sourceMappingURL=sql_order_by.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_path.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_path.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLPath = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class SQLPath extends combi_1.Expression {
    getRunnable() {
        // todo, only from version?
        const ret = (0, combi_1.seq)((0, combi_1.regex)(/\\_\w+/), (0, combi_1.tok)(tokens_1.Dash), (0, combi_1.regex)(/\w+/));
        return ret;
    }
}
exports.SQLPath = SQLPath;
//# sourceMappingURL=sql_path.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLSource = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLSource extends combi_1.Expression {
    getRunnable() {
        const paren = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeftW), _1.Source, (0, combi_1.tok)(tokens_1.WParenRightW));
        const at = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WAt), (0, combi_1.altPrio)(_1.SimpleSource3, paren)));
        return (0, combi_1.alt)(_1.SQLAliasField, _1.SimpleSource3, at);
    }
}
exports.SQLSource = SQLSource;
//# sourceMappingURL=sql_source.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source_no_space.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source_no_space.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLSourceNoSpace = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLSourceNoSpace extends combi_1.Expression {
    getRunnable() {
        const paren = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeftW), _1.Source, (0, combi_1.tok)(tokens_1.WParenRightW));
        const at = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)((0, combi_1.tok)(tokens_1.At), (0, combi_1.altPrio)(_1.SimpleSource3, paren)));
        return (0, combi_1.alt)(_1.SQLAliasField, _1.SimpleSource3, at);
    }
}
exports.SQLSourceNoSpace = SQLSourceNoSpace;
//# sourceMappingURL=sql_source_no_space.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source_simple.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source_simple.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLSourceSimple = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
// todo, delete this expression, its the same as SQLSource?
class SQLSourceSimple extends combi_1.Expression {
    getRunnable() {
        const paren = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeftW), _1.Source, (0, combi_1.tok)(tokens_1.WParenRightW));
        const at = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WAt), (0, combi_1.alt)(_1.SimpleSource3, paren)));
        return (0, combi_1.alt)(_1.SimpleSource3, at);
    }
}
exports.SQLSourceSimple = SQLSourceSimple;
//# sourceMappingURL=sql_source_simple.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_target.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_target.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLTarget = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SQLTarget extends combi_1.Expression {
    getRunnable() {
        const n = (0, combi_1.ver)(version_1.Version.v754, "NEW");
        const at = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)((0, combi_1.opt)(n), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WAt), (0, combi_1.tok)(tokens_1.At)), _1.Target));
        return (0, combi_1.altPrio)(at, _1.Target);
    }
}
exports.SQLTarget = SQLTarget;
//# sourceMappingURL=sql_target.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_up_to.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_up_to.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SQLUpTo = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const sql_source_1 = __webpack_require__(/*! ./sql_source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_source.js");
class SQLUpTo extends combi_1.Expression {
    getRunnable() {
        const up = (0, combi_1.seq)("UP TO", sql_source_1.SQLSource, "ROWS");
        return up;
    }
}
exports.SQLUpTo = SQLUpTo;
//# sourceMappingURL=sql_up_to.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringTemplate = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const Tokens = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class StringTemplate extends combi_1.Expression {
    getRunnable() {
        const nest = (0, combi_1.seq)((0, combi_1.tok)(Tokens.StringTemplateBegin), _1.StringTemplateSource, (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(Tokens.StringTemplateMiddle), _1.StringTemplateSource)), (0, combi_1.tok)(Tokens.StringTemplateEnd));
        return (0, combi_1.ver)(version_1.Version.v702, (0, combi_1.altPrio)(nest, (0, combi_1.tok)(Tokens.StringTemplate)));
    }
}
exports.StringTemplate = StringTemplate;
//# sourceMappingURL=string_template.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template_formatting.js":
/*!***********************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template_formatting.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringTemplateFormatting = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
class StringTemplateFormatting extends combi_1.Expression {
    getRunnable() {
        // https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-us/abapcompute_string_format_options.htm
        const alphaOptions = (0, combi_1.altPrio)("OUT", "RAW", "IN", _1.Source);
        const alignOptions = (0, combi_1.altPrio)("LEFT", "RIGHT", "CENTER", _1.Source);
        const dateTimeOptions = (0, combi_1.altPrio)("RAW", "ISO", "USER", "ENVIRONMENT", _1.Source, dynamic_1.Dynamic);
        const timeStampOptions = (0, combi_1.altPrio)("SPACE", "ISO", "USER", "ENVIRONMENT", _1.Source);
        const numberOptions = (0, combi_1.altPrio)("RAW", "USER", "ENVIRONMENT", _1.Source);
        const signOptions = (0, combi_1.altPrio)("LEFT", "LEFTPLUS", "LEFTSPACE", "RIGHT", "RIGHTPLUS", "RIGHTSPACE", _1.Source);
        const caseOptions = (0, combi_1.altPrio)("RAW", "UPPER", "LOWER", _1.Source, dynamic_1.Dynamic);
        const zeroXSDOptions = (0, combi_1.altPrio)("YES", "NO", _1.Source);
        const styleOptions = (0, combi_1.altPrio)("SIMPLE", "SIGN_AS_POSTFIX", "SCALE_PRESERVING", "SCIENTIFIC", "SCIENTIFIC_WITH_LEADING_ZERO", "SCALE_PRESERVING_SCIENTIFIC", "ENGINEERING", _1.Source);
        const width = (0, combi_1.seq)("WIDTH =", _1.Source);
        const align = (0, combi_1.seq)("ALIGN =", alignOptions);
        const timezone = (0, combi_1.seq)("TIMEZONE =", _1.Source);
        const timestamp = (0, combi_1.seq)("TIMESTAMP =", timeStampOptions);
        const pad = (0, combi_1.seq)("PAD =", _1.Source);
        const number = (0, combi_1.seq)("NUMBER =", numberOptions);
        const sign = (0, combi_1.seq)("SIGN =", signOptions);
        const decimals = (0, combi_1.seq)("DECIMALS =", _1.Source);
        const alpha = (0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.seq)("ALPHA =", alphaOptions));
        const xsd = (0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.seq)("XSD =", zeroXSDOptions));
        const formatting = (0, combi_1.altPrio)((0, combi_1.seq)("TIME =", dateTimeOptions), (0, combi_1.seq)("DATE =", dateTimeOptions), (0, combi_1.seq)("CASE =", caseOptions), (0, combi_1.seq)("EXPONENT", _1.Source), (0, combi_1.seq)("ZERO =", zeroXSDOptions), xsd, (0, combi_1.seq)("STYLE =", styleOptions), (0, combi_1.seq)("CURRENCY =", _1.Source), (0, combi_1.seq)("COUNTRY =", _1.Source), (0, combi_1.per)(sign, number, decimals, width, pad, alpha, align), (0, combi_1.per)(timezone, timestamp));
        return formatting;
    }
}
exports.StringTemplateFormatting = StringTemplateFormatting;
//# sourceMappingURL=string_template_formatting.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template_source.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/string_template_source.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StringTemplateSource = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class StringTemplateSource extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)(_1.Source, (0, combi_1.optPrio)(_1.StringTemplateFormatting));
        return ret;
    }
}
exports.StringTemplateSource = StringTemplateSource;
//# sourceMappingURL=string_template_source.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/super_class_name.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/super_class_name.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SuperClassName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SuperClassName extends combi_1.Expression {
    getRunnable() {
        return new _1.ClassName();
    }
}
exports.SuperClassName = SuperClassName;
//# sourceMappingURL=super_class_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/switch_body.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/switch_body.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SwitchBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SwitchBody extends combi_1.Expression {
    getRunnable() {
        const or = (0, combi_1.seq)("OR", _1.Source);
        const swhen = (0, combi_1.seq)("WHEN", _1.Source, (0, combi_1.star)(or), "THEN", (0, combi_1.alt)(_1.Source, _1.Throw));
        return (0, combi_1.seq)((0, combi_1.opt)(_1.Let), _1.Source, (0, combi_1.plus)(swhen), (0, combi_1.opt)((0, combi_1.seq)("ELSE", (0, combi_1.alt)(_1.Source, _1.Throw))));
    }
}
exports.SwitchBody = SwitchBody;
//# sourceMappingURL=switch_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_body.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_body.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TableBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class TableBody extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.BracketLeft), (0, combi_1.tok)(tokens_1.BracketRightW));
        return ret;
    }
}
exports.TableBody = TableBody;
//# sourceMappingURL=table_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_expression.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/table_expression.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TableExpression = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TableExpression extends combi_1.Expression {
    getRunnable() {
        const fields = (0, combi_1.plus)((0, combi_1.seq)((0, combi_1.altPrio)(_1.ComponentChainSimple, _1.Dynamic), "=", _1.Source));
        const key = (0, combi_1.seq)("KEY", _1.SimpleName);
        const index = (0, combi_1.seq)("INDEX", _1.Source);
        const ret = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.BracketLeftW), (0, combi_1.alt)(_1.Source, (0, combi_1.seq)((0, combi_1.optPrio)(key), (0, combi_1.opt)("COMPONENTS"), (0, combi_1.altPrio)(fields, index))), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WBracketRight), (0, combi_1.tok)(tokens_1.WBracketRightW)));
        return (0, combi_1.ver)(version_1.Version.v740sp02, ret);
    }
}
exports.TableExpression = TableExpression;
//# sourceMappingURL=table_expression.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Target = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const attribute_name_1 = __webpack_require__(/*! ./attribute_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/attribute_name.js");
const dereference_1 = __webpack_require__(/*! ./dereference */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dereference.js");
class Target extends combi_1.Expression {
    getRunnable() {
        const attr = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.InstanceArrow), attribute_name_1.AttributeName);
        const comp = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), _1.ComponentName);
        const something = (0, combi_1.starPrio)((0, combi_1.altPrio)(dereference_1.Dereference, attr, comp, _1.TableExpression));
        const cast = (0, combi_1.seq)((0, combi_1.altPrio)(_1.Cast, _1.NewObject), _1.Arrow, _1.FieldAll);
        const clas = (0, combi_1.seq)(_1.ClassName, (0, combi_1.tok)(tokens_1.StaticArrow), attribute_name_1.AttributeName);
        const start = (0, combi_1.altPrio)(cast, clas, _1.TargetField, _1.TargetFieldSymbol);
        const fields = (0, combi_1.seq)((0, combi_1.optPrio)(_1.FieldOffset), (0, combi_1.optPrio)(_1.FieldLength));
        const optional = (0, combi_1.altPrio)(_1.TableBody, fields);
        return (0, combi_1.altPrio)(_1.InlineData, _1.InlineFS, (0, combi_1.seq)(start, something, optional));
    }
}
exports.Target = Target;
//# sourceMappingURL=target.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target_field.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target_field.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TargetField = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TargetField extends combi_1.Expression {
    getRunnable() {
        return new _1.Field();
    }
}
exports.TargetField = TargetField;
//# sourceMappingURL=target_field.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target_field_symbol.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target_field_symbol.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TargetFieldSymbol = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TargetFieldSymbol extends combi_1.Expression {
    getRunnable() {
        return new _1.FieldSymbol();
    }
}
exports.TargetFieldSymbol = TargetFieldSymbol;
//# sourceMappingURL=target_field_symbol.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/test_seam_name.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/test_seam_name.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestSeamName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class TestSeamName extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)((0, combi_1.regex)(/^[\w%\$\*]+$/), (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), (0, combi_1.regex)(/^[\w%\$\*]+$/))));
        return ret;
    }
}
exports.TestSeamName = TestSeamName;
//# sourceMappingURL=test_seam_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextElement = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TextElement extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)("TEXT", (0, combi_1.tok)(tokens_1.Dash), _1.TextElementKey);
    }
}
exports.TextElement = TextElement;
//# sourceMappingURL=text_element.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element_key.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element_key.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextElementKey = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class TextElementKey extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.regex)(/^\w{3}$/);
    }
}
exports.TextElementKey = TextElementKey;
//# sourceMappingURL=text_element_key.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element_string.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/text_element_string.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextElementString = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TextElementString extends combi_1.Expression {
    getRunnable() {
        const text = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeft), _1.TextElementKey, (0, combi_1.tok)(tokens_1.ParenRightW));
        const stri = (0, combi_1.seq)((0, combi_1.regex)(/^('.*')|(`.*`)$/), text);
        return stri;
    }
}
exports.TextElementString = TextElementString;
//# sourceMappingURL=text_element_string.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/throw.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/throw.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Throw = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class Throw extends combi_1.Expression {
    getRunnable() {
        // todo, MESSAGE
        return (0, combi_1.seq)("THROW", (0, combi_1.opt)("RESUMABLE"), _1.ClassName, (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenLeftW), (0, combi_1.tok)(tokens_1.ParenLeft)), (0, combi_1.opt)((0, combi_1.alt)(_1.Source, _1.ParameterListS)), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRightW), (0, combi_1.tok)(tokens_1.ParenRightW)));
    }
}
exports.Throw = Throw;
//# sourceMappingURL=throw.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/transporting_fields.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/transporting_fields.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TransportingFields = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const dynamic_1 = __webpack_require__(/*! ./dynamic */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/dynamic.js");
const field_sub_1 = __webpack_require__(/*! ./field_sub */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_sub.js");
class TransportingFields extends combi_1.Expression {
    getRunnable() {
        const fields = (0, combi_1.plus)((0, combi_1.alt)((0, combi_1.seq)("INTO", (0, combi_1.failStar)()), field_sub_1.FieldSub));
        return (0, combi_1.altPrio)(dynamic_1.Dynamic, fields);
    }
}
exports.TransportingFields = TransportingFields;
//# sourceMappingURL=transporting_fields.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Type = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Type extends combi_1.Expression {
    getRunnable() {
        const typeType = (0, combi_1.seq)(_1.TypeName, (0, combi_1.optPrio)(_1.Default));
        const like = (0, combi_1.altPrio)((0, combi_1.seq)("LINE OF", _1.FieldChain), (0, combi_1.seq)("REF TO", _1.FieldChain), _1.FieldChain);
        const type = (0, combi_1.altPrio)((0, combi_1.seq)("LINE OF", typeType), (0, combi_1.seq)("REF TO", typeType), typeType);
        const ret = (0, combi_1.altPrio)((0, combi_1.seq)("LIKE", like), (0, combi_1.seq)("TYPE", type));
        return ret;
    }
}
exports.Type = Type;
//# sourceMappingURL=type.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_name.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_name.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeName = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
// todo, can this be replaced with one of the FieldChain expressions?
class TypeName extends combi_1.Expression {
    getRunnable() {
        const name = (0, combi_1.regex)(/^[\w~\/%$]+$/);
        const cla = (0, combi_1.seq)(name, (0, combi_1.alt)((0, combi_1.tok)(tokens_1.StaticArrow), (0, combi_1.tok)(tokens_1.InstanceArrow)));
        const field = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.Dash), name);
        return (0, combi_1.seq)((0, combi_1.opt)(cla), name, (0, combi_1.starPrio)(field));
    }
}
exports.TypeName = TypeName;
//# sourceMappingURL=type_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_name_or_infer.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_name_or_infer.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeNameOrInfer = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TypeNameOrInfer extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.altPrio)("#", _1.TypeName);
    }
}
exports.TypeNameOrInfer = TypeNameOrInfer;
//# sourceMappingURL=type_name_or_infer.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_param.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_param.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeParam = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TypeParam extends combi_1.Expression {
    getRunnable() {
        const table = (0, combi_1.seq)((0, combi_1.altPrio)("STANDARD", "HASHED", "INDEX", "SORTED", "ANY"), "TABLE");
        const foo = (0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.seq)(table, "OF")), (0, combi_1.optPrio)("REF TO"));
        const typeLine = "LINE OF";
        const ret = (0, combi_1.seq)((0, combi_1.alt)(foo, typeLine), _1.TypeNameOrInfer, (0, combi_1.opt)(_1.Default));
        const like = (0, combi_1.seq)("LIKE", (0, combi_1.opt)("LINE OF"), _1.FieldChain, (0, combi_1.optPrio)(_1.Default));
        return (0, combi_1.alt)((0, combi_1.seq)("TYPE", (0, combi_1.alt)(table, ret)), like);
    }
}
exports.TypeParam = TypeParam;
//# sourceMappingURL=type_param.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_structure.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_structure.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeStructure = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TypeStructure extends combi_1.Expression {
    getRunnable() {
        // todo, add version,
        const hier = (0, combi_1.seq)("HIERARCHY", _1.NamespaceSimpleName);
        const evt = (0, combi_1.seq)("EVENT", _1.EventName);
        return (0, combi_1.seq)("TYPE STRUCTURE FOR", (0, combi_1.altPrio)(hier, evt));
    }
}
exports.TypeStructure = TypeStructure;
//# sourceMappingURL=type_structure.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_table.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_table.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeTable = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const field_chain_1 = __webpack_require__(/*! ./field_chain */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/field_chain.js");
const type_table_key_1 = __webpack_require__(/*! ./type_table_key */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_table_key.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeTable extends combi_1.Expression {
    getRunnable() {
        const header = "WITH HEADER LINE";
        const initial = (0, combi_1.seq)("INITIAL SIZE", _1.Constant);
        const generic = (0, combi_1.seq)((0, combi_1.opt)((0, combi_1.alt)("STANDARD", "HASHED", "INDEX", "SORTED", "ANY")), "TABLE");
        const normal1 = (0, combi_1.seq)((0, combi_1.opt)((0, combi_1.alt)("STANDARD", "HASHED", "INDEX", "SORTED", "ANY")), "TABLE OF", (0, combi_1.opt)("REF TO"), (0, combi_1.opt)(_1.TypeName));
        const likeType = (0, combi_1.seq)((0, combi_1.opt)((0, combi_1.alt)("STANDARD", "HASHED", "INDEX", "SORTED", "ANY")), "TABLE OF", (0, combi_1.optPrio)("REF TO"), (0, combi_1.opt)(field_chain_1.FieldChain), (0, combi_1.opt)((0, combi_1.per)(header, initial, (0, combi_1.plusPrio)(type_table_key_1.TypeTableKey))));
        const rangeType = (0, combi_1.seq)("RANGE OF", _1.TypeName, (0, combi_1.opt)(header), (0, combi_1.opt)(initial));
        const rangeLike = (0, combi_1.seq)("RANGE OF", _1.SimpleFieldChain, (0, combi_1.opt)(header), (0, combi_1.opt)(initial));
        // a maximum of 15 secondary table keys can be defined
        // "WITH" is not allowed as a field name in keys
        const typetable = (0, combi_1.alt)(generic, (0, combi_1.seq)(normal1, (0, combi_1.alt)((0, combi_1.opt)((0, combi_1.per)(header, initial, (0, combi_1.plusPrio)(type_table_key_1.TypeTableKey))), (0, combi_1.seq)((0, combi_1.plus)(type_table_key_1.TypeTableKey), (0, combi_1.optPrio)(initial)))));
        const occurs = (0, combi_1.seq)("OCCURS", _1.Integer);
        const derived = (0, combi_1.ver)(version_1.Version.v754, (0, combi_1.seq)("TABLE FOR", (0, combi_1.altPrio)("ACTION IMPORT", "ACTION RESULT", "CREATE", "EVENT", "FAILED", "LOCK", "READ RESULT", "UPDATE"), _1.TypeName));
        const oldType = (0, combi_1.seq)((0, combi_1.opt)("REF TO"), _1.TypeName, (0, combi_1.alt)((0, combi_1.seq)(occurs, (0, combi_1.opt)(header)), header));
        const oldLike = (0, combi_1.seq)((0, combi_1.opt)("REF TO"), field_chain_1.FieldChain, (0, combi_1.alt)((0, combi_1.seq)(occurs, (0, combi_1.opt)(header)), header));
        const ret = (0, combi_1.altPrio)((0, combi_1.seq)(occurs, (0, combi_1.opt)(header)), (0, combi_1.seq)("LIKE", (0, combi_1.alt)(oldLike, likeType, rangeLike)), (0, combi_1.seq)("TYPE", (0, combi_1.alt)(oldType, typetable, rangeType, derived)));
        return ret;
    }
}
exports.TypeTable = TypeTable;
//# sourceMappingURL=type_table.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_table_key.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/type_table_key.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeTableKey = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeTableKey extends combi_1.Expression {
    getRunnable() {
        const uniqueness = (0, combi_1.alt)("NON-UNIQUE", "UNIQUE");
        const defaultKey = "DEFAULT KEY";
        const emptyKey = (0, combi_1.ver)(version_1.Version.v740sp02, "EMPTY KEY");
        const components = (0, combi_1.plus)((0, combi_1.alt)((0, combi_1.seq)("WITH", (0, combi_1.failStar)()), _1.FieldSub));
        const further = (0, combi_1.seq)((0, combi_1.alt)("WITHOUT", "WITH"), "FURTHER SECONDARY KEYS");
        const key = (0, combi_1.seq)("WITH", (0, combi_1.opt)(uniqueness), (0, combi_1.altPrio)(defaultKey, emptyKey, (0, combi_1.seq)((0, combi_1.opt)((0, combi_1.alt)("SORTED", "HASHED")), "KEY", (0, combi_1.alt)((0, combi_1.seq)(_1.Field, "COMPONENTS", components), components))), (0, combi_1.optPrio)(further), (0, combi_1.optPrio)("READ-ONLY"));
        return key;
    }
}
exports.TypeTableKey = TypeTableKey;
//# sourceMappingURL=type_table_key.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Value = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Value extends combi_1.Expression {
    getRunnable() {
        const ret = (0, combi_1.seq)("VALUE", (0, combi_1.alt)(_1.Constant, _1.SimpleFieldChain, "IS INITIAL"));
        return ret;
    }
}
exports.Value = Value;
//# sourceMappingURL=value.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValueBody = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ValueBody extends combi_1.Expression {
    getRunnable() {
        const base = (0, combi_1.seq)("BASE", _1.Source);
        const strucOrTab = (0, combi_1.seq)((0, combi_1.optPrio)(_1.Let), (0, combi_1.optPrio)(base), (0, combi_1.star)(_1.For), (0, combi_1.plusPrio)((0, combi_1.altPrio)(_1.FieldAssignment, _1.ValueBodyLine)));
        const tabdef = (0, combi_1.ver)(version_1.Version.v740sp08, (0, combi_1.altPrio)("OPTIONAL", (0, combi_1.seq)("DEFAULT", _1.Source)));
        return (0, combi_1.optPrio)((0, combi_1.altPrio)(strucOrTab, (0, combi_1.seq)(_1.Source, (0, combi_1.optPrio)(tabdef))));
    }
}
exports.ValueBody = ValueBody;
//# sourceMappingURL=value_body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body_line.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body_line.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValueBodyLine = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const value_body_lines_1 = __webpack_require__(/*! ./value_body_lines */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body_lines.js");
class ValueBodyLine extends combi_1.Expression {
    getRunnable() {
        // missing spaces caught by rule "parser_missing_space"
        const ret = (0, combi_1.seq)((0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenLeftW), (0, combi_1.tok)(tokens_1.WParenLeft)), (0, combi_1.optPrio)((0, combi_1.altPrio)((0, combi_1.plusPrio)(_1.FieldAssignment), value_body_lines_1.ValueBodyLines, _1.Source)), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.WParenRightW), (0, combi_1.tok)(tokens_1.ParenRightW)));
        return ret;
    }
}
exports.ValueBodyLine = ValueBodyLine;
//# sourceMappingURL=value_body_line.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body_lines.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/value_body_lines.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValueBodyLines = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _1 = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ValueBodyLines extends combi_1.Expression {
    getRunnable() {
        const range = (0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.seq)("FROM", _1.Source)), (0, combi_1.optPrio)((0, combi_1.seq)("TO", _1.Source)));
        const lines = (0, combi_1.seq)("LINES OF", _1.Source, range);
        return lines;
    }
}
exports.ValueBodyLines = ValueBodyLines;
//# sourceMappingURL=value_body_lines.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/with_name.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/with_name.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WithName = void 0;
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class WithName extends combi_1.Expression {
    getRunnable() {
        return (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WPlus), (0, combi_1.regex)(/^\w+$/));
    }
}
exports.WithName = WithName;
//# sourceMappingURL=with_name.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/write_offset_length.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/write_offset_length.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WriteOffsetLength = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const simple_field_chain2_1 = __webpack_require__(/*! ./simple_field_chain2 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_field_chain2.js");
class WriteOffsetLength extends combi_1.Expression {
    getRunnable() {
        const post = (0, combi_1.seq)((0, combi_1.alt)(simple_field_chain2_1.SimpleFieldChain2, (0, combi_1.regex)(/^[\d]+$/), (0, combi_1.regex)(/^\*$/)), (0, combi_1.alt)((0, combi_1.tok)(tokens_1.ParenRightW), (0, combi_1.tok)(tokens_1.ParenRight)));
        const wlength = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeft), post);
        const length = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeft), post);
        const complex = (0, combi_1.alt)(wlength, (0, combi_1.seq)((0, combi_1.alt)(simple_field_chain2_1.SimpleFieldChain2, (0, combi_1.regex)(/^\/?[\w\d]+$/), "/"), (0, combi_1.opt)(length)));
        const at = (0, combi_1.seq)((0, combi_1.opt)("AT"), complex);
        return at;
    }
}
exports.WriteOffsetLength = WriteOffsetLength;
//# sourceMappingURL=write_offset_length.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/result.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/result.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Result = void 0;
class Result {
    constructor(tokens, tokenIndex, nodes) {
        // tokens: all tokens, from the tokenIndex = not yet matched
        // nodes: matched tokens
        this.tokens = tokens;
        this.tokenIndex = tokenIndex;
        this.nodes = nodes;
        if (this.nodes === undefined) {
            this.nodes = [];
        }
    }
    peek() {
        return this.tokens[this.tokenIndex];
    }
    shift(node) {
        const cp = this.nodes.slice();
        cp.push(node);
        return new Result(this.tokens, this.tokenIndex + 1, cp);
    }
    popNode() {
        return this.nodes.pop();
    }
    getNodes() {
        return this.nodes;
    }
    setNodes(n) {
        this.nodes = n;
    }
    remainingLength() {
        return this.tokens.length - this.tokenIndex;
    }
}
exports.Result = Result;
//# sourceMappingURL=result.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statement_parser.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statement_parser.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StatementParser = exports.STATEMENT_MAX_TOKENS = void 0;
const Statements = __webpack_require__(/*! ./statements */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js");
const Expressions = __webpack_require__(/*! ./expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const Tokens = __webpack_require__(/*! ../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const nodes_1 = __webpack_require__(/*! ../nodes */ "./node_modules/@abaplint/core/build/src/abap/nodes/index.js");
const artifacts_1 = __webpack_require__(/*! ../artifacts */ "./node_modules/@abaplint/core/build/src/abap/artifacts.js");
const combi_1 = __webpack_require__(/*! ./combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const _statement_1 = __webpack_require__(/*! ./statements/_statement */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/_statement.js");
const expand_macros_1 = __webpack_require__(/*! ./expand_macros */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expand_macros.js");
const tokens_1 = __webpack_require__(/*! ../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
exports.STATEMENT_MAX_TOKENS = 1000;
class StatementMap {
    constructor() {
        this.map = {};
        for (const stat of artifacts_1.ArtifactsABAP.getStatements()) {
            const f = stat.getMatcher().first();
            if (f.length === 0) {
                throw new Error("StatementMap, first must have contents");
            }
            for (const first of f) {
                if (this.map[first]) {
                    this.map[first].push({ statement: stat });
                }
                else {
                    this.map[first] = [{ statement: stat }];
                }
            }
        }
    }
    lookup(str) {
        const res = this.map[str.toUpperCase()];
        if (res === undefined) {
            return [];
        }
        if (res[0].matcher === undefined) {
            for (const r of res) {
                r.matcher = r.statement.getMatcher();
            }
        }
        return res;
    }
}
class WorkArea {
    constructor(file, tokens) {
        this.file = file;
        this.tokens = tokens;
        this.statements = [];
    }
    addUnknown(pre, post, colon) {
        const st = new nodes_1.StatementNode(new _statement_1.Unknown(), colon);
        st.setChildren(this.tokensToNodes(pre, post));
        this.statements.push(st);
    }
    toResult() {
        return { file: this.file, tokens: this.tokens, statements: this.statements };
    }
    tokensToNodes(tokens1, tokens2) {
        const ret = [];
        for (const t of tokens1) {
            ret.push(new nodes_1.TokenNode(t));
        }
        for (const t of tokens2) {
            ret.push(new nodes_1.TokenNode(t));
        }
        return ret;
    }
}
class StatementParser {
    constructor(version, reg) {
        if (!StatementParser.map) {
            StatementParser.map = new StatementMap();
        }
        this.version = version;
        this.reg = reg;
    }
    /** input is one full object */
    run(input, globalMacros) {
        const macros = new expand_macros_1.ExpandMacros(globalMacros, this.version, this.reg);
        const wa = input.map(i => new WorkArea(i.file, i.tokens));
        for (const w of wa) {
            this.process(w);
            this.categorize(w);
            macros.find(w.statements);
        }
        for (const w of wa) {
            const res = macros.handleMacros(w.statements);
            w.statements = res.statements;
            if (res.containsUnknown === true) {
                this.lazyUnknown(w);
            }
            this.nativeSQL(w);
        }
        return wa.map(w => w.toResult());
    }
    // todo, refactor, remove method here and only have in WorkArea class
    tokensToNodes(tokens) {
        const ret = [];
        for (const t of tokens) {
            ret.push(new nodes_1.TokenNode(t));
        }
        return ret;
    }
    // tries to split Unknown statements by newlines, when adding/writing a new statement
    // in an editor, adding the statement terminator is typically the last thing to do
    // note: this will not work if the second statement is a macro call, guess this is okay
    lazyUnknown(wa) {
        const result = [];
        for (let statement of wa.statements) {
            // dont use CALL METHOD, when executing lazy, it easily gives a Move for the last statment if lazy logic is evaluated
            if (statement.get() instanceof _statement_1.Unknown) {
                const concat = statement.concatTokens().toUpperCase();
                if (concat.startsWith("CALL METHOD ") === false
                    && concat.startsWith("RAISE EXCEPTION TYPE ") === false
                    && concat.startsWith("READ TABLE ") === false
                    && concat.startsWith("LOOP AT ") === false
                    && concat.startsWith("CALL FUNCTION ") === false) {
                    for (const { first, second } of this.buildSplits(statement.getTokens())) {
                        if (second.length === 1) {
                            continue; // probably punctuation
                        }
                        const s = this.categorizeStatement(new nodes_1.StatementNode(new _statement_1.Unknown()).setChildren(this.tokensToNodes(second)));
                        if (!(s.get() instanceof _statement_1.Unknown)) {
                            result.push(new nodes_1.StatementNode(new _statement_1.Unknown()).setChildren(this.tokensToNodes(first)));
                            statement = s;
                            break;
                        }
                    }
                }
            }
            result.push(statement);
        }
        wa.statements = result;
    }
    buildSplits(tokens) {
        const res = [];
        const before = [];
        let prevRow = tokens[0].getRow();
        for (let i = 0; i < tokens.length; i++) {
            if (tokens[i].getRow() !== prevRow) {
                res.push({ first: [...before], second: [...tokens].splice(i) });
            }
            prevRow = tokens[i].getRow();
            before.push(tokens[i]);
        }
        return res;
    }
    nativeSQL(wa) {
        let sql = false;
        for (let i = 0; i < wa.statements.length; i++) {
            const statement = wa.statements[i];
            const type = statement.get();
            if (type instanceof Statements.ExecSQL
                || (type instanceof Statements.MethodImplementation && statement.findDirectExpression(Expressions.Language))) {
                sql = true;
            }
            else if (sql === true) {
                if (type instanceof Statements.EndExec
                    || type instanceof Statements.EndMethod) {
                    sql = false;
                }
                else if (!(type instanceof _statement_1.Comment)) {
                    wa.statements[i] = new nodes_1.StatementNode(new _statement_1.NativeSQL()).setChildren(this.tokensToNodes(statement.getTokens()));
                }
            }
        }
    }
    // for each statement, run statement matchers to figure out which kind of statement it is
    categorize(wa) {
        const result = [];
        for (const statement of wa.statements) {
            result.push(this.categorizeStatement(statement));
        }
        wa.statements = result;
    }
    categorizeStatement(input) {
        let statement = input;
        const length = input.getChildren().length;
        const lastToken = input.getLastToken();
        const isPunctuation = lastToken instanceof Tokens.Punctuation;
        if (length === 1 && isPunctuation) {
            const tokens = statement.getTokens();
            statement = new nodes_1.StatementNode(new _statement_1.Empty()).setChildren(this.tokensToNodes(tokens));
        }
        else if (statement.get() instanceof _statement_1.Unknown) {
            if (isPunctuation) {
                statement = this.match(statement);
            }
            else if (length > exports.STATEMENT_MAX_TOKENS) {
                // if the statement contains more than STATEMENT_MAX_TOKENS tokens, just give up
                statement = input;
            }
            else if (length === 1 && lastToken instanceof tokens_1.Pragma) {
                statement = new nodes_1.StatementNode(new _statement_1.Empty(), undefined, [lastToken]);
            }
        }
        return statement;
    }
    removePragma(tokens) {
        const result = [];
        const pragmas = [];
        // skip the last token as it is the punctuation
        for (let i = 0; i < tokens.length - 1; i++) {
            const t = tokens[i];
            if (t instanceof Tokens.Pragma) {
                pragmas.push(t);
            }
            else {
                result.push(t);
            }
        }
        return { tokens: result, pragmas: pragmas };
    }
    match(statement) {
        const tokens = statement.getTokens();
        const { tokens: filtered, pragmas } = this.removePragma(tokens);
        if (filtered.length === 0) {
            return new nodes_1.StatementNode(new _statement_1.Empty()).setChildren(this.tokensToNodes(tokens));
        }
        for (const st of StatementParser.map.lookup(filtered[0].getStr())) {
            const match = combi_1.Combi.run(st.matcher, filtered, this.version);
            if (match) {
                const last = tokens[tokens.length - 1];
                match.push(new nodes_1.TokenNode(last));
                return new nodes_1.StatementNode(st.statement, statement.getColon(), pragmas).setChildren(match);
            }
        }
        // next try the statements without specific keywords
        for (const st of StatementParser.map.lookup("")) {
            const match = combi_1.Combi.run(st.matcher, filtered, this.version);
            if (match) {
                const last = tokens[tokens.length - 1];
                match.push(new nodes_1.TokenNode(last));
                return new nodes_1.StatementNode(st.statement, statement.getColon(), pragmas).setChildren(match);
            }
        }
        return statement;
    }
    // takes care of splitting tokens into statements, also handles chained statements
    // statements are split by "," or "."
    // additional colons/chaining after the first colon are ignored
    process(wa) {
        let add = [];
        let pre = [];
        let colon = undefined;
        for (const token of wa.tokens) {
            if (token instanceof Tokens.Comment) {
                wa.statements.push(new nodes_1.StatementNode(new _statement_1.Comment()).setChildren(this.tokensToNodes([token])));
                continue;
            }
            add.push(token);
            const str = token.getStr();
            if (str.length === 1) {
                if (str === ".") {
                    wa.addUnknown(pre, add, colon);
                    add = [];
                    pre = [];
                    colon = undefined;
                }
                else if (str === "," && pre.length > 0) {
                    wa.addUnknown(pre, add, colon);
                    add = [];
                }
                else if (str === ":" && colon === undefined) {
                    colon = token;
                    add.pop(); // do not add colon token to statement
                    pre.push(...add);
                    add = [];
                }
                else if (str === ":") {
                    add.pop(); // do not add colon token to statement
                }
            }
        }
        if (add.length > 0) {
            wa.addUnknown(pre, add, colon);
        }
    }
}
exports.StatementParser = StatementParser;
//# sourceMappingURL=statement_parser.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/_statement.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/_statement.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NativeSQL = exports.MacroContent = exports.MacroCall = exports.Empty = exports.Comment = exports.Unknown = void 0;
class Unknown {
    getMatcher() {
        throw new Error("Unknown Statement, get_matcher");
    }
}
exports.Unknown = Unknown;
class Comment {
    getMatcher() {
        throw new Error("Comment Statement, get_matcher");
    }
}
exports.Comment = Comment;
class Empty {
    getMatcher() {
        throw new Error("Empty Statement, get_matcher");
    }
}
exports.Empty = Empty;
class MacroCall {
    getMatcher() {
        throw new Error("MacroCall Statement, get_matcher");
    }
}
exports.MacroCall = MacroCall;
class MacroContent {
    getMatcher() {
        throw new Error("MacroContent Statement, get_matcher");
    }
}
exports.MacroContent = MacroContent;
class NativeSQL {
    getMatcher() {
        throw new Error("NativeSQL Statement, get_matcher");
    }
}
exports.NativeSQL = NativeSQL;
//# sourceMappingURL=_statement.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/add.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/add.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Add = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Add {
    getMatcher() {
        const to = (0, combi_1.seq)("TO", expressions_1.Target);
        const then = (0, combi_1.seq)("THEN", expressions_1.FieldSub, "UNTIL", expressions_1.FieldSub, "GIVING", expressions_1.FieldSub);
        const ret = (0, combi_1.seq)("ADD", expressions_1.Source, (0, combi_1.altPrio)(to, then));
        return ret;
    }
}
exports.Add = Add;
//# sourceMappingURL=add.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/add_corresponding.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/add_corresponding.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AddCorresponding = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class AddCorresponding {
    getMatcher() {
        const ret = (0, combi_1.seq)("ADD-CORRESPONDING", expressions_1.Source, "TO", expressions_1.Target);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.AddCorresponding = AddCorresponding;
//# sourceMappingURL=add_corresponding.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/aliases.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/aliases.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Aliases = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Aliases {
    getMatcher() {
        return (0, combi_1.seq)("ALIASES", expressions_1.SimpleName, "FOR", expressions_1.Field);
    }
}
exports.Aliases = Aliases;
//# sourceMappingURL=aliases.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/append.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/append.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Append = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Append {
    getMatcher() {
        const assigning = (0, combi_1.seq)("ASSIGNING", expressions_1.FSTarget);
        const reference = (0, combi_1.seq)("REFERENCE INTO", expressions_1.Target);
        const sorted = (0, combi_1.seq)("SORTED BY", expressions_1.Field);
        const fromIndex = (0, combi_1.seq)("FROM", expressions_1.Source);
        const toIndex = (0, combi_1.seq)("TO", expressions_1.Source);
        const toTarget = (0, combi_1.seq)("TO", expressions_1.Target);
        const src = (0, combi_1.alt)(expressions_1.SimpleSource4, (0, combi_1.ver)(version_1.Version.v740sp02, expressions_1.Source));
        return (0, combi_1.seq)("APPEND", (0, combi_1.altPrio)("INITIAL LINE", (0, combi_1.seq)((0, combi_1.optPrio)("LINES OF"), src)), (0, combi_1.optPrio)(fromIndex), (0, combi_1.opt)((0, combi_1.alt)((0, combi_1.seq)(toIndex, toTarget), toTarget)), (0, combi_1.opt)((0, combi_1.altPrio)(assigning, reference)), (0, combi_1.optPrio)("CASTING"), (0, combi_1.optPrio)(sorted));
    }
}
exports.Append = Append;
//# sourceMappingURL=append.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assert.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assert.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Assert = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Assert {
    getMatcher() {
        const fields = (0, combi_1.seq)("FIELDS", (0, combi_1.plus)(expressions_1.Source));
        const subkey = (0, combi_1.seq)("SUBKEY", expressions_1.Source);
        const id = (0, combi_1.seq)("ID", expressions_1.NamespaceSimpleName);
        return (0, combi_1.seq)("ASSERT", (0, combi_1.optPrio)(id), (0, combi_1.optPrio)(subkey), (0, combi_1.opt)(fields), (0, combi_1.optPrio)("CONDITION"), expressions_1.Cond);
    }
}
exports.Assert = Assert;
//# sourceMappingURL=assert.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assign.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assign.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Assign = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Assign {
    getMatcher() {
        const type = (0, combi_1.seq)("TYPE", (0, combi_1.altPrio)(expressions_1.Dynamic, expressions_1.TypeName));
        const like = (0, combi_1.seq)("LIKE", (0, combi_1.altPrio)(expressions_1.Dynamic, expressions_1.Source));
        const handle = (0, combi_1.seq)("TYPE HANDLE", expressions_1.Source);
        const range = (0, combi_1.seq)("RANGE", expressions_1.Source);
        const decimals = (0, combi_1.seq)("DECIMALS", expressions_1.Source);
        const casting = (0, combi_1.seq)("CASTING", (0, combi_1.opt)((0, combi_1.alt)(like, handle, (0, combi_1.per)(type, decimals))));
        const obsoleteType = (0, combi_1.seq)("TYPE", expressions_1.Source, (0, combi_1.optPrio)(decimals));
        const ret = (0, combi_1.seq)("ASSIGN", (0, combi_1.opt)((0, combi_1.seq)(expressions_1.Target, "INCREMENT")), expressions_1.AssignSource, "TO", expressions_1.FSTarget, (0, combi_1.opt)((0, combi_1.altPrio)(casting, obsoleteType)), (0, combi_1.opt)(range), (0, combi_1.opt)((0, combi_1.ver)(version_1.Version.v757, "ELSE UNASSIGN")));
        return ret;
    }
}
exports.Assign = Assign;
//# sourceMappingURL=assign.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assign_local_copy.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assign_local_copy.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AssignLocalCopy = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class AssignLocalCopy {
    getMatcher() {
        const ret = (0, combi_1.seq)("ASSIGN LOCAL COPY OF", (0, combi_1.opt)((0, combi_1.seq)("INITIAL", (0, combi_1.opt)("LINE OF"))), (0, combi_1.alt)(expressions_1.Source, expressions_1.Dynamic), "TO", expressions_1.TargetFieldSymbol);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.AssignLocalCopy = AssignLocalCopy;
//# sourceMappingURL=assign_local_copy.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.At = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class At {
    getMatcher() {
        const field = (0, combi_1.alt)((0, combi_1.seq)(expressions_1.FieldSub, (0, combi_1.opt)(expressions_1.FieldOffset), (0, combi_1.opt)(expressions_1.FieldLength)), expressions_1.Dynamic, expressions_1.SourceFieldSymbol);
        const atNew = (0, combi_1.seq)("NEW", field);
        const atEnd = (0, combi_1.seq)("END OF", field);
        const group = (0, combi_1.regex)(/^\w+$/);
        const ret = (0, combi_1.seq)("AT", (0, combi_1.altPrio)(atNew, atEnd, group));
        return ret;
    }
}
exports.At = At;
//# sourceMappingURL=at.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_first.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_first.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AtFirst = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class AtFirst {
    getMatcher() {
        return (0, combi_1.str)("AT FIRST");
    }
}
exports.AtFirst = AtFirst;
//# sourceMappingURL=at_first.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_last.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_last.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AtLast = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class AtLast {
    getMatcher() {
        return (0, combi_1.str)("AT LAST");
    }
}
exports.AtLast = AtLast;
//# sourceMappingURL=at_last.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_line_selection.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_line_selection.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AtLineSelection = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class AtLineSelection {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "AT LINE-SELECTION");
    }
}
exports.AtLineSelection = AtLineSelection;
//# sourceMappingURL=at_line_selection.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_selection_screen.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_selection_screen.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AtSelectionScreen = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class AtSelectionScreen {
    getMatcher() {
        const output = "OUTPUT";
        const value = (0, combi_1.seq)("ON VALUE-REQUEST FOR", expressions_1.FieldSub);
        const exit = "ON EXIT-COMMAND";
        const field = (0, combi_1.seq)("ON", expressions_1.FieldSub);
        const end = (0, combi_1.seq)("ON END OF", expressions_1.Field);
        const radio = (0, combi_1.seq)("ON RADIOBUTTON GROUP", expressions_1.Field);
        const block = (0, combi_1.seq)("ON BLOCK", (0, combi_1.regex)(/^\w+$/));
        const help = (0, combi_1.seq)("ON HELP-REQUEST FOR", expressions_1.FieldSub);
        const ret = (0, combi_1.seq)("AT SELECTION-SCREEN", (0, combi_1.opt)((0, combi_1.alt)(output, value, radio, exit, field, end, help, block)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.AtSelectionScreen = AtSelectionScreen;
//# sourceMappingURL=at_selection_screen.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_user_command.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_user_command.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AtUserCommand = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class AtUserCommand {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "AT USER-COMMAND");
    }
}
exports.AtUserCommand = AtUserCommand;
//# sourceMappingURL=at_user_command.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/authority_check.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/authority_check.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AuthorityCheck = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class AuthorityCheck {
    getMatcher() {
        const field = (0, combi_1.seq)("FIELD", expressions_1.Source);
        const id = (0, combi_1.seq)("ID", expressions_1.Source, (0, combi_1.alt)(field, "DUMMY"));
        const ret = (0, combi_1.seq)("AUTHORITY-CHECK OBJECT", expressions_1.Source, (0, combi_1.opt)((0, combi_1.seq)("FOR USER", expressions_1.Source)), (0, combi_1.plus)(id));
        return ret;
    }
}
exports.AuthorityCheck = AuthorityCheck;
//# sourceMappingURL=authority_check.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/back.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/back.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Back = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Back {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "BACK");
    }
}
exports.Back = Back;
//# sourceMappingURL=back.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/break.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/break.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Break = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Break {
    getMatcher() {
        const next = (0, combi_1.str)("AT NEXT APPLICATION STATEMENT");
        const ret = (0, combi_1.altPrio)((0, combi_1.seq)("BREAK-POINT", (0, combi_1.optPrio)((0, combi_1.altPrio)(next, expressions_1.Source))), (0, combi_1.seq)("BREAK", expressions_1.FieldSub));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Break = Break;
//# sourceMappingURL=break.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/break_id.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/break_id.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BreakId = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class BreakId {
    getMatcher() {
        const id = (0, combi_1.seq)("ID", expressions_1.Field);
        const ret = (0, combi_1.seq)("BREAK-POINT", id);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.BreakId = BreakId;
//# sourceMappingURL=break_id.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Call = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
// method call
class Call {
    getMatcher() {
        const call = (0, combi_1.seq)("CALL METHOD", expressions_1.MethodSource, expressions_1.MethodCallBody);
        return (0, combi_1.altPrio)(call, expressions_1.MethodCallChain);
    }
}
exports.Call = Call;
//# sourceMappingURL=call.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_badi.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_badi.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallBadi = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallBadi {
    getMatcher() {
        const call = (0, combi_1.seq)("CALL", "BADI", expressions_1.MethodSource, expressions_1.MethodCallBody);
        return (0, combi_1.verNot)(version_1.Version.Cloud, call);
    }
}
exports.CallBadi = CallBadi;
//# sourceMappingURL=call_badi.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_database.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_database.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallDatabase = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallDatabase {
    getMatcher() {
        const exporting = (0, combi_1.seq)("EXPORTING", expressions_1.ParameterListS);
        const importing = (0, combi_1.seq)("IMPORTING", expressions_1.ParameterListT);
        const expl = (0, combi_1.seq)((0, combi_1.opt)(exporting), (0, combi_1.opt)(importing));
        const tab = (0, combi_1.seq)("PARAMETER-TABLE", expressions_1.Source);
        const ret = (0, combi_1.seq)("CALL DATABASE PROCEDURE", expressions_1.Dynamic, (0, combi_1.opt)(expressions_1.DatabaseConnection), (0, combi_1.alt)(expl, tab));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CallDatabase = CallDatabase;
//# sourceMappingURL=call_database.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_dialog.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_dialog.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallDialog = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallDialog {
    getMatcher() {
        const from = (0, combi_1.seq)(expressions_1.FieldSub, (0, combi_1.optPrio)((0, combi_1.seq)("FROM", expressions_1.Source)));
        const exporting = (0, combi_1.seq)("EXPORTING", (0, combi_1.plus)(from));
        const to = (0, combi_1.seq)(expressions_1.Field, (0, combi_1.optPrio)((0, combi_1.seq)("TO", expressions_1.Field)));
        const importing = (0, combi_1.seq)("IMPORTING", (0, combi_1.plus)(to));
        const ret = (0, combi_1.seq)("CALL DIALOG", expressions_1.Constant, (0, combi_1.opt)(exporting), (0, combi_1.opt)(importing));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CallDialog = CallDialog;
//# sourceMappingURL=call_dialog.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_function.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_function.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallFunction = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallFunction {
    getMatcher() {
        const starting = (0, combi_1.verNot)(version_1.Version.Cloud, (0, combi_1.seq)("STARTING NEW TASK", expressions_1.SimpleSource2));
        const update = (0, combi_1.verNot)(version_1.Version.Cloud, (0, combi_1.str)("IN UPDATE TASK"));
        const unit = (0, combi_1.seq)("UNIT", expressions_1.Source);
        const background = (0, combi_1.verNot)(version_1.Version.Cloud, (0, combi_1.seq)("IN BACKGROUND", (0, combi_1.altPrio)("TASK", unit)));
        const calling = (0, combi_1.seq)("CALLING", expressions_1.MethodSource, "ON END OF TASK");
        const performing = (0, combi_1.seq)("PERFORMING", expressions_1.FormName, "ON END OF TASK");
        const separate = (0, combi_1.str)("AS SEPARATE UNIT");
        const keeping = (0, combi_1.str)("KEEPING LOGICAL UNIT OF WORK");
        const options = (0, combi_1.per)(starting, update, background, expressions_1.Destination, calling, performing, separate, keeping);
        const dynamic = (0, combi_1.seq)("PARAMETER-TABLE", expressions_1.Source, (0, combi_1.opt)((0, combi_1.seq)("EXCEPTION-TABLE", expressions_1.Source)));
        const call = (0, combi_1.seq)("CALL", (0, combi_1.altPrio)("FUNCTION", (0, combi_1.verNot)(version_1.Version.Cloud, "CUSTOMER-FUNCTION")), expressions_1.FunctionName, (0, combi_1.opt)(options), (0, combi_1.alt)(expressions_1.FunctionParameters, dynamic));
        return call;
    }
}
exports.CallFunction = CallFunction;
//# sourceMappingURL=call_function.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_kernel.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_kernel.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallKernel = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallKernel {
    getMatcher() {
        const ret = (0, combi_1.seq)("CALL", (0, combi_1.altPrio)(expressions_1.Constant, expressions_1.Field), (0, combi_1.starPrio)(expressions_1.KernelId));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CallKernel = CallKernel;
//# sourceMappingURL=call_kernel.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_ole.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_ole.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallOLE = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallOLE {
    getMatcher() {
        const rc = (0, combi_1.seq)("=", expressions_1.Target);
        const ret = (0, combi_1.seq)("CALL METHOD OF", expressions_1.Source, expressions_1.Source, (0, combi_1.opt)(rc), (0, combi_1.opt)("NO FLUSH"), (0, combi_1.opt)("QUEUEONLY"), (0, combi_1.opt)(expressions_1.OLEExporting));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CallOLE = CallOLE;
//# sourceMappingURL=call_ole.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_screen.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_screen.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallScreen = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallScreen {
    getMatcher() {
        const starting = (0, combi_1.seq)("STARTING AT", expressions_1.Source, expressions_1.Source);
        const ending = (0, combi_1.seq)("ENDING AT", expressions_1.Source, expressions_1.Source);
        const ret = (0, combi_1.seq)("CALL SCREEN", expressions_1.Source, (0, combi_1.optPrio)((0, combi_1.seq)(starting, (0, combi_1.optPrio)(ending))));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CallScreen = CallScreen;
//# sourceMappingURL=call_screen.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_selection_screen.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_selection_screen.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallSelectionScreen = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallSelectionScreen {
    getMatcher() {
        const ending = (0, combi_1.seq)("ENDING AT", expressions_1.Source, expressions_1.Source);
        const starting = (0, combi_1.seq)("STARTING AT", expressions_1.Source, expressions_1.Source);
        const using = (0, combi_1.seq)("USING SELECTION-SET", expressions_1.Source);
        const at = (0, combi_1.seq)(starting, (0, combi_1.opt)(ending));
        const ret = (0, combi_1.seq)("CALL SELECTION-SCREEN", expressions_1.Source, (0, combi_1.opt)(at), (0, combi_1.opt)(using));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CallSelectionScreen = CallSelectionScreen;
//# sourceMappingURL=call_selection_screen.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_transaction.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_transaction.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallTransaction = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CallTransaction {
    getMatcher() {
        const options = (0, combi_1.seq)("OPTIONS FROM", expressions_1.Source);
        const messages = (0, combi_1.seq)("MESSAGES INTO", expressions_1.Target);
        const auth = (0, combi_1.seq)((0, combi_1.altPrio)("WITH", "WITHOUT"), "AUTHORITY-CHECK");
        const perm = (0, combi_1.per)((0, combi_1.seq)("UPDATE", expressions_1.Source), "AND SKIP FIRST SCREEN", options, messages, (0, combi_1.seq)("MODE", expressions_1.Source));
        const ret = (0, combi_1.seq)("CALL TRANSACTION", expressions_1.Source, (0, combi_1.optPrio)(auth), (0, combi_1.optPrio)((0, combi_1.seq)("USING", expressions_1.Source)), (0, combi_1.opt)(perm));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CallTransaction = CallTransaction;
//# sourceMappingURL=call_transaction.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_transformation.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_transformation.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CallTransformation = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class CallTransformation {
    getMatcher() {
        const options = (0, combi_1.seq)("OPTIONS", expressions_1.CallTransformationOptions);
        const parameters = (0, combi_1.seq)("PARAMETERS", expressions_1.CallTransformationParameters);
        const objects = (0, combi_1.seq)("OBJECTS", expressions_1.CallTransformationParameters);
        const source2 = (0, combi_1.seq)("XML", expressions_1.SimpleSource3);
        const source = (0, combi_1.seq)("SOURCE", (0, combi_1.alt)(expressions_1.CallTransformationParameters, source2));
        const result2 = (0, combi_1.seq)("XML", expressions_1.Target);
        const result = (0, combi_1.seq)("RESULT", (0, combi_1.alt)(expressions_1.CallTransformationParameters, result2));
        const call = (0, combi_1.seq)("CALL TRANSFORMATION", (0, combi_1.alt)(expressions_1.NamespaceSimpleName, expressions_1.Dynamic), (0, combi_1.per)(options, parameters, objects, source, result));
        return call;
    }
}
exports.CallTransformation = CallTransformation;
//# sourceMappingURL=call_transformation.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/case.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/case.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Case = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Case {
    getMatcher() {
        return (0, combi_1.seq)("CASE", expressions_1.Source);
    }
}
exports.Case = Case;
//# sourceMappingURL=case.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/case_type.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/case_type.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CaseType = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class CaseType {
    getMatcher() {
        return (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("CASE TYPE OF", expressions_1.Source), version_1.Version.OpenABAP);
    }
}
exports.CaseType = CaseType;
//# sourceMappingURL=case_type.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/catch.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/catch.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Catch = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Catch {
    getMatcher() {
        return (0, combi_1.seq)("CATCH", (0, combi_1.optPrio)("BEFORE UNWIND"), (0, combi_1.plus)(expressions_1.ClassName), (0, combi_1.opt)((0, combi_1.seq)("INTO", expressions_1.Target)));
    }
}
exports.Catch = Catch;
//# sourceMappingURL=catch.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/catch_system_exceptions.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/catch_system_exceptions.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CatchSystemExceptions = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CatchSystemExceptions {
    getMatcher() {
        const ret = (0, combi_1.seq)("CATCH SYSTEM-EXCEPTIONS", (0, combi_1.plus)((0, combi_1.seq)(expressions_1.Field, "=", expressions_1.Source)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CatchSystemExceptions = CatchSystemExceptions;
//# sourceMappingURL=catch_system_exceptions.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/check.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/check.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Check = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Check {
    getMatcher() {
        const ret = (0, combi_1.seq)("CHECK", (0, combi_1.altPrio)(expressions_1.Cond, expressions_1.Field));
        return ret;
    }
}
exports.Check = Check;
//# sourceMappingURL=check.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/check_select_options.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/check_select_options.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CheckSelectOptions = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CheckSelectOptions {
    getMatcher() {
        const ret = "CHECK SELECT-OPTIONS";
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CheckSelectOptions = CheckSelectOptions;
//# sourceMappingURL=check_select_options.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassData = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ClassData {
    getMatcher() {
        return (0, combi_1.seq)("CLASS-DATA", expressions_1.DataDefinition);
    }
}
exports.ClassData = ClassData;
//# sourceMappingURL=class_data.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data_begin.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data_begin.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassDataBegin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ClassDataBegin {
    getMatcher() {
        const occurs = (0, combi_1.seq)("OCCURS", expressions_1.Integer);
        const structure = (0, combi_1.seq)("BEGIN OF", (0, combi_1.optPrio)("COMMON PART"), expressions_1.NamespaceSimpleName, (0, combi_1.optPrio)("READ-ONLY"), (0, combi_1.optPrio)(occurs));
        return (0, combi_1.seq)("CLASS-DATA", structure);
    }
}
exports.ClassDataBegin = ClassDataBegin;
//# sourceMappingURL=class_data_begin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data_end.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data_end.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassDataEnd = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ClassDataEnd {
    getMatcher() {
        const common = (0, combi_1.seq)("COMMON PART", (0, combi_1.optPrio)(expressions_1.NamespaceSimpleName));
        const structure = (0, combi_1.seq)("END OF", (0, combi_1.altPrio)(common, expressions_1.NamespaceSimpleName));
        return (0, combi_1.seq)("CLASS-DATA", structure);
    }
}
exports.ClassDataEnd = ClassDataEnd;
//# sourceMappingURL=class_data_end.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_deferred.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_deferred.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassDeferred = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ClassDeferred {
    getMatcher() {
        return (0, combi_1.seq)("CLASS", expressions_1.ClassName, "DEFINITION DEFERRED", (0, combi_1.optPrio)("PUBLIC"));
    }
}
exports.ClassDeferred = ClassDeferred;
//# sourceMappingURL=class_deferred.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_definition.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_definition.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassDefinition = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ClassDefinition {
    getMatcher() {
        const create = (0, combi_1.seq)("CREATE", (0, combi_1.altPrio)("PUBLIC", "PROTECTED", "PRIVATE"));
        const level = (0, combi_1.altPrio)("CRITICAL", "HARMLESS", "DANGEROUS");
        const risk = (0, combi_1.seq)("RISK LEVEL", level);
        const time = (0, combi_1.altPrio)("LONG", "MEDIUM", "SHORT");
        const duration = (0, combi_1.seq)("DURATION", time);
        const blah = (0, combi_1.per)(expressions_1.ClassGlobal, expressions_1.ClassFinal, "ABSTRACT", (0, combi_1.seq)("INHERITING FROM", expressions_1.SuperClassName), create, "FOR TESTING", risk, "SHARED MEMORY ENABLED", duration, (0, combi_1.ver)(version_1.Version.v754, (0, combi_1.seq)("FOR BEHAVIOR OF", expressions_1.BehaviorDefinitionName)), expressions_1.ClassFriends);
        const def = (0, combi_1.seq)("DEFINITION", (0, combi_1.optPrio)(blah));
        return (0, combi_1.seq)("CLASS", expressions_1.ClassName, def);
    }
}
exports.ClassDefinition = ClassDefinition;
//# sourceMappingURL=class_definition.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_definition_load.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_definition_load.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassDefinitionLoad = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ClassDefinitionLoad {
    getMatcher() {
        return (0, combi_1.seq)("CLASS", expressions_1.ClassName, "DEFINITION LOAD");
    }
}
exports.ClassDefinitionLoad = ClassDefinitionLoad;
//# sourceMappingURL=class_definition_load.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_implementation.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_implementation.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassImplementation = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ClassImplementation {
    getMatcher() {
        return (0, combi_1.seq)("CLASS", expressions_1.ClassName, "IMPLEMENTATION");
    }
}
exports.ClassImplementation = ClassImplementation;
//# sourceMappingURL=class_implementation.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_local_friends.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_local_friends.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClassLocalFriends = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ClassLocalFriends {
    getMatcher() {
        return (0, combi_1.seq)("CLASS", expressions_1.ClassName, "DEFINITION LOCAL FRIENDS", (0, combi_1.plusPrio)(expressions_1.ClassName));
    }
}
exports.ClassLocalFriends = ClassLocalFriends;
//# sourceMappingURL=class_local_friends.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/cleanup.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/cleanup.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Cleanup = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Cleanup {
    getMatcher() {
        const into = (0, combi_1.seq)("INTO", expressions_1.Target);
        return (0, combi_1.seq)("CLEANUP", (0, combi_1.opt)(into));
    }
}
exports.Cleanup = Cleanup;
//# sourceMappingURL=cleanup.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/clear.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/clear.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Clear = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Clear {
    getMatcher() {
        const wit = (0, combi_1.seq)("WITH", expressions_1.Source);
        const mode = (0, combi_1.altPrio)("IN CHARACTER MODE", "IN BYTE MODE");
        return (0, combi_1.seq)("CLEAR", expressions_1.Target, (0, combi_1.optPrio)(wit), (0, combi_1.optPrio)(mode));
    }
}
exports.Clear = Clear;
//# sourceMappingURL=clear.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/close_cursor.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/close_cursor.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CloseCursor = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CloseCursor {
    getMatcher() {
        const ret = (0, combi_1.seq)("CLOSE CURSOR", expressions_1.SQLSourceSimple);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CloseCursor = CloseCursor;
//# sourceMappingURL=close_cursor.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/close_dataset.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/close_dataset.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CloseDataset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CloseDataset {
    getMatcher() {
        const ret = (0, combi_1.seq)("CLOSE DATASET", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CloseDataset = CloseDataset;
//# sourceMappingURL=close_dataset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/collect.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/collect.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Collect = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Collect {
    getMatcher() {
        const into = (0, combi_1.seq)("INTO", expressions_1.Target);
        const assigning = (0, combi_1.seq)("ASSIGNING", expressions_1.FSTarget);
        return (0, combi_1.seq)("COLLECT", expressions_1.Source, (0, combi_1.opt)(into), (0, combi_1.opt)(assigning));
    }
}
exports.Collect = Collect;
//# sourceMappingURL=collect.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/commit.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/commit.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Commit = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Commit {
    getMatcher() {
        const work = (0, combi_1.seq)("WORK", (0, combi_1.opt)("AND WAIT"));
        return (0, combi_1.seq)("COMMIT", (0, combi_1.alt)(work, expressions_1.DatabaseConnection));
    }
}
exports.Commit = Commit;
//# sourceMappingURL=commit.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/commit_entities.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/commit_entities.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommitEntities = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CommitEntities {
    getMatcher() {
        const s = (0, combi_1.seq)("COMMIT ENTITIES", (0, combi_1.optPrio)("IN SIMULATION MODE"), (0, combi_1.star)((0, combi_1.seq)("RESPONSE OF", expressions_1.NamespaceSimpleName, "FAILED", expressions_1.Target, "REPORTED", expressions_1.Target)));
        return (0, combi_1.ver)(version_1.Version.v754, s);
    }
}
exports.CommitEntities = CommitEntities;
//# sourceMappingURL=commit_entities.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/communication.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/communication.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Communication = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Communication {
    getMatcher() {
        const length = (0, combi_1.seq)("LENGTH", expressions_1.Target);
        const init = (0, combi_1.seq)("INIT ID", expressions_1.Source, "DESTINATION", expressions_1.Target);
        const allocate = (0, combi_1.seq)("ALLOCATE ID", expressions_1.Source);
        const send = (0, combi_1.seq)("SEND ID", expressions_1.Source, "BUFFER", expressions_1.Target, (0, combi_1.opt)(length));
        const deallocate = (0, combi_1.seq)("DEALLOCATE ID", expressions_1.Source);
        const accept = (0, combi_1.seq)("ACCEPT ID", expressions_1.Source);
        const receive = (0, combi_1.seq)("RECEIVE ID", expressions_1.Source, "BUFFER", expressions_1.Source, (0, combi_1.opt)(length), "DATAINFO", expressions_1.Target, "STATUSINFO", expressions_1.Target, "RECEIVED", expressions_1.Target);
        const ret = (0, combi_1.seq)("COMMUNICATION", (0, combi_1.alt)(init, allocate, send, deallocate, receive, accept));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Communication = Communication;
//# sourceMappingURL=communication.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/compute.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/compute.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Compute = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Compute {
    getMatcher() {
        const ret = (0, combi_1.seq)("COMPUTE", (0, combi_1.opt)("EXACT"), expressions_1.Target, "=", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Compute = Compute;
//# sourceMappingURL=compute.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/concatenate.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/concatenate.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Concatenate = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Concatenate {
    getMatcher() {
        const mode = (0, combi_1.seq)("IN", (0, combi_1.altPrio)("BYTE", "CHARACTER"), "MODE");
        const blanks = (0, combi_1.str)("RESPECTING BLANKS");
        const sep = (0, combi_1.seq)("SEPARATED BY", expressions_1.Source);
        const options = (0, combi_1.per)(mode, blanks, sep);
        const sourc = (0, combi_1.seq)(expressions_1.Source, (0, combi_1.plus)(expressions_1.Source));
        const lines = (0, combi_1.seq)("LINES OF", expressions_1.Source);
        return (0, combi_1.seq)("CONCATENATE", (0, combi_1.altPrio)(lines, sourc), "INTO", expressions_1.Target, (0, combi_1.optPrio)(options));
    }
}
exports.Concatenate = Concatenate;
//# sourceMappingURL=concatenate.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/condense.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/condense.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Condense = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Condense {
    getMatcher() {
        return (0, combi_1.seq)("CONDENSE", expressions_1.Target, (0, combi_1.opt)("NO-GAPS"));
    }
}
exports.Condense = Condense;
//# sourceMappingURL=condense.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Constant = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Constant {
    getMatcher() {
        const def = (0, combi_1.seq)(expressions_1.DefinitionName, (0, combi_1.opt)(expressions_1.ConstantFieldLength), (0, combi_1.per)(expressions_1.Type, expressions_1.Value, expressions_1.Decimals, expressions_1.Length));
        const ret = (0, combi_1.seq)((0, combi_1.alt)("CONSTANT", "CONSTANTS"), def, (0, combi_1.optPrio)("%_PREDEFINED"));
        return ret;
    }
}
exports.Constant = Constant;
//# sourceMappingURL=constant.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant_begin.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant_begin.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConstantBegin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ConstantBegin {
    getMatcher() {
        const ret = (0, combi_1.seq)("CONSTANTS BEGIN OF", expressions_1.DefinitionName, (0, combi_1.optPrio)("%_PREDEFINED"));
        return ret;
    }
}
exports.ConstantBegin = ConstantBegin;
//# sourceMappingURL=constant_begin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant_end.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant_end.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConstantEnd = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ConstantEnd {
    getMatcher() {
        const ret = (0, combi_1.seq)("CONSTANTS", "END", "OF", expressions_1.DefinitionName);
        return ret;
    }
}
exports.ConstantEnd = ConstantEnd;
//# sourceMappingURL=constant_end.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/contexts.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/contexts.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Contexts = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Contexts {
    getMatcher() {
        const ret = (0, combi_1.seq)("CONTEXTS", expressions_1.Field);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Contexts = Contexts;
//# sourceMappingURL=contexts.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/continue.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/continue.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Continue = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Continue {
    getMatcher() {
        return (0, combi_1.str)("CONTINUE");
    }
}
exports.Continue = Continue;
//# sourceMappingURL=continue.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/controls.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/controls.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Controls = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Controls {
    getMatcher() {
        const tableview = (0, combi_1.seq)("TABLEVIEW USING SCREEN", expressions_1.Source);
        const type = (0, combi_1.seq)("TYPE", (0, combi_1.alt)(tableview, "TABSTRIP"));
        const ret = (0, combi_1.seq)("CONTROLS", expressions_1.NamespaceSimpleName, type);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Controls = Controls;
//# sourceMappingURL=controls.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/convert.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/convert.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Convert = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Convert {
    getMatcher() {
        const intoTime = (0, combi_1.seq)("TIME", expressions_1.Target);
        const intoDate = (0, combi_1.seq)("DATE", expressions_1.Target);
        const into = (0, combi_1.seq)("INTO", (0, combi_1.per)(intoTime, intoDate));
        const daylight = (0, combi_1.seq)("DAYLIGHT SAVING TIME", expressions_1.Source);
        const zone = (0, combi_1.seq)("TIME ZONE", expressions_1.Source);
        const time = (0, combi_1.seq)("TIME STAMP", expressions_1.Source, (0, combi_1.per)(zone, into, daylight));
        const dat = (0, combi_1.seq)("DATE", expressions_1.Source);
        const tim = (0, combi_1.seq)("TIME", expressions_1.Source);
        const stamp = (0, combi_1.seq)("INTO TIME STAMP", expressions_1.Target);
        const invert = (0, combi_1.seq)("INTO INVERTED-DATE", expressions_1.Target);
        const date = (0, combi_1.seq)((0, combi_1.per)(dat, tim), (0, combi_1.per)(daylight, stamp, zone, invert));
        const inv = (0, combi_1.seq)("INVERTED-DATE", expressions_1.Source, "INTO DATE", expressions_1.Target);
        return (0, combi_1.seq)("CONVERT", (0, combi_1.alt)(time, date, inv));
    }
}
exports.Convert = Convert;
//# sourceMappingURL=convert.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/convert_text.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/convert_text.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConvertText = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ConvertText {
    getMatcher() {
        return (0, combi_1.seq)("CONVERT TEXT", expressions_1.Source, "INTO SORTABLE CODE", expressions_1.Target);
    }
}
exports.ConvertText = ConvertText;
//# sourceMappingURL=convert_text.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_data.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_data.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CreateData = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
// todo, similar to DATA or TYPES?
class CreateData {
    getMatcher() {
        const areaHandle = (0, combi_1.seq)("AREA HANDLE", expressions_1.Source);
        const typeHandle = (0, combi_1.seq)("TYPE HANDLE", expressions_1.Source);
        const type = (0, combi_1.seq)((0, combi_1.alt)("TYPE", "TYPE REF TO", "TYPE TABLE OF", "TYPE TABLE OF REF TO", "TYPE SORTED TABLE OF", "TYPE HASHED TABLE OF", "TYPE STANDARD TABLE OF", "TYPE LINE OF"), (0, combi_1.alt)(expressions_1.TypeName, expressions_1.Dynamic));
        const like = (0, combi_1.seq)((0, combi_1.alt)("LIKE", "LIKE HASHED TABLE OF", "LIKE LINE OF", "LIKE STANDARD TABLE OF", "LIKE SORTED TABLE OF", "LIKE TABLE OF"), (0, combi_1.alt)(expressions_1.Source, expressions_1.Dynamic));
        const length = (0, combi_1.seq)("LENGTH", expressions_1.Source);
        const initial = (0, combi_1.seq)("INITIAL SIZE", expressions_1.Source);
        const decimals = (0, combi_1.seq)("DECIMALS", expressions_1.Source);
        const uniq = (0, combi_1.alt)("UNIQUE", "NON-UNIQUE");
        const emptyKey = (0, combi_1.ver)(version_1.Version.v740sp02, "EMPTY KEY");
        const def = (0, combi_1.seq)((0, combi_1.opt)(uniq), (0, combi_1.alt)("DEFAULT KEY", emptyKey));
        const kdef = (0, combi_1.seq)((0, combi_1.opt)(uniq), "KEY", (0, combi_1.alt)((0, combi_1.plus)(expressions_1.Field), expressions_1.Dynamic));
        const key = (0, combi_1.seq)("WITH", (0, combi_1.alt)(def, kdef));
        const specified = (0, combi_1.seq)((0, combi_1.alt)(type, like), (0, combi_1.opt)(key), (0, combi_1.opt)(initial), (0, combi_1.opt)(length), (0, combi_1.opt)(decimals));
        const ret = (0, combi_1.seq)("CREATE DATA", expressions_1.Target, (0, combi_1.opt)((0, combi_1.alt)(typeHandle, (0, combi_1.seq)((0, combi_1.opt)(areaHandle), specified))));
        return ret;
    }
}
exports.CreateData = CreateData;
//# sourceMappingURL=create_data.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_object.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_object.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CreateObject = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class CreateObject {
    getMatcher() {
        const exporting = (0, combi_1.seq)("EXPORTING", expressions_1.ParameterListS);
        const exceptions = (0, combi_1.seq)("EXCEPTIONS", expressions_1.ParameterListExceptions);
        const ptable = (0, combi_1.seq)("PARAMETER-TABLE", expressions_1.Source);
        const etable = (0, combi_1.seq)("EXCEPTION-TABLE", expressions_1.Source);
        const area = (0, combi_1.seq)("AREA HANDLE", expressions_1.Source);
        const type = (0, combi_1.seq)("TYPE", (0, combi_1.altPrio)(expressions_1.ClassName, expressions_1.Dynamic));
        const ret = (0, combi_1.seq)("CREATE OBJECT", expressions_1.Target, (0, combi_1.optPrio)((0, combi_1.per)(type, area)), (0, combi_1.optPrio)((0, combi_1.altPrio)(exporting, ptable)), (0, combi_1.optPrio)((0, combi_1.altPrio)(exceptions, etable)));
        return ret;
    }
}
exports.CreateObject = CreateObject;
//# sourceMappingURL=create_object.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_ole.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_ole.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CreateOLE = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class CreateOLE {
    getMatcher() {
        const ret = (0, combi_1.seq)("CREATE OBJECT", expressions_1.Target, expressions_1.Source, (0, combi_1.opt)("NO FLUSH"), (0, combi_1.opt)("QUEUE-ONLY"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.CreateOLE = CreateOLE;
//# sourceMappingURL=create_ole.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Data = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Data {
    getMatcher() {
        return (0, combi_1.seq)("DATA", expressions_1.DataDefinition, (0, combi_1.optPrio)("%_PREDEFINED"));
    }
}
exports.Data = Data;
//# sourceMappingURL=data.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data_begin.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data_begin.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataBegin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class DataBegin {
    getMatcher() {
        const occurs = (0, combi_1.seq)("OCCURS", expressions_1.Integer);
        const structure = (0, combi_1.seq)("BEGIN OF", (0, combi_1.opt)("COMMON PART"), expressions_1.DefinitionName, (0, combi_1.opt)("READ-ONLY"), (0, combi_1.opt)(occurs));
        return (0, combi_1.seq)("DATA", structure);
    }
}
exports.DataBegin = DataBegin;
//# sourceMappingURL=data_begin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data_end.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data_end.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataEnd = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class DataEnd {
    getMatcher() {
        const common = (0, combi_1.seq)("COMMON PART", (0, combi_1.optPrio)(expressions_1.DefinitionName));
        const structure = (0, combi_1.seq)("END OF", (0, combi_1.altPrio)(common, expressions_1.DefinitionName));
        const valid = (0, combi_1.seq)("VALID BETWEEN", expressions_1.ComponentName, "AND", expressions_1.ComponentName);
        return (0, combi_1.seq)("DATA", structure, (0, combi_1.optPrio)(valid));
    }
}
exports.DataEnd = DataEnd;
//# sourceMappingURL=data_end.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/define.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/define.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Define = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Define {
    getMatcher() {
        const ret = (0, combi_1.seq)("DEFINE", expressions_1.MacroName);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Define = Define;
//# sourceMappingURL=define.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_cluster.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_cluster.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteCluster = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class DeleteCluster {
    getMatcher() {
        const client = (0, combi_1.seq)("CLIENT", expressions_1.Source);
        const ret = (0, combi_1.seq)("DELETE FROM DATABASE", expressions_1.NamespaceSimpleName, (0, combi_1.tok)(tokens_1.ParenLeft), expressions_1.SimpleName, (0, combi_1.tok)(tokens_1.ParenRightW), (0, combi_1.opt)(client), "ID", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.DeleteCluster = DeleteCluster;
//# sourceMappingURL=delete_cluster.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_database.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_database.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteDatabase = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const sql_client_1 = __webpack_require__(/*! ../expressions/sql_client */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_client.js");
class DeleteDatabase {
    getMatcher() {
        const where = (0, combi_1.seq)("WHERE", (0, combi_1.altPrio)(expressions_1.SQLCond, expressions_1.Dynamic));
        const from = (0, combi_1.seq)("FROM", expressions_1.DatabaseTable, (0, combi_1.optPrio)(sql_client_1.SQLClient), (0, combi_1.optPrio)(expressions_1.DatabaseConnection), (0, combi_1.opt)(where));
        const table = (0, combi_1.seq)(expressions_1.DatabaseTable, (0, combi_1.optPrio)(sql_client_1.SQLClient), (0, combi_1.optPrio)(expressions_1.DatabaseConnection), "FROM", (0, combi_1.opt)("TABLE"), expressions_1.SQLSourceSimple);
        const ret = (0, combi_1.seq)("DELETE", (0, combi_1.altPrio)(from, table));
        return ret;
    }
}
exports.DeleteDatabase = DeleteDatabase;
//# sourceMappingURL=delete_database.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_dataset.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_dataset.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteDataset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class DeleteDataset {
    getMatcher() {
        const ret = (0, combi_1.seq)("DELETE DATASET", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.DeleteDataset = DeleteDataset;
//# sourceMappingURL=delete_dataset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_dynpro.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_dynpro.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteDynpro = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class DeleteDynpro {
    getMatcher() {
        const ret = (0, combi_1.seq)("DELETE DYNPRO", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.DeleteDynpro = DeleteDynpro;
//# sourceMappingURL=delete_dynpro.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_internal.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_internal.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteInternal = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class DeleteInternal {
    getMatcher() {
        // todo, is READ and DELETE similar? something can be reused?
        const index = (0, combi_1.seq)("INDEX", expressions_1.Source);
        const keyName = (0, combi_1.altPrio)(expressions_1.SimpleName, expressions_1.Dynamic);
        const using = (0, combi_1.seq)("USING KEY", keyName);
        const from = (0, combi_1.optPrio)((0, combi_1.seq)("FROM", expressions_1.Source));
        const fromTo = (0, combi_1.seq)(from, (0, combi_1.optPrio)((0, combi_1.seq)("TO", expressions_1.Source)));
        const where = (0, combi_1.seq)("WHERE", (0, combi_1.alt)(expressions_1.ComponentCond, expressions_1.Dynamic));
        const key = (0, combi_1.seq)("WITH TABLE KEY", (0, combi_1.opt)((0, combi_1.seq)(keyName, "COMPONENTS")), (0, combi_1.plus)(expressions_1.ComponentCompare));
        const table = (0, combi_1.seq)("TABLE", expressions_1.Target, (0, combi_1.alt)((0, combi_1.per)(index, using), from, key));
        const other = (0, combi_1.seq)(expressions_1.Target, (0, combi_1.alt)((0, combi_1.per)(index, using), fromTo, key), (0, combi_1.opt)(where));
        const f = (0, combi_1.seq)(expressions_1.FieldSub, (0, combi_1.optPrio)(expressions_1.FieldOffset), (0, combi_1.optPrio)(expressions_1.FieldLength));
        const adjacent = (0, combi_1.seq)("ADJACENT DUPLICATES FROM", expressions_1.Target, (0, combi_1.optPrio)(using), (0, combi_1.opt)((0, combi_1.seq)("COMPARING", (0, combi_1.altPrio)("ALL FIELDS", (0, combi_1.plus)((0, combi_1.altPrio)(f, expressions_1.Dynamic))))), (0, combi_1.optPrio)(using));
        return (0, combi_1.seq)("DELETE", (0, combi_1.alt)(table, adjacent, other));
    }
}
exports.DeleteInternal = DeleteInternal;
//# sourceMappingURL=delete_internal.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_memory.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_memory.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteMemory = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class DeleteMemory {
    getMatcher() {
        const memory = (0, combi_1.seq)("MEMORY ID", expressions_1.Source);
        const id = (0, combi_1.seq)("ID", expressions_1.Source);
        const client = (0, combi_1.seq)("CLIENT", expressions_1.Source);
        const shared = (0, combi_1.seq)("SHARED MEMORY", expressions_1.Field, "(", expressions_1.Field, ")", (0, combi_1.optPrio)(client), id);
        const ret = (0, combi_1.seq)("DELETE FROM", (0, combi_1.alt)(memory, shared));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.DeleteMemory = DeleteMemory;
//# sourceMappingURL=delete_memory.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_report.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_report.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteReport = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class DeleteReport {
    getMatcher() {
        const state = (0, combi_1.seq)("STATE", expressions_1.Source);
        const ret = (0, combi_1.seq)("DELETE REPORT", expressions_1.Source, (0, combi_1.optPrio)(state));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.DeleteReport = DeleteReport;
//# sourceMappingURL=delete_report.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_textpool.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_textpool.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteTextpool = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class DeleteTextpool {
    getMatcher() {
        const language = (0, combi_1.seq)("LANGUAGE", expressions_1.Source);
        const state = (0, combi_1.seq)("STATE", expressions_1.Source);
        const ret = (0, combi_1.seq)("DELETE TEXTPOOL", expressions_1.Source, (0, combi_1.opt)(language), (0, combi_1.opt)(state));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.DeleteTextpool = DeleteTextpool;
//# sourceMappingURL=delete_textpool.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/demand.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/demand.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Demand = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Demand {
    getMatcher() {
        const field = (0, combi_1.seq)(expressions_1.Field, "=", expressions_1.Target);
        const messages = (0, combi_1.seq)("MESSAGES INTO", expressions_1.Target);
        const ret = (0, combi_1.seq)("DEMAND", (0, combi_1.plus)(field), "FROM CONTEXT", expressions_1.Field, (0, combi_1.opt)(messages));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Demand = Demand;
//# sourceMappingURL=demand.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/describe.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/describe.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Describe = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Describe {
    getMatcher() {
        const tlines = (0, combi_1.seq)("LINES", expressions_1.Target);
        const kind = (0, combi_1.seq)("KIND", expressions_1.Target);
        const occurs = (0, combi_1.seq)("OCCURS", expressions_1.Target);
        const table = (0, combi_1.seq)("TABLE", expressions_1.FieldChain, (0, combi_1.opt)((0, combi_1.per)(tlines, kind, occurs)));
        const mode = (0, combi_1.seq)("IN", (0, combi_1.alt)("BYTE", "CHARACTER"), "MODE");
        const field = (0, combi_1.seq)("FIELD", expressions_1.Source, (0, combi_1.per)((0, combi_1.seq)("TYPE", expressions_1.Target), (0, combi_1.seq)("COMPONENTS", expressions_1.Target), (0, combi_1.seq)("LENGTH", expressions_1.Target, (0, combi_1.opt)(mode)), (0, combi_1.seq)("DECIMALS", expressions_1.Target), (0, combi_1.seq)("HELP-ID", expressions_1.Target), (0, combi_1.seq)("OUTPUT-LENGTH", expressions_1.Target), (0, combi_1.seq)("EDIT MASK", expressions_1.Target), (0, combi_1.seq)("INTO", expressions_1.Target)));
        const distance = (0, combi_1.seq)("DISTANCE BETWEEN", expressions_1.Source, "AND", expressions_1.Source, "INTO", expressions_1.Target, mode);
        const lines = (0, combi_1.seq)("NUMBER OF LINES", expressions_1.Target);
        const line = (0, combi_1.seq)("LINE", expressions_1.Source);
        const page = (0, combi_1.seq)("PAGE", expressions_1.Source);
        const index = (0, combi_1.seq)("INDEX", expressions_1.Source);
        const top = (0, combi_1.seq)("TOP-LINES", expressions_1.Target);
        const lineSize = (0, combi_1.seq)("LINE-SIZE", expressions_1.Target);
        const first = (0, combi_1.seq)("FIRST-LINE", expressions_1.Target);
        const list = (0, combi_1.seq)("LIST", (0, combi_1.per)(lines, index, line, page, top, first, lineSize));
        const ret = (0, combi_1.seq)("DESCRIBE", (0, combi_1.altPrio)(table, field, distance, list));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Describe = Describe;
//# sourceMappingURL=describe.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/detail.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/detail.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Detail = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Detail {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "DETAIL");
    }
}
exports.Detail = Detail;
//# sourceMappingURL=detail.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/divide.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/divide.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Divide = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Divide {
    getMatcher() {
        const ret = (0, combi_1.seq)("DIVIDE", expressions_1.Target, "BY", expressions_1.Source);
        return ret;
    }
}
exports.Divide = Divide;
//# sourceMappingURL=divide.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/do.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/do.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Do = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Do {
    getMatcher() {
        const range = (0, combi_1.seq)("RANGE", expressions_1.Source);
        const vary = (0, combi_1.seq)("VARYING", expressions_1.Target, "FROM", expressions_1.Source, "NEXT", expressions_1.Source, (0, combi_1.optPrio)(range));
        const times = (0, combi_1.seq)(expressions_1.Source, "TIMES");
        return (0, combi_1.seq)("DO", (0, combi_1.optPrio)((0, combi_1.per)((0, combi_1.plus)(vary), times)));
    }
}
exports.Do = Do;
//# sourceMappingURL=do.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/editor_call.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/editor_call.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditorCall = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EditorCall {
    getMatcher() {
        const title = (0, combi_1.seq)("TITLE", expressions_1.Source);
        const options = (0, combi_1.per)("DISPLAY-MODE", title);
        const ret = (0, combi_1.seq)("EDITOR-CALL FOR", (0, combi_1.opt)("REPORT"), expressions_1.Source, (0, combi_1.opt)(options));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.EditorCall = EditorCall;
//# sourceMappingURL=editor_call.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/else.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/else.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Else = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Else {
    getMatcher() {
        return (0, combi_1.str)("ELSE");
    }
}
exports.Else = Else;
//# sourceMappingURL=else.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/elseif.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/elseif.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ElseIf = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ElseIf {
    getMatcher() {
        return (0, combi_1.seq)("ELSEIF", expressions_1.Cond);
    }
}
exports.ElseIf = ElseIf;
//# sourceMappingURL=elseif.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_enhancement.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_enhancement.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndEnhancement = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndEnhancement {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "ENDENHANCEMENT");
    }
}
exports.EndEnhancement = EndEnhancement;
//# sourceMappingURL=end_enhancement.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_enhancement_section.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_enhancement_section.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndEnhancementSection = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndEnhancementSection {
    getMatcher() {
        const ret = (0, combi_1.str)("END-ENHANCEMENT-SECTION");
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.EndEnhancementSection = EndEnhancementSection;
//# sourceMappingURL=end_enhancement_section.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_of_page.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_of_page.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndOfPage = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndOfPage {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "END-OF-PAGE");
    }
}
exports.EndOfPage = EndOfPage;
//# sourceMappingURL=end_of_page.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_of_selection.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_of_selection.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndOfSelection = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndOfSelection {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "END-OF-SELECTION");
    }
}
exports.EndOfSelection = EndOfSelection;
//# sourceMappingURL=end_of_selection.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_test_injection.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_test_injection.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndTestInjection = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndTestInjection {
    getMatcher() {
        return (0, combi_1.str)("END-TEST-INJECTION");
    }
}
exports.EndTestInjection = EndTestInjection;
//# sourceMappingURL=end_test_injection.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_test_seam.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_test_seam.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndTestSeam = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndTestSeam {
    getMatcher() {
        return (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.str)("END-TEST-SEAM"));
    }
}
exports.EndTestSeam = EndTestSeam;
//# sourceMappingURL=end_test_seam.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endat.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endat.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndAt = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndAt {
    getMatcher() {
        const ret = (0, combi_1.str)("ENDAT");
        return ret;
    }
}
exports.EndAt = EndAt;
//# sourceMappingURL=endat.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endcase.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endcase.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndCase = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndCase {
    getMatcher() {
        return (0, combi_1.str)("ENDCASE");
    }
}
exports.EndCase = EndCase;
//# sourceMappingURL=endcase.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endcatch.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endcatch.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndCatch = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndCatch {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "ENDCATCH");
    }
}
exports.EndCatch = EndCatch;
//# sourceMappingURL=endcatch.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endclass.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endclass.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndClass = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndClass {
    getMatcher() {
        return (0, combi_1.str)("ENDCLASS");
    }
}
exports.EndClass = EndClass;
//# sourceMappingURL=endclass.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enddefine.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enddefine.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndOfDefinition = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndOfDefinition {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "END-OF-DEFINITION");
    }
}
exports.EndOfDefinition = EndOfDefinition;
//# sourceMappingURL=enddefine.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enddo.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enddo.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndDo = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndDo {
    getMatcher() {
        return (0, combi_1.str)("ENDDO");
    }
}
exports.EndDo = EndDo;
//# sourceMappingURL=enddo.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endexec.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endexec.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndExec = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndExec {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "ENDEXEC");
    }
}
exports.EndExec = EndExec;
//# sourceMappingURL=endexec.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endform.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endform.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndForm = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndForm {
    getMatcher() {
        const ret = (0, combi_1.str)("ENDFORM");
        return ret;
    }
}
exports.EndForm = EndForm;
//# sourceMappingURL=endform.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endfunction.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endfunction.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndFunction = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndFunction {
    getMatcher() {
        return (0, combi_1.str)("ENDFUNCTION");
    }
}
exports.EndFunction = EndFunction;
//# sourceMappingURL=endfunction.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endif.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endif.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndIf = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndIf {
    getMatcher() {
        return (0, combi_1.str)("ENDIF");
    }
}
exports.EndIf = EndIf;
//# sourceMappingURL=endif.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endinterface.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endinterface.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndInterface = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndInterface {
    getMatcher() {
        return (0, combi_1.str)("ENDINTERFACE");
    }
}
exports.EndInterface = EndInterface;
//# sourceMappingURL=endinterface.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endloop.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endloop.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndLoop = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndLoop {
    getMatcher() {
        return (0, combi_1.str)("ENDLOOP");
    }
}
exports.EndLoop = EndLoop;
//# sourceMappingURL=endloop.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endmethod.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endmethod.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndMethod = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndMethod {
    getMatcher() {
        return (0, combi_1.str)("ENDMETHOD");
    }
}
exports.EndMethod = EndMethod;
//# sourceMappingURL=endmethod.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endmodule.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endmodule.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndModule = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndModule {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "ENDMODULE");
    }
}
exports.EndModule = EndModule;
//# sourceMappingURL=endmodule.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endon.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endon.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndOn = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndOn {
    getMatcher() {
        const ret = (0, combi_1.str)("ENDON");
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.EndOn = EndOn;
//# sourceMappingURL=endon.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endprovide.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endprovide.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndProvide = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndProvide {
    getMatcher() {
        const ret = (0, combi_1.str)("ENDPROVIDE");
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.EndProvide = EndProvide;
//# sourceMappingURL=endprovide.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endselect.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endselect.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndSelect = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndSelect {
    getMatcher() {
        return (0, combi_1.str)("ENDSELECT");
    }
}
exports.EndSelect = EndSelect;
//# sourceMappingURL=endselect.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endtry.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endtry.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndTry = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndTry {
    getMatcher() {
        return (0, combi_1.str)("ENDTRY");
    }
}
exports.EndTry = EndTry;
//# sourceMappingURL=endtry.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endwhile.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endwhile.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndWhile = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class EndWhile {
    getMatcher() {
        return (0, combi_1.str)("ENDWHILE");
    }
}
exports.EndWhile = EndWhile;
//# sourceMappingURL=endwhile.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endwith.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endwith.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EndWith = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EndWith {
    getMatcher() {
        return (0, combi_1.ver)(version_1.Version.v751, "ENDWITH");
    }
}
exports.EndWith = EndWith;
//# sourceMappingURL=endwith.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Enhancement = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const namespace_simple_name_1 = __webpack_require__(/*! ../expressions/namespace_simple_name */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/namespace_simple_name.js");
class Enhancement {
    getMatcher() {
        const ret = (0, combi_1.seq)("ENHANCEMENT", (0, combi_1.plus)(namespace_simple_name_1.NamespaceSimpleName));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Enhancement = Enhancement;
//# sourceMappingURL=enhancement.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement_point.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement_point.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnhancementPoint = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class EnhancementPoint {
    getMatcher() {
        const ret = (0, combi_1.seq)("ENHANCEMENT-POINT", expressions_1.FieldSub, "SPOTS", expressions_1.Field, (0, combi_1.opt)("STATIC"), (0, combi_1.opt)("INCLUDE BOUND"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.EnhancementPoint = EnhancementPoint;
//# sourceMappingURL=enhancement_point.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement_section.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement_section.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnhancementSection = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const dash_1 = __webpack_require__(/*! ../../1_lexer/tokens/dash */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/dash.js");
class EnhancementSection {
    getMatcher() {
        const ret = (0, combi_1.seq)("ENHANCEMENT-SECTION", (0, combi_1.seq)(expressions_1.Field, (0, combi_1.starPrio)((0, combi_1.seq)((0, combi_1.tok)(dash_1.Dash), expressions_1.Field))), "SPOTS", expressions_1.Field, (0, combi_1.opt)("STATIC"), (0, combi_1.opt)("INCLUDE BOUND"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.EnhancementSection = EnhancementSection;
//# sourceMappingURL=enhancement_section.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/events.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/events.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Events = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Events {
    getMatcher() {
        const exporting = (0, combi_1.seq)("EXPORTING", (0, combi_1.plus)(expressions_1.MethodParamOptional));
        return (0, combi_1.seq)((0, combi_1.altPrio)("CLASS-EVENTS", "EVENTS"), expressions_1.EventName, (0, combi_1.optPrio)(exporting));
    }
}
exports.Events = Events;
//# sourceMappingURL=events.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/exec_sql.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/exec_sql.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExecSQL = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ExecSQL {
    getMatcher() {
        const performing = (0, combi_1.seq)("PERFORMING", expressions_1.SimpleName);
        const ret = (0, combi_1.seq)("EXEC SQL", (0, combi_1.opt)(performing));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ExecSQL = ExecSQL;
//# sourceMappingURL=exec_sql.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/exit.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/exit.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Exit = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Exit {
    getMatcher() {
        return (0, combi_1.seq)("EXIT", (0, combi_1.opt)((0, combi_1.alt)("FROM SQL", "FROM STEP-LOOP")));
    }
}
exports.Exit = Exit;
//# sourceMappingURL=exit.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/export.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/export.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Export = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
// todo, cloud, split?
class Export {
    getMatcher() {
        const from = (0, combi_1.seq)("FROM", expressions_1.Source);
        const client = (0, combi_1.seq)("CLIENT", expressions_1.Source);
        const id = (0, combi_1.seq)("ID", expressions_1.Source);
        const using = (0, combi_1.seq)("USING", expressions_1.Source);
        const cluster = (0, combi_1.seq)(expressions_1.NamespaceSimpleName, (0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.regex)(/^[\w$%\^]{2}$/), (0, combi_1.tok)(tokens_1.ParenRightW));
        const buffer = (0, combi_1.seq)("DATA BUFFER", expressions_1.Target);
        const memory = (0, combi_1.seq)("MEMORY", (0, combi_1.opt)((0, combi_1.seq)("ID", expressions_1.Source)));
        const table = (0, combi_1.seq)("INTERNAL TABLE", expressions_1.Target);
        const shared = (0, combi_1.seq)((0, combi_1.alt)("SHARED MEMORY", "SHARED BUFFER"), cluster, (0, combi_1.per)(from, client, id));
        const database = (0, combi_1.seq)("DATABASE", cluster, (0, combi_1.per)(from, client, id, using));
        const target = (0, combi_1.alt)(buffer, memory, database, table, shared);
        const left = (0, combi_1.alt)(expressions_1.FieldSub, expressions_1.FieldSymbol);
        const source = (0, combi_1.alt)((0, combi_1.plus)((0, combi_1.altPrio)(expressions_1.ParameterS, (0, combi_1.seq)(left, from), left)), expressions_1.Dynamic);
        const compression = (0, combi_1.seq)("COMPRESSION", (0, combi_1.alt)("ON", "OFF"));
        const hint = (0, combi_1.seq)("CODE PAGE HINT", expressions_1.Source);
        return (0, combi_1.seq)("EXPORT", source, "TO", target, (0, combi_1.opt)(compression), (0, combi_1.opt)(hint));
    }
}
exports.Export = Export;
//# sourceMappingURL=export.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/export_dynpro.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/export_dynpro.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportDynpro = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ExportDynpro {
    getMatcher() {
        const ret = (0, combi_1.seq)("EXPORT DYNPRO", expressions_1.Source, expressions_1.Source, expressions_1.Source, expressions_1.Source, "ID", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ExportDynpro = ExportDynpro;
//# sourceMappingURL=export_dynpro.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/extract.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/extract.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Extract = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Extract {
    getMatcher() {
        const ret = (0, combi_1.seq)("EXTRACT", (0, combi_1.opt)(expressions_1.Field));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Extract = Extract;
//# sourceMappingURL=extract.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fetch_next_cursor.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fetch_next_cursor.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FetchNextCursor = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const sql_into_structure_1 = __webpack_require__(/*! ../expressions/sql_into_structure */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/sql_into_structure.js");
class FetchNextCursor {
    getMatcher() {
        const size = (0, combi_1.seq)("PACKAGE SIZE", expressions_1.SQLSourceSimple);
        const ret = (0, combi_1.seq)("FETCH NEXT CURSOR", expressions_1.SQLSourceSimple, (0, combi_1.alt)(sql_into_structure_1.SQLIntoStructure, expressions_1.SQLIntoTable, expressions_1.SQLIntoList), (0, combi_1.optPrio)(size));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.FetchNextCursor = FetchNextCursor;
//# sourceMappingURL=fetch_next_cursor.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/field_group.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/field_group.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldGroup = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class FieldGroup {
    getMatcher() {
        const ret = (0, combi_1.seq)("FIELD-GROUPS", (0, combi_1.plus)(expressions_1.Field));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.FieldGroup = FieldGroup;
//# sourceMappingURL=field_group.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fields.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fields.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Fields = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Fields {
    getMatcher() {
        const ret = (0, combi_1.seq)("FIELDS", expressions_1.FieldSub);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Fields = Fields;
//# sourceMappingURL=fields.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fieldsymbol.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fieldsymbol.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FieldSymbol = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FieldSymbol {
    getMatcher() {
        const stru = (0, combi_1.seq)("STRUCTURE", expressions_1.TypeName, "DEFAULT", expressions_1.Field);
        return (0, combi_1.seq)("FIELD-SYMBOLS", expressions_1.FieldSymbol, (0, combi_1.opt)((0, combi_1.alt)(expressions_1.Type, expressions_1.TypeTable, stru)));
    }
}
exports.FieldSymbol = FieldSymbol;
//# sourceMappingURL=fieldsymbol.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/find.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/find.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Find = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Find {
    getMatcher() {
        // SUBMATCHES handling is a workaround
        const options = (0, combi_1.per)("IGNORING CASE", "RESPECTING CASE", "IN BYTE MODE", "IN CHARACTER MODE", (0, combi_1.seq)("OF", expressions_1.Source), (0, combi_1.seq)("FROM", expressions_1.Source), (0, combi_1.seq)("TO", expressions_1.Source), (0, combi_1.seq)("MATCH OFFSET", expressions_1.Target), (0, combi_1.seq)("MATCH LINE", expressions_1.Target), (0, combi_1.seq)("MATCH COUNT", expressions_1.Target), (0, combi_1.seq)("MATCH LENGTH", expressions_1.Target), (0, combi_1.seq)("LENGTH", expressions_1.Source), (0, combi_1.seq)("RESULTS", expressions_1.Target), (0, combi_1.seq)("SUBMATCHES", expressions_1.Target), (0, combi_1.seq)("SUBMATCHES", expressions_1.Target, expressions_1.Target), (0, combi_1.seq)("SUBMATCHES", (0, combi_1.plus)(expressions_1.Target)));
        const sectionLength = (0, combi_1.seq)("SECTION LENGTH", expressions_1.Source, "OF");
        const before = (0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.altPrio)("TABLE", "SECTION OFFSET", sectionLength)), expressions_1.Source);
        const ret = (0, combi_1.seq)("FIND", (0, combi_1.opt)((0, combi_1.altPrio)("FIRST OCCURRENCE OF", "ALL OCCURRENCES OF")), expressions_1.FindType, expressions_1.Source, "IN", before, (0, combi_1.opt)(options));
        return ret;
    }
}
exports.Find = Find;
//# sourceMappingURL=find.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/form.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/form.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Form = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Form {
    getMatcher() {
        const parameters = (0, combi_1.seq)((0, combi_1.opt)(expressions_1.FormTables), (0, combi_1.opt)(expressions_1.FormUsing), (0, combi_1.opt)(expressions_1.FormChanging), (0, combi_1.opt)(expressions_1.FormRaising));
        const ret = (0, combi_1.seq)("FORM", expressions_1.FormName, (0, combi_1.alt)("IMPLEMENTATION", parameters));
        return ret;
    }
}
exports.Form = Form;
//# sourceMappingURL=form.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/form_definition.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/form_definition.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormDefinition = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FormDefinition {
    getMatcher() {
        const ret = (0, combi_1.seq)("FORM", expressions_1.FormName, "DEFINITION", (0, combi_1.opt)(expressions_1.FormTables), (0, combi_1.opt)(expressions_1.FormUsing), (0, combi_1.opt)(expressions_1.FormChanging), (0, combi_1.opt)(expressions_1.FormRaising));
        return ret;
    }
}
exports.FormDefinition = FormDefinition;
//# sourceMappingURL=form_definition.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/format.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/format.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Format = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Format {
    getMatcher() {
        const eq = (0, combi_1.seq)("=", expressions_1.Source);
        const value = (0, combi_1.altPrio)(eq, "ON", "OFF");
        const options = (0, combi_1.per)("RESET", (0, combi_1.seq)("INTENSIFIED", (0, combi_1.opt)(value)), (0, combi_1.seq)("INVERSE", (0, combi_1.opt)(value)), (0, combi_1.seq)("HOTSPOT", (0, combi_1.opt)(value)), (0, combi_1.seq)("FRAMES", value), (0, combi_1.seq)("INPUT", value), expressions_1.Color);
        const ret = (0, combi_1.seq)("FORMAT", options);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Format = Format;
//# sourceMappingURL=format.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Free = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Free {
    getMatcher() {
        const ret = (0, combi_1.seq)("FREE", expressions_1.Target);
        return ret;
    }
}
exports.Free = Free;
//# sourceMappingURL=free.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free_memory.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free_memory.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FreeMemory = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class FreeMemory {
    getMatcher() {
        const ret = (0, combi_1.seq)("FREE MEMORY", (0, combi_1.optPrio)((0, combi_1.seq)("ID", expressions_1.Source)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.FreeMemory = FreeMemory;
//# sourceMappingURL=free_memory.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free_object.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free_object.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FreeObject = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class FreeObject {
    getMatcher() {
        const ret = (0, combi_1.seq)("FREE OBJECT", expressions_1.Target, (0, combi_1.opt)("NO FLUSH"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.FreeObject = FreeObject;
//# sourceMappingURL=free_object.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/function_module.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/function_module.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FunctionModule = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FunctionModule {
    getMatcher() {
        return (0, combi_1.seq)("FUNCTION", expressions_1.Field);
    }
}
exports.FunctionModule = FunctionModule;
//# sourceMappingURL=function_module.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/function_pool.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/function_pool.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FunctionPool = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class FunctionPool {
    getMatcher() {
        const message = (0, combi_1.seq)("MESSAGE-ID", expressions_1.MessageClass);
        const line = (0, combi_1.seq)("LINE-SIZE", expressions_1.Integer);
        const no = (0, combi_1.str)("NO STANDARD PAGE HEADING");
        return (0, combi_1.seq)("FUNCTION-POOL", expressions_1.Field, (0, combi_1.opt)((0, combi_1.per)(message, line, no)));
    }
}
exports.FunctionPool = FunctionPool;
//# sourceMappingURL=function_pool.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_dynpro.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_dynpro.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GenerateDynpro = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GenerateDynpro {
    getMatcher() {
        const line = (0, combi_1.seq)("LINE", expressions_1.Target);
        const word = (0, combi_1.seq)("WORD", expressions_1.Target);
        const ret = (0, combi_1.seq)("GENERATE DYNPRO", expressions_1.Source, expressions_1.Source, expressions_1.Source, expressions_1.Source, "ID", expressions_1.Source, "MESSAGE", expressions_1.Target, (0, combi_1.per)(line, word));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GenerateDynpro = GenerateDynpro;
//# sourceMappingURL=generate_dynpro.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_report.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_report.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GenerateReport = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GenerateReport {
    getMatcher() {
        const without = (0, combi_1.str)("WITHOUT SELECTION-SCREEN");
        const message = (0, combi_1.seq)("MESSAGE", expressions_1.Target);
        const include = (0, combi_1.seq)("INCLUDE", expressions_1.Target);
        const line = (0, combi_1.seq)("LINE", expressions_1.Target);
        const word = (0, combi_1.seq)("WORD", expressions_1.Target);
        const offset = (0, combi_1.seq)("OFFSET", expressions_1.Target);
        const headers = (0, combi_1.str)("WITH PRECOMPILED HEADERS");
        const test = (0, combi_1.str)("WITH TEST CODE");
        const messageid = (0, combi_1.seq)("MESSAGE-ID", expressions_1.Target);
        const trace = (0, combi_1.seq)("TRACE-FILE", expressions_1.Target);
        const shortdumpid = (0, combi_1.seq)("SHORTDUMP-ID", expressions_1.Target);
        const directory = (0, combi_1.seq)("DIRECTORY ENTRY", expressions_1.Target);
        const options = (0, combi_1.per)(without, message, include, trace, line, word, offset, headers, test, messageid, shortdumpid, directory);
        const ret = (0, combi_1.seq)("GENERATE REPORT", expressions_1.Source, (0, combi_1.opt)(options));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GenerateReport = GenerateReport;
//# sourceMappingURL=generate_report.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_subroutine.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_subroutine.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GenerateSubroutine = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GenerateSubroutine {
    getMatcher() {
        const name = (0, combi_1.seq)("NAME", expressions_1.Source);
        const message = (0, combi_1.seq)("MESSAGE", expressions_1.Target);
        const messageid = (0, combi_1.seq)("MESSAGE-ID", expressions_1.Target);
        const line = (0, combi_1.seq)("LINE", expressions_1.Target);
        const word = (0, combi_1.seq)("WORD", expressions_1.Target);
        const offset = (0, combi_1.seq)("OFFSET", expressions_1.Target);
        const short = (0, combi_1.seq)("SHORTDUMP-ID", expressions_1.Target);
        const include = (0, combi_1.seq)("INCLUDE", expressions_1.Target);
        const ret = (0, combi_1.seq)("GENERATE SUBROUTINE POOL", expressions_1.Source, (0, combi_1.per)(name, message, line, word, include, offset, messageid, short));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GenerateSubroutine = GenerateSubroutine;
//# sourceMappingURL=generate_subroutine.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Get = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Get {
    getMatcher() {
        const fields = (0, combi_1.seq)("FIELDS", (0, combi_1.plus)(expressions_1.Field));
        const options = (0, combi_1.per)("LATE", fields);
        const ret = (0, combi_1.seq)("GET", expressions_1.Target, (0, combi_1.opt)(options));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Get = Get;
//# sourceMappingURL=get.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_badi.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_badi.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetBadi = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetBadi {
    getMatcher() {
        const filters = (0, combi_1.seq)("FILTERS", expressions_1.ParameterListS);
        const context = (0, combi_1.seq)("CONTEXT", expressions_1.Source);
        const type = (0, combi_1.seq)("TYPE", expressions_1.Dynamic);
        const ret = (0, combi_1.seq)("GET BADI", expressions_1.Target, (0, combi_1.opt)(type), (0, combi_1.opt)(filters), (0, combi_1.opt)(context));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GetBadi = GetBadi;
//# sourceMappingURL=get_badi.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_bit.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_bit.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetBit = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class GetBit {
    getMatcher() {
        const ret = (0, combi_1.seq)("GET BIT", expressions_1.Source, "OF", expressions_1.Source, "INTO", expressions_1.Target);
        return ret;
    }
}
exports.GetBit = GetBit;
//# sourceMappingURL=get_bit.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_cursor.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_cursor.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetCursor = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetCursor {
    getMatcher() {
        const line = (0, combi_1.seq)("LINE", expressions_1.Target);
        const field = (0, combi_1.seq)("FIELD", expressions_1.Target);
        const offset = (0, combi_1.seq)("OFFSET", expressions_1.Target);
        const value = (0, combi_1.seq)("VALUE", expressions_1.Target);
        const length = (0, combi_1.seq)("LENGTH", expressions_1.Target);
        const area = (0, combi_1.seq)("AREA", expressions_1.Target);
        const ret = (0, combi_1.seq)("GET CURSOR", (0, combi_1.per)(line, (0, combi_1.opt)("DISPLAY"), field, offset, value, length, area));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GetCursor = GetCursor;
//# sourceMappingURL=get_cursor.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_dataset.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_dataset.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetDataset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetDataset {
    getMatcher() {
        const position = (0, combi_1.seq)("POSITION", expressions_1.Target);
        const attr = (0, combi_1.seq)("ATTRIBUTES", expressions_1.Target);
        const ret = (0, combi_1.seq)("GET DATASET", expressions_1.Target, (0, combi_1.opt)((0, combi_1.per)(position, attr)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GetDataset = GetDataset;
//# sourceMappingURL=get_dataset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_locale.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_locale.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetLocale = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetLocale {
    getMatcher() {
        const country = (0, combi_1.seq)("COUNTRY", expressions_1.Target);
        const modifier = (0, combi_1.seq)("MODIFIER", expressions_1.Target);
        const ret = (0, combi_1.seq)("GET LOCALE LANGUAGE", expressions_1.Target, country, modifier);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GetLocale = GetLocale;
//# sourceMappingURL=get_locale.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_parameter.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_parameter.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetParameter = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetParameter {
    getMatcher() {
        const ret = (0, combi_1.seq)("GET PARAMETER ID", expressions_1.Source, "FIELD", expressions_1.Target);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GetParameter = GetParameter;
//# sourceMappingURL=get_parameter.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_permissions.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_permissions.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetPermissions = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetPermissions {
    getMatcher() {
        const s = (0, combi_1.seq)("GET PERMISSIONS ONLY GLOBAL AUTHORIZATION ENTITY", expressions_1.SimpleName, "REQUEST", expressions_1.Source, "RESULT", expressions_1.Target, "FAILED", expressions_1.Target, "REPORTED", expressions_1.Target);
        return (0, combi_1.ver)(version_1.Version.v754, s);
    }
}
exports.GetPermissions = GetPermissions;
//# sourceMappingURL=get_permissions.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_pf_status.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_pf_status.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetPFStatus = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetPFStatus {
    getMatcher() {
        const program = (0, combi_1.seq)("PROGRAM", expressions_1.Source);
        const excl = (0, combi_1.seq)("EXCLUDING", expressions_1.Source);
        const ret = (0, combi_1.seq)("GET PF-STATUS", expressions_1.Target, (0, combi_1.opt)(program), (0, combi_1.opt)(excl));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GetPFStatus = GetPFStatus;
//# sourceMappingURL=get_pf_status.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_property.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_property.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetProperty = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetProperty {
    getMatcher() {
        const ret = (0, combi_1.seq)("GET PROPERTY OF", expressions_1.FieldSub, expressions_1.Source, "=", expressions_1.Source, (0, combi_1.opt)("NO FLUSH"), (0, combi_1.opt)(expressions_1.OLEExporting));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GetProperty = GetProperty;
//# sourceMappingURL=get_property.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_reference.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_reference.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetReference = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class GetReference {
    getMatcher() {
        const ret = (0, combi_1.seq)("GET REFERENCE OF", expressions_1.Source, "INTO", expressions_1.Target);
        return ret;
    }
}
exports.GetReference = GetReference;
//# sourceMappingURL=get_reference.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_run_time.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_run_time.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetRunTime = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class GetRunTime {
    getMatcher() {
        const ret = (0, combi_1.seq)("GET RUN TIME FIELD", expressions_1.Target);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.GetRunTime = GetRunTime;
//# sourceMappingURL=get_run_time.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_time.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_time.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GetTime = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class GetTime {
    getMatcher() {
        const options = (0, combi_1.seq)((0, combi_1.alt)("STAMP FIELD", "FIELD"), expressions_1.Target);
        return (0, combi_1.seq)("GET TIME", (0, combi_1.opt)(options));
    }
}
exports.GetTime = GetTime;
//# sourceMappingURL=get_time.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/hide.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/hide.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Hide = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Hide {
    getMatcher() {
        const ret = (0, combi_1.seq)("HIDE", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Hide = Hide;
//# sourceMappingURL=hide.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/if.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/if.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.If = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class If {
    getMatcher() {
        return (0, combi_1.seq)("IF", expressions_1.Cond);
    }
}
exports.If = If;
//# sourceMappingURL=if.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Import = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Import {
    getMatcher() {
        const dto = (0, combi_1.seq)("TO", expressions_1.Target);
        const client = (0, combi_1.seq)("CLIENT", expressions_1.Source);
        const id = (0, combi_1.seq)("ID", expressions_1.Source);
        const using = (0, combi_1.seq)("USING", expressions_1.Source);
        const cluster = (0, combi_1.seq)(expressions_1.NamespaceSimpleName, (0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.regex)(/^[\w$%\^]{2}$/), (0, combi_1.tok)(tokens_1.ParenRightW));
        const buffer = (0, combi_1.seq)("DATA BUFFER", expressions_1.Source);
        const memory = (0, combi_1.seq)("MEMORY ID", expressions_1.Source);
        const table = (0, combi_1.seq)("INTERNAL TABLE", expressions_1.Source);
        const shared = (0, combi_1.seq)((0, combi_1.alt)("SHARED MEMORY", "SHARED BUFFER"), cluster, (0, combi_1.per)(dto, client, id));
        const database = (0, combi_1.seq)("DATABASE", cluster, (0, combi_1.per)(dto, client, id, using));
        const source = (0, combi_1.alt)(buffer, memory, database, table, shared);
        const to = (0, combi_1.plus)((0, combi_1.seq)(expressions_1.ComponentChainSimple, (0, combi_1.alt)("TO", "INTO"), expressions_1.Target));
        const toeq = (0, combi_1.plus)((0, combi_1.seq)((0, combi_1.alt)(expressions_1.ComponentChainSimple, expressions_1.FieldSymbol), "=", expressions_1.Target));
        const target = (0, combi_1.alt)(toeq, to, expressions_1.Dynamic, (0, combi_1.plus)(expressions_1.Target));
        const options = (0, combi_1.per)("ACCEPTING PADDING", "IGNORING CONVERSION ERRORS", "IN CHAR-TO-HEX MODE", "IGNORING STRUCTURE BOUNDARIES", "ACCEPTING TRUNCATION", (0, combi_1.seq)("REPLACEMENT CHARACTER", expressions_1.Source), (0, combi_1.seq)("CODE PAGE INTO", expressions_1.Source), (0, combi_1.seq)("ENDIAN INTO", expressions_1.Source));
        const ret = (0, combi_1.seq)("IMPORT", target, "FROM", source, (0, combi_1.opt)(options));
        return ret;
    }
}
exports.Import = Import;
//# sourceMappingURL=import.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import_dynpro.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import_dynpro.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportDynpro = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ImportDynpro {
    getMatcher() {
        const ret = (0, combi_1.seq)("IMPORT DYNPRO", expressions_1.Target, expressions_1.Target, expressions_1.Target, expressions_1.Target, "ID", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ImportDynpro = ImportDynpro;
//# sourceMappingURL=import_dynpro.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import_nametab.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import_nametab.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportNametab = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ImportNametab {
    getMatcher() {
        const ret = (0, combi_1.seq)("IMPORT NAMETAB", expressions_1.Target, expressions_1.Target, "ID", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ImportNametab = ImportNametab;
//# sourceMappingURL=import_nametab.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/include.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/include.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Include = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Include {
    getMatcher() {
        const ret = (0, combi_1.seq)("INCLUDE", expressions_1.IncludeName, (0, combi_1.opt)("IF FOUND"));
        return ret;
    }
}
exports.Include = Include;
//# sourceMappingURL=include.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/include_type.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/include_type.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IncludeType = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const Expressions = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class IncludeType {
    getMatcher() {
        const tas = (0, combi_1.seq)("AS", Expressions.Field);
        const renaming = (0, combi_1.seq)("RENAMING WITH SUFFIX", Expressions.ComponentName);
        const ret = (0, combi_1.seq)("INCLUDE", (0, combi_1.alt)("TYPE", "STRUCTURE"), Expressions.TypeName, (0, combi_1.opt)(tas), (0, combi_1.opt)(renaming));
        return ret;
    }
}
exports.IncludeType = IncludeType;
//# sourceMappingURL=include_type.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
// do not include statement.ts in this file.
// this file only contains "real" statements
// sequence of exports is optimized for parsing and precedence
// see statement.ts for Unknown, Empty, Macro and Comment statements
__exportStar(__webpack_require__(/*! ./data */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data.js"), exports);
__exportStar(__webpack_require__(/*! ./report */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/report.js"), exports);
__exportStar(__webpack_require__(/*! ./write */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/write.js"), exports);
__exportStar(__webpack_require__(/*! ./endmethod */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endmethod.js"), exports);
__exportStar(__webpack_require__(/*! ./method_implementation */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/method_implementation.js"), exports);
__exportStar(__webpack_require__(/*! ./endform */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endform.js"), exports);
__exportStar(__webpack_require__(/*! ./form */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/form.js"), exports);
__exportStar(__webpack_require__(/*! ./import_nametab */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import_nametab.js"), exports);
__exportStar(__webpack_require__(/*! ./check_select_options */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/check_select_options.js"), exports);
__exportStar(__webpack_require__(/*! ./call_badi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_badi.js"), exports);
__exportStar(__webpack_require__(/*! ./class_data */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data.js"), exports);
__exportStar(__webpack_require__(/*! ./class_data_begin */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data_begin.js"), exports);
__exportStar(__webpack_require__(/*! ./class_data_end */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_data_end.js"), exports);
__exportStar(__webpack_require__(/*! ./select_loop */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/select_loop.js"), exports);
__exportStar(__webpack_require__(/*! ./do */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/do.js"), exports);
__exportStar(__webpack_require__(/*! ./break_id */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/break_id.js"), exports);
__exportStar(__webpack_require__(/*! ./interface_deferred */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_deferred.js"), exports);
__exportStar(__webpack_require__(/*! ./while */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/while.js"), exports);
__exportStar(__webpack_require__(/*! ./loop_at_screen */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/loop_at_screen.js"), exports);
__exportStar(__webpack_require__(/*! ./loop */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/loop.js"), exports);
__exportStar(__webpack_require__(/*! ./check */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/check.js"), exports);
__exportStar(__webpack_require__(/*! ./endprovide */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endprovide.js"), exports);
__exportStar(__webpack_require__(/*! ./if */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/if.js"), exports);
__exportStar(__webpack_require__(/*! ./convert_text */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/convert_text.js"), exports);
__exportStar(__webpack_require__(/*! ./log_point */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/log_point.js"), exports);
__exportStar(__webpack_require__(/*! ./window */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/window.js"), exports);
__exportStar(__webpack_require__(/*! ./endif */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endif.js"), exports);
__exportStar(__webpack_require__(/*! ./type_enum */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum.js"), exports);
__exportStar(__webpack_require__(/*! ./type_enum_begin */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum_begin.js"), exports);
__exportStar(__webpack_require__(/*! ./type_enum_end */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum_end.js"), exports);
__exportStar(__webpack_require__(/*! ./set_run_time */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_run_time.js"), exports);
__exportStar(__webpack_require__(/*! ./field_group */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/field_group.js"), exports);
__exportStar(__webpack_require__(/*! ./print_control */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/print_control.js"), exports);
__exportStar(__webpack_require__(/*! ./extract */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/extract.js"), exports);
__exportStar(__webpack_require__(/*! ./sum */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sum.js"), exports);
__exportStar(__webpack_require__(/*! ./end_of_page */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_of_page.js"), exports);
__exportStar(__webpack_require__(/*! ./generate_report */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_report.js"), exports);
__exportStar(__webpack_require__(/*! ./elseif */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/elseif.js"), exports);
__exportStar(__webpack_require__(/*! ./else */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/else.js"), exports);
__exportStar(__webpack_require__(/*! ./perform */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/perform.js"), exports);
__exportStar(__webpack_require__(/*! ./append */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/append.js"), exports);
__exportStar(__webpack_require__(/*! ./clear */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/clear.js"), exports);
__exportStar(__webpack_require__(/*! ./concatenate */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/concatenate.js"), exports);
__exportStar(__webpack_require__(/*! ./enddo */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enddo.js"), exports);
__exportStar(__webpack_require__(/*! ./endclass */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endclass.js"), exports);
__exportStar(__webpack_require__(/*! ./try */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/try.js"), exports);
__exportStar(__webpack_require__(/*! ./endtry */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endtry.js"), exports);
__exportStar(__webpack_require__(/*! ./assert */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assert.js"), exports);
__exportStar(__webpack_require__(/*! ./return */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/return.js"), exports);
__exportStar(__webpack_require__(/*! ./endwhile */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endwhile.js"), exports);
__exportStar(__webpack_require__(/*! ./constant */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant.js"), exports);
__exportStar(__webpack_require__(/*! ./catch */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/catch.js"), exports);
__exportStar(__webpack_require__(/*! ./infotypes */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/infotypes.js"), exports);
__exportStar(__webpack_require__(/*! ./message */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/message.js"), exports);
__exportStar(__webpack_require__(/*! ./read_table */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_table.js"), exports);
__exportStar(__webpack_require__(/*! ./endloop */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endloop.js"), exports);
__exportStar(__webpack_require__(/*! ./case */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/case.js"), exports);
__exportStar(__webpack_require__(/*! ./create_object */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_object.js"), exports);
__exportStar(__webpack_require__(/*! ./select */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/select.js"), exports);
__exportStar(__webpack_require__(/*! ./call */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call.js"), exports);
__exportStar(__webpack_require__(/*! ./class_local_friends */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_local_friends.js"), exports);
__exportStar(__webpack_require__(/*! ./class_deferred */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_deferred.js"), exports);
__exportStar(__webpack_require__(/*! ./fieldsymbol */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fieldsymbol.js"), exports);
__exportStar(__webpack_require__(/*! ./class_definition */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_definition.js"), exports);
__exportStar(__webpack_require__(/*! ./class_implementation */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_implementation.js"), exports);
__exportStar(__webpack_require__(/*! ./translate */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/translate.js"), exports);
__exportStar(__webpack_require__(/*! ./exit */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/exit.js"), exports);
__exportStar(__webpack_require__(/*! ./endcase */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endcase.js"), exports);
__exportStar(__webpack_require__(/*! ./constant_begin */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant_begin.js"), exports);
__exportStar(__webpack_require__(/*! ./constant_end */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/constant_end.js"), exports);
__exportStar(__webpack_require__(/*! ./when_others */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when_others.js"), exports);
__exportStar(__webpack_require__(/*! ./when */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when.js"), exports);
__exportStar(__webpack_require__(/*! ./continue */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/continue.js"), exports);
__exportStar(__webpack_require__(/*! ./assign */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assign.js"), exports);
__exportStar(__webpack_require__(/*! ./get_badi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_badi.js"), exports);
__exportStar(__webpack_require__(/*! ./suppress_dialog */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/suppress_dialog.js"), exports);
__exportStar(__webpack_require__(/*! ./type */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type.js"), exports);
__exportStar(__webpack_require__(/*! ./hide */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/hide.js"), exports);
__exportStar(__webpack_require__(/*! ./get_locale */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_locale.js"), exports);
__exportStar(__webpack_require__(/*! ./set_locale */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_locale.js"), exports);
__exportStar(__webpack_require__(/*! ./commit */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/commit.js"), exports);
__exportStar(__webpack_require__(/*! ./modify_screen */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_screen.js"), exports);
__exportStar(__webpack_require__(/*! ./commit_entities */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/commit_entities.js"), exports);
__exportStar(__webpack_require__(/*! ./modify_entities */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_entities.js"), exports);
__exportStar(__webpack_require__(/*! ./read_entities */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_entities.js"), exports);
__exportStar(__webpack_require__(/*! ./rollback_entities */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/rollback_entities.js"), exports);
__exportStar(__webpack_require__(/*! ./summary */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/summary.js"), exports);
__exportStar(__webpack_require__(/*! ./on_change */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/on_change.js"), exports);
__exportStar(__webpack_require__(/*! ./at_user_command */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_user_command.js"), exports);
__exportStar(__webpack_require__(/*! ./position */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/position.js"), exports);
__exportStar(__webpack_require__(/*! ./resume */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/resume.js"), exports);
__exportStar(__webpack_require__(/*! ./stop */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/stop.js"), exports);
__exportStar(__webpack_require__(/*! ./get_pf_status */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_pf_status.js"), exports);
__exportStar(__webpack_require__(/*! ./delete_report */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_report.js"), exports);
__exportStar(__webpack_require__(/*! ./controls */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/controls.js"), exports);
__exportStar(__webpack_require__(/*! ./at_line_selection */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_line_selection.js"), exports);
__exportStar(__webpack_require__(/*! ./new_page */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/new_page.js"), exports);
__exportStar(__webpack_require__(/*! ./set_dataset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_dataset.js"), exports);
__exportStar(__webpack_require__(/*! ./get_property */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_property.js"), exports);
__exportStar(__webpack_require__(/*! ./scroll_list */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/scroll_list.js"), exports);
__exportStar(__webpack_require__(/*! ./load_of_program */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/load_of_program.js"), exports);
__exportStar(__webpack_require__(/*! ./top_of_page */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/top_of_page.js"), exports);
__exportStar(__webpack_require__(/*! ./truncate_dataset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/truncate_dataset.js"), exports);
__exportStar(__webpack_require__(/*! ./set_update_task */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_update_task.js"), exports);
__exportStar(__webpack_require__(/*! ./set_user_command */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_user_command.js"), exports);
__exportStar(__webpack_require__(/*! ./rollback */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/rollback.js"), exports);
__exportStar(__webpack_require__(/*! ./delete_internal */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_internal.js"), exports);
__exportStar(__webpack_require__(/*! ./delete_database */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_database.js"), exports);
__exportStar(__webpack_require__(/*! ./delete_dataset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_dataset.js"), exports);
__exportStar(__webpack_require__(/*! ./free_memory */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free_memory.js"), exports);
__exportStar(__webpack_require__(/*! ./catch_system_exceptions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/catch_system_exceptions.js"), exports);
__exportStar(__webpack_require__(/*! ./endcatch */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endcatch.js"), exports);
__exportStar(__webpack_require__(/*! ./assign_local_copy */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/assign_local_copy.js"), exports);
__exportStar(__webpack_require__(/*! ./set_extended_check */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_extended_check.js"), exports);
__exportStar(__webpack_require__(/*! ./split */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/split.js"), exports);
__exportStar(__webpack_require__(/*! ./new_line */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/new_line.js"), exports);
__exportStar(__webpack_require__(/*! ./free_object */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free_object.js"), exports);
__exportStar(__webpack_require__(/*! ./sort */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sort.js"), exports);
__exportStar(__webpack_require__(/*! ./replace */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/replace.js"), exports);
__exportStar(__webpack_require__(/*! ./with_loop */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/with_loop.js"), exports);
__exportStar(__webpack_require__(/*! ./with */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/with.js"), exports);
__exportStar(__webpack_require__(/*! ./endwith */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endwith.js"), exports);
__exportStar(__webpack_require__(/*! ./condense */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/condense.js"), exports);
__exportStar(__webpack_require__(/*! ./insert_internal */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_internal.js"), exports);
__exportStar(__webpack_require__(/*! ./insert_database */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_database.js"), exports);
__exportStar(__webpack_require__(/*! ./insert_field_group */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_field_group.js"), exports);
__exportStar(__webpack_require__(/*! ./update_database */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/update_database.js"), exports);
__exportStar(__webpack_require__(/*! ./modify_database */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_database.js"), exports);
__exportStar(__webpack_require__(/*! ./modify_internal */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_internal.js"), exports);
__exportStar(__webpack_require__(/*! ./raise */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise.js"), exports);
__exportStar(__webpack_require__(/*! ./define */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/define.js"), exports);
__exportStar(__webpack_require__(/*! ./enddefine */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enddefine.js"), exports);
__exportStar(__webpack_require__(/*! ./find */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/find.js"), exports);
__exportStar(__webpack_require__(/*! ./move */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/move.js"), exports);
__exportStar(__webpack_require__(/*! ./move_corresponding */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/move_corresponding.js"), exports);
__exportStar(__webpack_require__(/*! ./get_time */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_time.js"), exports);
__exportStar(__webpack_require__(/*! ./enhancement_point */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement_point.js"), exports);
__exportStar(__webpack_require__(/*! ./enhancement_section */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement_section.js"), exports);
__exportStar(__webpack_require__(/*! ./end_enhancement_section */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_enhancement_section.js"), exports);
__exportStar(__webpack_require__(/*! ./set_handler */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_handler.js"), exports);
__exportStar(__webpack_require__(/*! ./set_left */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_left.js"), exports);
__exportStar(__webpack_require__(/*! ./pack */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/pack.js"), exports);
__exportStar(__webpack_require__(/*! ./case_type */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/case_type.js"), exports);
__exportStar(__webpack_require__(/*! ./when_type */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when_type.js"), exports);
__exportStar(__webpack_require__(/*! ./exec_sql */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/exec_sql.js"), exports);
__exportStar(__webpack_require__(/*! ./open_cursor */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/open_cursor.js"), exports);
__exportStar(__webpack_require__(/*! ./communication */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/communication.js"), exports);
__exportStar(__webpack_require__(/*! ./generate_subroutine */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_subroutine.js"), exports);
__exportStar(__webpack_require__(/*! ./reject */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/reject.js"), exports);
__exportStar(__webpack_require__(/*! ./load_report */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/load_report.js"), exports);
__exportStar(__webpack_require__(/*! ./private */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/private.js"), exports);
__exportStar(__webpack_require__(/*! ./system_call */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/system_call.js"), exports);
__exportStar(__webpack_require__(/*! ./set_language */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_language.js"), exports);
__exportStar(__webpack_require__(/*! ./call_dialog */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_dialog.js"), exports);
__exportStar(__webpack_require__(/*! ./protected */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/protected.js"), exports);
__exportStar(__webpack_require__(/*! ./public */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/public.js"), exports);
__exportStar(__webpack_require__(/*! ./nodes */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/nodes.js"), exports);
__exportStar(__webpack_require__(/*! ./demand */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/demand.js"), exports);
__exportStar(__webpack_require__(/*! ./supply */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/supply.js"), exports);
__exportStar(__webpack_require__(/*! ./fields */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fields.js"), exports);
__exportStar(__webpack_require__(/*! ./delete_cluster */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_cluster.js"), exports);
__exportStar(__webpack_require__(/*! ./set_margin */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_margin.js"), exports);
__exportStar(__webpack_require__(/*! ./call_database */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_database.js"), exports);
__exportStar(__webpack_require__(/*! ./contexts */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/contexts.js"), exports);
__exportStar(__webpack_require__(/*! ./interface */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface.js"), exports);
__exportStar(__webpack_require__(/*! ./endinterface */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endinterface.js"), exports);
__exportStar(__webpack_require__(/*! ./parameter */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/parameter.js"), exports);
__exportStar(__webpack_require__(/*! ./include */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/include.js"), exports);
__exportStar(__webpack_require__(/*! ./collect */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/collect.js"), exports);
__exportStar(__webpack_require__(/*! ./ranges */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/ranges.js"), exports);
__exportStar(__webpack_require__(/*! ./events */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/events.js"), exports);
__exportStar(__webpack_require__(/*! ./receive */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/receive.js"), exports);
__exportStar(__webpack_require__(/*! ./back */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/back.js"), exports);
__exportStar(__webpack_require__(/*! ./add_corresponding */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/add_corresponding.js"), exports);
__exportStar(__webpack_require__(/*! ./subtract_corresponding */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/subtract_corresponding.js"), exports);
__exportStar(__webpack_require__(/*! ./static_begin */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static_begin.js"), exports);
__exportStar(__webpack_require__(/*! ./static_end */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static_end.js"), exports);
__exportStar(__webpack_require__(/*! ./get_dataset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_dataset.js"), exports);
__exportStar(__webpack_require__(/*! ./tables */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/tables.js"), exports);
__exportStar(__webpack_require__(/*! ./local */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/local.js"), exports);
__exportStar(__webpack_require__(/*! ./add */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/add.js"), exports);
__exportStar(__webpack_require__(/*! ./describe */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/describe.js"), exports);
__exportStar(__webpack_require__(/*! ./submit */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/submit.js"), exports);
__exportStar(__webpack_require__(/*! ./scan */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/scan.js"), exports);
__exportStar(__webpack_require__(/*! ./export */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/export.js"), exports);
__exportStar(__webpack_require__(/*! ./import */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import.js"), exports);
__exportStar(__webpack_require__(/*! ./at_first */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_first.js"), exports);
__exportStar(__webpack_require__(/*! ./at_last */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_last.js"), exports);
__exportStar(__webpack_require__(/*! ./at */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at.js"), exports);
__exportStar(__webpack_require__(/*! ./put */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/put.js"), exports);
__exportStar(__webpack_require__(/*! ./endat */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endat.js"), exports);
__exportStar(__webpack_require__(/*! ./endselect */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endselect.js"), exports);
__exportStar(__webpack_require__(/*! ./refresh */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/refresh.js"), exports);
__exportStar(__webpack_require__(/*! ./shift */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/shift.js"), exports);
__exportStar(__webpack_require__(/*! ./type_mesh */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh.js"), exports);
__exportStar(__webpack_require__(/*! ./transfer */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/transfer.js"), exports);
__exportStar(__webpack_require__(/*! ./subtract */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/subtract.js"), exports);
__exportStar(__webpack_require__(/*! ./unassign */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/unassign.js"), exports);
__exportStar(__webpack_require__(/*! ./open_dataset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/open_dataset.js"), exports);
__exportStar(__webpack_require__(/*! ./close_dataset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/close_dataset.js"), exports);
__exportStar(__webpack_require__(/*! ./interface_load */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_load.js"), exports);
__exportStar(__webpack_require__(/*! ./close_cursor */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/close_cursor.js"), exports);
__exportStar(__webpack_require__(/*! ./leave */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/leave.js"), exports);
__exportStar(__webpack_require__(/*! ./class_definition_load */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/class_definition_load.js"), exports);
__exportStar(__webpack_require__(/*! ./initialization */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/initialization.js"), exports);
__exportStar(__webpack_require__(/*! ./start_of_selection */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/start_of_selection.js"), exports);
__exportStar(__webpack_require__(/*! ./set_blank */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_blank.js"), exports);
__exportStar(__webpack_require__(/*! ./export_dynpro */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/export_dynpro.js"), exports);
__exportStar(__webpack_require__(/*! ./end_of_selection */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_of_selection.js"), exports);
__exportStar(__webpack_require__(/*! ./search */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/search.js"), exports);
__exportStar(__webpack_require__(/*! ./modify_line */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_line.js"), exports);
__exportStar(__webpack_require__(/*! ./selectionscreen */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/selectionscreen.js"), exports);
__exportStar(__webpack_require__(/*! ./free */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/free.js"), exports);
__exportStar(__webpack_require__(/*! ./endon */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endon.js"), exports);
__exportStar(__webpack_require__(/*! ./fetch_next_cursor */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/fetch_next_cursor.js"), exports);
__exportStar(__webpack_require__(/*! ./reserve */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/reserve.js"), exports);
__exportStar(__webpack_require__(/*! ./raise_entity_event */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise_entity_event.js"), exports);
__exportStar(__webpack_require__(/*! ./refresh_control */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/refresh_control.js"), exports);
__exportStar(__webpack_require__(/*! ./delete_dynpro */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_dynpro.js"), exports);
__exportStar(__webpack_require__(/*! ./generate_dynpro */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/generate_dynpro.js"), exports);
__exportStar(__webpack_require__(/*! ./detail */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/detail.js"), exports);
__exportStar(__webpack_require__(/*! ./editor_call */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/editor_call.js"), exports);
__exportStar(__webpack_require__(/*! ./break */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/break.js"), exports);
__exportStar(__webpack_require__(/*! ./delete_textpool */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_textpool.js"), exports);
__exportStar(__webpack_require__(/*! ./get */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get.js"), exports);
__exportStar(__webpack_require__(/*! ./selectoption */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/selectoption.js"), exports);
__exportStar(__webpack_require__(/*! ./convert */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/convert.js"), exports);
__exportStar(__webpack_require__(/*! ./static */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static.js"), exports);
__exportStar(__webpack_require__(/*! ./compute */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/compute.js"), exports);
__exportStar(__webpack_require__(/*! ./multiply */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/multiply.js"), exports);
__exportStar(__webpack_require__(/*! ./divide */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/divide.js"), exports);
__exportStar(__webpack_require__(/*! ./format */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/format.js"), exports);
__exportStar(__webpack_require__(/*! ./syntax_check */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/syntax_check.js"), exports);
__exportStar(__webpack_require__(/*! ./aliases */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/aliases.js"), exports);
__exportStar(__webpack_require__(/*! ./method_def */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/method_def.js"), exports);
__exportStar(__webpack_require__(/*! ./type_mesh_begin */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh_begin.js"), exports);
__exportStar(__webpack_require__(/*! ./type_mesh_end */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh_end.js"), exports);
__exportStar(__webpack_require__(/*! ./interface_def */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_def.js"), exports);
__exportStar(__webpack_require__(/*! ./at_selection_screen */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/at_selection_screen.js"), exports);
__exportStar(__webpack_require__(/*! ./include_type */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/include_type.js"), exports);
__exportStar(__webpack_require__(/*! ./import_dynpro */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/import_dynpro.js"), exports);
__exportStar(__webpack_require__(/*! ./call_function */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_function.js"), exports);
__exportStar(__webpack_require__(/*! ./call_selection_screen */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_selection_screen.js"), exports);
__exportStar(__webpack_require__(/*! ./call_transformation */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_transformation.js"), exports);
__exportStar(__webpack_require__(/*! ./read_line */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_line.js"), exports);
__exportStar(__webpack_require__(/*! ./read_textpool */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_textpool.js"), exports);
__exportStar(__webpack_require__(/*! ./read_report */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_report.js"), exports);
__exportStar(__webpack_require__(/*! ./read_dataset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_dataset.js"), exports);
__exportStar(__webpack_require__(/*! ./get_bit */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_bit.js"), exports);
__exportStar(__webpack_require__(/*! ./get_reference */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_reference.js"), exports);
__exportStar(__webpack_require__(/*! ./insert_report */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_report.js"), exports);
__exportStar(__webpack_require__(/*! ./insert_textpool */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_textpool.js"), exports);
__exportStar(__webpack_require__(/*! ./set_bit */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_bit.js"), exports);
__exportStar(__webpack_require__(/*! ./get_run_time */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_run_time.js"), exports);
__exportStar(__webpack_require__(/*! ./get_parameter */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_parameter.js"), exports);
__exportStar(__webpack_require__(/*! ./create_data */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_data.js"), exports);
__exportStar(__webpack_require__(/*! ./set_country */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_country.js"), exports);
__exportStar(__webpack_require__(/*! ./function_module */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/function_module.js"), exports);
__exportStar(__webpack_require__(/*! ./type_pools */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_pools.js"), exports);
__exportStar(__webpack_require__(/*! ./type_pool */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_pool.js"), exports);
__exportStar(__webpack_require__(/*! ./wait */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/wait.js"), exports);
__exportStar(__webpack_require__(/*! ./overlay */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/overlay.js"), exports);
__exportStar(__webpack_require__(/*! ./set_screen */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_screen.js"), exports);
__exportStar(__webpack_require__(/*! ./set_cursor */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_cursor.js"), exports);
__exportStar(__webpack_require__(/*! ./call_screen */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_screen.js"), exports);
__exportStar(__webpack_require__(/*! ./set_pf_status */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_pf_status.js"), exports);
__exportStar(__webpack_require__(/*! ./set_titlebar */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_titlebar.js"), exports);
__exportStar(__webpack_require__(/*! ./program */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/program.js"), exports);
__exportStar(__webpack_require__(/*! ./function_pool */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/function_pool.js"), exports);
__exportStar(__webpack_require__(/*! ./module */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/module.js"), exports);
__exportStar(__webpack_require__(/*! ./endmodule */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endmodule.js"), exports);
__exportStar(__webpack_require__(/*! ./endfunction */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endfunction.js"), exports);
__exportStar(__webpack_require__(/*! ./retry */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/retry.js"), exports);
__exportStar(__webpack_require__(/*! ./authority_check */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/authority_check.js"), exports);
__exportStar(__webpack_require__(/*! ./set_parameter */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_parameter.js"), exports);
__exportStar(__webpack_require__(/*! ./get_cursor */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_cursor.js"), exports);
__exportStar(__webpack_require__(/*! ./call_kernel */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_kernel.js"), exports);
__exportStar(__webpack_require__(/*! ./call_transaction */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_transaction.js"), exports);
__exportStar(__webpack_require__(/*! ./unpack */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/unpack.js"), exports);
__exportStar(__webpack_require__(/*! ./skip */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/skip.js"), exports);
__exportStar(__webpack_require__(/*! ./uline */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/uline.js"), exports);
__exportStar(__webpack_require__(/*! ./data_begin */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data_begin.js"), exports);
__exportStar(__webpack_require__(/*! ./data_end */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/data_end.js"), exports);
__exportStar(__webpack_require__(/*! ./type_begin */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_begin.js"), exports);
__exportStar(__webpack_require__(/*! ./type_end */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_end.js"), exports);
__exportStar(__webpack_require__(/*! ./raise_event */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise_event.js"), exports);
__exportStar(__webpack_require__(/*! ./cleanup */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/cleanup.js"), exports);
__exportStar(__webpack_require__(/*! ./create_ole */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/create_ole.js"), exports);
__exportStar(__webpack_require__(/*! ./call_ole */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/call_ole.js"), exports);
__exportStar(__webpack_require__(/*! ./set_property */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_property.js"), exports);
__exportStar(__webpack_require__(/*! ./test_injection */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/test_injection.js"), exports);
__exportStar(__webpack_require__(/*! ./end_test_injection */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_test_injection.js"), exports);
__exportStar(__webpack_require__(/*! ./test_seam */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/test_seam.js"), exports);
__exportStar(__webpack_require__(/*! ./end_test_seam */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_test_seam.js"), exports);
__exportStar(__webpack_require__(/*! ./delete_memory */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/delete_memory.js"), exports);
__exportStar(__webpack_require__(/*! ./provide */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/provide.js"), exports);
__exportStar(__webpack_require__(/*! ./endexec */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/endexec.js"), exports);
__exportStar(__webpack_require__(/*! ./sort_dataset */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sort_dataset.js"), exports);
__exportStar(__webpack_require__(/*! ./get_permissions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/get_permissions.js"), exports);
__exportStar(__webpack_require__(/*! ./set_locks */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_locks.js"), exports);
__exportStar(__webpack_require__(/*! ./enhancement */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/enhancement.js"), exports);
__exportStar(__webpack_require__(/*! ./end_enhancement */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/end_enhancement.js"), exports);
__exportStar(__webpack_require__(/*! ./form_definition */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/form_definition.js"), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/infotypes.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/infotypes.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Infotypes = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Infotypes {
    getMatcher() {
        const occurs = (0, combi_1.seq)("OCCURS", expressions_1.Constant);
        const name = (0, combi_1.seq)("NAME", expressions_1.Field);
        const ret = (0, combi_1.seq)("INFOTYPES", expressions_1.Constant, (0, combi_1.optPrio)(occurs), (0, combi_1.optPrio)(name));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Infotypes = Infotypes;
//# sourceMappingURL=infotypes.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/initialization.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/initialization.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Initialization = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Initialization {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "INITIALIZATION");
    }
}
exports.Initialization = Initialization;
//# sourceMappingURL=initialization.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_database.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_database.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InsertDatabase = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class InsertDatabase {
    getMatcher() {
        const sub = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WParenLeftW), expressions_1.Select, (0, combi_1.tok)(tokens_1.WParenRightW));
        const f = (0, combi_1.seq)((0, combi_1.opt)(expressions_1.SQLClient), (0, combi_1.opt)(expressions_1.DatabaseConnection), "FROM", (0, combi_1.opt)("TABLE"), (0, combi_1.alt)(expressions_1.SQLSource, sub), (0, combi_1.opt)("ACCEPTING DUPLICATE KEYS"));
        const from = (0, combi_1.seq)(expressions_1.DatabaseTable, (0, combi_1.opt)((0, combi_1.alt)(f, expressions_1.SQLClient, expressions_1.DatabaseConnection)));
        const into = (0, combi_1.seq)("INTO", expressions_1.DatabaseTable, (0, combi_1.opt)(expressions_1.SQLClient), (0, combi_1.opt)(expressions_1.DatabaseConnection), "VALUES", expressions_1.SQLSource);
        return (0, combi_1.seq)("INSERT", (0, combi_1.alt)(from, into));
    }
}
exports.InsertDatabase = InsertDatabase;
//# sourceMappingURL=insert_database.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_field_group.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_field_group.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InsertFieldGroup = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class InsertFieldGroup {
    getMatcher() {
        const into = (0, combi_1.seq)("INTO", expressions_1.Target);
        const src = (0, combi_1.alt)((0, combi_1.ver)(version_1.Version.v740sp02, (0, combi_1.plus)(expressions_1.Source)), (0, combi_1.plus)(expressions_1.SimpleSource1));
        const ret = (0, combi_1.seq)("INSERT", src, into);
        return ret;
    }
}
exports.InsertFieldGroup = InsertFieldGroup;
//# sourceMappingURL=insert_field_group.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_internal.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_internal.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InsertInternal = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class InsertInternal {
    getMatcher() {
        const target = (0, combi_1.altPrio)(expressions_1.Source, expressions_1.Dynamic);
        const assigning = (0, combi_1.seq)("ASSIGNING", expressions_1.FSTarget);
        const ref = (0, combi_1.seq)("REFERENCE INTO", expressions_1.Target);
        const index = (0, combi_1.seq)("INDEX", expressions_1.Source);
        const initial = (0, combi_1.str)("INITIAL LINE");
        const into = (0, combi_1.seq)("INTO", expressions_1.Target);
        const intoTable = (0, combi_1.seq)("INTO TABLE", expressions_1.Target, (0, combi_1.opt)((0, combi_1.alt)(ref, assigning)));
        const to = (0, combi_1.seq)("TO", expressions_1.Source);
        const from = (0, combi_1.seq)("FROM", expressions_1.Source);
        const fromTo = (0, combi_1.opt)((0, combi_1.per)(from, to));
        const foo = (0, combi_1.alt)(intoTable, (0, combi_1.seq)(into, (0, combi_1.opt)((0, combi_1.per)(index, (0, combi_1.alt)(ref, assigning)))), (0, combi_1.per)(index, (0, combi_1.alt)(ref, assigning)));
        const lines = (0, combi_1.seq)("LINES OF", target, (0, combi_1.opt)(fromTo));
        const src = (0, combi_1.alt)(expressions_1.SimpleSource4, (0, combi_1.ver)(version_1.Version.v740sp02, expressions_1.Source));
        const tab = (0, combi_1.seq)("TABLE", expressions_1.Source);
        const ret = (0, combi_1.seq)("INSERT", (0, combi_1.altPrio)(tab, (0, combi_1.seq)((0, combi_1.altPrio)(initial, lines, src), foo)));
        return ret;
    }
}
exports.InsertInternal = InsertInternal;
//# sourceMappingURL=insert_internal.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_report.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_report.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InsertReport = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class InsertReport {
    getMatcher() {
        const options = (0, combi_1.per)((0, combi_1.seq)("STATE", expressions_1.Source), (0, combi_1.seq)("EXTENSION TYPE", expressions_1.Source), (0, combi_1.seq)("DIRECTORY ENTRY", expressions_1.Source), (0, combi_1.seq)("UNICODE ENABLING", expressions_1.Source), (0, combi_1.seq)("PROGRAM TYPE", expressions_1.Source), (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("VERSION", expressions_1.Source)), (0, combi_1.seq)("FIXED-POINT ARITHMETIC", expressions_1.Source), "KEEPING DIRECTORY ENTRY");
        const ret = (0, combi_1.seq)("INSERT REPORT", expressions_1.Source, "FROM", expressions_1.Source, (0, combi_1.opt)(options));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.InsertReport = InsertReport;
//# sourceMappingURL=insert_report.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_textpool.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/insert_textpool.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InsertTextpool = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class InsertTextpool {
    getMatcher() {
        const state = (0, combi_1.seq)("STATE", expressions_1.Source);
        const language = (0, combi_1.seq)("LANGUAGE", expressions_1.Source);
        const ret = (0, combi_1.seq)("INSERT TEXTPOOL", expressions_1.Source, "FROM", expressions_1.Source, (0, combi_1.opt)(language), (0, combi_1.opt)(state));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.InsertTextpool = InsertTextpool;
//# sourceMappingURL=insert_textpool.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Interface = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Interface {
    getMatcher() {
        return (0, combi_1.seq)("INTERFACE", expressions_1.InterfaceName, (0, combi_1.opt)(expressions_1.ClassGlobal));
    }
}
exports.Interface = Interface;
//# sourceMappingURL=interface.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_def.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_def.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InterfaceDef = void 0;
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class InterfaceDef {
    getMatcher() {
        const val = (0, combi_1.seq)(expressions_1.AttributeName, "=", expressions_1.Source);
        const dataValues = (0, combi_1.seq)("DATA VALUES", (0, combi_1.plus)(val));
        const options = (0, combi_1.alt)(expressions_1.AbstractMethods, expressions_1.FinalMethods, "ALL METHODS ABSTRACT", "ALL METHODS FINAL", (0, combi_1.ver)(version_1.Version.v740sp02, "PARTIALLY IMPLEMENTED"));
        return (0, combi_1.seq)("INTERFACES", expressions_1.InterfaceName, (0, combi_1.opt)(options), (0, combi_1.opt)(dataValues));
    }
}
exports.InterfaceDef = InterfaceDef;
//# sourceMappingURL=interface_def.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_deferred.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_deferred.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InterfaceDeferred = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class InterfaceDeferred {
    getMatcher() {
        return (0, combi_1.seq)("INTERFACE", expressions_1.InterfaceName, "DEFERRED", (0, combi_1.opt)("PUBLIC"));
    }
}
exports.InterfaceDeferred = InterfaceDeferred;
//# sourceMappingURL=interface_deferred.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_load.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/interface_load.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InterfaceLoad = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class InterfaceLoad {
    getMatcher() {
        return (0, combi_1.seq)("INTERFACE", expressions_1.InterfaceName, "LOAD");
    }
}
exports.InterfaceLoad = InterfaceLoad;
//# sourceMappingURL=interface_load.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/leave.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/leave.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Leave = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Leave {
    getMatcher() {
        const retu = (0, combi_1.seq)(expressions_1.AndReturn, "TO SCREEN", expressions_1.Source);
        const transaction = (0, combi_1.seq)("TO TRANSACTION", expressions_1.Source, (0, combi_1.opt)("AND SKIP FIRST SCREEN"));
        const ret = (0, combi_1.seq)("LEAVE", (0, combi_1.opt)((0, combi_1.alt)("TO CURRENT TRANSACTION", (0, combi_1.seq)((0, combi_1.opt)("TO"), "LIST-PROCESSING", (0, combi_1.opt)(retu)), "LIST-PROCESSING", "SCREEN", transaction, "PROGRAM", (0, combi_1.seq)("TO SCREEN", expressions_1.Source))));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Leave = Leave;
//# sourceMappingURL=leave.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/load_of_program.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/load_of_program.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoadOfProgram = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class LoadOfProgram {
    getMatcher() {
        const ret = (0, combi_1.str)("LOAD-OF-PROGRAM");
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.LoadOfProgram = LoadOfProgram;
//# sourceMappingURL=load_of_program.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/load_report.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/load_report.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoadReport = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class LoadReport {
    getMatcher() {
        const ret = (0, combi_1.seq)("LOAD REPORT", expressions_1.Source, "PART", expressions_1.Source, "INTO", expressions_1.Target);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.LoadReport = LoadReport;
//# sourceMappingURL=load_report.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/local.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/local.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Local = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Local {
    getMatcher() {
        const ret = (0, combi_1.seq)("LOCAL", expressions_1.FieldSub, (0, combi_1.opt)(expressions_1.TableBody));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Local = Local;
//# sourceMappingURL=local.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/log_point.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/log_point.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LogPoint = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class LogPoint {
    getMatcher() {
        const subkey = (0, combi_1.seq)("SUBKEY", expressions_1.Source);
        const fields = (0, combi_1.seq)("FIELDS", (0, combi_1.plus)(expressions_1.Source));
        const ret = (0, combi_1.seq)("LOG-POINT ID", expressions_1.NamespaceSimpleName, (0, combi_1.opt)(subkey), (0, combi_1.opt)(fields));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.LogPoint = LogPoint;
//# sourceMappingURL=log_point.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/loop.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/loop.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Loop = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const simple_source2_1 = __webpack_require__(/*! ../expressions/simple_source2 */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/simple_source2.js");
const loop_group_by_1 = __webpack_require__(/*! ../expressions/loop_group_by */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/loop_group_by.js");
class Loop {
    getMatcher() {
        const where = (0, combi_1.seq)("WHERE", (0, combi_1.alt)(expressions_1.ComponentCond, expressions_1.Dynamic));
        const group = (0, combi_1.ver)(version_1.Version.v740sp08, (0, combi_1.seq)("GROUP BY", loop_group_by_1.LoopGroupBy));
        const step = (0, combi_1.ver)(version_1.Version.v757, (0, combi_1.seq)("STEP", expressions_1.Source));
        const from = (0, combi_1.seq)("FROM", expressions_1.Source);
        const to = (0, combi_1.seq)("TO", expressions_1.Source);
        const usingKey = (0, combi_1.seq)("USING KEY", (0, combi_1.altPrio)(expressions_1.SimpleName, expressions_1.Dynamic));
        const options = (0, combi_1.per)(expressions_1.LoopTarget, from, to, where, usingKey, group, step);
        const at = (0, combi_1.seq)("AT", (0, combi_1.opt)((0, combi_1.seq)("SCREEN", (0, combi_1.failCombinator)())), (0, combi_1.opt)((0, combi_1.ver)(version_1.Version.v740sp08, "GROUP")), (0, combi_1.alt)(simple_source2_1.SimpleSource2, (0, combi_1.ver)(version_1.Version.v740sp02, expressions_1.Source)), (0, combi_1.opt)(options));
        return (0, combi_1.seq)("LOOP", (0, combi_1.opt)(at));
    }
}
exports.Loop = Loop;
//# sourceMappingURL=loop.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/loop_at_screen.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/loop_at_screen.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoopAtScreen = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class LoopAtScreen {
    getMatcher() {
        const l = (0, combi_1.seq)("LOOP AT SCREEN", (0, combi_1.opt)((0, combi_1.seq)("INTO", expressions_1.Target)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, l);
    }
}
exports.LoopAtScreen = LoopAtScreen;
//# sourceMappingURL=loop_at_screen.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/message.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/message.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Message = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Message {
    getMatcher() {
        const s = (0, combi_1.alt)((0, combi_1.ver)(version_1.Version.v740sp02, expressions_1.Source), expressions_1.SimpleSource3);
        const like = (0, combi_1.seq)("DISPLAY LIKE", expressions_1.Source);
        const into = (0, combi_1.seq)("INTO", expressions_1.Target);
        const raising = (0, combi_1.seq)("RAISING", expressions_1.ExceptionName);
        const options = (0, combi_1.per)(like, into, raising);
        const type = (0, combi_1.seq)("TYPE", expressions_1.Source);
        const sou = (0, combi_1.altPrio)(options, s);
        const sourc = (0, combi_1.alt)(sou, (0, combi_1.seq)(s, sou), (0, combi_1.seq)(s, s, sou), (0, combi_1.seq)(s, s, s, options));
        const mwith = (0, combi_1.seq)("WITH", s, (0, combi_1.opt)(sourc));
        const foo = (0, combi_1.seq)(expressions_1.MessageSource, (0, combi_1.opt)(options), (0, combi_1.opt)(mwith));
        const text = (0, combi_1.seq)(s, type, (0, combi_1.optPrio)(like), (0, combi_1.optPrio)(raising));
        const cloud1 = (0, combi_1.seq)((0, combi_1.opt)((0, combi_1.seq)("WITH", expressions_1.Source, (0, combi_1.opt)(expressions_1.Source), (0, combi_1.opt)(expressions_1.Source), (0, combi_1.opt)(expressions_1.Source))), (0, combi_1.altPrio)(into, raising));
        const cloud2 = (0, combi_1.seq)((0, combi_1.altPrio)(into, raising), (0, combi_1.opt)((0, combi_1.seq)("WITH", expressions_1.Source, (0, combi_1.opt)(expressions_1.Source), (0, combi_1.opt)(expressions_1.Source), (0, combi_1.opt)(expressions_1.Source))));
        const cloud = (0, combi_1.seq)(expressions_1.MessageSource, (0, combi_1.alt)(cloud1, cloud2));
        const ret = (0, combi_1.seq)("MESSAGE", (0, combi_1.altPrio)((0, combi_1.verNot)(version_1.Version.Cloud, foo), (0, combi_1.verNot)(version_1.Version.Cloud, text), (0, combi_1.ver)(version_1.Version.Cloud, cloud)));
        return ret;
    }
}
exports.Message = Message;
//# sourceMappingURL=message.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/method_def.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/method_def.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodDef = void 0;
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodDef {
    getMatcher() {
        const def = (0, combi_1.ver)(version_1.Version.v740sp08, (0, combi_1.seq)("DEFAULT", (0, combi_1.altPrio)("FAIL", "IGNORE")));
        const parameters = (0, combi_1.seq)((0, combi_1.optPrio)((0, combi_1.altPrio)("FINAL", def, expressions_1.Abstract)), (0, combi_1.optPrio)(expressions_1.MethodDefImporting), (0, combi_1.optPrio)(expressions_1.MethodDefExporting), (0, combi_1.optPrio)(expressions_1.MethodDefChanging), (0, combi_1.optPrio)(expressions_1.MethodDefReturning), (0, combi_1.optPrio)((0, combi_1.altPrio)(expressions_1.MethodDefRaising, expressions_1.MethodDefExceptions)));
        const testing = (0, combi_1.seq)((0, combi_1.optPrio)(expressions_1.Abstract), "FOR TESTING", (0, combi_1.optPrio)((0, combi_1.altPrio)(expressions_1.MethodDefRaising, expressions_1.MethodDefExceptions)));
        // todo, this is only from version something
        const tableFunction = (0, combi_1.seq)("TABLE FUNCTION", (0, combi_1.regex)(/^\w+?$/));
        // todo, this is only from version something
        const ddl = "DDL OBJECT OPTIONS CDS SESSION CLIENT REQUIRED";
        const result = (0, combi_1.seq)("RESULT", expressions_1.MethodParamName);
        const link = (0, combi_1.seq)("LINK", expressions_1.MethodParamName);
        const full = (0, combi_1.seq)("FULL", expressions_1.MethodParamName);
        const modify = (0, combi_1.alt)((0, combi_1.seq)("FOR ACTION", expressions_1.TypeName, (0, combi_1.optPrio)(result)), (0, combi_1.seq)("FOR CREATE", (0, combi_1.alt)(expressions_1.TypeName, expressions_1.EntityAssociation)), (0, combi_1.seq)("FOR DELETE", expressions_1.TypeName), (0, combi_1.seq)("FOR UPDATE", expressions_1.TypeName));
        const behavior = (0, combi_1.altPrio)((0, combi_1.seq)("VALIDATE ON SAVE IMPORTING", expressions_1.MethodParamName, "FOR", expressions_1.TypeName), (0, combi_1.seq)("MODIFY IMPORTING", expressions_1.MethodParamName, modify), (0, combi_1.seq)("READ IMPORTING", expressions_1.MethodParamName, "FOR READ", (0, combi_1.alt)(expressions_1.TypeName, expressions_1.EntityAssociation), (0, combi_1.optPrio)(full), result, (0, combi_1.optPrio)(link)), (0, combi_1.seq)("FEATURES IMPORTING", expressions_1.MethodParamName, "REQUEST", expressions_1.NamespaceSimpleName, "FOR", expressions_1.NamespaceSimpleName, result), (0, combi_1.seq)("BEHAVIOR IMPORTING", expressions_1.MethodParamName, "FOR CREATE", expressions_1.TypeName, expressions_1.MethodParamName, "FOR UPDATE", expressions_1.TypeName, expressions_1.MethodParamName, "FOR DELETE", expressions_1.TypeName), (0, combi_1.seq)("BEHAVIOR IMPORTING", expressions_1.MethodParamName, "FOR READ", expressions_1.TypeName, result), (0, combi_1.seq)((0, combi_1.alt)("BEHAVIOR", "LOCK"), "IMPORTING", expressions_1.MethodParamName, "FOR LOCK", expressions_1.TypeName), (0, combi_1.seq)("DETERMINE", (0, combi_1.alt)("ON MODIFY", "ON SAVE"), "IMPORTING", expressions_1.MethodParamName, "FOR", expressions_1.TypeName), (0, combi_1.seq)("GLOBAL AUTHORIZATION IMPORTING REQUEST", expressions_1.MethodParamName, "FOR", expressions_1.TypeName, result), (0, combi_1.seq)("INSTANCE AUTHORIZATION IMPORTING", expressions_1.MethodParamName, "REQUEST", expressions_1.MethodParamName, "FOR", expressions_1.TypeName, result));
        // todo, this is only from version something
        const amdp = (0, combi_1.seq)("AMDP OPTIONS CDS SESSION CLIENT CURRENT", (0, combi_1.optPrio)(expressions_1.MethodDefImporting), (0, combi_1.optPrio)(expressions_1.MethodDefExporting), (0, combi_1.optPrio)(expressions_1.MethodDefRaising));
        const ret = (0, combi_1.seq)((0, combi_1.altPrio)("CLASS-METHODS", "METHODS"), expressions_1.MethodName, (0, combi_1.alt)((0, combi_1.seq)((0, combi_1.optPrio)(expressions_1.Abstract), expressions_1.EventHandler), parameters, testing, (0, combi_1.seq)("FOR", (0, combi_1.alt)(tableFunction, ddl, behavior)), amdp, "NOT AT END OF MODE", (0, combi_1.optPrio)(expressions_1.Redefinition)));
        return ret;
    }
}
exports.MethodDef = MethodDef;
//# sourceMappingURL=method_def.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/method_implementation.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/method_implementation.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MethodImplementation = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class MethodImplementation {
    getMatcher() {
        const name = (0, combi_1.regex)(/[\w~]+/);
        const kernel = (0, combi_1.seq)("KERNEL MODULE", (0, combi_1.plus)(name), (0, combi_1.optPrio)((0, combi_1.altPrio)("FAIL", "IGNORE")));
        const using = (0, combi_1.seq)("USING", (0, combi_1.plus)(expressions_1.SimpleFieldChain));
        const database = (0, combi_1.seq)("DATABASE", (0, combi_1.alt)("PROCEDURE", "FUNCTION", "GRAPH WORKSPACE"), "FOR HDB", expressions_1.Language, (0, combi_1.opt)("OPTIONS READ-ONLY"), (0, combi_1.opt)(using));
        const by = (0, combi_1.seq)("BY", (0, combi_1.alt)(kernel, database));
        return (0, combi_1.seq)("METHOD", expressions_1.MethodName, (0, combi_1.optPrio)(by));
    }
}
exports.MethodImplementation = MethodImplementation;
//# sourceMappingURL=method_implementation.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_database.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_database.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModifyDatabase = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ModifyDatabase {
    getMatcher() {
        const from = (0, combi_1.seq)("FROM", (0, combi_1.opt)("TABLE"), expressions_1.SQLSource);
        const options = (0, combi_1.per)(expressions_1.DatabaseConnection, from, expressions_1.SQLClient);
        return (0, combi_1.seq)("MODIFY", expressions_1.DatabaseTable, options);
    }
}
exports.ModifyDatabase = ModifyDatabase;
//# sourceMappingURL=modify_database.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_entities.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_entities.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModifyEntities = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ModifyEntities {
    getMatcher() {
        const fieldsWith = (0, combi_1.seq)("FIELDS (", (0, combi_1.plus)(expressions_1.SimpleName), ") WITH", expressions_1.Source);
        const operation = (0, combi_1.alt)((0, combi_1.seq)("UPDATE SET FIELDS WITH", expressions_1.Source), (0, combi_1.seq)("CREATE SET FIELDS WITH", expressions_1.Source), (0, combi_1.seq)("UPDATE", fieldsWith), (0, combi_1.seq)("DELETE FROM", expressions_1.Source), (0, combi_1.seq)("EXECUTE", expressions_1.SimpleName, "FROM", expressions_1.Source), (0, combi_1.seq)("CREATE", (0, combi_1.optPrio)("AUTO FILL CID"), fieldsWith));
        const s = (0, combi_1.seq)("MODIFY ENTITIES OF", expressions_1.NamespaceSimpleName, (0, combi_1.opt)("IN LOCAL MODE"), "ENTITY", expressions_1.SimpleName, operation, (0, combi_1.per)((0, combi_1.seq)("FAILED", expressions_1.Target), (0, combi_1.seq)("RESULT", expressions_1.Target), (0, combi_1.seq)("MAPPED", expressions_1.Target), (0, combi_1.seq)("REPORTED", expressions_1.Target)));
        return (0, combi_1.ver)(version_1.Version.v754, s);
    }
}
exports.ModifyEntities = ModifyEntities;
//# sourceMappingURL=modify_entities.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_internal.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_internal.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModifyInternal = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class ModifyInternal {
    getMatcher() {
        const index = (0, combi_1.seq)("INDEX", expressions_1.Source);
        const from = (0, combi_1.seq)("FROM", expressions_1.Source);
        const transporting = (0, combi_1.seq)("TRANSPORTING", (0, combi_1.plus)((0, combi_1.alt)(expressions_1.ComponentChainSimple, expressions_1.Dynamic)));
        const where = (0, combi_1.seq)("WHERE", expressions_1.ComponentCond);
        const assigning = (0, combi_1.seq)("ASSIGNING", expressions_1.FSTarget);
        const using = (0, combi_1.seq)("USING KEY", expressions_1.SimpleName);
        const additions = (0, combi_1.per)(where, assigning, using);
        const target = (0, combi_1.alt)(expressions_1.Target, expressions_1.Dynamic);
        const options = (0, combi_1.alt)((0, combi_1.per)(index, transporting), (0, combi_1.seq)(from, (0, combi_1.opt)((0, combi_1.per)(index, transporting))), (0, combi_1.seq)((0, combi_1.per)(index, transporting), from, (0, combi_1.opt)((0, combi_1.per)(index, transporting))));
        const long = (0, combi_1.seq)("MODIFY", (0, combi_1.opt)("TABLE"), target, (0, combi_1.opt)(options), (0, combi_1.opt)(additions));
        const simple = (0, combi_1.seq)("MODIFY TABLE", target, from, (0, combi_1.opt)(using));
        return (0, combi_1.alt)(long, simple);
    }
}
exports.ModifyInternal = ModifyInternal;
//# sourceMappingURL=modify_internal.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_line.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_line.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModifyLine = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ModifyLine {
    getMatcher() {
        const form = (0, combi_1.seq)((0, combi_1.alt)("INVERSE", "INPUT"), "=", expressions_1.Source);
        const from = (0, combi_1.seq)("FROM", expressions_1.Source);
        const value = (0, combi_1.seq)("FIELD VALUE", (0, combi_1.plus)((0, combi_1.seq)(expressions_1.Source, (0, combi_1.optPrio)(from))));
        const format = (0, combi_1.seq)("FIELD FORMAT", expressions_1.Source, (0, combi_1.opt)(form));
        const lineValue = (0, combi_1.seq)("LINE VALUE FROM", expressions_1.Source);
        const index = (0, combi_1.seq)("INDEX", expressions_1.Source);
        const page = (0, combi_1.seq)("OF PAGE", expressions_1.Source);
        const ocp = (0, combi_1.str)("OF CURRENT PAGE");
        const lineFormat = (0, combi_1.seq)("LINE FORMAT", (0, combi_1.alt)("INPUT OFF", "INVERSE", "RESET", "INTENSIFIED"));
        const onOff = (0, combi_1.alt)("ON", "OFF");
        const intensified = (0, combi_1.seq)("INTENSIFIED", onOff);
        const options = (0, combi_1.per)(index, value, format, page, lineFormat, lineValue, ocp, intensified, expressions_1.Color);
        const ret = (0, combi_1.seq)("MODIFY", (0, combi_1.altPrio)("CURRENT LINE", (0, combi_1.seq)("LINE", expressions_1.Source)), (0, combi_1.opt)(options));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ModifyLine = ModifyLine;
//# sourceMappingURL=modify_line.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_screen.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/modify_screen.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModifyScreen = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ModifyScreen {
    getMatcher() {
        const ret = (0, combi_1.seq)("MODIFY SCREEN", (0, combi_1.opt)((0, combi_1.seq)("FROM", expressions_1.Source)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ModifyScreen = ModifyScreen;
//# sourceMappingURL=modify_screen.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/module.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/module.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Module = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Module {
    getMatcher() {
        const ret = (0, combi_1.seq)("MODULE", expressions_1.FormName, (0, combi_1.opt)((0, combi_1.alt)("INPUT", "OUTPUT")));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Module = Module;
//# sourceMappingURL=module.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/move.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/move.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Move = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class Move {
    getMatcher() {
        const mov = (0, combi_1.verNot)(version_1.Version.Cloud, "MOVE");
        const move = (0, combi_1.seq)(mov, (0, combi_1.altPrio)((0, combi_1.seq)("EXACT", expressions_1.Source, "TO", expressions_1.Target), (0, combi_1.seq)(expressions_1.Source, (0, combi_1.altPrio)("?TO", "TO"), expressions_1.Target)));
        const calcAssign = (0, combi_1.ver)(version_1.Version.v754, (0, combi_1.alt)((0, combi_1.seq)((0, combi_1.tok)(tokens_1.WPlus), "="), (0, combi_1.seq)((0, combi_1.tok)(tokens_1.WDash), "="), "/=", "*=", "&&="));
        const chained = (0, combi_1.seq)("=", (0, combi_1.star)((0, combi_1.seq)(expressions_1.Target, "=")));
        const equals = (0, combi_1.altPrio)((0, combi_1.altPrio)(chained, "?="), calcAssign);
        // todo, move "?=" to CAST?
        const eq = (0, combi_1.seq)(expressions_1.Target, equals, expressions_1.Source);
        return (0, combi_1.altPrio)(move, eq);
    }
}
exports.Move = Move;
//# sourceMappingURL=move.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/move_corresponding.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/move_corresponding.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveCorresponding = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class MoveCorresponding {
    getMatcher() {
        const keeping = (0, combi_1.ver)(version_1.Version.v740sp05, "KEEPING TARGET LINES");
        const expanding = (0, combi_1.ver)(version_1.Version.v740sp05, "EXPANDING NESTED TABLES");
        const move = (0, combi_1.seq)("MOVE-CORRESPONDING", (0, combi_1.optPrio)("EXACT"), expressions_1.Source, "TO", 
        // inline defintions not possible in this position,
        expressions_1.SimpleTarget, (0, combi_1.optPrio)(expanding), (0, combi_1.optPrio)(keeping));
        return move;
    }
}
exports.MoveCorresponding = MoveCorresponding;
//# sourceMappingURL=move_corresponding.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/multiply.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/multiply.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Multiply = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Multiply {
    getMatcher() {
        const ret = (0, combi_1.seq)("MULTIPLY", expressions_1.Target, "BY", expressions_1.Source);
        return ret;
    }
}
exports.Multiply = Multiply;
//# sourceMappingURL=multiply.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/new_line.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/new_line.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NewLine = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class NewLine {
    getMatcher() {
        const ret = (0, combi_1.seq)("NEW-LINE", (0, combi_1.opt)((0, combi_1.alt)("SCROLLING", "NO-SCROLLING")));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.NewLine = NewLine;
//# sourceMappingURL=new_line.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/new_page.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/new_page.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NewPage = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class NewPage {
    getMatcher() {
        const line = (0, combi_1.seq)("LINE-SIZE", expressions_1.Source);
        const print = (0, combi_1.seq)("PRINT", (0, combi_1.alt)("OFF", "ON"));
        const parameters = (0, combi_1.seq)("PARAMETERS", expressions_1.Source);
        const destination = (0, combi_1.seq)("DESTINATION", expressions_1.Source);
        const archive = (0, combi_1.seq)("ARCHIVE PARAMETERS", expressions_1.Source);
        const lineCount = (0, combi_1.seq)("LINE-COUNT", expressions_1.Source);
        const coverText = (0, combi_1.seq)("COVER TEXT", expressions_1.Source);
        const coverPage = (0, combi_1.seq)("SAP COVER PAGE", expressions_1.Source);
        const immediately = (0, combi_1.seq)("IMMEDIATELY", expressions_1.Source);
        const keep = (0, combi_1.seq)("KEEP IN SPOOL", expressions_1.Source);
        const layout = (0, combi_1.seq)("LAYOUT", expressions_1.Source);
        const listAuth = (0, combi_1.seq)("LIST AUTHORITY", expressions_1.Source);
        const dataset = (0, combi_1.seq)("LIST DATASET", expressions_1.Source);
        const name = (0, combi_1.seq)("LIST NAME", expressions_1.Source);
        const newList = (0, combi_1.seq)("NEW LIST IDENTIFICATION", expressions_1.Source);
        const ret = (0, combi_1.seq)("NEW-PAGE", (0, combi_1.opt)((0, combi_1.per)(print, (0, combi_1.alt)("NO-TITLE", "WITH-TITLE"), (0, combi_1.alt)("NO-HEADING", "WITH-HEADING"), "NO DIALOG", parameters, listAuth, immediately, dataset, coverPage, newList, keep, name, layout, destination, coverText, archive, "NEW-SECTION", lineCount, line)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.NewPage = NewPage;
//# sourceMappingURL=new_page.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/nodes.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/nodes.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Nodes = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Nodes {
    getMatcher() {
        const ret = (0, combi_1.seq)("NODES", expressions_1.Field);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Nodes = Nodes;
//# sourceMappingURL=nodes.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/on_change.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/on_change.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OnChange = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class OnChange {
    getMatcher() {
        const or = (0, combi_1.seq)("OR", expressions_1.Target);
        const ret = (0, combi_1.seq)("ON CHANGE OF", expressions_1.Target, (0, combi_1.star)(or));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.OnChange = OnChange;
//# sourceMappingURL=on_change.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/open_cursor.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/open_cursor.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OpenCursor = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class OpenCursor {
    getMatcher() {
        const ret = (0, combi_1.seq)("OPEN CURSOR", (0, combi_1.optPrio)("WITH HOLD"), expressions_1.SQLTarget, "FOR", expressions_1.Select);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.OpenCursor = OpenCursor;
//# sourceMappingURL=open_cursor.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/open_dataset.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/open_dataset.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OpenDataset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class OpenDataset {
    getMatcher() {
        const mode = (0, combi_1.seq)("IN", (0, combi_1.opt)("LEGACY"), (0, combi_1.altPrio)("BINARY MODE", "TEXT MODE"));
        const code = (0, combi_1.seq)("CODE PAGE", expressions_1.Source);
        const direction = (0, combi_1.seq)("FOR", (0, combi_1.altPrio)("OUTPUT", "INPUT", "UPDATE", "APPENDING"));
        const encoding = (0, combi_1.seq)("ENCODING", (0, combi_1.altPrio)("DEFAULT", "UTF-8", "NON-UNICODE"));
        const pos = (0, combi_1.seq)("AT POSITION", expressions_1.Source);
        const message = (0, combi_1.seq)("MESSAGE", expressions_1.Target);
        const ignoring = (0, combi_1.str)("IGNORING CONVERSION ERRORS");
        const replacement = (0, combi_1.seq)("REPLACEMENT CHARACTER", expressions_1.Source);
        const bom = (0, combi_1.str)("SKIPPING BYTE-ORDER MARK");
        const wbom = (0, combi_1.str)("WITH BYTE-ORDER MARK");
        const type = (0, combi_1.seq)("TYPE", expressions_1.Source);
        const filter = (0, combi_1.seq)("FILTER", expressions_1.Source);
        const linetype = (0, combi_1.altPrio)("SMART", "NATIVE", "UNIX");
        const feed = (0, combi_1.seq)("WITH", linetype, "LINEFEED");
        const windows = (0, combi_1.str)("WITH WINDOWS LINEFEED");
        const ret = (0, combi_1.seq)("OPEN DATASET", expressions_1.Source, (0, combi_1.per)(direction, type, mode, wbom, replacement, filter, encoding, pos, message, ignoring, bom, code, feed, windows));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.OpenDataset = OpenDataset;
//# sourceMappingURL=open_dataset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/overlay.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/overlay.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Overlay = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Overlay {
    getMatcher() {
        const only = (0, combi_1.seq)("ONLY", expressions_1.Source);
        const ret = (0, combi_1.seq)("OVERLAY", expressions_1.Target, "WITH", expressions_1.Source, (0, combi_1.opt)(only));
        return ret;
    }
}
exports.Overlay = Overlay;
//# sourceMappingURL=overlay.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/pack.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/pack.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Pack = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Pack {
    getMatcher() {
        const ret = (0, combi_1.seq)("PACK", expressions_1.Source, "TO", expressions_1.Target);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Pack = Pack;
//# sourceMappingURL=pack.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/parameter.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/parameter.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Parameter = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Parameter {
    getMatcher() {
        const para = (0, combi_1.altPrio)("PARAMETER", "PARAMETERS");
        const def = (0, combi_1.seq)("DEFAULT", (0, combi_1.altPrio)(expressions_1.Constant, expressions_1.FieldChain));
        const radio = (0, combi_1.seq)("RADIOBUTTON GROUP", expressions_1.RadioGroupName);
        const type = (0, combi_1.seq)((0, combi_1.altPrio)("TYPE", "LIKE"), (0, combi_1.altPrio)(expressions_1.TypeName, expressions_1.Dynamic));
        const memory = (0, combi_1.seq)("MEMORY ID", expressions_1.SimpleSource1);
        const listbox = (0, combi_1.str)("AS LISTBOX");
        const cmd = (0, combi_1.seq)("USER-COMMAND", (0, combi_1.regex)(/^\w+$/));
        const modif = (0, combi_1.seq)("MODIF ID", expressions_1.Modif);
        const visible = (0, combi_1.seq)("VISIBLE LENGTH", expressions_1.Constant);
        const length = (0, combi_1.seq)("LENGTH", expressions_1.Constant);
        const match = (0, combi_1.seq)("MATCHCODE OBJECT", expressions_1.Field);
        const decimals = (0, combi_1.seq)("DECIMALS", expressions_1.Source);
        const perm = (0, combi_1.per)(type, def, "OBLIGATORY", match, cmd, length, decimals, radio, memory, modif, listbox, visible, "VALUE CHECK", "NO-DISPLAY", "AS CHECKBOX", "LOWER CASE");
        const ret = (0, combi_1.seq)(para, expressions_1.FieldSub, (0, combi_1.opt)(expressions_1.FieldLength), (0, combi_1.opt)(perm));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Parameter = Parameter;
//# sourceMappingURL=parameter.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/perform.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/perform.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Perform = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const Expressions = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Perform {
    getMatcher() {
        const level = (0, combi_1.seq)("LEVEL", Expressions.Source);
        const commit = (0, combi_1.alt)((0, combi_1.seq)("ON COMMIT", (0, combi_1.opt)(level)), "ON ROLLBACK");
        const short = (0, combi_1.verNot)(version_1.Version.Cloud, (0, combi_1.seq)(Expressions.FormName, (0, combi_1.tok)(tokens_1.ParenLeft), Expressions.IncludeName, (0, combi_1.tok)(tokens_1.ParenRightW)));
        const program = (0, combi_1.seq)("IN PROGRAM", (0, combi_1.opt)((0, combi_1.alt)(Expressions.Dynamic, Expressions.IncludeName)));
        const found = (0, combi_1.str)("IF FOUND");
        const full = (0, combi_1.seq)((0, combi_1.alt)(Expressions.FormName, Expressions.Dynamic), (0, combi_1.opt)((0, combi_1.verNot)(version_1.Version.Cloud, program)));
        const ret = (0, combi_1.seq)("PERFORM", (0, combi_1.alt)(short, full), (0, combi_1.opt)(found), (0, combi_1.opt)(expressions_1.PerformTables), (0, combi_1.opt)(expressions_1.PerformUsing), (0, combi_1.opt)(expressions_1.PerformChanging), (0, combi_1.opt)(found), (0, combi_1.opt)(commit));
        return ret;
    }
}
exports.Perform = Perform;
//# sourceMappingURL=perform.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/position.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/position.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Position = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Position {
    getMatcher() {
        const ret = (0, combi_1.seq)("POSITION", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Position = Position;
//# sourceMappingURL=position.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/print_control.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/print_control.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PrintControl = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class PrintControl {
    getMatcher() {
        const index = (0, combi_1.seq)("INDEX-LINE", expressions_1.Source);
        const func = (0, combi_1.seq)("FUNCTION", expressions_1.Source);
        const ret = (0, combi_1.seq)("PRINT-CONTROL", (0, combi_1.alt)(index, func));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.PrintControl = PrintControl;
//# sourceMappingURL=print_control.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/private.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/private.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Private = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Private {
    getMatcher() {
        return (0, combi_1.str)("PRIVATE SECTION");
    }
}
exports.Private = Private;
//# sourceMappingURL=private.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/program.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/program.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Program = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Program {
    getMatcher() {
        const message = (0, combi_1.seq)("MESSAGE-ID", expressions_1.Source);
        const size = (0, combi_1.seq)("LINE-SIZE", expressions_1.Source);
        const heading = (0, combi_1.str)("NO STANDARD PAGE HEADING");
        const line = (0, combi_1.seq)("LINE-COUNT", expressions_1.Source);
        const options = (0, combi_1.per)(message, size, heading, line);
        const ret = (0, combi_1.seq)("PROGRAM", (0, combi_1.optPrio)(expressions_1.ReportName), (0, combi_1.opt)(options));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Program = Program;
//# sourceMappingURL=program.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/protected.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/protected.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Protected = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Protected {
    getMatcher() {
        return (0, combi_1.str)("PROTECTED SECTION");
    }
}
exports.Protected = Protected;
//# sourceMappingURL=protected.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/provide.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/provide.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Provide = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Provide {
    getMatcher() {
        const list = (0, combi_1.plus)((0, combi_1.altPrio)("*", expressions_1.Field));
        const fields = (0, combi_1.seq)("FIELDS", list, "FROM", expressions_1.Source, "INTO", expressions_1.Target, "VALID", expressions_1.Field, "BOUNDS", expressions_1.Field, "AND", expressions_1.Field);
        const fieldList = (0, combi_1.altPrio)((0, combi_1.seq)(list, "FROM", expressions_1.Source), list);
        const ret = (0, combi_1.seq)("PROVIDE", (0, combi_1.altPrio)((0, combi_1.plus)(fields), (0, combi_1.plus)(fieldList)), "BETWEEN", expressions_1.SimpleSource3, "AND", expressions_1.SimpleSource3);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Provide = Provide;
//# sourceMappingURL=provide.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/public.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/public.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Public = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Public {
    getMatcher() {
        return (0, combi_1.str)("PUBLIC SECTION");
    }
}
exports.Public = Public;
//# sourceMappingURL=public.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/put.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/put.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Put = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Put {
    getMatcher() {
        const ret = (0, combi_1.seq)("PUT", expressions_1.Field);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Put = Put;
//# sourceMappingURL=put.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Raise = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Raise {
    getMatcher() {
        const mess = (0, combi_1.seq)("MESSAGE", expressions_1.MessageSource, (0, combi_1.opt)(expressions_1.RaiseWith));
        const messid = (0, combi_1.seq)("MESSAGE ID", expressions_1.Source, "NUMBER", (0, combi_1.altPrio)(expressions_1.MessageNumber, expressions_1.Source), (0, combi_1.optPrio)(expressions_1.RaiseWith));
        const exporting = (0, combi_1.seq)("EXPORTING", expressions_1.ParameterListS);
        const from = (0, combi_1.seq)("TYPE", expressions_1.ClassName, (0, combi_1.opt)((0, combi_1.alt)((0, combi_1.ver)(version_1.Version.v750, (0, combi_1.alt)(mess, messid)), (0, combi_1.ver)(version_1.Version.v752, "USING MESSAGE"))), (0, combi_1.optPrio)(exporting));
        const pre = (0, combi_1.altPrio)((0, combi_1.seq)((0, combi_1.optPrio)("RESUMABLE"), "EXCEPTION"), "SHORTDUMP");
        const clas = (0, combi_1.seq)(pre, (0, combi_1.altPrio)(from, (0, combi_1.ver)(version_1.Version.v752, expressions_1.Source), expressions_1.SimpleSource2));
        const ret = (0, combi_1.seq)("RAISE", (0, combi_1.altPrio)(clas, expressions_1.ExceptionName));
        return ret;
    }
}
exports.Raise = Raise;
//# sourceMappingURL=raise.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise_entity_event.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise_entity_event.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RaiseEntityEvent = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class RaiseEntityEvent {
    getMatcher() {
        return (0, combi_1.seq)("RAISE ENTITY EVENT", expressions_1.EventName, "FROM", expressions_1.Source);
    }
}
exports.RaiseEntityEvent = RaiseEntityEvent;
//# sourceMappingURL=raise_entity_event.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise_event.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/raise_event.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RaiseEvent = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class RaiseEvent {
    getMatcher() {
        const exporting = (0, combi_1.seq)("EXPORTING", expressions_1.ParameterListS);
        return (0, combi_1.seq)("RAISE EVENT", expressions_1.EventName, (0, combi_1.opt)(exporting));
    }
}
exports.RaiseEvent = RaiseEvent;
//# sourceMappingURL=raise_event.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/ranges.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/ranges.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Ranges = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Ranges {
    getMatcher() {
        const occurs = (0, combi_1.seq)("OCCURS", expressions_1.Source);
        const ret = (0, combi_1.seq)("RANGES", expressions_1.SimpleName, "FOR", expressions_1.FieldSub, (0, combi_1.opt)(occurs));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Ranges = Ranges;
//# sourceMappingURL=ranges.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_dataset.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_dataset.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReadDataset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ReadDataset {
    getMatcher() {
        const ret = (0, combi_1.seq)("READ DATASET", expressions_1.Source, "INTO", expressions_1.Target, (0, combi_1.opt)((0, combi_1.seq)("MAXIMUM LENGTH", expressions_1.Source)), (0, combi_1.opt)((0, combi_1.seq)("ACTUAL LENGTH", expressions_1.Target)), (0, combi_1.opt)((0, combi_1.seq)("LENGTH", expressions_1.Target)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ReadDataset = ReadDataset;
//# sourceMappingURL=read_dataset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_entities.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_entities.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReadEntities = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class ReadEntities {
    getMatcher() {
        const from = (0, combi_1.seq)("FROM", expressions_1.Source);
        const fields = (0, combi_1.seq)("FIELDS", (0, combi_1.tok)(tokens_1.WParenLeftW), (0, combi_1.plus)(expressions_1.SimpleName), (0, combi_1.tok)(tokens_1.WParenRightW), "WITH", expressions_1.Source);
        const all = (0, combi_1.seq)("ALL FIELDS WITH", expressions_1.Source);
        const s = (0, combi_1.seq)("READ ENTITIES OF", expressions_1.NamespaceSimpleName, (0, combi_1.opt)("IN LOCAL MODE"), "ENTITY", expressions_1.SimpleName, (0, combi_1.opt)((0, combi_1.seq)("BY", expressions_1.AssociationName)), (0, combi_1.alt)(fields, from, all), "RESULT", expressions_1.Target, (0, combi_1.optPrio)((0, combi_1.seq)("LINK", expressions_1.Target)), (0, combi_1.optPrio)((0, combi_1.seq)("FAILED", expressions_1.Target)), (0, combi_1.optPrio)((0, combi_1.seq)("REPORTED", expressions_1.Target)));
        return (0, combi_1.ver)(version_1.Version.v754, s);
    }
}
exports.ReadEntities = ReadEntities;
//# sourceMappingURL=read_entities.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_line.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_line.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReadLine = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ReadLine {
    getMatcher() {
        const val = (0, combi_1.seq)("LINE VALUE INTO", expressions_1.Target);
        const fields = (0, combi_1.seq)(expressions_1.Target, (0, combi_1.opt)((0, combi_1.seq)("INTO", expressions_1.Target)));
        const field = (0, combi_1.seq)("FIELD VALUE", (0, combi_1.plus)(fields));
        const index = (0, combi_1.seq)("INDEX", expressions_1.Source);
        const page = (0, combi_1.seq)("OF PAGE", expressions_1.Source);
        const current = (0, combi_1.str)("OF CURRENT PAGE");
        const ret = (0, combi_1.seq)("READ", (0, combi_1.alt)("CURRENT LINE", (0, combi_1.seq)("LINE", expressions_1.Source)), (0, combi_1.opt)((0, combi_1.per)(val, index, field, page, current)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ReadLine = ReadLine;
//# sourceMappingURL=read_line.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_report.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_report.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReadReport = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ReadReport {
    getMatcher() {
        const state = (0, combi_1.seq)("STATE", expressions_1.Source);
        const into = (0, combi_1.seq)("INTO", expressions_1.Target);
        const maximum = (0, combi_1.seq)("MAXIMUM WIDTH INTO", expressions_1.Target);
        const ret = (0, combi_1.seq)("READ REPORT", expressions_1.Source, (0, combi_1.per)(state, into, maximum));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ReadReport = ReadReport;
//# sourceMappingURL=read_report.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_table.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_table.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReadTable = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const transporting_fields_1 = __webpack_require__(/*! ../expressions/transporting_fields */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/transporting_fields.js");
class ReadTable {
    getMatcher() {
        const comparing = (0, combi_1.seq)("COMPARING", (0, combi_1.alt)((0, combi_1.plus)(expressions_1.FieldSub), expressions_1.Dynamic));
        const index = (0, combi_1.seq)("INDEX", expressions_1.Source);
        const components = (0, combi_1.seq)((0, combi_1.alt)(expressions_1.Field, expressions_1.Dynamic), "COMPONENTS", expressions_1.ComponentCompareSimple);
        const key = (0, combi_1.seq)((0, combi_1.altPrio)("WITH KEY", "WITH TABLE KEY"), (0, combi_1.alt)(expressions_1.ComponentCompareSimple, components, (0, combi_1.seq)((0, combi_1.optPrio)("="), expressions_1.Source)));
        const using = (0, combi_1.seq)("USING KEY", (0, combi_1.alt)(expressions_1.Field, expressions_1.Dynamic));
        const from = (0, combi_1.seq)("FROM", expressions_1.Source);
        const perm = (0, combi_1.per)((0, combi_1.alt)(index, key, from), expressions_1.ReadTableTarget, using, comparing, "CASTING", "TRANSPORTING ALL FIELDS", (0, combi_1.seq)("TRANSPORTING", transporting_fields_1.TransportingFields), "BINARY SEARCH");
        return (0, combi_1.seq)("READ TABLE", (0, combi_1.alt)(expressions_1.SimpleSource2, (0, combi_1.ver)(version_1.Version.v740sp02, expressions_1.Source)), (0, combi_1.opt)(perm));
    }
}
exports.ReadTable = ReadTable;
//# sourceMappingURL=read_table.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_textpool.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/read_textpool.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ReadTextpool = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ReadTextpool {
    getMatcher() {
        const language = (0, combi_1.seq)("LANGUAGE", expressions_1.Source);
        const into = (0, combi_1.seq)("INTO", expressions_1.SimpleTarget);
        const state = (0, combi_1.seq)("STATE", expressions_1.Source);
        const ret = (0, combi_1.seq)("READ TEXTPOOL", expressions_1.Source, (0, combi_1.per)(into, language, state));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ReadTextpool = ReadTextpool;
//# sourceMappingURL=read_textpool.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/receive.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/receive.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Receive = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Receive {
    getMatcher() {
        const ret = (0, combi_1.seq)("RECEIVE RESULTS FROM FUNCTION", expressions_1.FunctionName, (0, combi_1.opt)("KEEPING TASK"), expressions_1.ReceiveParameters);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Receive = Receive;
//# sourceMappingURL=receive.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/refresh.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/refresh.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Refresh = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Refresh {
    getMatcher() {
        const from = (0, combi_1.seq)("FROM TABLE", expressions_1.DatabaseTable);
        const ret = (0, combi_1.seq)("REFRESH", expressions_1.Target, (0, combi_1.optPrio)(from));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Refresh = Refresh;
//# sourceMappingURL=refresh.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/refresh_control.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/refresh_control.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RefreshControl = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class RefreshControl {
    getMatcher() {
        const ret = (0, combi_1.seq)("REFRESH CONTROL", expressions_1.Source, "FROM SCREEN", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.RefreshControl = RefreshControl;
//# sourceMappingURL=refresh_control.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/reject.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/reject.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Reject = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Reject {
    getMatcher() {
        const ret = (0, combi_1.seq)("REJECT", (0, combi_1.opt)(expressions_1.Source));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Reject = Reject;
//# sourceMappingURL=reject.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/replace.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/replace.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Replace = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Replace {
    getMatcher() {
        const length = (0, combi_1.seq)("LENGTH", expressions_1.Source);
        const offset = (0, combi_1.seq)("OFFSET", expressions_1.Source);
        const section = (0, combi_1.seq)((0, combi_1.opt)("IN"), "SECTION", (0, combi_1.per)(offset, length), "OF", expressions_1.Target);
        const source = (0, combi_1.seq)((0, combi_1.opt)("OF"), expressions_1.FindType, expressions_1.Source);
        const cas = (0, combi_1.altPrio)("IGNORING CASE", "RESPECTING CASE");
        const repl = (0, combi_1.seq)("REPLACEMENT COUNT", expressions_1.Target);
        const replo = (0, combi_1.seq)("REPLACEMENT OFFSET", expressions_1.Target);
        const repll = (0, combi_1.seq)("REPLACEMENT LENGTH", expressions_1.Target);
        const repli = (0, combi_1.seq)("REPLACEMENT LINE", expressions_1.Target);
        const occ = (0, combi_1.altPrio)("ALL OCCURRENCES", "ALL OCCURENCES", "FIRST OCCURENCE", "FIRST OCCURRENCE");
        const mode = (0, combi_1.alt)("IN CHARACTER MODE", "IN BYTE MODE");
        const wit = (0, combi_1.seq)("WITH", expressions_1.Source);
        const into = (0, combi_1.seq)("INTO", expressions_1.Target);
        return (0, combi_1.seq)("REPLACE", (0, combi_1.per)(section, (0, combi_1.seq)((0, combi_1.opt)(occ), source)), (0, combi_1.opt)((0, combi_1.seq)("IN", (0, combi_1.opt)("TABLE"), expressions_1.Target)), (0, combi_1.opt)((0, combi_1.per)(wit, into, cas, mode, repl, replo, repll, repli, length)));
    }
}
exports.Replace = Replace;
//# sourceMappingURL=replace.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/report.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/report.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Report = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class Report {
    getMatcher() {
        const more = (0, combi_1.seq)((0, combi_1.tok)(tokens_1.ParenLeft), expressions_1.Integer, (0, combi_1.tok)(tokens_1.ParenRightW));
        const heading = (0, combi_1.str)("NO STANDARD PAGE HEADING");
        const size = (0, combi_1.seq)("LINE-SIZE", expressions_1.Integer);
        const count = (0, combi_1.seq)("LINE-COUNT", expressions_1.Integer, (0, combi_1.opt)(more));
        const message = (0, combi_1.seq)("MESSAGE-ID", expressions_1.MessageClass);
        const database = (0, combi_1.seq)("USING DATABASE", expressions_1.Field);
        const ret = (0, combi_1.seq)("REPORT", (0, combi_1.opt)(expressions_1.ReportName), (0, combi_1.opt)((0, combi_1.per)(heading, size, count, database, message)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Report = Report;
//# sourceMappingURL=report.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/reserve.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/reserve.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Reserve = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Reserve {
    getMatcher() {
        const ret = (0, combi_1.seq)("RESERVE", expressions_1.Source, "LINES");
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Reserve = Reserve;
//# sourceMappingURL=reserve.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/resume.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/resume.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Resume = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Resume {
    getMatcher() {
        return (0, combi_1.str)("RESUME");
    }
}
exports.Resume = Resume;
//# sourceMappingURL=resume.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/retry.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/retry.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Retry = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Retry {
    getMatcher() {
        return (0, combi_1.ver)(version_1.Version.v702, "RETRY");
    }
}
exports.Retry = Retry;
//# sourceMappingURL=retry.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/return.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/return.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Return = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Return {
    getMatcher() {
        return (0, combi_1.str)("RETURN");
    }
}
exports.Return = Return;
//# sourceMappingURL=return.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/rollback.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/rollback.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Rollback = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Rollback {
    getMatcher() {
        return (0, combi_1.seq)("ROLLBACK", (0, combi_1.altPrio)("WORK", expressions_1.DatabaseConnection));
    }
}
exports.Rollback = Rollback;
//# sourceMappingURL=rollback.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/rollback_entities.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/rollback_entities.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RollbackEntities = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class RollbackEntities {
    getMatcher() {
        const s = "ROLLBACK ENTITIES";
        return (0, combi_1.ver)(version_1.Version.v754, s);
    }
}
exports.RollbackEntities = RollbackEntities;
//# sourceMappingURL=rollback_entities.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/scan.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/scan.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Scan = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Scan {
    getMatcher() {
        const tokens = (0, combi_1.seq)("TOKENS INTO", expressions_1.Target);
        const word = (0, combi_1.seq)("WORD INTO", expressions_1.Target);
        const line = (0, combi_1.seq)("LINE INTO", expressions_1.Target);
        const statements = (0, combi_1.seq)("STATEMENTS INTO", expressions_1.Target);
        const levels = (0, combi_1.seq)("LEVELS INTO", expressions_1.Target);
        const structures = (0, combi_1.seq)("STRUCTURES INTO", expressions_1.Target);
        const include = (0, combi_1.seq)("INCLUDE INTO", expressions_1.Target);
        const offset = (0, combi_1.seq)("OFFSET INTO", expressions_1.Target);
        const enh = (0, combi_1.seq)("ENHANCEMENTS INTO", expressions_1.Target);
        const enhO = (0, combi_1.seq)("ENHANCEMENT OPTIONS INTO", expressions_1.Target);
        const keywords = (0, combi_1.seq)("KEYWORDS FROM", expressions_1.Source);
        const pragmas = (0, combi_1.seq)("WITH PRAGMAS", expressions_1.Source);
        const overflow = (0, combi_1.seq)("OVERFLOW INTO", expressions_1.Target);
        const message = (0, combi_1.seq)("MESSAGE INTO", expressions_1.Target);
        const includeProgram = (0, combi_1.seq)("INCLUDE PROGRAM FROM", expressions_1.Source);
        const frame = (0, combi_1.seq)("FRAME PROGRAM FROM", expressions_1.Source);
        const program = (0, combi_1.seq)("PROGRAM FROM", expressions_1.Source);
        const from = (0, combi_1.seq)("FROM", expressions_1.Source);
        const to = (0, combi_1.seq)("TO", expressions_1.Source);
        const replacing = (0, combi_1.seq)("REPLACING", expressions_1.Source);
        const id = (0, combi_1.seq)("ID", expressions_1.Source, "TABLE", expressions_1.Source);
        const ret = (0, combi_1.seq)("SCAN ABAP-SOURCE", expressions_1.Source, (0, combi_1.per)(tokens, levels, from, to, statements, structures, keywords, word, line, offset, overflow, message, includeProgram, include, frame, enhO, enh, program, replacing, "WITH ANALYSIS", "WITH COMMENTS", "WITH TYPE-POOLS", "WITH INCLUDES", "WITHOUT TRMAC", "WITH DECLARATIONS", "WITH BLOCKS", "PRESERVING IDENTIFIER ESCAPING", "WITH LIST TOKENIZATION", "WITH EXPLICIT ENHANCEMENTS", "WITH IMPLICIT ENHANCEMENTS", "WITH INACTIVE ENHANCEMENTS", pragmas, id));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Scan = Scan;
//# sourceMappingURL=scan.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/scroll_list.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/scroll_list.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScrollList = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class ScrollList {
    getMatcher() {
        const index = (0, combi_1.seq)("INDEX", expressions_1.Source);
        const line = (0, combi_1.seq)("LINE", expressions_1.Source);
        const column = (0, combi_1.seq)("TO COLUMN", expressions_1.Source);
        const to = (0, combi_1.seq)("TO", (0, combi_1.alt)("FIRST PAGE", "LAST PAGE", (0, combi_1.seq)("PAGE", expressions_1.Source)));
        const ret = (0, combi_1.seq)("SCROLL LIST", (0, combi_1.per)(index, (0, combi_1.alt)(to, "BACKWARD", "FORWARD"), column, line));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.ScrollList = ScrollList;
//# sourceMappingURL=scroll_list.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/search.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/search.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Search = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Search {
    getMatcher() {
        const starting = (0, combi_1.seq)("STARTING AT", expressions_1.Source);
        const ending = (0, combi_1.seq)("ENDING AT", expressions_1.Source);
        const mark = (0, combi_1.str)("AND MARK");
        const mode = (0, combi_1.altPrio)("IN BYTE MODE", "IN CHARACTER MODE");
        const ret = (0, combi_1.seq)("SEARCH", expressions_1.Source, "FOR", expressions_1.Source, (0, combi_1.opt)((0, combi_1.per)(mode, starting, ending, mark)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Search = Search;
//# sourceMappingURL=search.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/select.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/select.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Select = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Select {
    getMatcher() {
        const union = (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("UNION", (0, combi_1.optPrio)((0, combi_1.altPrio)("DISTINCT", "ALL")), expressions_1.Select));
        return (0, combi_1.seq)(expressions_1.Select, (0, combi_1.starPrio)(union));
    }
}
exports.Select = Select;
//# sourceMappingURL=select.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/select_loop.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/select_loop.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectLoop = void 0;
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SelectLoop {
    getMatcher() {
        return new expressions_1.SelectLoop();
    }
}
exports.SelectLoop = SelectLoop;
//# sourceMappingURL=select_loop.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/selectionscreen.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/selectionscreen.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectionScreen = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SelectionScreen {
    getMatcher() {
        const beginBlock = (0, combi_1.seq)("BEGIN OF BLOCK", expressions_1.BlockName, (0, combi_1.optPrio)("WITH FRAME"), (0, combi_1.optPrio)((0, combi_1.seq)("TITLE", (0, combi_1.alt)(expressions_1.InlineField, expressions_1.TextElement))), (0, combi_1.optPrio)("NO INTERVALS"));
        const endBlock = (0, combi_1.seq)("END OF BLOCK", expressions_1.BlockName);
        const nesting = (0, combi_1.seq)("NESTING LEVEL", expressions_1.Source);
        const scrOptions = (0, combi_1.per)((0, combi_1.seq)("AS", (0, combi_1.alt)("WINDOW", "SUBSCREEN")), (0, combi_1.seq)("TITLE", (0, combi_1.alt)(expressions_1.InlineField, expressions_1.TextElement)), "NO INTERVALS", nesting);
        const beginScreen = (0, combi_1.seq)("BEGIN OF SCREEN", expressions_1.Integer, (0, combi_1.opt)(scrOptions));
        const endScreen = (0, combi_1.seq)("END OF SCREEN", expressions_1.Integer);
        const beginLine = (0, combi_1.str)("BEGIN OF LINE");
        const endLine = (0, combi_1.str)("END OF LINE");
        const modif = (0, combi_1.seq)("MODIF ID", expressions_1.Modif);
        const visible = (0, combi_1.seq)("VISIBLE LENGTH", (0, combi_1.regex)(/^\d+$/));
        const commentOpt = (0, combi_1.per)((0, combi_1.seq)("FOR FIELD", expressions_1.Field), modif, visible);
        const position = (0, combi_1.seq)((0, combi_1.opt)((0, combi_1.regex)(/^\/?[\d\w]+$/)), (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenLeft), (0, combi_1.tok)(tokens_1.WParenLeft)), expressions_1.Integer, (0, combi_1.altPrio)((0, combi_1.tok)(tokens_1.ParenRightW), (0, combi_1.tok)(tokens_1.ParenRight)));
        const comment = (0, combi_1.seq)("COMMENT", position, (0, combi_1.opt)((0, combi_1.alt)(expressions_1.InlineField, expressions_1.TextElement)), (0, combi_1.opt)(commentOpt));
        const command = (0, combi_1.seq)("USER-COMMAND", (0, combi_1.alt)(expressions_1.Field, expressions_1.Constant));
        const push = (0, combi_1.seq)("PUSHBUTTON", position, (0, combi_1.alt)(expressions_1.InlineField, expressions_1.TextElement), command, (0, combi_1.opt)(modif), (0, combi_1.opt)(visible));
        const prog = (0, combi_1.seq)("PROGRAM", expressions_1.Field);
        const def = (0, combi_1.seq)("DEFAULT", (0, combi_1.opt)(prog), "SCREEN", expressions_1.Integer);
        const tab = (0, combi_1.seq)("TAB", (0, combi_1.tok)(tokens_1.WParenLeft), expressions_1.Integer, (0, combi_1.tok)(tokens_1.ParenRightW), (0, combi_1.alt)(expressions_1.InlineField, expressions_1.TextElement), command, (0, combi_1.opt)(def), (0, combi_1.opt)(modif));
        const func = (0, combi_1.seq)("FUNCTION KEY", expressions_1.Integer);
        const skip = (0, combi_1.seq)("SKIP", (0, combi_1.opt)(expressions_1.Integer));
        const posSymbols = (0, combi_1.altPrio)("POS_LOW", "POS_HIGH");
        // number between 1 and 83
        const posIntegers = (0, combi_1.regex)(/^(0?[1-9]|[1234567][0-9]|8[0-3])$/);
        const pos = (0, combi_1.seq)("POSITION", (0, combi_1.altPrio)(posIntegers, posSymbols));
        const incl = (0, combi_1.seq)("INCLUDE BLOCKS", expressions_1.BlockName);
        const tabbed = (0, combi_1.seq)("BEGIN OF TABBED BLOCK", expressions_1.InlineField, "FOR", expressions_1.Integer, "LINES", (0, combi_1.optPrio)("NO INTERVALS"));
        const uline = (0, combi_1.seq)("ULINE", (0, combi_1.opt)(position));
        const param = (0, combi_1.seq)("INCLUDE PARAMETERS", expressions_1.Field);
        const iso = (0, combi_1.seq)("INCLUDE SELECT-OPTIONS", expressions_1.Field);
        const ret = (0, combi_1.seq)("SELECTION-SCREEN", (0, combi_1.altPrio)(comment, func, skip, pos, incl, iso, push, tab, uline, beginBlock, tabbed, endBlock, beginLine, endLine, param, beginScreen, endScreen));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SelectionScreen = SelectionScreen;
//# sourceMappingURL=selectionscreen.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/selectoption.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/selectoption.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectOption = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SelectOption {
    getMatcher() {
        const sourc = (0, combi_1.alt)(expressions_1.Constant, expressions_1.FieldChain);
        const to = (0, combi_1.seq)("TO", sourc);
        const def = (0, combi_1.seq)("DEFAULT", sourc, (0, combi_1.opt)(to));
        const option = (0, combi_1.seq)("OPTION", (0, combi_1.alt)("CP", expressions_1.Field));
        const sign = (0, combi_1.seq)("SIGN", expressions_1.Field);
        const memory = (0, combi_1.seq)("MEMORY ID", expressions_1.SimpleSource1);
        const match = (0, combi_1.seq)("MATCHCODE OBJECT", expressions_1.Field);
        const modif = (0, combi_1.seq)("MODIF ID", expressions_1.Modif);
        const visible = (0, combi_1.seq)("VISIBLE LENGTH", expressions_1.Source);
        const options = (0, combi_1.per)(def, option, sign, memory, match, visible, modif, "NO DATABASE SELECTION", "LOWER CASE", "NO-EXTENSION", "NO INTERVALS", "NO-DISPLAY", "OBLIGATORY");
        const ret = (0, combi_1.seq)("SELECT-OPTIONS", expressions_1.FieldSub, "FOR", (0, combi_1.alt)(expressions_1.FieldChain, expressions_1.Dynamic), (0, combi_1.opt)(options));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SelectOption = SelectOption;
//# sourceMappingURL=selectoption.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_bit.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_bit.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetBit = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SetBit {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET BIT", expressions_1.Source, "OF", expressions_1.Target, (0, combi_1.opt)((0, combi_1.seq)("TO", expressions_1.Source)));
        return ret;
    }
}
exports.SetBit = SetBit;
//# sourceMappingURL=set_bit.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_blank.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_blank.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetBlank = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetBlank {
    getMatcher() {
        const onOff = (0, combi_1.alt)("ON", "OFF");
        const ret = (0, combi_1.seq)("SET BLANK LINES", onOff);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetBlank = SetBlank;
//# sourceMappingURL=set_blank.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_country.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_country.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetCountry = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetCountry {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET COUNTRY", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetCountry = SetCountry;
//# sourceMappingURL=set_country.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_cursor.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_cursor.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetCursor = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetCursor {
    getMatcher() {
        const line = (0, combi_1.seq)("LINE", expressions_1.Source);
        const offset = (0, combi_1.seq)("OFFSET", expressions_1.Source);
        const field = (0, combi_1.seq)("FIELD", expressions_1.Source);
        const pos = (0, combi_1.seq)(expressions_1.Source, expressions_1.Source);
        const ret = (0, combi_1.seq)("SET CURSOR", (0, combi_1.altPrio)((0, combi_1.per)(field, offset, line), pos));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetCursor = SetCursor;
//# sourceMappingURL=set_cursor.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_dataset.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_dataset.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetDataset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetDataset {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET DATASET", expressions_1.Source, "POSITION", (0, combi_1.alt)(expressions_1.Source, "END OF FILE"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetDataset = SetDataset;
//# sourceMappingURL=set_dataset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_extended_check.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_extended_check.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetExtendedCheck = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetExtendedCheck {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET EXTENDED CHECK", (0, combi_1.alt)("OFF", "ON"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetExtendedCheck = SetExtendedCheck;
//# sourceMappingURL=set_extended_check.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_handler.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_handler.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetHandler = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SetHandler {
    getMatcher() {
        const activation = (0, combi_1.seq)("ACTIVATION", expressions_1.Source);
        const fo = (0, combi_1.seq)("FOR", (0, combi_1.altPrio)("ALL INSTANCES", expressions_1.Source));
        const ret = (0, combi_1.seq)("SET HANDLER", (0, combi_1.plus)(expressions_1.MethodSource), (0, combi_1.optPrio)(fo), (0, combi_1.optPrio)(activation));
        return ret;
    }
}
exports.SetHandler = SetHandler;
//# sourceMappingURL=set_handler.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_language.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_language.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetLanguage = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetLanguage {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET LANGUAGE", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetLanguage = SetLanguage;
//# sourceMappingURL=set_language.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_left.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_left.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetLeft = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class SetLeft {
    getMatcher() {
        const column = (0, combi_1.seq)("COLUMN", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, (0, combi_1.seq)("SET LEFT SCROLL-BOUNDARY", (0, combi_1.opt)(column)));
    }
}
exports.SetLeft = SetLeft;
//# sourceMappingURL=set_left.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_locale.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_locale.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetLocale = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetLocale {
    getMatcher() {
        const country = (0, combi_1.seq)("COUNTRY", expressions_1.Source);
        const modifier = (0, combi_1.seq)("MODIFIER", expressions_1.Source);
        const ret = (0, combi_1.seq)("SET LOCALE LANGUAGE", expressions_1.Source, (0, combi_1.opt)(country), (0, combi_1.opt)(modifier));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetLocale = SetLocale;
//# sourceMappingURL=set_locale.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_locks.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_locks.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetLocks = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetLocks {
    getMatcher() {
        const s = (0, combi_1.seq)("SET LOCKS OF", expressions_1.SimpleName, "ENTITY", expressions_1.SimpleName, "FROM", expressions_1.Source, "FAILED", expressions_1.Target, "REPORTED", expressions_1.Target);
        return (0, combi_1.ver)(version_1.Version.v754, s);
    }
}
exports.SetLocks = SetLocks;
//# sourceMappingURL=set_locks.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_margin.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_margin.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetMargin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetMargin {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET MARGIN", expressions_1.Source, (0, combi_1.opt)(expressions_1.Source));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetMargin = SetMargin;
//# sourceMappingURL=set_margin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_parameter.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_parameter.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetParameter = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetParameter {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET PARAMETER ID", expressions_1.Source, "FIELD", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetParameter = SetParameter;
//# sourceMappingURL=set_parameter.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_pf_status.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_pf_status.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetPFStatus = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetPFStatus {
    getMatcher() {
        const program = (0, combi_1.seq)("OF PROGRAM", expressions_1.Source);
        const options = (0, combi_1.per)(program, "IMMEDIATELY", (0, combi_1.seq)("EXCLUDING", expressions_1.Source));
        const ret = (0, combi_1.seq)("SET PF-STATUS", expressions_1.Source, (0, combi_1.opt)(options));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetPFStatus = SetPFStatus;
//# sourceMappingURL=set_pf_status.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_property.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_property.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetProperty = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetProperty {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET PROPERTY OF", expressions_1.Source, (0, combi_1.alt)(expressions_1.Constant, expressions_1.Field), "=", expressions_1.Source, (0, combi_1.optPrio)("NO FLUSH"), (0, combi_1.opt)(expressions_1.OLEExporting));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetProperty = SetProperty;
//# sourceMappingURL=set_property.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_run_time.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_run_time.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetRunTime = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetRunTime {
    getMatcher() {
        const clock = (0, combi_1.seq)("CLOCK RESOLUTION", (0, combi_1.alt)("LOW", "HIGH"));
        const analyzer = (0, combi_1.seq)("ANALYZER", (0, combi_1.alt)("ON", "OFF"));
        const ret = (0, combi_1.seq)("SET RUN TIME", (0, combi_1.alt)(clock, analyzer));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetRunTime = SetRunTime;
//# sourceMappingURL=set_run_time.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_screen.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_screen.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetScreen = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetScreen {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET SCREEN", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetScreen = SetScreen;
//# sourceMappingURL=set_screen.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_titlebar.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_titlebar.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetTitlebar = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetTitlebar {
    getMatcher() {
        const wit = (0, combi_1.seq)("WITH", (0, combi_1.plus)(expressions_1.Source));
        const program = (0, combi_1.seq)("OF PROGRAM", expressions_1.Source);
        const ret = (0, combi_1.seq)("SET TITLEBAR", expressions_1.Source, (0, combi_1.opt)(program), (0, combi_1.opt)(wit));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetTitlebar = SetTitlebar;
//# sourceMappingURL=set_titlebar.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_update_task.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_update_task.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetUpdateTask = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetUpdateTask {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "SET UPDATE TASK LOCAL");
    }
}
exports.SetUpdateTask = SetUpdateTask;
//# sourceMappingURL=set_update_task.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_user_command.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/set_user_command.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetUserCommand = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SetUserCommand {
    getMatcher() {
        const ret = (0, combi_1.seq)("SET USER-COMMAND", expressions_1.Source);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SetUserCommand = SetUserCommand;
//# sourceMappingURL=set_user_command.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/shift.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/shift.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Shift = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Shift {
    getMatcher() {
        const deleting = (0, combi_1.seq)("DELETING", (0, combi_1.altPrio)("LEADING", "TRAILING"), expressions_1.Source);
        const up = (0, combi_1.seq)("UP TO", expressions_1.Source);
        const mode = (0, combi_1.seq)("IN", (0, combi_1.altPrio)("CHARACTER", "BYTE"), "MODE");
        const dir = (0, combi_1.altPrio)("LEFT", "RIGHT");
        const by = (0, combi_1.seq)("BY", expressions_1.Source, (0, combi_1.optPrio)("PLACES"));
        const options = (0, combi_1.per)(deleting, up, mode, dir, by, "CIRCULAR");
        return (0, combi_1.seq)("SHIFT", expressions_1.Target, (0, combi_1.opt)(options));
    }
}
exports.Shift = Shift;
//# sourceMappingURL=shift.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/skip.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/skip.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Skip = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Skip {
    getMatcher() {
        const ret = (0, combi_1.seq)("SKIP", (0, combi_1.opt)("TO LINE"), (0, combi_1.opt)(expressions_1.Source));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Skip = Skip;
//# sourceMappingURL=skip.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sort.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sort.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Sort = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Sort {
    getMatcher() {
        const order = (0, combi_1.altPrio)("ASCENDING", "DESCENDING");
        const sel = (0, combi_1.alt)(expressions_1.ComponentChain, expressions_1.Dynamic, expressions_1.SourceFieldSymbol);
        const text = "AS TEXT";
        const fields = (0, combi_1.plus)((0, combi_1.seq)(sel, (0, combi_1.optPrio)(text), (0, combi_1.optPrio)(order), (0, combi_1.optPrio)(text)));
        const by = (0, combi_1.seq)("BY", fields);
        const normal = (0, combi_1.seq)(expressions_1.Target, (0, combi_1.opt)((0, combi_1.per)(order, by, "STABLE", text)));
        const target = (0, combi_1.altPrio)(text, normal);
        return (0, combi_1.seq)("SORT", target);
    }
}
exports.Sort = Sort;
//# sourceMappingURL=sort.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sort_dataset.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sort_dataset.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SortDataset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SortDataset {
    getMatcher() {
        const order = (0, combi_1.alt)("ASCENDING", "DESCENDING");
        const sel = (0, combi_1.alt)(expressions_1.FieldSub, expressions_1.SourceFieldSymbol, expressions_1.Dynamic);
        const fields = (0, combi_1.plus)((0, combi_1.seq)(sel, (0, combi_1.optPrio)(order)));
        const by = (0, combi_1.seq)("BY", fields);
        const ret = (0, combi_1.seq)("SORT", (0, combi_1.opt)(by));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SortDataset = SortDataset;
//# sourceMappingURL=sort_dataset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/split.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/split.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Split = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Split {
    getMatcher() {
        const mode = (0, combi_1.seq)("IN", (0, combi_1.alt)("CHARACTER", "BYTE"), "MODE");
        const into = (0, combi_1.altPrio)((0, combi_1.seq)("TABLE", expressions_1.Target, (0, combi_1.opt)(mode)), (0, combi_1.seq)((0, combi_1.plus)(expressions_1.Target), (0, combi_1.opt)(mode)));
        const ret = (0, combi_1.seq)("SPLIT", expressions_1.Source, "AT", expressions_1.Source, "INTO", into);
        return ret;
    }
}
exports.Split = Split;
//# sourceMappingURL=split.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/start_of_selection.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/start_of_selection.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StartOfSelection = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class StartOfSelection {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "START-OF-SELECTION");
    }
}
exports.StartOfSelection = StartOfSelection;
//# sourceMappingURL=start_of_selection.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Static = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const Expressions = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Static {
    getMatcher() {
        const p = (0, combi_1.opt)((0, combi_1.per)(Expressions.Type, Expressions.Value, Expressions.Length, Expressions.Decimals));
        const type = (0, combi_1.seq)((0, combi_1.opt)(Expressions.ConstantFieldLength), p);
        const ret = (0, combi_1.seq)((0, combi_1.alt)("STATIC", "STATICS"), Expressions.DefinitionName, (0, combi_1.alt)(type, Expressions.TypeTable));
        return ret;
    }
}
exports.Static = Static;
//# sourceMappingURL=static.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static_begin.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static_begin.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StaticBegin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class StaticBegin {
    getMatcher() {
        const occurs = (0, combi_1.seq)("OCCURS", expressions_1.Integer);
        const ret = (0, combi_1.seq)((0, combi_1.alt)("STATIC", "STATICS"), "BEGIN OF", expressions_1.DefinitionName, (0, combi_1.opt)(occurs));
        return ret;
    }
}
exports.StaticBegin = StaticBegin;
//# sourceMappingURL=static_begin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static_end.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/static_end.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StaticEnd = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class StaticEnd {
    getMatcher() {
        const ret = (0, combi_1.seq)((0, combi_1.alt)("STATIC", "STATICS"), "END OF", expressions_1.DefinitionName);
        return ret;
    }
}
exports.StaticEnd = StaticEnd;
//# sourceMappingURL=static_end.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/stop.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/stop.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Stop = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Stop {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "STOP");
    }
}
exports.Stop = Stop;
//# sourceMappingURL=stop.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/submit.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/submit.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Submit = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Submit {
    getMatcher() {
        const sign = (0, combi_1.seq)("SIGN", expressions_1.Source);
        const eq = (0, combi_1.alt)("=", "EQ", "IN", "NE", "CP", "GE", "LE", "INCL");
        const compare = (0, combi_1.seq)(eq, expressions_1.Source);
        const between = (0, combi_1.seq)("BETWEEN", expressions_1.Source, "AND", expressions_1.Source);
        const selectionTable = (0, combi_1.seq)("WITH SELECTION-TABLE", expressions_1.Source);
        const awith = (0, combi_1.seq)("WITH", expressions_1.FieldSub, (0, combi_1.alt)(compare, between), (0, combi_1.optPrio)(sign));
        const prog = (0, combi_1.alt)(expressions_1.NamespaceSimpleName, expressions_1.Dynamic);
        const job = (0, combi_1.seq)("VIA JOB", expressions_1.Source, "NUMBER", expressions_1.Source);
        const exporting = (0, combi_1.str)("EXPORTING LIST TO MEMORY");
        const spool = (0, combi_1.seq)("SPOOL PARAMETERS", expressions_1.Source);
        const archive = (0, combi_1.seq)("ARCHIVE PARAMETERS", expressions_1.Source);
        const lineSize = (0, combi_1.seq)("LINE-SIZE", expressions_1.Source);
        const lineCount = (0, combi_1.seq)("LINE-COUNT", expressions_1.Source);
        const user = (0, combi_1.seq)("USER", expressions_1.Source);
        const sset = (0, combi_1.seq)("USING SELECTION-SET", expressions_1.Source);
        const ssetp = (0, combi_1.seq)("USING SELECTION-SETS OF PROGRAM", expressions_1.Source);
        const uss = (0, combi_1.seq)("USING SELECTION-SCREEN", expressions_1.Source);
        const free = (0, combi_1.seq)("WITH FREE SELECTIONS", expressions_1.Source);
        const newList = (0, combi_1.seq)("NEW LIST IDENTIFICATION", expressions_1.Source);
        const layout = (0, combi_1.seq)("LAYOUT", expressions_1.Source);
        const cover = (0, combi_1.seq)("SAP COVER PAGE", expressions_1.Source);
        const keep = (0, combi_1.seq)("KEEP IN SPOOL", expressions_1.Source);
        const imm = (0, combi_1.seq)("IMMEDIATELY", expressions_1.Source);
        const dest = (0, combi_1.seq)("DESTINATION", expressions_1.Source);
        const language = (0, combi_1.seq)("LANGUAGE", expressions_1.Source);
        const perm = (0, combi_1.per)((0, combi_1.plus)(awith), selectionTable, spool, lineSize, lineCount, archive, user, sset, ssetp, keep, cover, imm, layout, dest, language, free, newList, uss, "TO SAP-SPOOL", "WITHOUT SPOOL DYNPRO", "VIA SELECTION-SCREEN", exporting, expressions_1.AndReturn, job);
        const ret = (0, combi_1.seq)("SUBMIT", prog, (0, combi_1.opt)(perm));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Submit = Submit;
//# sourceMappingURL=submit.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/subtract.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/subtract.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Subtract = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Subtract {
    getMatcher() {
        const ret = (0, combi_1.seq)("SUBTRACT", expressions_1.Source, "FROM", expressions_1.Target);
        return ret;
    }
}
exports.Subtract = Subtract;
//# sourceMappingURL=subtract.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/subtract_corresponding.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/subtract_corresponding.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SubtractCorresponding = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SubtractCorresponding {
    getMatcher() {
        const ret = (0, combi_1.seq)("SUBTRACT-CORRESPONDING", expressions_1.Source, "FROM", expressions_1.Target);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SubtractCorresponding = SubtractCorresponding;
//# sourceMappingURL=subtract_corresponding.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sum.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/sum.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Sum = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Sum {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "SUM");
    }
}
exports.Sum = Sum;
//# sourceMappingURL=sum.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/summary.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/summary.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Summary = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Summary {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, "SUMMARY");
    }
}
exports.Summary = Summary;
//# sourceMappingURL=summary.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/supply.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/supply.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Supply = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Supply {
    getMatcher() {
        const field = (0, combi_1.seq)(expressions_1.Field, "=", expressions_1.Source);
        const ret = (0, combi_1.seq)("SUPPLY", (0, combi_1.plus)(field), "TO CONTEXT", expressions_1.Field);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Supply = Supply;
//# sourceMappingURL=supply.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/suppress_dialog.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/suppress_dialog.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SuppressDialog = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SuppressDialog {
    getMatcher() {
        const ret = (0, combi_1.str)("SUPPRESS DIALOG");
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SuppressDialog = SuppressDialog;
//# sourceMappingURL=suppress_dialog.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/syntax_check.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/syntax_check.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SyntaxCheck = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class SyntaxCheck {
    getMatcher() {
        const program = (0, combi_1.seq)("PROGRAM", expressions_1.Source);
        const offset = (0, combi_1.seq)("OFFSET", expressions_1.Target);
        const frame = (0, combi_1.seq)("FRAME ENTRY", expressions_1.Target);
        const include = (0, combi_1.seq)("INCLUDE", expressions_1.Target);
        const trace = (0, combi_1.seq)("TRACE-TABLE", expressions_1.Target);
        const line = (0, combi_1.seq)("LINE", expressions_1.Target);
        const word = (0, combi_1.seq)("WORD", expressions_1.Target);
        const messageId = (0, combi_1.seq)("MESSAGE-ID", expressions_1.Target);
        const message = (0, combi_1.seq)("MESSAGE", expressions_1.Target);
        const id = (0, combi_1.seq)("ID", expressions_1.Source, "TABLE", expressions_1.Target);
        const replacing = (0, combi_1.seq)("REPLACING", expressions_1.Target);
        const directory = (0, combi_1.seq)("DIRECTORY ENTRY", expressions_1.Source);
        const dump = (0, combi_1.seq)("SHORTDUMP-ID", expressions_1.Source);
        const filter = (0, combi_1.seq)("FILTER", expressions_1.Source);
        const syntax = (0, combi_1.seq)((0, combi_1.optPrio)("PROGRAM"), expressions_1.Source, (0, combi_1.per)(message, line, word, offset, program, replacing, directory, frame, include, messageId, trace, dump, filter, (0, combi_1.plus)(id)));
        const dynpro = (0, combi_1.seq)("DYNPRO", expressions_1.Source, expressions_1.Source, expressions_1.Source, expressions_1.Source, (0, combi_1.per)(message, line, word, offset, messageId, trace));
        const ret = (0, combi_1.seq)("SYNTAX-CHECK FOR", (0, combi_1.alt)(syntax, dynpro));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SyntaxCheck = SyntaxCheck;
//# sourceMappingURL=syntax_check.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/system_call.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/system_call.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SystemCall = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const source_1 = __webpack_require__(/*! ../expressions/source */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/source.js");
const target_1 = __webpack_require__(/*! ../expressions/target */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/target.js");
class SystemCall {
    getMatcher() {
        const anyy = (0, combi_1.regex)(/^.+$/);
        const objmgr = (0, combi_1.seq)("OBJMGR CLONE", source_1.Source, "TO", target_1.Target);
        const did = (0, combi_1.seq)(anyy, "DID", source_1.Source, "PARAMETERS", source_1.Source, source_1.Source, source_1.Source);
        const ret = (0, combi_1.seq)("SYSTEM-CALL", (0, combi_1.altPrio)(objmgr, did, (0, combi_1.plus)(anyy)));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.SystemCall = SystemCall;
//# sourceMappingURL=system_call.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/tables.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/tables.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Tables = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Tables {
    getMatcher() {
        const ret = (0, combi_1.seq)("TABLES", expressions_1.Field);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Tables = Tables;
//# sourceMappingURL=tables.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/test_injection.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/test_injection.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestInjection = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TestInjection {
    getMatcher() {
        return (0, combi_1.seq)("TEST-INJECTION", expressions_1.TestSeamName);
    }
}
exports.TestInjection = TestInjection;
//# sourceMappingURL=test_injection.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/test_seam.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/test_seam.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestSeam = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TestSeam {
    getMatcher() {
        return (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("TEST-SEAM", expressions_1.TestSeamName));
    }
}
exports.TestSeam = TestSeam;
//# sourceMappingURL=test_seam.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/top_of_page.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/top_of_page.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TopOfPage = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TopOfPage {
    getMatcher() {
        const ret = (0, combi_1.seq)("TOP-OF-PAGE", (0, combi_1.opt)("DURING LINE-SELECTION"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.TopOfPage = TopOfPage;
//# sourceMappingURL=top_of_page.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/transfer.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/transfer.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Transfer = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Transfer {
    getMatcher() {
        const length = (0, combi_1.seq)("LENGTH", expressions_1.Source);
        const ret = (0, combi_1.seq)("TRANSFER", expressions_1.Source, "TO", expressions_1.Source, (0, combi_1.opt)(length), (0, combi_1.opt)("NO END OF LINE"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Transfer = Transfer;
//# sourceMappingURL=transfer.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/translate.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/translate.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Translate = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Translate {
    getMatcher() {
        const cas = (0, combi_1.seq)("TO", (0, combi_1.altPrio)("UPPER", "LOWER"), "CASE");
        const using = (0, combi_1.seq)("USING", expressions_1.Source);
        return (0, combi_1.seq)("TRANSLATE", expressions_1.Target, (0, combi_1.altPrio)(cas, using));
    }
}
exports.Translate = Translate;
//# sourceMappingURL=translate.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/truncate_dataset.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/truncate_dataset.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TruncateDataset = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TruncateDataset {
    getMatcher() {
        return (0, combi_1.verNot)(version_1.Version.Cloud, (0, combi_1.seq)("TRUNCATE DATASET", expressions_1.Source, "AT CURRENT POSITION"));
    }
}
exports.TruncateDataset = TruncateDataset;
//# sourceMappingURL=truncate_dataset.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/try.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/try.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Try = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class Try {
    getMatcher() {
        return (0, combi_1.str)("TRY");
    }
}
exports.Try = Try;
//# sourceMappingURL=try.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Type = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const Expressions = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Type {
    getMatcher() {
        const simple = (0, combi_1.per)(Expressions.Type, Expressions.Decimals, Expressions.Length);
        const def = (0, combi_1.seq)(Expressions.NamespaceSimpleName, (0, combi_1.opt)(Expressions.ConstantFieldLength), (0, combi_1.opt)((0, combi_1.alt)(simple, Expressions.TypeTable, Expressions.TypeStructure)));
        // todo, BOXED is only allowed with structures inside structures?
        const boxed = (0, combi_1.ver)(version_1.Version.v702, "BOXED");
        const ret = (0, combi_1.seq)("TYPES", def, (0, combi_1.opt)(boxed));
        return ret;
    }
}
exports.Type = Type;
//# sourceMappingURL=type.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_begin.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_begin.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeBegin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeBegin {
    getMatcher() {
        const ret = (0, combi_1.seq)("TYPES", "BEGIN OF", expressions_1.NamespaceSimpleName, (0, combi_1.optPrio)((0, combi_1.verNot)(version_1.Version.Cloud, "%_FINAL")));
        return ret;
    }
}
exports.TypeBegin = TypeBegin;
//# sourceMappingURL=type_begin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_end.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_end.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeEnd = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class TypeEnd {
    getMatcher() {
        const ret = (0, combi_1.seq)("TYPES", "END OF", expressions_1.NamespaceSimpleName);
        return ret;
    }
}
exports.TypeEnd = TypeEnd;
//# sourceMappingURL=type_end.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeEnum = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeEnum {
    getMatcher() {
        // it is also possible to define without Value, this is covered by normal type
        const ret = (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("TYPES", expressions_1.NamespaceSimpleName, expressions_1.Value));
        return ret;
    }
}
exports.TypeEnum = TypeEnum;
//# sourceMappingURL=type_enum.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum_begin.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum_begin.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeEnumBegin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeEnumBegin {
    getMatcher() {
        const structure = (0, combi_1.seq)("STRUCTURE", expressions_1.NamespaceSimpleName);
        const base = (0, combi_1.seq)("BASE TYPE", expressions_1.NamespaceSimpleName);
        const em = (0, combi_1.seq)("ENUM", expressions_1.NamespaceSimpleName, (0, combi_1.opt)(structure), (0, combi_1.opt)(base));
        const ret = (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("TYPES", "BEGIN OF", em));
        return ret;
    }
}
exports.TypeEnumBegin = TypeEnumBegin;
//# sourceMappingURL=type_enum_begin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum_end.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_enum_end.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeEnumEnd = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeEnumEnd {
    getMatcher() {
        const structure = (0, combi_1.seq)("STRUCTURE", expressions_1.NamespaceSimpleName);
        const ret = (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("TYPES", "END OF", "ENUM", expressions_1.NamespaceSimpleName, (0, combi_1.opt)(structure)));
        return ret;
    }
}
exports.TypeEnumEnd = TypeEnumEnd;
//# sourceMappingURL=type_enum_end.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeMesh = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeMesh {
    getMatcher() {
        const on = (0, combi_1.seq)("ON", expressions_1.NamespaceSimpleName, "=", expressions_1.NamespaceSimpleName, (0, combi_1.star)((0, combi_1.seq)("AND", expressions_1.NamespaceSimpleName, "=", expressions_1.NamespaceSimpleName)));
        const using = (0, combi_1.seq)("USING KEY", expressions_1.NamespaceSimpleName);
        const association = (0, combi_1.seq)("ASSOCIATION", expressions_1.NamespaceSimpleName, "TO", expressions_1.NamespaceSimpleName, (0, combi_1.plus)(on));
        const ret = (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("TYPES", expressions_1.NamespaceSimpleName, "TYPE", (0, combi_1.opt)("REF TO"), expressions_1.TypeName, (0, combi_1.plus)(association), (0, combi_1.opt)(using)));
        return ret;
    }
}
exports.TypeMesh = TypeMesh;
//# sourceMappingURL=type_mesh.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh_begin.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh_begin.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeMeshBegin = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeMeshBegin {
    getMatcher() {
        const ret = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("TYPES", "BEGIN OF MESH", expressions_1.NamespaceSimpleName));
        return ret;
    }
}
exports.TypeMeshBegin = TypeMeshBegin;
//# sourceMappingURL=type_mesh_begin.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh_end.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_mesh_end.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypeMeshEnd = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class TypeMeshEnd {
    getMatcher() {
        const ret = (0, combi_1.ver)(version_1.Version.v740sp05, (0, combi_1.seq)("TYPES", "END OF MESH", expressions_1.NamespaceSimpleName));
        return ret;
    }
}
exports.TypeMeshEnd = TypeMeshEnd;
//# sourceMappingURL=type_mesh_end.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_pool.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_pool.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypePool = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
// type pool definition
class TypePool {
    getMatcher() {
        const fieldName = (0, combi_1.regex)(/^\w+$/);
        const ret = (0, combi_1.seq)("TYPE-POOL", fieldName);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.TypePool = TypePool;
//# sourceMappingURL=type_pool.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_pools.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/type_pools.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TypePools = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
// type pool usage
class TypePools {
    getMatcher() {
        const fieldName = (0, combi_1.regex)(/^\w+$/);
        const ret = (0, combi_1.seq)("TYPE-POOLS", fieldName);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.TypePools = TypePools;
//# sourceMappingURL=type_pools.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/uline.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/uline.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Uline = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Uline {
    getMatcher() {
        const ret = (0, combi_1.seq)("ULINE", (0, combi_1.optPrio)(expressions_1.WriteOffsetLength), (0, combi_1.optPrio)("NO-GAP"));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Uline = Uline;
//# sourceMappingURL=uline.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/unassign.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/unassign.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Unassign = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Unassign {
    getMatcher() {
        return (0, combi_1.seq)("UNASSIGN", expressions_1.TargetFieldSymbol);
    }
}
exports.Unassign = Unassign;
//# sourceMappingURL=unassign.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/unpack.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/unpack.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Unpack = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Unpack {
    getMatcher() {
        const ret = (0, combi_1.seq)("UNPACK", expressions_1.Source, "TO", expressions_1.Target);
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Unpack = Unpack;
//# sourceMappingURL=unpack.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/update_database.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/update_database.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UpdateDatabase = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class UpdateDatabase {
    getMatcher() {
        const parameters = (0, combi_1.seq)(expressions_1.SQLFieldAndValue, (0, combi_1.star)((0, combi_1.seq)((0, combi_1.opt)(","), expressions_1.SQLFieldAndValue)));
        const set = (0, combi_1.seq)("SET", (0, combi_1.alt)(parameters, expressions_1.Dynamic), (0, combi_1.opt)((0, combi_1.seq)("WHERE", expressions_1.SQLCond)));
        const fromTable = (0, combi_1.seq)("FROM", (0, combi_1.opt)("TABLE"), expressions_1.SQLSource);
        const ret = (0, combi_1.seq)("UPDATE", expressions_1.DatabaseTable, (0, combi_1.opt)(expressions_1.SQLClient), (0, combi_1.opt)(expressions_1.DatabaseConnection), (0, combi_1.opt)((0, combi_1.alt)(fromTable, set)));
        return ret;
    }
}
exports.UpdateDatabase = UpdateDatabase;
//# sourceMappingURL=update_database.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/wait.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/wait.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Wait = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class Wait {
    getMatcher() {
        const up = (0, combi_1.seq)("UP TO", expressions_1.Source, "SECONDS");
        const channels = "MESSAGING CHANNELS";
        const push = (0, combi_1.ver)(version_1.Version.v750, "PUSH CHANNELS", version_1.Version.OpenABAP);
        const tasks = "ASYNCHRONOUS TASKS";
        const type = (0, combi_1.seq)("FOR", (0, combi_1.per)(channels, push, tasks));
        const until = (0, combi_1.seq)((0, combi_1.opt)(type), "UNTIL", expressions_1.Cond, (0, combi_1.opt)(up));
        const ret = (0, combi_1.seq)("WAIT", (0, combi_1.alt)(until, up));
        return ret;
    }
}
exports.Wait = Wait;
//# sourceMappingURL=wait.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.When = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class When {
    getMatcher() {
        const sourc = (0, combi_1.seq)(expressions_1.Source, (0, combi_1.starPrio)(expressions_1.Or));
        return (0, combi_1.seq)("WHEN", sourc);
    }
}
exports.When = When;
//# sourceMappingURL=when.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when_others.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when_others.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WhenOthers = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
class WhenOthers {
    getMatcher() {
        return (0, combi_1.str)("WHEN OTHERS");
    }
}
exports.WhenOthers = WhenOthers;
//# sourceMappingURL=when_others.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when_type.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/when_type.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WhenType = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class WhenType {
    getMatcher() {
        const into = (0, combi_1.seq)("INTO", expressions_1.Target);
        const type = (0, combi_1.seq)(expressions_1.ClassName, (0, combi_1.optPrio)(into));
        return (0, combi_1.ver)(version_1.Version.v750, (0, combi_1.seq)("WHEN TYPE", type), version_1.Version.OpenABAP);
    }
}
exports.WhenType = WhenType;
//# sourceMappingURL=when_type.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/while.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/while.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.While = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class While {
    getMatcher() {
        const vary = (0, combi_1.seq)("VARY", expressions_1.Target, "FROM", expressions_1.Source, "NEXT", expressions_1.Source);
        return (0, combi_1.seq)("WHILE", expressions_1.Cond, (0, combi_1.opt)(vary));
    }
}
exports.While = While;
//# sourceMappingURL=while.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/window.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/window.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Window = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Window {
    getMatcher() {
        const ending = (0, combi_1.seq)("ENDING AT", expressions_1.Source, expressions_1.Source);
        const ret = (0, combi_1.seq)("WINDOW STARTING AT", expressions_1.Source, expressions_1.Source, (0, combi_1.opt)(ending));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Window = Window;
//# sourceMappingURL=window.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/with.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/with.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.With = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
class With {
    getMatcher() {
        const as = (0, combi_1.seq)(expressions_1.WithName, "AS", (0, combi_1.tok)(tokens_1.WParenLeftW), expressions_1.SelectLoop, (0, combi_1.tok)(tokens_1.WParenRightW));
        return (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("WITH", (0, combi_1.plus)(as), expressions_1.Select));
    }
}
exports.With = With;
//# sourceMappingURL=with.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/with_loop.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/with_loop.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WithLoop = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
const tokens_1 = __webpack_require__(/*! ../../1_lexer/tokens */ "./node_modules/@abaplint/core/build/src/abap/1_lexer/tokens/index.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
class WithLoop {
    getMatcher() {
        const as = (0, combi_1.seq)(expressions_1.WithName, "AS", (0, combi_1.tok)(tokens_1.WParenLeftW), expressions_1.SelectLoop, (0, combi_1.tok)(tokens_1.WParenRightW));
        return (0, combi_1.ver)(version_1.Version.v751, (0, combi_1.seq)("WITH", (0, combi_1.plus)(as), expressions_1.SelectLoop));
    }
}
exports.WithLoop = WithLoop;
//# sourceMappingURL=with_loop.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/write.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/2_statements/statements/write.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Write = void 0;
const combi_1 = __webpack_require__(/*! ../combi */ "./node_modules/@abaplint/core/build/src/abap/2_statements/combi.js");
const expressions_1 = __webpack_require__(/*! ../expressions */ "./node_modules/@abaplint/core/build/src/abap/2_statements/expressions/index.js");
const version_1 = __webpack_require__(/*! ../../../version */ "./node_modules/@abaplint/core/build/src/version.js");
class Write {
    getMatcher() {
        const mask = (0, combi_1.seq)("USING", (0, combi_1.altPrio)("NO EDIT MASK", (0, combi_1.seq)("EDIT MASK", expressions_1.Source)));
        const onOff = (0, combi_1.alt)((0, combi_1.altPrio)("ON", "OFF"), (0, combi_1.seq)("=", expressions_1.FieldSub));
        const dateFormat = (0, combi_1.altPrio)("DD/MM/YY", "MM/DD/YY", "DD/MM/YYYY", "MM/DD/YYYY", "DDMMYY", "MMDDYY", "YYMMDD");
        const as = (0, combi_1.seq)("AS", (0, combi_1.altPrio)("LINE", "ICON", "CHECKBOX", "SYMBOL"));
        const to = (0, combi_1.seq)("TO", expressions_1.Target);
        const options = (0, combi_1.per)(mask, to, (0, combi_1.seq)("EXPONENT", expressions_1.Source), "NO-GROUPING", "NO-ZERO", "CENTERED", (0, combi_1.seq)("INPUT", (0, combi_1.opt)(onOff)), "NO-GAP", "LEFT-JUSTIFIED", as, (0, combi_1.seq)("FRAMES", onOff), (0, combi_1.seq)("HOTSPOT", (0, combi_1.opt)(onOff)), "RIGHT-JUSTIFIED", (0, combi_1.seq)("TIME ZONE", expressions_1.Source), (0, combi_1.seq)("UNDER", expressions_1.Source), (0, combi_1.seq)("STYLE", expressions_1.Source), (0, combi_1.seq)("ROUND", expressions_1.Source), (0, combi_1.seq)("QUICKINFO", expressions_1.Source), "ENVIRONMENT TIME FORMAT", dateFormat, (0, combi_1.seq)("UNIT", expressions_1.Source), (0, combi_1.seq)("INTENSIFIED", (0, combi_1.opt)(onOff)), (0, combi_1.seq)("INDEX", expressions_1.Source), (0, combi_1.seq)("DECIMALS", expressions_1.Source), (0, combi_1.seq)("INVERSE", (0, combi_1.opt)(onOff)), expressions_1.Color, (0, combi_1.seq)("CURRENCY", expressions_1.Source), "NO-SIGN");
        const ret = (0, combi_1.seq)("WRITE", (0, combi_1.alt)("AT /", (0, combi_1.seq)((0, combi_1.opt)(expressions_1.WriteOffsetLength), (0, combi_1.altPrio)(expressions_1.Source, expressions_1.Dynamic, "/"), (0, combi_1.opt)(options))));
        return (0, combi_1.verNot)(version_1.Version.Cloud, ret);
    }
}
exports.Write = Write;
//# sourceMappingURL=write.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structure_parser.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structure_parser.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StructureParser = void 0;
const _statement_1 = __webpack_require__(/*! ../2_statements/statements/_statement */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/_statement.js");
const Structures = __webpack_require__(/*! ./structures */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/index.js");
const issue_1 = __webpack_require__(/*! ../../issue */ "./node_modules/@abaplint/core/build/src/issue.js");
const nodes_1 = __webpack_require__(/*! ../nodes */ "./node_modules/@abaplint/core/build/src/abap/nodes/index.js");
const position_1 = __webpack_require__(/*! ../../position */ "./node_modules/@abaplint/core/build/src/position.js");
const severity_1 = __webpack_require__(/*! ../../severity */ "./node_modules/@abaplint/core/build/src/severity.js");
class StructureParser {
    static run(input) {
        const structure = this.findStructureForFile(input.file.getFilename());
        const filtered = [];
        for (const s of input.statements) {
            const get = s.get();
            if (get instanceof _statement_1.Comment || get instanceof _statement_1.Empty || get instanceof _statement_1.Unknown) {
                continue;
            }
            filtered.push(s);
        }
        return this.runFile(structure, input.file, filtered);
    }
    //////////////////
    static findStructureForFile(filename) {
        // todo, not sure this is the right place for this logic
        if (filename.endsWith(".clas.abap")) {
            return new Structures.ClassGlobal();
        }
        else if (filename.endsWith(".intf.abap")) {
            return new Structures.InterfaceGlobal();
        }
        else {
            // todo, add a special structure for TYPE-POOLS
            return new Structures.Any();
        }
    }
    static runFile(structure, file, statements) {
        const parent = new nodes_1.StructureNode(structure);
        if (this.singletons[structure.constructor.name] === undefined) {
            this.singletons[structure.constructor.name] = structure.getMatcher();
        }
        const result = this.singletons[structure.constructor.name].run(statements, parent);
        if (result.error) {
            const issue = issue_1.Issue.atPosition(file, new position_1.Position(1, 1), result.errorDescription, "structure", severity_1.Severity.Error);
            return { issues: [issue], node: undefined };
        }
        if (result.unmatched.length > 0) {
            const statement = result.unmatched[0];
            const descr = "Unexpected " + statement.get().constructor.name.toUpperCase();
            const issue = issue_1.Issue.atPosition(file, statement.getStart(), descr, "structure", severity_1.Severity.Error);
            return { issues: [issue], node: undefined };
        }
        return { issues: [], node: parent };
    }
}
exports.StructureParser = StructureParser;
StructureParser.singletons = {};
//# sourceMappingURL=structure_parser.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/_combi.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structures/_combi.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.sub = exports.sta = exports.star = exports.opt = exports.beginEnd = exports.alt = exports.seq = void 0;
const nodes_1 = __webpack_require__(/*! ../../nodes */ "./node_modules/@abaplint/core/build/src/abap/nodes/index.js");
const _statement_1 = __webpack_require__(/*! ../../2_statements/statements/_statement */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/_statement.js");
class Sequence {
    constructor(list) {
        if (list.length < 2) {
            throw new Error("Sequence, length error");
        }
        this.list = list;
    }
    toRailroad() {
        const children = this.list.map((e) => { return e.toRailroad(); });
        return "Railroad.Sequence(" + children.join() + ")";
    }
    getUsing() {
        return this.list.reduce((a, c) => { return a.concat(c.getUsing()); }, []);
    }
    first() {
        return this.list[0].first();
    }
    run(statements, parent) {
        let inn = statements;
        const out = [];
        for (const i of this.list) {
            const match = i.run(inn, parent);
            if (match.error) {
                return {
                    matched: [],
                    unmatched: statements,
                    error: true,
                    errorDescription: match.errorDescription,
                    errorMatched: out.length,
                };
            }
            out.push(...match.matched);
            inn = match.unmatched;
        }
        return {
            matched: out,
            unmatched: inn,
            error: false,
            errorDescription: "",
            errorMatched: 0,
        };
    }
}
// Note that the Alternative does not nessesarily return the first in the alternative
// as a map is used for better performance
class Alternative {
    constructor(list) {
        if (list.length < 2) {
            throw new Error("Alternative, length error");
        }
        this.list = list;
    }
    setupMap() {
        // dont call from constructor, it will cause infinite loop
        if (this.map === undefined) {
            this.map = {};
            for (const i of this.list) {
                for (const first of i.first()) {
                    if (this.map[first]) {
                        this.map[first].push(i);
                    }
                    else {
                        this.map[first] = [i];
                    }
                }
            }
        }
    }
    first() {
        return [""];
    }
    toRailroad() {
        const children = this.list.map((e) => { return e.toRailroad(); });
        return "Railroad.Choice(0, " + children.join() + ")";
    }
    getUsing() {
        return this.list.reduce((a, c) => { return a.concat(c.getUsing()); }, []);
    }
    run(statements, parent) {
        this.setupMap();
        let count = 0;
        let countError = "";
        if (statements.length === 0) {
            return {
                matched: [],
                unmatched: statements,
                error: true,
                errorDescription: countError,
                errorMatched: count,
            };
        }
        const token = statements[0].getFirstToken().getStr().toUpperCase();
        for (const i of this.map[token] || []) {
            const match = i.run(statements, parent);
            if (match.error === false) {
                return match;
            }
            if (match.errorMatched > count) {
                countError = match.errorDescription;
                count = match.errorMatched;
            }
        }
        for (const i of this.map[""] || []) {
            const match = i.run(statements, parent);
            if (match.error === false) {
                return match;
            }
            if (match.errorMatched > count) {
                countError = match.errorDescription;
                count = match.errorMatched;
            }
        }
        if (count === 0) {
            return {
                matched: [],
                unmatched: statements,
                error: true,
                errorDescription: "Unexpected code structure",
                errorMatched: count,
            };
        }
        else {
            return {
                matched: [],
                unmatched: statements,
                error: true,
                errorDescription: countError,
                errorMatched: count,
            };
        }
    }
}
class Optional {
    constructor(obj) {
        this.obj = obj;
    }
    toRailroad() {
        return "Railroad.Optional(" + this.obj.toRailroad() + ")";
    }
    getUsing() {
        return this.obj.getUsing();
    }
    run(statements, parent) {
        const ret = this.obj.run(statements, parent);
        ret.error = false;
        return ret;
    }
    first() {
        return [""];
    }
}
class Star {
    constructor(obj) {
        this.obj = obj;
    }
    toRailroad() {
        return "Railroad.ZeroOrMore(" + this.obj.toRailroad() + ")";
    }
    getUsing() {
        return this.obj.getUsing();
    }
    run(statements, parent) {
        let inn = statements;
        const out = [];
        while (true) {
            if (inn.length === 0) {
                return {
                    matched: out,
                    unmatched: inn,
                    error: false,
                    errorDescription: "",
                    errorMatched: 0,
                };
            }
            const match = this.obj.run(inn, parent);
            if (match.error === true) {
                if (match.errorMatched > 0) {
                    return {
                        matched: out,
                        unmatched: inn,
                        error: true,
                        errorDescription: match.errorDescription,
                        errorMatched: match.errorMatched,
                    };
                }
                else {
                    return {
                        matched: out,
                        unmatched: inn,
                        error: false,
                        errorDescription: "",
                        errorMatched: 0,
                    };
                }
            }
            out.push(...match.matched);
            inn = match.unmatched;
        }
    }
    first() {
        return [""];
    }
}
class SubStructure {
    constructor(s) {
        this.s = s;
    }
    toRailroad() {
        return "Railroad.NonTerminal('" + this.s.constructor.name + "', {href: '#/structure/" + this.s.constructor.name + "'})";
    }
    getUsing() {
        return ["structure/" + this.s.constructor.name];
    }
    first() {
        this.setupMatcher();
        return this.matcher.first();
    }
    setupMatcher() {
        if (this.matcher === undefined) {
            // SubStructures are singletons, so the getMatcher can be saved, its expensive to create
            // dont move this to the constructor, as it might trigger infinite recursion
            this.matcher = this.s.getMatcher();
        }
    }
    run(statements, parent) {
        const nparent = new nodes_1.StructureNode(this.s);
        this.setupMatcher();
        const ret = this.matcher.run(statements, nparent);
        if (ret.matched.length === 0) {
            ret.error = true;
        }
        else {
            parent.addChild(nparent);
        }
        return ret;
    }
}
class SubStatement {
    constructor(obj) {
        this.obj = obj;
    }
    first() {
        const o = new this.obj();
        if (o instanceof _statement_1.MacroCall || o instanceof _statement_1.NativeSQL) {
            return [""];
        }
        return o.getMatcher().first();
    }
    toRailroad() {
        return "Railroad.Terminal('" + this.className() + "', {href: '#/statement/" + this.className() + "'})";
    }
    getUsing() {
        return ["statement/" + this.className()];
    }
    className() {
        return this.obj.name;
    }
    run(statements, parent) {
        if (statements.length === 0) {
            return {
                matched: [],
                unmatched: [],
                error: true,
                errorDescription: "Expected " + this.className().toUpperCase(),
                errorMatched: 0,
            };
        }
        else if (statements[0].get() instanceof this.obj) {
            parent.addChild(statements[0]);
            return {
                matched: [statements[0]],
                unmatched: statements.splice(1),
                error: false,
                errorDescription: "",
                errorMatched: 0,
            };
        }
        else {
            return {
                matched: [],
                unmatched: statements,
                error: true,
                errorDescription: "Expected " + this.className().toUpperCase(),
                errorMatched: 0,
            };
        }
    }
}
function seq(first, ...rest) {
    return new Sequence([first].concat(rest));
}
exports.seq = seq;
function alt(first, ...rest) {
    return new Alternative([first].concat(rest));
}
exports.alt = alt;
function beginEnd(begin, body, end) {
    return new Sequence([begin, body, end]);
}
exports.beginEnd = beginEnd;
function opt(o) {
    return new Optional(o);
}
exports.opt = opt;
function star(s) {
    return new Star(s);
}
exports.star = star;
function sta(s) {
    return new SubStatement(s);
}
exports.sta = sta;
const singletons = {};
function sub(s) {
    if (singletons[s.name] === undefined) {
        singletons[s.name] = new SubStructure(new s());
    }
    return singletons[s.name];
}
exports.sub = sub;
//# sourceMappingURL=_combi.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/any.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structures/any.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Any = void 0;
const _combi_1 = __webpack_require__(/*! ./_combi */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/_combi.js");
const Structures = __webpack_require__(/*! . */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/index.js");
const Statements = __webpack_require__(/*! ../../2_statements/statements */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js");
class Any {
    getMatcher() {
        return (0, _combi_1.star)((0, _combi_1.alt)((0, _combi_1.sta)(Statements.ClassLocalFriends), (0, _combi_1.sta)(Statements.ClassDeferred), (0, _combi_1.sta)(Statements.Report), (0, _combi_1.sta)(Statements.Program), (0, _combi_1.sta)(Statements.Parameter), (0, _combi_1.sta)(Statements.CheckSelectOptions), (0, _combi_1.sta)(Statements.Get), (0, _combi_1.sta)(Statements.Initialization), (0, _combi_1.sta)(Statements.InterfaceDeferred), (0, _combi_1.sta)(Statements.SelectionScreen), (0, _combi_1.sta)(Statements.SelectOption), (0, _combi_1.sta)(Statements.AtSelectionScreen), (0, _combi_1.sta)(Statements.AtLineSelection), (0, _combi_1.sta)(Statements.AtUserCommand), (0, _combi_1.sta)(Statements.StartOfSelection), (0, _combi_1.sta)(Statements.EndOfSelection), (0, _combi_1.sta)(Statements.LoadOfProgram), (0, _combi_1.sta)(Statements.TopOfPage), (0, _combi_1.sta)(Statements.EndOfPage), (0, _combi_1.sta)(Statements.Controls), (0, _combi_1.sta)(Statements.TypePools), (0, _combi_1.sta)(Statements.TypePool), (0, _combi_1.sta)(Statements.FunctionPool), (0, _combi_1.sub)(Structures.Normal), (0, _combi_1.sub)(Structures.Form), (0, _combi_1.sub)(Structures.Module), (0, _combi_1.sub)(Structures.FunctionModule), (0, _combi_1.sub)(Structures.Interface), (0, _combi_1.sub)(Structures.ClassDefinition), (0, _combi_1.sub)(Structures.ClassImplementation)));
    }
}
exports.Any = Any;
//# sourceMappingURL=any.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/at.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structures/at.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.At = void 0;
const Statements = __webpack_require__(/*! ../../2_statements/statements */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js");
const _combi_1 = __webpack_require__(/*! ./_combi */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/_combi.js");
const body_1 = __webpack_require__(/*! ./body */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/body.js");
class At {
    getMatcher() {
        return (0, _combi_1.beginEnd)((0, _combi_1.sta)(Statements.At), (0, _combi_1.opt)((0, _combi_1.sub)(body_1.Body)), (0, _combi_1.sta)(Statements.EndAt));
    }
}
exports.At = At;
//# sourceMappingURL=at.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/at_first.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structures/at_first.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AtFirst = void 0;
const Statements = __webpack_require__(/*! ../../2_statements/statements */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js");
const _combi_1 = __webpack_require__(/*! ./_combi */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/_combi.js");
const body_1 = __webpack_require__(/*! ./body */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/body.js");
class AtFirst {
    getMatcher() {
        return (0, _combi_1.beginEnd)((0, _combi_1.sta)(Statements.AtFirst), (0, _combi_1.opt)((0, _combi_1.sub)(body_1.Body)), (0, _combi_1.sta)(Statements.EndAt));
    }
}
exports.AtFirst = AtFirst;
//# sourceMappingURL=at_first.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/at_last.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structures/at_last.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AtLast = void 0;
const Statements = __webpack_require__(/*! ../../2_statements/statements */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js");
const _combi_1 = __webpack_require__(/*! ./_combi */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/_combi.js");
const body_1 = __webpack_require__(/*! ./body */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/body.js");
class AtLast {
    getMatcher() {
        return (0, _combi_1.beginEnd)((0, _combi_1.sta)(Statements.AtLast), (0, _combi_1.opt)((0, _combi_1.sub)(body_1.Body)), (0, _combi_1.sta)(Statements.EndAt));
    }
}
exports.AtLast = AtLast;
//# sourceMappingURL=at_last.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/body.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structures/body.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Body = void 0;
const _combi_1 = __webpack_require__(/*! ./_combi */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/_combi.js");
const normal_1 = __webpack_require__(/*! ./normal */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/normal.js");
class Body {
    getMatcher() {
        // todo, this should be a "plus" instead, however its not implemented yet
        return (0, _combi_1.star)((0, _combi_1.sub)(normal_1.Normal));
    }
}
exports.Body = Body;
//# sourceMappingURL=body.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/case.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structures/case.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Case = void 0;
const Statements = __webpack_require__(/*! ../../2_statements/statements */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/index.js");
const _combi_1 = __webpack_require__(/*! ./_combi */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/_combi.js");
const when_1 = __webpack_require__(/*! ./when */ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/when.js");
const _statement_1 = __webpack_require__(/*! ../../2_statements/statements/_statement */ "./node_modules/@abaplint/core/build/src/abap/2_statements/statements/_statement.js");
class Case {
    getMatcher() {
        return (0, _combi_1.beginEnd)((0, _combi_1.sta)(Statements.Case), (0, _combi_1.star)((0, _combi_1.alt)((0, _combi_1.sub)(when_1.When), (0, _combi_1.sta)(_statement_1.MacroCall), (0, _combi_1.sta)(Statements.Include))), (0, _combi_1.sta)(Statements.EndCase));
    }
}
exports.Case = Case;
//# sourceMappingURL=case.js.map

/***/ }),

/***/ "./node_modules/@abaplint/core/build/src/abap/3_structures/structures/case_type.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@abaplint/core/build/src/abap/3_structures/structures/case_type.js ***!
  \********************************************************