Avoid jumbled loop variable modifications. 

# Why is This a Problem?
When a nested for-loop modifies a variable, that was defined in an outer for-loop, it is usually a mistake. Even when done intentionally, this can be confusing and make the code harder to read. 

An exception is made for variables defined in an outer for-loop, that are both used in the condition of an inner for-loop and incremented in the same inner for-loop.
# How Can I Resolve This?
## Example (Before)
```javascript
for(var i=0; i<10; i++){
    for(var j=0; j<10; i++){  // Defines and references 'j', but increments 'i'
        ...
    }
}
...
```

## Example (After)
```javascript
for(var i=0; i<10; i++){
    for(var j=0; j<10; j++){  // Only references 'j'
        ...
    }
}
...
```