Returning `null` for collections can complicate usage and lead to a `NullPointerException`.
Try to refactor the code to avoid returning `null`.

# What Does This Check Look For?

This check identifies methods that return collections and might return a `null` value.

# Why is This a Problem?

Returning `null` for collections forces callers of the method to check for `null`, increasing the risk of a `NullPointerException` if they forget.
Returning an empty collection improves code readability and safety, as the client code can iterate over the result without additional `null` checks.
It is an indication for suboptimal design, if returning an empty collection is not possible because `null` and an empty collection have different semantics.

# How Can I Resolve This?

Return an empty collection instead of `null`.
This approach eliminates the need for `null` checks by the callers and reduces the risk of a `NullPointerException`.
In case an empty collection and `null` have different meaning, consider refactoring to avoid this or alternatively wrap the return value in an `Optional` type.

# Where Can I Learn More?

- [Guideline SEI CERT Oracle Coding Standard for Java: MET55-J. Return an empty array or collection instead of a null value for methods that return an array or collection](https://wiki.sei.cmu.edu/confluence/display/java/MET55-J.+Return+an+empty+array+or+collection+instead+of+a+null+value+for+methods+that+return+an+array+or+collection?src=contextnavpagetreemode)