Empty catch blocks are discouraged as they effectively suppress an exceptional condition. 
This can result in error conditions that are hard to debug. 

In general, catch blocks should contain error handling code, or at least log the
error condition. In rare cases where the exception is expected and should be 
ignored on purpose, an explanatory inline comment in the catch block is recommended.

# What Does This Check Look For?

This check reports findings for `CATCH` blocks that do not contain any code or comments. `CATCH` blocks which contain 
only the default Eclipse ADT comment **do** get flagged.

With the `Assume catch block with only comments is empty` check option this check can be set to also flag `CATCH` blocks 
which contain only comments.

# Why is This a Problem?

Empty catch blocks effectively suppress an exceptional condition. This can result in 
error conditions that are hard to debug. Since unhandled exceptions will be propagated
to the caller to be handled there, empty catch blocks break this propagation and make
error handling at a higher lever impossible.

Moreover, someone working on this code at a later point in time might wonder whether the 
block was intentionally left empty, or the error handling is missing and should be added.

# How Can I Resolve This?

In general, catch blocks should contain error handling code, or at least log the
error condition. If the exception should not be handled in the context of the current
method, it may be removed completely to allow callers to handle the condition. This is
only advisable for *static exceptions* (i.e., subclasses of `CX_STATIC_CHECK`), so that
callers are explicitly asked to handle the exception.

In rare cases where the exception is expected and should be ignored on purpose, an 
explanatory inline comment in the catch block is recommended.

# Examples
## Non-Compliant

```ABAP
TRY.
  "some code
  CATCH cx_error.
ENDTRY.
```

## Compliant

```ABAP
TRY.
  "some code
  CATCH cx_error.
    "No handling necessary, because...
ENDTRY.
```

# Where Can I Learn More?

- [code pal for ABAP: Empty Catch](https://github.com/SAP/code-pal-for-abap/blob/master/docs/checks/empty-catch.md)
