Specifying a logger with the current class improves traceability in log output.
Ensure that each logger instance is initialized with the context of its class.

# What Does This Check Look For?

This check identifies logger instances that are not specified with the current class they operate in.

# Why is This a Problem?

Logging without class context makes it difficult to trace where a log entry originates from, complicating debugging and monitoring. It hampers the efficiency of understanding and diagnosing issues within the application, as the log's source cannot be pinpointed easily. Including the class context in each logger instance enhances log readability and maintainability by providing clear traces of log origins.

# How Can I Resolve This?

To resolve this issue, always initialize logger instances by explicitly passing the current class as a parameter. This practice ensures that every log entry can be easily associated with its source class, thus improving the ability to debug and monitor the application effectively.

# Examples

## Non-Compliant

```java
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jExample {
	private static final Logger logger = LoggerFactory.getLogger(Logger.ROOT_LOGGER_NAME);

	public static void main(String[] args) {
		LOGGER.info("Hello {}", args[1]);
	}
}
```

## Compliant

```java
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jExample {
	private static final Logger logger = LoggerFactory.getLogger(Slf4jExample.class);

	public static void main(String[] args) {
		LOGGER.info("Hello {}", args[1]);
	}
}
```