Explicitly returning `null` in a function with return type `Optional` can lead to a `NullPointerException`.
The function should return an empty `Optional` object instead.

# What Does This Check Look For?
This check detects methods, whose return type is `Optional` or includes `Optional` (e.g. `Optional<String>` or `List<Optional<String>>`), whenever a statement `return null;` is found in the method body.

# Why is This a Problem?
Using the class `Optional` as return type explicitly indicates that a function call does not return a `null` value.
Instead, it should return a container that may or may not contain a value.
Usually, a caller then checks the value in the container using the `isPresent()` or `isEmpty()` function (e.g. `returnValue.isPresent()`).

If a function with return type `Optional` returns `null`, this can lead to a **`NullPointerException`**. 
A caller would check the value with the function `isPresent()` (or `isEmpty()`), but implicitly calls `null.isPresent()` in this case.

# How Can I Resolve This?
Functions with return type `Optional` should not return `null`, but instead **return an empty `Optional` object** , i.e. return `Optional.empty()`.
This way, treating the return value as an `Optional` object (e.g. using `isPresent()`) would **not** result in a `NullPointerException`.

# Examples
## Non-Compliant

```java
private Optional<String> nonCompliantFunction() {
	someCode();
    return null;
}
```

## Compliant

```java
private Optional<String> compliantFunction() {
	someCode();
    return Optional.empty();
}
```

# Where Can I Learn More?
- [Baeldung: Guide To Java 8 Optional](https://www.baeldung.com/java-optional)
- [Baeldung: Java Optional as Return Type](https://www.baeldung.com/java-optional-return)



