Nested comments can cause confusion and misinterpretation of the code documentation.
Ensure that comments are straightforward and avoid embedding comments within comments.

# What Does This Check Look For?

This check identifies instances where comments contain strings indicative of nested comments, suggesting a comment is embedded within another comment.

# Why is This a Problem?

Nested comments can make the code harder to read and maintain. They might lead to parts of the comment being ignored by the compiler or interpreter, potentially causing important information to be overlooked. This can result in miscommunication between developers and can obscure the code's intention.

# How Can I Resolve This?

Review the nested comment structures and refactor them into a single layer of commenting. This could involve consolidating information into a more coherent block or separating the comments into distinct areas of the code where they are more relevant. Ensuring comments are clear and direct supports better code maintenance and team communication.

# Examples

## Non-Compliant

```java
// This function does X and also
// /* It handles Y condition */
void doX() {
    // Implementation
}
```

## Compliant

```java
// This function does X and also handles Y condition.
void doX() {
    // Implementation
}
```
