Star imports must not be used, because they clutter the local namespace.

# Why is This a Problem?
`*`-imports import every class of the respective package, which clutters the namespace and 
also makes name collisions much more likely.

## Example
Additionally to cluttering the namespace this code also results in a compile error, because both packages contain a class named `Date`.
```java
import java.util.*;
import java.sql.*;
```

## Exceptions
If a majority of classes from a package is being used, star imports can be reasonable.
In such a case, name conflicts can be avoided like this:
```java
import java.util.*;
import java.sql.*;
import java.sql.Date;
```
However, modern IDEs offer "import by default" and "import hiding", making this rationale for `*`-imports only reasonable in a small number of scenarios.

# How Can I Resolve This?
Can be resolved by explicitly importing only the classes used in the code.

## Example (After)
```java
import java.util.Date;
import java.util.HashMap;
import java.sql.DriverManager;
```
