This check detects ABAP write accesses to system fields (`sy-xxxx`).

# Why is This a Problem?

System fields (`sy-xxxx`) should only be read (as they are set by the runtime environment).

You can configure the check via the option "Allowed system fields" in the analysis profile to ignore write accesses to specific system fields.
System field `sy-lsind` is allowed to be modified by default.

# How can I Resolve This?

To fix this issue, you should not write to system fields.

## Example (Before)

```ABAP
sy-subrc = 4.
CALL FUNCTION ...
    ...
    EXCEPTIONS ...
CASE sy-subrc.
    ...
```

## Example (After)

```ABAP
CALL FUNCTION...
    ...
    EXCEPTIONS ...
CASE sy-subrc.
    ...
```

# Where Can I Learn More?

## References

- [Access - ABAP Programming Guidelines](https://help.sap.com/doc/abapdocu_750_index_htm/7.50/en-US/abensyst_field_access_guidl.htm)