Avoid usage of the `var` keyword.

# Why is This a Problem?
Usage of the `var` keyword makes the code harder to understand because the type of a variable becomes not immediately clear.
This can lead to error-prone code throughout the following usage of the variable. 

## Exceptions
If the type is apparent, the usage of `var` can be justifiable. For example in the following two cases:
```cs
var x = 1;
var y = new Bar();
```

# How Can I Resolve This?
Explicitly state the type of the variable.

## Example (Before)

```cs
var x = y.Foo(z).Bar();
```

## Example (After)

```cs
string x = y.Foo(z).Bar();
```

# Where Can I Learn More?

## References
- https://docs.microsoft.com/de-de/archive/blogs/ericlippert/uses-and-misuses-of-implicit-typing