Negative formulations in specifications can cause confusion and incorrect interpretations.
It is preferable to use positive, clear, and direct statements.

# What Does This Check Look For?

This check reports a finding whenever a negative formulation,
such as the usage of the word "not" or its abbreviations, is detected.

# Why is This a Problem?

Negative formulations can lead to ambiguity and confusion,
as they require the reader to infer or guess what *should* be in the specification.
This could potentially lead to misunderstandings or mistakes in implementation, testing, or operation,
especially in complex systems where precise specifications are critical.
Expressing your requirement in a positive and direct manner reduces the risk of uncertainty and misinterpretation.

# How Can I Resolve This?

Consider revising the negative statements into clear, positive instructions.
Along with removing the direct usage of "not", make sure to reverse the meaning adequately to maintain the original intent.

# Examples
## Non-Compliant

```NaturalLanguage
The system should not operate in low power mode. // non-compliant: use of "not" creates negative formulation
```

## Compliant

```NaturalLanguage
The system should operate in normal power mode. // compliant: direct positive instruction 
```
# Where Can I Learn More?

- [Guide: Plain Language Guidelines: Use Positive Language](https://www.plainlanguage.gov/guidelines/concise/use-positive-language/)