Logical conditions can be expressed in an If-Condition block instead of building it from logical operation blocks.
If an If-Condition Block is used, its condition shall be simple.
It shall contain no more than two primary expressions (input, constant, constant parameter, or an expression in parentheses such as `(a<b)`).

If the condition contains more than two primary expressions, they shall be separated by the same logical operators.

Acceptable conditions:
``` js
a
~a
(a < b)
(a < b) && (c <= d)
a && b && c
```
Negations may be used with or without parentheses, i.e. all the following examples are valid conditions:
``` js
u1 && ~u2
u1 && (~u2)
(~u1) && (~u2)
(u1 > 0) && ~u2
```

## Guidelines

- [MAB Modeling Guideline (Version 6.0)](https://mathworks.com/help/simulink/mdl_gd/maab/na_0003simplelogicalexpressionsinifconditionblock.html)

## References

- Corresponding Model Advisor check [MAAB na_0003](https://www.mathworks.com/help/slcheck/ref/check-logical-expressions-in-if-blocks.html)
