A signal shall be labeled if it is coming from or going to blocks of certain (configurable) types.
By default, the block
types that require labels on outgoing signal lines are:

- `Inport`, `From`, `Subsystem`, `Stateflow Chart`, `Bus Selector`, `Demux`, `Selector`, `Data Store Read`,
  and `Constant`

Signal lines from `Constant` blocks do not require a label if the constant value has a meaningful name, e.g., if the value is a parameter or function.
If the constant value is a numeric value, a label is required.

By default, the block types that require labels on incoming signal lines are:

- `Outport`, `Goto`, `Data Store Write`, `Bus Creator`, `Mux`, `Subsystem`, and `Stateflow Chart`

Signal lines from/to `Subsystem` and `Stateflow Chart` blocks do not require a label if the `Format->Port Labels` option
of the block is set to `Signal Names`.

Signal lines from blocks that have the `Icon Display` option set to `Signal Name` or `Tag and Signal Name` don't require
a label unless the block is an `Inport`, `Bus Selector`, `Demux`, or `Selector` block.

## Guidelines

- [MAB Modeling Guideline (Version 6.0)](https://mathworks.com/help/simulink/mdl_gd/maab/na_0008displayoflabelsonsignals.html)

## References

- Corresponding Model Advisor check [MAAB na_0008](https://www.mathworks.com/help/slcheck/ref/check-signal-line-labels.html)
