<h2>Why is this an issue?</h2>
<p>JUnit5 is more tolerant regarding the visibilities of Test classes and methods than JUnit4, which required everything to be public. JUnit5 supports
default package, public and protected visibility, even if it is recommended to use the default package visibility, which improves the readability of
code.</p>
<p>But JUnit5 ignores without any warning:</p>
<ul>
  <li> private classes and private methods </li>
  <li> static methods </li>
  <li> methods returning a value without being a TestFactory </li>
</ul>
<h3>Noncompliant code example</h3>

```java
import org.junit.jupiter.api.Test;

class MyClassTest {
  @Test
  private void test1() { // Noncompliant - ignored by JUnit5
    // ...
  }
  @Test
  static void test2() { // Noncompliant - ignored by JUnit5
    // ...
  }
  @Test
  boolean test3() { // Noncompliant - ignored by JUnit5
    // ...
  }
  @Nested
  private class MyNestedClass { // Noncompliant - ignored by JUnit5
    @Test
    void test() {
      // ...
    }
  }
}
```
<h3>Compliant solution</h3>

```java
import org.junit.jupiter.api.Test;

class MyClassTest {
  @Test
  void test1() {
    // ...
  }
  @Test
  void test2() {
    // ...
  }
  @Test
  void test3() {
    // ...
  }
  @Nested
  class MyNestedClass {
    @Test
    void test() {
      // ...
    }
  }
}
```