/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public abstract class ProjectIdBase
implements IProjectId,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}$");
    @JsonValue
    public final String projectId;

    protected ProjectIdBase(String projectId) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID must not be empty");
        this.projectId = projectId;
    }

    protected boolean isUuidFormat() {
        return ProjectIdBase.isUuidIdFormat(this.projectId);
    }

    public String toString() {
        return this.projectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectIdBase that = (ProjectIdBase)o;
        return Objects.equals(this.projectId, that.projectId);
    }

    public int hashCode() {
        return Objects.hash(this.projectId);
    }

    @Override
    public int compareTo(IProjectId o) {
        return this.toString().compareTo(o.toString());
    }

    private static boolean isUuidIdFormat(String id) {
        return UUID_PATTERN.matcher(id).matches();
    }

    public static IProjectId convert(String projectId) {
        if (StringUtils.isEmpty((String)projectId)) {
            return null;
        }
        if (ProjectIdBase.isUuidIdFormat(projectId)) {
            return new InternalProjectId(projectId);
        }
        return new PublicProjectId(projectId);
    }
}

