/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared.tests;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum ETestExecutionResult {
    PASSED("passed"),
    IGNORED("ignored"),
    SKIPPED("skipped"),
    FAILURE("failure"),
    ERROR("error"),
    INCONCLUSIVE("inconclusive");

    private String readableName;
    public static final String ALL_RESULTS = "PASSED, IGNORED, SKIPPED, FAILURE, ERROR";
    public static final ETestExecutionResult BEST_RESULT;

    private ETestExecutionResult(String readableName) {
        this.readableName = readableName;
    }

    public static ETestExecutionResult worst(@Nullable ETestExecutionResult resultA, @Nullable ETestExecutionResult resultB) {
        if (resultA == null) {
            return resultB;
        }
        if (resultB == null) {
            return resultA;
        }
        if (resultA.ordinal() < resultB.ordinal()) {
            return resultB;
        }
        return resultA;
    }

    public String getReadableName() {
        return this.readableName;
    }

    public static List<String> getReadableNames() {
        return Arrays.stream(ETestExecutionResult.values()).map(ETestExecutionResult::getReadableName).collect(Collectors.toList());
    }

    static {
        BEST_RESULT = ETestExecutionResult.values()[0];
    }
}

