/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.resource.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class UniformPathUtils {
    public static final Pattern DRIVE_LETTER_PATTERN = Pattern.compile("[A-Za-z]:/(.*)");
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR = String.valueOf('/');
    public static final String ARCHITECTURE_FILE_EXTENSION = ".architecture";

    public static String extractProject(String uniformPath) {
        return StringUtils.getFirstParts((String)uniformPath, (int)1, (char)'/');
    }

    public static String stripProject(String uniformPath) {
        int pos = uniformPath.indexOf(47);
        if (pos >= 0) {
            return uniformPath.substring(pos + 1);
        }
        return uniformPath;
    }

    public static String getElementName(String uniformPath) {
        return StringUtils.getLastPart((String)uniformPath, (char)'/');
    }

    public static String getParentPath(String uniformPath) {
        int lastSlash = uniformPath.length();
        while ((lastSlash = uniformPath.lastIndexOf(47, lastSlash - 1)) != -1 && (lastSlash <= 0 || uniformPath.charAt(lastSlash - 1) == '\\')) {
        }
        if (lastSlash == -1) {
            return "";
        }
        return uniformPath.substring(0, lastSlash);
    }

    public static String removeFirstSegments(String uniformPath, int count) {
        String[] segments = UniformPathUtils.splitPath(uniformPath);
        return UniformPathUtils.concatenate(Arrays.copyOfRange(segments, count, segments.length));
    }

    public static String removeLastSegments(String uniformPath, int count) {
        String[] segments = UniformPathUtils.splitPath(uniformPath);
        return UniformPathUtils.concatenate(Arrays.copyOfRange(segments, 0, segments.length - count));
    }

    public static String[] splitPath(String uniformPath) {
        int currentOffset = -1;
        ArrayList<Integer> splitPositions = new ArrayList<Integer>();
        while ((currentOffset = uniformPath.indexOf(47, currentOffset + 1)) != -1) {
            if (currentOffset != 0 && (currentOffset > uniformPath.length() - 1 || uniformPath.charAt(currentOffset - 1) == '\\')) continue;
            splitPositions.add(currentOffset);
        }
        if (splitPositions.isEmpty()) {
            return new String[]{uniformPath};
        }
        String[] segments = new String[splitPositions.size() + 1];
        for (int i = 0; i < splitPositions.size(); ++i) {
            segments[i] = i == 0 ? uniformPath.substring(0, (Integer)splitPositions.get(i)) : uniformPath.substring((Integer)splitPositions.get(i - 1) + 1, (Integer)splitPositions.get(i));
            if (i != splitPositions.size() - 1) continue;
            segments[i + 1] = uniformPath.substring((Integer)splitPositions.get(i) + 1);
        }
        return segments;
    }

    public static @Nullable String getExtension(String uniformPath) {
        String name = UniformPathUtils.getElementName(uniformPath);
        int posLastDot = name.lastIndexOf(46);
        if (posLastDot < 0) {
            return null;
        }
        return name.substring(posLastDot + 1);
    }

    public static boolean isArchitectureFile(String uniformPath) {
        return !uniformPath.startsWith(UniformPath.EType.ARCHITECTURE.getPrefix()) && ARCHITECTURE_FILE_EXTENSION.equals("." + UniformPathUtils.getExtension(uniformPath));
    }

    public static boolean isArchitectureFile(UniformPath uniformPath) {
        return UniformPathUtils.isArchitectureFile(uniformPath.toStringAsMigrationFrontier());
    }

    public static boolean isArchitectureRootComponent(String uniformPath) {
        return uniformPath.startsWith(UniformPath.EType.ARCHITECTURE.getPrefix()) && ARCHITECTURE_FILE_EXTENSION.equals("." + UniformPathUtils.getExtension(uniformPath));
    }

    public static String normalizeAllSeparators(String path) {
        int pathLength = path.length();
        char[] result = new char[pathLength];
        int skippedChars = 0;
        boolean previousWasPathSeparator = false;
        boolean madeChanges = false;
        block4: for (int i = 0; i < pathLength; ++i) {
            char currentChar = path.charAt(i);
            switch (currentChar) {
                case '\\': {
                    madeChanges = true;
                }
                case '/': {
                    if (previousWasPathSeparator) {
                        madeChanges = true;
                        ++skippedChars;
                        continue block4;
                    }
                    result[i - skippedChars] = 47;
                    previousWasPathSeparator = true;
                    continue block4;
                }
                default: {
                    result[i - skippedChars] = currentChar;
                    previousWasPathSeparator = false;
                }
            }
        }
        if (madeChanges) {
            return new String(Arrays.copyOfRange(result, 0, result.length - skippedChars));
        }
        return path;
    }

    public static String cleanPath(String path) {
        String[] parts = UniformPathUtils.splitPath(path);
        block0: for (int i = 0; i < parts.length; ++i) {
            if ("".equals(parts[i]) || ".".equals(parts[i])) {
                parts[i] = null;
                continue;
            }
            if (!"..".equals(parts[i])) continue;
            for (int j = i - 1; j >= 0 && !"..".equals(parts[j]); --j) {
                if (parts[j] == null) continue;
                parts[j] = null;
                parts[i] = null;
                continue block0;
            }
        }
        return UniformPathUtils.joinPath(parts);
    }

    private static String joinPath(String[] parts) {
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part == null) continue;
            if (!sb.isEmpty()) {
                sb.append('/');
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static String resolveRelativePath(String basePath, String relative) {
        Object directory = UniformPathUtils.getParentPath(basePath);
        if (!((String)directory).isEmpty()) {
            directory = (String)directory + SEPARATOR;
        }
        return UniformPathUtils.cleanPath((String)directory + relative);
    }

    public static String concatenate(String ... parts) {
        ArrayList<String> list = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (StringUtils.isEmpty((String)part)) continue;
            list.add(part);
        }
        return StringUtils.concat(list, (String)SEPARATOR);
    }

    public static String createSystemIndependentPath(String path) {
        Matcher m1 = DRIVE_LETTER_PATTERN.matcher(UniformPathUtils.normalizeAllSeparators(path));
        if (m1.matches()) {
            path = m1.group(1);
        }
        path = StringUtils.stripPrefix((String)path, (String)"/");
        return path;
    }

    public static @NonNull UniformPath reduceToCommonPrefix(List<UniformPath> uniformPaths) {
        return (UniformPath)uniformPaths.stream().reduce(UniformPathUtils::getCommonPrefix).orElseThrow(() -> new IllegalArgumentException("uniformPaths must not be empty"));
    }

    private static @NonNull UniformPath getCommonPrefix(UniformPath p1, UniformPath p2) {
        String p2Value;
        String p1Value;
        if (p1.getType() != p2.getType()) {
            throw new IllegalArgumentException(String.format("Cannot find a common prefix for different uniform path types: %s (%s) and %s (%s)", new Object[]{p1.getType(), p1, p2.getType(), p2}));
        }
        ArrayList<String> segments = new ArrayList<String>();
        UnmodifiableIterator p1Segments = p1.getPathSegments().iterator();
        UnmodifiableIterator p2Segments = p2.getPathSegments().iterator();
        while (p1Segments.hasNext() && p2Segments.hasNext() && Objects.equals(p1Value = (String)p1Segments.next(), p2Value = (String)p2Segments.next())) {
            segments.add(p1Value);
        }
        return UniformPath.ofSegments(p1.getType(), segments);
    }

    private UniformPathUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

