/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.releasemanagement.webapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ArtifactSourceTrigger;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseTriggerBase;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ReleaseTriggerType;
import com.microsoft.alm.visualstudio.services.releasemanagement.webapi.ScheduledReleaseTrigger;
import java.io.IOException;

public class ReleaseTriggerBaseDeserializer
extends JsonDeserializer<ReleaseTriggerBase> {
    public ReleaseTriggerBase deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        JsonNode typeNode = rootNode.findValue("TriggerType");
        if (typeNode != null) {
            ReleaseTriggerType triggerType = null;
            if (typeNode.isInt() && typeNode.asInt() == ReleaseTriggerType.ARTIFACT_SOURCE.getValue()) {
                triggerType = ReleaseTriggerType.ARTIFACT_SOURCE;
            } else if (typeNode.isInt() && typeNode.asInt() == ReleaseTriggerType.SCHEDULE.getValue()) {
                triggerType = ReleaseTriggerType.SCHEDULE;
            } else if (typeNode.isTextual() && ReleaseTriggerType.ARTIFACT_SOURCE.toString().equalsIgnoreCase(typeNode.asText())) {
                triggerType = ReleaseTriggerType.ARTIFACT_SOURCE;
            } else if (typeNode.isTextual() && ReleaseTriggerType.SCHEDULE.toString().equalsIgnoreCase(typeNode.asText())) {
                triggerType = ReleaseTriggerType.SCHEDULE;
            }
            if (ReleaseTriggerType.SCHEDULE == triggerType) {
                return (ReleaseTriggerBase)rootNode.traverse((ObjectCodec)mapper).readValueAs(ScheduledReleaseTrigger.class);
            }
            if (ReleaseTriggerType.ARTIFACT_SOURCE == triggerType) {
                return (ReleaseTriggerBase)rootNode.traverse((ObjectCodec)mapper).readValueAs(ArtifactSourceTrigger.class);
            }
        }
        return null;
    }
}

