/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IFailure;
import com.microsoft.tfs.core.clients.build.IQueuedBuild;
import com.microsoft.tfs.core.clients.build.IQueuedBuildQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildInformationNode;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import com.microsoft.tfs.core.clients.build.internal.utils.QueryResultHelper;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import java.util.HashMap;
import java.util.Map;
import ms.tfs.build.buildservice._04._BuildAgent;
import ms.tfs.build.buildservice._04._BuildController;
import ms.tfs.build.buildservice._04._BuildDefinition;
import ms.tfs.build.buildservice._04._BuildDetail;
import ms.tfs.build.buildservice._04._BuildQueueQueryResult;
import ms.tfs.build.buildservice._04._BuildServiceHost;
import ms.tfs.build.buildservice._04._QueuedBuild;

public class BuildQueueQueryResult
extends WebServiceObjectWrapper
implements IQueuedBuildQueryResult {
    private final QueuedBuild[] queuedBuilds;
    private final BuildAgent[] agents;
    private final BuildController[] controllers;
    private final BuildDefinition[] definitions;
    private final BuildDetail[] builds;
    private final BuildServiceHost[] serviceHosts;

    public BuildQueueQueryResult(IBuildServer buildServer, _BuildQueueQueryResult webServiceObject) {
        super(webServiceObject);
        Check.notNull(buildServer, "buildServer");
        this.serviceHosts = BuildTypeConvertor.toBuildServiceHostArray(buildServer, this.getWebServiceObject().getServiceHosts());
        this.controllers = BuildTypeConvertor.toBuildControllersArray(buildServer, this.getWebServiceObject().getControllers());
        this.agents = BuildTypeConvertor.toBuildAgentArray(this.getWebServiceObject().getAgents());
        this.definitions = BuildTypeConvertor.toBuildDefinitionArray(buildServer, this.getWebServiceObject().getDefinitions());
        this.builds = BuildTypeConvertor.toBuildDetailArray(buildServer, this.getWebServiceObject().getBuilds());
        this.queuedBuilds = BuildTypeConvertor.toQueuedBuildArray(buildServer, this.getWebServiceObject().getQueuedBuilds());
        this.afterDeserialize(buildServer);
    }

    public BuildQueueQueryResult(BuildServer buildServer, BuildAgent[] agents, BuildController[] controllers, BuildDefinition[] definitions, QueuedBuild[] queuedBuilds, BuildServiceHost[] serviceHosts, BuildDetail[] buildDetails) {
        super(new _BuildQueueQueryResult());
        Check.notNull(buildServer, "buildServer");
        Check.notNull(agents, "agents");
        Check.notNull(controllers, "controllers");
        Check.notNull(definitions, "definitions");
        Check.notNull(queuedBuilds, "queuedBuilds");
        Check.notNull(serviceHosts, "serviceHosts");
        Check.notNull(buildDetails, "buildDetails");
        this.agents = agents;
        this.controllers = controllers;
        this.definitions = definitions;
        this.queuedBuilds = queuedBuilds;
        this.serviceHosts = serviceHosts;
        this.builds = buildDetails;
        _BuildAgent[] _agents = (_BuildAgent[])WrapperUtils.unwrap(_BuildAgent.class, agents);
        _BuildController[] _controllers = (_BuildController[])WrapperUtils.unwrap(_BuildController.class, controllers);
        _BuildDefinition[] _definitions = (_BuildDefinition[])WrapperUtils.unwrap(_BuildDefinition.class, definitions);
        _QueuedBuild[] _queuedBuilds = (_QueuedBuild[])WrapperUtils.unwrap(_QueuedBuild.class, queuedBuilds);
        _BuildServiceHost[] _serviceHosts = (_BuildServiceHost[])WrapperUtils.unwrap(_BuildServiceHost.class, serviceHosts);
        _BuildDetail[] _buildDetails = (_BuildDetail[])WrapperUtils.unwrap(_BuildDetail.class, buildDetails);
        this.getWebServiceObject().setAgents(_agents);
        this.getWebServiceObject().setControllers(_controllers);
        this.getWebServiceObject().setDefinitions(_definitions);
        this.getWebServiceObject().setQueuedBuilds(_queuedBuilds);
        this.getWebServiceObject().setServiceHosts(_serviceHosts);
        this.getWebServiceObject().setBuilds(_buildDetails);
        this.afterDeserialize(buildServer);
    }

    public _BuildQueueQueryResult getWebServiceObject() {
        return (_BuildQueueQueryResult)this.webServiceObject;
    }

    @Override
    public IQueuedBuild[] getQueuedBuilds() {
        return this.queuedBuilds;
    }

    @Override
    public IFailure[] getFailures() {
        return new IFailure[0];
    }

    private void afterDeserialize(IBuildServer buildServer) {
        Map<String, BuildController> controllerDict = QueryResultHelper.match(this.serviceHosts, this.controllers, this.agents);
        HashMap<String, BuildDefinition> definitionDict = new HashMap<String, BuildDefinition>();
        HashMap<String, WebServiceObjectWrapper> buildDict = new HashMap<String, WebServiceObjectWrapper>();
        for (BuildDefinition buildDefinition : this.definitions) {
            definitionDict.put(buildDefinition.getURI(), buildDefinition);
            if (!controllerDict.containsKey(buildDefinition.getBuildControllerURI())) continue;
            buildDefinition.setBuildController(controllerDict.get(buildDefinition.getBuildControllerURI()));
        }
        for (WebServiceObjectWrapper webServiceObjectWrapper : this.builds) {
            buildDict.put(((BuildDetail)webServiceObjectWrapper).getURI(), webServiceObjectWrapper);
            if (controllerDict.containsKey(((BuildDetail)webServiceObjectWrapper).getBuildControllerURI())) {
                ((BuildDetail)webServiceObjectWrapper).setBuildController(controllerDict.get(((BuildDetail)webServiceObjectWrapper).getBuildControllerURI()));
            }
            if (definitionDict.containsKey(((BuildDetail)webServiceObjectWrapper).getBuildDefinitionURI())) {
                ((BuildDetail)webServiceObjectWrapper).setBuildDefinition((IBuildDefinition)definitionDict.get(((BuildDetail)webServiceObjectWrapper).getBuildDefinitionURI()));
            }
            for (BuildInformationNode informationNode : ((BuildDetail)webServiceObjectWrapper).getInternalInformation()) {
                informationNode.setBuild((BuildDetail)webServiceObjectWrapper);
            }
        }
        for (WebServiceObjectWrapper webServiceObjectWrapper : this.queuedBuilds) {
            if (webServiceObjectWrapper == null) continue;
            if (controllerDict.containsKey(((QueuedBuild)webServiceObjectWrapper).getBuildControllerURI())) {
                ((QueuedBuild)webServiceObjectWrapper).setBuildController(controllerDict.get(((QueuedBuild)webServiceObjectWrapper).getBuildControllerURI()));
            }
            if (definitionDict.containsKey(((QueuedBuild)webServiceObjectWrapper).getBuildDefinitionURI())) {
                ((QueuedBuild)webServiceObjectWrapper).setBuildDefinition((IBuildDefinition)definitionDict.get(((QueuedBuild)webServiceObjectWrapper).getBuildDefinitionURI()));
            }
            for (String buildUri : ((QueuedBuild)webServiceObjectWrapper).getBuildURIs()) {
                BuildDetail buildDetail = (BuildDetail)buildDict.get(buildUri);
                if (buildDetail == null) continue;
                ((QueuedBuild)webServiceObjectWrapper).getAllBuilds().add(buildDetail);
                buildDetail.addRequest((IQueuedBuild)((Object)webServiceObjectWrapper));
            }
        }
    }
}

