/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.compatibility;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceTypes;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.core.clients.framework.configuration.TFSWebSiteEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.TFSCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.OrganizationalRootEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProcessGuidanceEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSWebSiteEntityUtils;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.GUID;

public class ProcessGuidanceCompatibilityEntity
extends TFSCompatibilityEntity
implements ProcessGuidanceEntity,
TFSWebSiteEntity.TFSRelativeWebSiteEntity {
    protected ProcessGuidanceCompatibilityEntity(TFSCompatibilityEntity parent) {
        super(parent);
    }

    @Override
    public GUID getResourceID() {
        return CatalogResourceTypes.PROCESS_GUIDANCE_SITE;
    }

    @Override
    public String getDisplayName() {
        return "Process Guidance";
    }

    @Override
    public String getResourceSubType() {
        return "WssDocumentLibrary";
    }

    @Override
    public String getASCIIName() {
        return "Process Guidance";
    }

    @Override
    public String getRelativePath() {
        TeamProjectEntity teamProject = this.getAncestorOfType(TeamProjectEntity.class);
        if (teamProject == null) {
            return null;
        }
        return URIUtils.combinePaths(this.getConnection().getRegistrationClient().getServiceInterfaceURL("Wss", "BaseSiteUrl"), teamProject.getProjectName());
    }

    @Override
    public TFSEntity getReferencedResource() {
        OrganizationalRootEntity organizationalRoot = this.getAncestorOfType(OrganizationalRootEntity.class);
        if (organizationalRoot != null) {
            return organizationalRoot.getSharePointWebApplication();
        }
        return null;
    }

    @Override
    public String getFullyQualifiedURL() {
        return TFSWebSiteEntityUtils.getFullItemPath(this);
    }
}

