/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.compatibility;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceTypes;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.core.clients.framework.configuration.TFSWebSiteEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.TFSCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.OrganizationalRootEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectPortalEntity;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSWebSiteEntityUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;

public class ProjectPortalCompatibilityEntity
extends TFSCompatibilityEntity
implements ProjectPortalEntity,
TFSWebSiteEntity.TFSRelativeWebSiteEntity {
    private final String projectName;

    protected ProjectPortalCompatibilityEntity(TFSCompatibilityEntity parent, String projectName) {
        super(parent);
        Check.notNull(projectName, "projectName");
        this.projectName = projectName;
    }

    @Override
    public GUID getResourceID() {
        return CatalogResourceTypes.PROJECT_PORTAL;
    }

    @Override
    public String getDisplayName() {
        return "Project Portal";
    }

    @Override
    public String getResourceSubType() {
        return "WssSite";
    }

    @Override
    public GUID getOwnedWebIdentifier() {
        return null;
    }

    @Override
    public TFSEntity getReferencedResource() {
        OrganizationalRootEntity organizationalRoot = this.getAncestorOfType(OrganizationalRootEntity.class);
        if (organizationalRoot != null) {
            return organizationalRoot.getSharePointWebApplication();
        }
        return null;
    }

    @Override
    public String getRelativePath() {
        return this.projectName;
    }

    @Override
    public String getFullItemPath() {
        return TFSWebSiteEntityUtils.getFullItemPath(this);
    }
}

