/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol;

import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.events.ConflictResolvedEvent;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolveErrorHandler;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolvedHandler;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import java.util.ArrayList;
import java.util.List;

public class ResolveLocalConflictHandler
implements ConflictResolvedHandler,
ConflictResolveErrorHandler {
    private final VersionControlClient client;
    private final Workspace workspace;
    private final List<GetRequest> getRequests = new ArrayList<GetRequest>();
    private ChangePendedFlags flags;

    public ResolveLocalConflictHandler(VersionControlClient client, Workspace workspace) {
        this.client = client;
        this.workspace = workspace;
    }

    public List<GetRequest> getGetRequests() {
        return this.getRequests;
    }

    public ChangePendedFlags getFlags() {
        return this.flags;
    }

    @Override
    public void conflictResolved(Conflict conflict, GetOperation[] getOps, GetOperation[] undoOps, Conflict[] resolvedConflicts, ChangePendedFlags changePendedFlags) {
        conflict.setResolved(true);
        this.client.getEventEngine().fireConflictResolved(new ConflictResolvedEvent(EventSource.newFromHere(), this.workspace, conflict, changePendedFlags));
        String path = conflict.getTargetLocalItem();
        if (path == null) {
            path = conflict.getSourceLocalItem();
        }
        ChangesetVersionSpec version = conflict.getTheirVersion() != 0 ? new ChangesetVersionSpec(conflict.getTheirVersion()) : new ChangesetVersionSpec(1);
        this.getRequests.add(new GetRequest(new ItemSpec(path, RecursionType.NONE), version));
    }

    @Override
    public void conflictResolveError(Conflict conflict, Exception exception) {
        this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), this.workspace, (Throwable)exception));
    }
}

