/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionStatus;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class CoreConflictResolution
extends ConflictResolution {
    private final Resolution resolution;
    private String newPath;
    private FileEncoding newEncoding;

    public CoreConflictResolution(ConflictDescription conflictDescription, String description, String helpText, ConflictResolutionOptions options, Resolution resolution) {
        super(conflictDescription, description, helpText, options);
        Check.notNull(resolution, "resolution");
        this.resolution = resolution;
    }

    @Override
    public ConflictResolution newForConflictDescription(ConflictDescription conflictDescription) {
        return new CoreConflictResolution(conflictDescription, this.getDescription(), this.getHelpText(), ConflictResolutionOptions.NONE, this.resolution);
    }

    @Override
    public void setNewPath(String newPath) {
        if (!this.needsNewPath()) {
            throw new TECoreException(MessageFormat.format(Messages.getString("CoreConflictResolution.ResolutionTypeDoesNotAcceptNewPathsFormat"), this.getDescription()));
        }
        this.newPath = newPath;
    }

    @Override
    public void setEncoding(FileEncoding newEncoding) {
        if (!this.needsEncodingSelection()) {
            throw new TECoreException(MessageFormat.format(Messages.getString("CoreConflictResolution.ResolutionTypeDoesNotAcceptNewEncodingsFormat"), this.getDescription()));
        }
        this.newEncoding = newEncoding;
    }

    @Override
    public ConflictResolutionStatus work() {
        ConflictDescription conflictDescription = this.getConflictDescription();
        Workspace workspace = conflictDescription.getWorkspace();
        Conflict conflict = conflictDescription.getConflict();
        conflict.setResolution(this.resolution);
        if (this.newPath != null) {
            conflict.getResolutionOptions().setNewPath(this.newPath);
        }
        if (this.newEncoding != null) {
            conflict.getResolutionOptions().setEncodingStrategy(ResolutionOptions.EncodingStrategy.CONVERT_EXPLICIT, this.newEncoding);
            conflict.getResolutionOptions().setAcceptMergeEncoding(this.newEncoding);
        }
        workspace.resolveConflict(conflict);
        if (conflict.isResolved()) {
            return ConflictResolutionStatus.SUCCESS;
        }
        if (conflict.getContentMergeSummary() != null && conflict.getContentMergeSummary().getTotalConflictingLines() > 0) {
            this.setErrorMessage(Messages.getString("CoreConflictResolution.ConflictingContentChanges"));
        }
        conflict.setResolution(Resolution.NONE);
        return ConflictResolutionStatus.FAILED;
    }

    public Resolution getResolution() {
        return this.resolution;
    }
}

