/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ExternalConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.externaltools.ExternalTool;
import com.microsoft.tfs.core.externaltools.ExternalToolset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;

public final class ExternalConflictResolutionContributor
implements ConflictResolutionContributor {
    private final ExternalToolset mergeToolset;

    public ExternalConflictResolutionContributor(ExternalToolset mergeToolset) {
        this.mergeToolset = mergeToolset;
    }

    @Override
    public Collection<ConflictResolution> getConflictResolutions(ConflictDescription conflictDescription, ConflictResolutionOptions resolutionOptions) {
        if (conflictDescription == null || conflictDescription.getConflict() == null || this.mergeToolset == null) {
            return null;
        }
        ChangeType deleteAtRollback = ChangeType.ROLLBACK.combine(ChangeType.DELETE);
        if (conflictDescription.getConflict().getBaseChangeType().containsAll(deleteAtRollback)) {
            return null;
        }
        ExternalTool mergeTool = this.mergeToolset.findTool(conflictDescription.getLocalPath());
        if (mergeTool == null) {
            return null;
        }
        String programName = LocalPath.getFileName(mergeTool.getOriginalCommand());
        String resolutionDescriptionText = MessageFormat.format(Messages.getString("ExternalConflictResolutionContributor.ResolutionNameFormat"), programName);
        String resolutionHelpText = MessageFormat.format(Messages.getString("ExternalConflictResolutionContributor.ResolutionHelpTextFormat"), programName);
        ArrayList<ConflictResolution> resolutions = new ArrayList<ConflictResolution>();
        resolutions.add(new ExternalConflictResolution(conflictDescription, resolutionDescriptionText, resolutionHelpText, resolutionOptions, this.mergeToolset));
        return resolutions;
    }
}

