/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.exceptions;

import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ActionDeniedBySubscriberException;
import java.util.HashMap;
import java.util.Map;

public class GatedCheckinException
extends ActionDeniedBySubscriberException {
    public Map<String, String> affectedBuildDefinitions = null;
    public String[] affectedBuildDefinitionNames = null;
    public String[] affectedBuildDefinitionURIs = null;

    public GatedCheckinException(ActionDeniedBySubscriberException e) {
        super(e.getMessage());
        this.setProperties(e.getProperties());
    }

    public Map<String, String> getAffectedBuildDefinitions() {
        if (this.affectedBuildDefinitions == null) {
            this.affectedBuildDefinitions = new HashMap<String, String>();
            String[] definitionURIs = this.getProperties().getStringArrayProperty("AffectedBuildDefinitionUris");
            String[] definitionNames = this.getProperties().getStringArrayProperty("AffectedBuildDefinitionNames");
            if (definitionURIs != null && definitionNames != null) {
                if (definitionURIs.length == definitionNames.length) {
                    for (int i = 0; i < definitionURIs.length; ++i) {
                        this.affectedBuildDefinitions.put(definitionNames[i], definitionURIs[i]);
                    }
                }
                this.affectedBuildDefinitionNames = definitionNames;
                this.affectedBuildDefinitionURIs = definitionURIs;
            } else {
                this.affectedBuildDefinitionNames = new String[0];
                this.affectedBuildDefinitionURIs = new String[0];
            }
        }
        return this.affectedBuildDefinitions;
    }

    public String[] getAffectedBuildDefinitionNames() {
        if (this.affectedBuildDefinitionNames == null) {
            this.getAffectedBuildDefinitions();
        }
        return this.affectedBuildDefinitionNames;
    }

    public String[] getAffectedBuildDefinitionURIs() {
        if (this.affectedBuildDefinitionURIs == null) {
            this.getAffectedBuildDefinitions();
        }
        return this.affectedBuildDefinitionURIs;
    }

    public String getCheckinTicket() {
        return this.getProperties().getStringProperty("CheckInTicket");
    }

    public String getShelvesetName() {
        return this.getProperties().getStringProperty("ShelvesetName");
    }

    public boolean getOverridePermission() {
        return this.getProperties().getBooleanProperty("HasOverridePermission");
    }

    public int getSubCode() {
        return this.getProperties().getIntProperty("SubCode");
    }

    public int getQueueID() {
        if (this.getProperties().hasIntProperty("QueueId")) {
            return this.getProperties().getIntProperty("QueueId");
        }
        return 0;
    }
}

