/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.framework.ServerDataProvider;
import com.microsoft.tfs.core.clients.framework.internal.ServiceInterfaceIdentifiers;
import com.microsoft.tfs.core.clients.versioncontrol.ChangePendedFlags;
import com.microsoft.tfs.core.clients.versioncontrol.CheckinFlags;
import com.microsoft.tfs.core.clients.versioncontrol.DestroyFlags;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ILocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.MergeFlags;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.QueryMergesExtendedOptions;
import com.microsoft.tfs.core.clients.versioncontrol.ResolveErrorOptions;
import com.microsoft.tfs.core.clients.versioncontrol.RollbackOptions;
import com.microsoft.tfs.core.clients.versioncontrol.SupportedFeatures;
import com.microsoft.tfs.core.clients.versioncontrol.UploadedBaselinesCollection;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspacePermissions;
import com.microsoft.tfs.core.clients.versioncontrol.Workstation;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.events.NonFatalErrorEvent;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.FeatureNotSupportedException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolveErrorHandler;
import com.microsoft.tfs.core.clients.versioncontrol.internal.conflict.ConflictResolvedHandler;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.QueuedEditsTable;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalMetadataTable;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Annotation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ArtifactPropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.BranchObject;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.BranchObjectOwnership;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.BranchProperties;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangesetMerge;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangesetMergeDetails;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNoteFieldDefinition;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ConflictType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedItem;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ExtendedMerge;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Failure;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.FileType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetRequest;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemIdentifier;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelChildOption;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LabelResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalPendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LocalVersion;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Mapping;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.MergeCandidate;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ReconcileResult;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RepositoryProperties;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RequestType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ServerSettings;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Shelveset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.VersionControlLabel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkingFolder;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkspaceItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.CheckinNotificationInfo;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.LocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.internal.ServerItemLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.LabelItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.WorkspaceInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.RuntimeWorkspaceCache;
import com.microsoft.tfs.core.config.persistence.PersistenceStoreProvider;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.core.exceptions.mappers.VersionControlExceptionMapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import com.microsoft.tfs.core.ws.runtime.serialization.ElementDeserializable;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import ms.tfs.versioncontrol.clientservices._03._ArtifactPropertyValue;
import ms.tfs.versioncontrol.clientservices._03._BranchRelative;
import ms.tfs.versioncontrol.clientservices._03._ChangeRequest;
import ms.tfs.versioncontrol.clientservices._03._CheckinNoteFieldDefinition;
import ms.tfs.versioncontrol.clientservices._03._CheckinResult;
import ms.tfs.versioncontrol.clientservices._03._ExtendedItem;
import ms.tfs.versioncontrol.clientservices._03._FileType;
import ms.tfs.versioncontrol.clientservices._03._GetOperation;
import ms.tfs.versioncontrol.clientservices._03._GetRequest;
import ms.tfs.versioncontrol.clientservices._03._ItemIdentifier;
import ms.tfs.versioncontrol.clientservices._03._ItemSpec;
import ms.tfs.versioncontrol.clientservices._03._LabelItemSpec;
import ms.tfs.versioncontrol.clientservices._03._LatestVersionSpec;
import ms.tfs.versioncontrol.clientservices._03._LocalPendingChange;
import ms.tfs.versioncontrol.clientservices._03._LocalVersion;
import ms.tfs.versioncontrol.clientservices._03._LocalVersionUpdate;
import ms.tfs.versioncontrol.clientservices._03._LockLevel;
import ms.tfs.versioncontrol.clientservices._03._Mapping;
import ms.tfs.versioncontrol.clientservices._03._PendingState;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_CheckInResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_CheckInShelvesetResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_CreateBranchResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_MergeResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_PendChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_QueryPendingChangesForWorkspaceResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_QueryPendingSetsResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_QueryShelvedChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_ResolveResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_RollbackResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_UndoPendingChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository4Soap_UnshelveResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_CheckInResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_CheckInShelvesetResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_CreateBranchResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_DestroyResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_LabelItemResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_MergeResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_PendChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_QueryPendingSetsResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_ResolveResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_RollbackResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_UndoPendingChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_UnlabelItemResponse;
import ms.tfs.versioncontrol.clientservices._03._Repository5Soap_UnshelveResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_CheckInResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_CheckInShelvesetResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_MergeResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_PendChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_QueryPendingChangesForWorkspaceResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_ResolveResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_RollbackResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_TrackMergesResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_UndoPendingChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositoryExtensionsSoap_UnshelveResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_CheckInResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_DestroyResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_LabelItemResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_MergeResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_PendChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_QueryMergesResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_QueryPendingSetsResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_QueryShelvedChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_ResolveResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_UndoPendingChangesResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_UnlabelItemResponse;
import ms.tfs.versioncontrol.clientservices._03._RepositorySoap_UnshelveResponse;
import ms.tfs.versioncontrol.clientservices._03._ServerItemLocalVersionUpdate;
import ms.tfs.versioncontrol.clientservices._03._Shelveset;
import ms.tfs.versioncontrol.clientservices._03._Workspace;

public abstract class WebServiceLayer {
    private final VersionControlClient client;
    protected final RuntimeWorkspaceCache runtimeWorkspaceCache;
    private final WebServiceLevel serviceLevel;
    private SupportedFeatures supportedFeatures;
    private static final ThreadLocal<Boolean> playingBackQueuedEdits = new ThreadLocal();
    private final _RepositorySoap repository;
    private final _RepositoryExtensionsSoap repositoryExtensions;
    private final _Repository4Soap repository4;
    private final _Repository5Soap repository5;

    public WebServiceLayer(VersionControlClient client, _RepositorySoap repository, _RepositoryExtensionsSoap repositoryExtensions, _Repository4Soap repository4, _Repository5Soap repository5) {
        Check.notNull(client, "client");
        Check.notNull(repository, "repository");
        this.client = client;
        this.runtimeWorkspaceCache = client.getRuntimeWorkspaceCache();
        this.repository = repository;
        this.repositoryExtensions = repositoryExtensions;
        this.repository4 = repository4;
        this.repository5 = repository5;
        if (this.repository5 != null) {
            ServerDataProvider provider = client.getConnection().getServerDataProvider();
            String repository5Uri = provider.locationForCurrentConnection("ISCCProvider5", ServiceInterfaceIdentifiers.VERSION_CONTROL_5);
            String repository5Dot1Uri = provider.locationForCurrentConnection("ISCCProvider5.1", ServiceInterfaceIdentifiers.VERSION_CONTROL_5_DOT_1);
            String repository5Dot2Uri = provider.locationForCurrentConnection("ISCCProvider5.2", ServiceInterfaceIdentifiers.VERSION_CONTROL_5_DOT_2);
            this.serviceLevel = null != repository5Dot2Uri ? WebServiceLevel.TFS_2013 : (null != repository5Dot1Uri ? WebServiceLevel.TFS_2012_QU1_1 : (null != repository5Uri ? WebServiceLevel.TFS_2012_QU1 : WebServiceLevel.TFS_2012_QU1));
        } else if (this.repository4 != null) {
            ServerDataProvider provider = client.getConnection().getServerDataProvider();
            String repository4Dot1Uri = provider.locationForCurrentConnection("ISCCProvider4.1", ServiceInterfaceIdentifiers.VERSION_CONTROL_4_DOT_1);
            String repository4Dot2Uri = provider.locationForCurrentConnection("ISCCProvider4.2", ServiceInterfaceIdentifiers.VERSION_CONTROL_4_DOT_2);
            String repository4Dot3Uri = provider.locationForCurrentConnection("ISCCProvider4.3", ServiceInterfaceIdentifiers.VERSION_CONTROL_4_DOT_3);
            this.serviceLevel = null != repository4Dot3Uri ? WebServiceLevel.TFS_2012_3 : (null != repository4Dot2Uri ? WebServiceLevel.TFS_2012_2 : (null != repository4Dot1Uri ? WebServiceLevel.TFS_2012_1 : WebServiceLevel.TFS_2012));
        } else {
            this.serviceLevel = this.repositoryExtensions != null ? WebServiceLevel.TFS_2010 : WebServiceLevel.PRE_TFS_2010;
        }
    }

    public VersionControlClient getVersionControlClient() {
        return this.client;
    }

    protected _RepositorySoap getRepository() {
        return this.repository;
    }

    protected _RepositoryExtensionsSoap getRepositoryExtensions() {
        return this.repositoryExtensions;
    }

    protected _Repository4Soap getRepository4() {
        return this.repository4;
    }

    protected _Repository5Soap getRepository5() {
        return this.repository5;
    }

    public WebServiceLevel getServiceLevel() {
        return this.serviceLevel;
    }

    public SupportedFeatures getSupportedFeatures() {
        if (this.supportedFeatures == null) {
            try {
                this.supportedFeatures = this.getRepositoryProperties().getSupportedFeatures();
            }
            catch (ProxyException e) {
                throw VersionControlExceptionMapper.map(e);
            }
        }
        return this.supportedFeatures;
    }

    private void requireSupportedFeature(SupportedFeatures required, String featureNotSupportedMessage) {
        Check.notNull(required, "required");
        Check.notNull(featureNotSupportedMessage, "featureNotSupportedMessage");
        if (this.getServiceLevel() == WebServiceLevel.PRE_TFS_2010 && !this.getSupportedFeatures().containsAll(required)) {
            throw new FeatureNotSupportedException(featureNotSupportedMessage);
        }
    }

    private void requireServiceLevel(WebServiceLevel serviceLevel, String featureNotSupportedMessage) {
        Check.notNull(serviceLevel, "serviceLevel");
        Check.notNull(featureNotSupportedMessage, "featureNotSupportedMessage");
        if (this.getServiceLevel().getValue() < serviceLevel.getValue()) {
            throw new FeatureNotSupportedException(featureNotSupportedMessage);
        }
    }

    public void addConflict(String workspaceName, String ownerName, ConflictType conflictType, int itemId, int versionFrom, int pendingChangeId, String sourceLocalItem, String targetLocalItem, OperationStatus reason, String[] itemPropertyFilters) {
        try {
            this.playbackQueuedEdits(workspaceName, ownerName);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                this.repository5.addConflict(workspaceName, ownerName, conflictType.getWebServiceObject(), itemId, versionFrom, pendingChangeId, LocalPath.nativeToTFS(sourceLocalItem), LocalPath.nativeToTFS(targetLocalItem), reason.getValue(), 399);
            } else {
                this.repository.addConflict(workspaceName, ownerName, conflictType.getWebServiceObject(), itemId, versionFrom, pendingChangeId, LocalPath.nativeToTFS(sourceLocalItem), LocalPath.nativeToTFS(targetLocalItem), reason.getValue());
            }
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void promotePendingWorkspaceMappings(String workspaceName, String ownerName, int projectNotificationId) {
        try {
            this.repository5.promotePendingWorkspaceMappings(workspaceName, ownerName, projectNotificationId);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public String checkAuthentication() {
        try {
            return this.repository.checkAuthentication();
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public CheckinResult checkIn(String workspaceName, String ownerName, String[] serverItems, Changeset changeset, CheckinNotificationInfo checkinNotificationInfo, CheckinFlags checkinFlags, UploadedBaselinesCollection uploadedBaselinesCollection, AtomicReference<Failure[]> conflicts, AtomicReference<Failure[]> failures, boolean deferCheckIn, int checkInTicket, String[] itemPropertyFilters) {
        Check.notNull(changeset, "changeset");
        Check.notNull(checkinNotificationInfo, "checkinNotificationInfo");
        Check.notNull(checkinFlags, "checkinFlags");
        Check.notNull(conflicts, "conflicts");
        Check.notNull(failures, "failures");
        this.playbackQueuedEdits(workspaceName, ownerName);
        if (checkinFlags.contains(CheckinFlags.SUPPRESS_EVENT) || checkinFlags.contains(CheckinFlags.VALIDATE_CHECK_IN_OWNER) || checkInTicket != 0 || deferCheckIn) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.CheckInOptions2NotSupported"));
        }
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_CheckInResponse response = this.repository5.checkIn(workspaceName, ownerName, serverItems, changeset.getWebServiceObject(), checkinNotificationInfo.getWebServiceObject(), checkinFlags.toIntFlags(), deferCheckIn, checkInTicket, 399);
                conflicts.set((Failure[])WrapperUtils.wrap(Failure.class, response.getConflicts()));
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return new CheckinResult(response.getCheckInResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                _Repository4Soap_CheckInResponse response = this.repository4.checkIn(workspaceName, ownerName, serverItems, changeset.getWebServiceObject(), checkinNotificationInfo.getWebServiceObject(), checkinFlags.toIntFlags(), deferCheckIn, checkInTicket);
                conflicts.set((Failure[])WrapperUtils.wrap(Failure.class, response.getConflicts()));
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return new CheckinResult(response.getCheckInResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
                _RepositoryExtensionsSoap_CheckInResponse response = this.repositoryExtensions.checkIn(workspaceName, ownerName, serverItems, changeset.getWebServiceObject(), checkinNotificationInfo.getWebServiceObject(), checkinFlags.toIntFlags(), deferCheckIn, checkInTicket);
                failures.set(new Failure[0]);
                conflicts.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return new CheckinResult(response.getCheckInResult());
            }
            _RepositorySoap_CheckInResponse response = this.repository.checkIn(workspaceName, ownerName, serverItems, changeset.getWebServiceObject(), checkinNotificationInfo.getWebServiceObject(), checkinFlags.toCheckinOptions().getWebServiceObject(), deferCheckIn, checkInTicket);
            failures.set(new Failure[0]);
            conflicts.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            return new CheckinResult(response.getCheckInResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public CheckinResult checkInShelveset(String shelvesetName, String ownerName, String changesetOwner, CheckinNotificationInfo checkinNotificationInfo, CheckinFlags checkinFlags, AtomicReference<Failure[]> conflicts, AtomicReference<Failure[]> failures) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.CheckInShelvesetNotSupported"));
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_CheckInShelvesetResponse response = this.repository5.checkInShelveset(shelvesetName, ownerName, changesetOwner, checkinNotificationInfo.getWebServiceObject(), checkinFlags.toIntFlags(), 399);
                conflicts.set((Failure[])WrapperUtils.wrap(Failure.class, response.getConflicts()));
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return new CheckinResult(response.getCheckInShelvesetResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                _Repository4Soap_CheckInShelvesetResponse response = this.repository4.checkInShelveset(shelvesetName, ownerName, changesetOwner, checkinNotificationInfo.getWebServiceObject(), checkinFlags.toIntFlags());
                conflicts.set((Failure[])WrapperUtils.wrap(Failure.class, response.getConflicts()));
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return new CheckinResult(response.getCheckInShelvesetResult());
            }
            _RepositoryExtensionsSoap_CheckInShelvesetResponse response = this.repositoryExtensions.checkInShelveset(shelvesetName, ownerName, changesetOwner, checkinNotificationInfo.getWebServiceObject(), checkinFlags.toIntFlags());
            conflicts.set(new Failure[0]);
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            return new CheckinResult(response.getCheckInShelvesetResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Failure[] checkPendingChanges(String workspaceName, String ownerName, String[] serverItems) {
        try {
            this.playbackQueuedEdits(workspaceName, ownerName);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                return (Failure[])WrapperUtils.wrap(Failure.class, this.repository5.checkPendingChanges(workspaceName, ownerName, serverItems, 399));
            }
            return (Failure[])WrapperUtils.wrap(Failure.class, this.repository.checkPendingChanges(workspaceName, ownerName, serverItems));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void createAnnotation(String annotationName, String annotatedItem, int version, String annotationValue, String comment, boolean overwrite) {
        try {
            this.repository.createAnnotation(annotationName, annotatedItem, version, annotationValue, comment, overwrite);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public CheckinResult createBranch(String sourcePath, String targetPath, VersionSpec version, Changeset changeset, CheckinNotificationInfo checkinNotificationInfo, Mapping[] mappings, AtomicReference<Failure[]> failures) {
        this.requireSupportedFeature(SupportedFeatures.CREATE_BRANCH, Messages.getString("WebServiceLayer.CreateBranchNotSupported"));
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_CreateBranchResponse response = this.repository5.createBranch(sourcePath, targetPath, version.getWebServiceObject(), changeset.getWebServiceObject(), checkinNotificationInfo != null ? checkinNotificationInfo.getWebServiceObject() : null, (_Mapping[])(mappings != null ? WrapperUtils.unwrap(_Mapping.class, mappings) : null), 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return new CheckinResult(response.getCreateBranchResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                _Repository4Soap_CreateBranchResponse response = this.repository4.createBranch(sourcePath, targetPath, version.getWebServiceObject(), changeset.getWebServiceObject(), checkinNotificationInfo != null ? checkinNotificationInfo.getWebServiceObject() : null, (_Mapping[])(mappings != null ? WrapperUtils.unwrap(_Mapping.class, mappings) : null));
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return new CheckinResult(response.getCreateBranchResult());
            }
            _CheckinResult response = this.repository.createBranch(sourcePath, targetPath, version.getWebServiceObject(), changeset.getWebServiceObject(), checkinNotificationInfo != null ? checkinNotificationInfo.getWebServiceObject() : null, (_Mapping[])(mappings != null ? WrapperUtils.unwrap(_Mapping.class, mappings) : null));
            failures.set(new Failure[0]);
            return new CheckinResult(response);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void createCheckinNoteDefinition(String associatedServerItem, CheckinNoteFieldDefinition[] checkinNoteFields) {
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                this.repository5.createCheckinNoteDefinition(associatedServerItem, (_CheckinNoteFieldDefinition[])WrapperUtils.unwrap(_CheckinNoteFieldDefinition.class, checkinNoteFields), 399);
            } else {
                this.repository.createCheckinNoteDefinition(associatedServerItem, (_CheckinNoteFieldDefinition[])WrapperUtils.unwrap(_CheckinNoteFieldDefinition.class, checkinNoteFields));
            }
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Workspace createWorkspace(Workspace workspace) {
        if (workspace.getLocation().equals(WorkspaceLocation.LOCAL)) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012, Messages.getString("WebServiceLayer.LocalWorkspacesNotSupported"));
        }
        if (workspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN)) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_1, Messages.getString("WebServiceLayer.SetFileTimeNotSupported"));
        }
        if (workspace.getPermissionsProfile().getBuiltinIndex() != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.PublicWorkspacesNotSupported"));
        }
        if (this.getServiceLevel() == WebServiceLevel.PRE_TFS_2010) {
            boolean hasOneLevelMappings = false;
            for (WorkingFolder folder : workspace.getFolders()) {
                if (folder.getDepth() != RecursionType.ONE_LEVEL) continue;
                hasOneLevelMappings = true;
                break;
            }
            if (hasOneLevelMappings) {
                this.requireSupportedFeature(SupportedFeatures.ONE_LEVEL_MAPPING, Messages.getString("WebServiceLayer.DepthOneMappingsNotSupported"));
            }
        }
        try {
            _Workspace created = this.repository.createWorkspace(workspace.getWebServiceObject());
            if (created == null) {
                return null;
            }
            return new Workspace(created, this.getVersionControlClient());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void deleteAnnotation(String annotationName, String annotatedItem, int version, String annotationValue) {
        try {
            this.repository.deleteAnnotation(annotationName, annotatedItem, version, annotationValue);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void deleteBranchObject(ItemIdentifier rootItem) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.BranchObjectsNotSupported"));
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                this.repository5.deleteBranchObject(rootItem.getWebServiceObject(), 399);
            } else {
                this.repositoryExtensions.deleteBranchObject(rootItem.getWebServiceObject());
            }
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public LabelResult[] deleteLabel(String labelName, String labelScope) {
        try {
            return (LabelResult[])WrapperUtils.wrap(LabelResult.class, this.repository.deleteLabel(labelName, labelScope));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void deleteProxy(String proxyUrl) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.DeleteProxyNotSupported"));
        try {
            this.repositoryExtensions.deleteProxy(proxyUrl);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void deleteShelveset(String shelvesetName, String ownerName) {
        try {
            this.repository.deleteShelveset(shelvesetName, ownerName);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void deleteWorkspace(String workspaceName, String ownerName) {
        try {
            this.playbackQueuedEdits(workspaceName, ownerName);
            this.repository.deleteWorkspace(workspaceName, ownerName);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Item[] destroy(ItemSpec item, VersionSpec versionSpec, VersionSpec stopAtSpec, DestroyFlags flags, AtomicReference<Failure[]> failures, AtomicReference<PendingSet[]> pendingChanges, AtomicReference<PendingSet[]> shelvedChanges) {
        this.requireSupportedFeature(SupportedFeatures.DESTROY, Messages.getString("WebServiceLayer.DestroyNotSupported"));
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_DestroyResponse response = this.repository5.destroy(item.getWebServiceObject(), versionSpec.getWebServiceObject(), stopAtSpec != null ? stopAtSpec.getWebServiceObject() : null, flags.toIntFlags(), 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                pendingChanges.set((PendingSet[])WrapperUtils.wrap(PendingSet.class, response.getPendingChanges()));
                shelvedChanges.set((PendingSet[])WrapperUtils.wrap(PendingSet.class, response.getShelvedChanges()));
                return (Item[])WrapperUtils.wrap(Item.class, response.getDestroyResult());
            }
            _RepositorySoap_DestroyResponse response = this.repository.destroy(item.getWebServiceObject(), versionSpec.getWebServiceObject(), stopAtSpec != null ? stopAtSpec.getWebServiceObject() : null, flags.toIntFlags());
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            pendingChanges.set((PendingSet[])WrapperUtils.wrap(PendingSet.class, response.getPendingChanges()));
            shelvedChanges.set((PendingSet[])WrapperUtils.wrap(PendingSet.class, response.getShelvedChanges()));
            return (Item[])WrapperUtils.wrap(Item.class, response.getDestroyResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public GetOperation[][] get(String workspaceName, String ownerName, GetRequest[] requests, int maxResults, GetOptions options, String[] itemAttributeFilters, String[] itemPropertyFilters, boolean noGet) {
        _GetOperation[][] arrayOfArrays;
        if (null != itemPropertyFilters && itemPropertyFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        } else if (null != itemAttributeFilters && itemAttributeFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.AttributeOperationsNotSupported"));
        }
        this.playbackQueuedEdits(workspaceName, ownerName);
        Check.isTrue(maxResults == 0 || !options.contains(GetOptions.GET_ALL), "Should never specify GetOptions.FORCE_GET_ALL and non-zero maxResults simultaneously");
        options = options.remove(GetOptions.NO_DISK_UPDATE);
        if (noGet) {
            options = options.combine(GetOptions.PREVIEW);
        }
        try {
            arrayOfArrays = this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue() ? this.repository5.get(workspaceName, ownerName, (_GetRequest[])WrapperUtils.unwrap(_GetRequest.class, requests), maxResults, options.toIntFlags(), itemPropertyFilters, itemAttributeFilters, 399) : (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_2.getValue() ? this.repository4.get(workspaceName, ownerName, (_GetRequest[])WrapperUtils.unwrap(_GetRequest.class, requests), maxResults, options.toIntFlags(), itemPropertyFilters, itemAttributeFilters) : (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue() ? this.repositoryExtensions.get(workspaceName, ownerName, (_GetRequest[])WrapperUtils.unwrap(_GetRequest.class, requests), maxResults, options.toIntFlags(), itemAttributeFilters) : this.repository.get(workspaceName, ownerName, (_GetRequest[])WrapperUtils.unwrap(_GetRequest.class, requests), options.contains(GetOptions.GET_ALL), options.contains(GetOptions.PREVIEW), maxResults, options.toIntFlags())));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        GetOperation[][] operationsArrays = new GetOperation[arrayOfArrays.length][];
        for (int i = 0; i < arrayOfArrays.length; ++i) {
            if (arrayOfArrays[i] == null) continue;
            operationsArrays[i] = (GetOperation[])WrapperUtils.wrap(GetOperation.class, arrayOfArrays[i]);
        }
        return operationsArrays;
    }

    public ArtifactPropertyValue getChangesetProperty(int changesetId, String[] propertyNameFilters) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        try {
            return new ArtifactPropertyValue(this.repositoryExtensions.getChangesetProperty(changesetId, propertyNameFilters));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public RepositoryProperties getRepositoryProperties() {
        try {
            return new RepositoryProperties(this.repository.getRepositoryProperties());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ArtifactPropertyValue[] getVersionedItemProperty(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs, VersionSpec versionSpec, DeletedState deletedState, ItemType itemType, String[] propertyNameFilters) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        try {
            return (ArtifactPropertyValue[])WrapperUtils.wrap(ArtifactPropertyValue.class, this.repositoryExtensions.getVersionedItemProperty(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), versionSpec.getWebServiceObject(), deletedState.getWebServiceObject(), itemType.getWebServiceObject(), propertyNameFilters));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public LabelResult[] labelItem(String workspaceName, String workspaceOwner, VersionControlLabel label, LabelItemSpec[] labelSpecs, LabelChildOption children, AtomicReference<Failure[]> failures) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_LabelItemResponse response = this.repository5.labelItem(workspaceName, workspaceOwner, label.getWebServiceObject(), (_LabelItemSpec[])WrapperUtils.unwrap(_LabelItemSpec.class, labelSpecs), children.getWebServiceObject(), 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return (LabelResult[])WrapperUtils.wrap(LabelResult.class, response.getLabelItemResult());
            }
            _RepositorySoap_LabelItemResponse response = this.repository.labelItem(workspaceName, workspaceOwner, label.getWebServiceObject(), (_LabelItemSpec[])WrapperUtils.unwrap(_LabelItemSpec.class, labelSpecs), children.getWebServiceObject());
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            return (LabelResult[])WrapperUtils.wrap(LabelResult.class, response.getLabelItemResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public GetOperation[] merge(String workspaceName, String workspaceOwner, ItemSpec source, ItemSpec target, VersionSpec from, VersionSpec to, LockLevel lockLevel, MergeFlags mergeFlags, AtomicReference<Failure[]> failures, AtomicReference<Conflict[]> conflicts, String[] itemAttributeFilters, String[] itemPropertyFilters, AtomicReference<ChangePendedFlags> changePendedFlags) {
        if (null != itemPropertyFilters && itemPropertyFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        } else if (null != itemAttributeFilters && itemAttributeFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.AttributeOperationsNotSupported"));
        }
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_MergeResponse response = this.repository5.merge(workspaceName, workspaceOwner, source.getWebServiceObject(), target.getWebServiceObject(), from != null ? from.getWebServiceObject() : null, to != null ? to.getWebServiceObject() : null, lockLevel.getWebServiceObject(), mergeFlags.toIntFlags(), itemPropertyFilters, itemAttributeFilters, 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getMergeResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
                _Repository4Soap_MergeResponse response = this.repository4.merge(workspaceName, workspaceOwner, source.getWebServiceObject(), target.getWebServiceObject(), from != null ? from.getWebServiceObject() : null, to != null ? to.getWebServiceObject() : null, lockLevel.getWebServiceObject(), mergeFlags.toIntFlags(), itemPropertyFilters, itemAttributeFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getMergeResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
                _RepositoryExtensionsSoap_MergeResponse response = this.repositoryExtensions.merge(workspaceName, workspaceOwner, source.getWebServiceObject(), target.getWebServiceObject(), from != null ? from.getWebServiceObject() : null, to != null ? to.getWebServiceObject() : null, lockLevel.getWebServiceObject(), mergeFlags.toIntFlags(), itemPropertyFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getMergeResult());
            }
            _RepositorySoap_MergeResponse response = this.repository.merge(workspaceName, workspaceOwner, source.getWebServiceObject(), target.getWebServiceObject(), from != null ? from.getWebServiceObject() : null, to != null ? to.getWebServiceObject() : null, mergeFlags.toMergeOptions().getWebServiceObject(), lockLevel.getWebServiceObject(), mergeFlags.toIntFlags());
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
            changePendedFlags.set(ChangePendedFlags.UNKNOWN);
            return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getMergeResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public GetOperation[] pendChanges(String workspaceName, String ownerName, ChangeRequest[] changes, PendChangesOptions pendChangesOptions, SupportedFeatures supportedFeatures, AtomicReference<Failure[]> failures, String[] itemPropertyFilters, String[] itemAttributeFilters, boolean updateDisk, AtomicBoolean onlineOperation, AtomicReference<ChangePendedFlags> changePendedFlags) {
        if (null != itemPropertyFilters && itemPropertyFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        } else if (null != itemAttributeFilters && itemAttributeFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.AttributeOperationsNotSupported"));
        }
        if (null != changes && changes.length > 0 && changes[0].getRequestType().equals(RequestType.EDIT)) {
            this.playbackQueuedEdits(workspaceName, ownerName, changes);
        } else {
            this.playbackQueuedEdits(workspaceName, ownerName);
        }
        onlineOperation.set(true);
        Check.isTrue(!pendChangesOptions.contains(PendChangesOptions.FORCE_CHECK_OUT_LOCAL_VERSION) || !pendChangesOptions.contains(PendChangesOptions.GET_LATEST_ON_CHECKOUT), "Should never specify PendChangesOptions.FORCE_CHECK_OUT_LOCAL_VERSION and PendChangesOptions.GET_LATEST_ON_CHECKOUT simultaneously");
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_PendChangesResponse response = this.repository5.pendChanges(workspaceName, ownerName, (_ChangeRequest[])WrapperUtils.unwrap(_ChangeRequest.class, changes), pendChangesOptions.toIntFlags(), supportedFeatures.toIntFlags(), itemPropertyFilters, itemAttributeFilters, 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getPendChangesResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
                _Repository4Soap_PendChangesResponse response = this.repository4.pendChanges(workspaceName, ownerName, (_ChangeRequest[])WrapperUtils.unwrap(_ChangeRequest.class, changes), pendChangesOptions.toIntFlags(), supportedFeatures.toIntFlags(), itemPropertyFilters, itemAttributeFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getPendChangesResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
                _RepositoryExtensionsSoap_PendChangesResponse response = this.repositoryExtensions.pendChanges(workspaceName, ownerName, (_ChangeRequest[])WrapperUtils.unwrap(_ChangeRequest.class, changes), pendChangesOptions.toIntFlags(), supportedFeatures.toIntFlags(), itemAttributeFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getPendChangesResult());
            }
            _RepositorySoap_PendChangesResponse response = this.repository.pendChanges(workspaceName, ownerName, (_ChangeRequest[])WrapperUtils.unwrap(_ChangeRequest.class, changes), pendChangesOptions.toIntFlags(), supportedFeatures.toIntFlags());
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            changePendedFlags.set(ChangePendedFlags.UNKNOWN);
            return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getPendChangesResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Annotation[] queryAnnotation(String annotationName, String annotatedItem, int version) {
        try {
            return (Annotation[])WrapperUtils.wrap(Annotation.class, this.repository.queryAnnotation(annotationName, annotatedItem, version));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public _BranchRelative[][] queryBranches(String workspaceName, String workspaceOwner, ItemSpec[] items, VersionSpec version) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            return this.repository.queryBranches(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), version.getWebServiceObject());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public BranchObjectOwnership[] queryBranchObjectOwnership(int[] changesets, ItemSpec pathFilter) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.BranchObjectsNotSupported"));
        try {
            return (BranchObjectOwnership[])WrapperUtils.wrap(BranchObjectOwnership.class, this.repositoryExtensions.queryBranchObjectOwnership(changesets, pathFilter.getWebServiceObject()));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public BranchObject[] queryBranchObjects(ItemIdentifier item, RecursionType recursion) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.BranchObjectsNotSupported"));
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                return (BranchObject[])WrapperUtils.wrap(BranchObject.class, this.repository5.queryBranchObjects(item.getWebServiceObject(), recursion.getWebServiceObject(), 399));
            }
            return (BranchObject[])WrapperUtils.wrap(BranchObject.class, this.repositoryExtensions.queryBranchObjects(item.getWebServiceObject(), recursion.getWebServiceObject()));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Changeset queryChangeset(int changesetId, boolean includeChanges, boolean generateDownloadUrls, boolean includeSourceRenames) {
        try {
            return new Changeset(this.repository.queryChangeset(changesetId, includeChanges, generateDownloadUrls, includeSourceRenames));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Changeset queryChangesetExtended(int changesetId, boolean includeChanges, boolean generateDownloadUrls, String[] changesetPropertyFilters, String[] itemAttributeFilters, String[] itemPropertyFilters) {
        try {
            if (itemPropertyFilters != null && itemPropertyFilters.length > 0 || itemAttributeFilters != null && itemAttributeFilters.length > 0 || this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
                this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyChangesNotSupported"));
                return new Changeset(this.repository4.queryChangesetExtended(changesetId, includeChanges, generateDownloadUrls, changesetPropertyFilters, itemAttributeFilters, itemPropertyFilters));
            }
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.GetChangesWithPropertiesNotSupported"));
            if (changesetPropertyFilters == null) {
                changesetPropertyFilters = new String[]{};
            }
            return new Changeset(this.repositoryExtensions.queryChangesetExtended(changesetId, includeChanges, generateDownloadUrls, changesetPropertyFilters));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Change[] queryChangesForChangeset(int changesetId, boolean generateDownloadUrls, int pageSize, ItemSpec lastItem, String[] itemAttributeFilters, String[] itemPropertyFilters, boolean includeMergeSourceInfo) {
        this.requireSupportedFeature(SupportedFeatures.GET_CHANGES_FOR_CHANGESET, Messages.getString("WebServiceLayer.GetChangesForChangesetNotSupported"));
        if (null != itemPropertyFilters && itemPropertyFilters.length > 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        } else if (null != itemAttributeFilters && itemAttributeFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.AttributeOperationsNotSupported"));
        }
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
                return (Change[])WrapperUtils.wrap(Change.class, this.repository4.queryChangesForChangeset(changesetId, generateDownloadUrls, pageSize, lastItem != null ? lastItem.getWebServiceObject() : null, itemPropertyFilters, itemAttributeFilters, includeMergeSourceInfo));
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
                return (Change[])WrapperUtils.wrap(Change.class, this.repositoryExtensions.queryChangesForChangeset(changesetId, generateDownloadUrls, pageSize, lastItem != null ? lastItem.getWebServiceObject() : null, itemAttributeFilters, includeMergeSourceInfo));
            }
            return (Change[])WrapperUtils.wrap(Change.class, this.repository.queryChangesForChangeset(changesetId, generateDownloadUrls, pageSize, lastItem != null ? lastItem.getWebServiceObject() : null));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public CheckinNoteFieldDefinition[] queryCheckinNoteDefinition(String[] associatedServerItem) {
        try {
            return (CheckinNoteFieldDefinition[])WrapperUtils.wrap(CheckinNoteFieldDefinition.class, this.repository.queryCheckinNoteDefinition(associatedServerItem));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public String[] queryCheckinNoteFieldNames() {
        try {
            return this.repository.queryCheckinNoteFieldNames();
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Conflict[] queryConflicts(String workspaceName, String ownerName, ItemSpec[] items) {
        try {
            this.playbackQueuedEdits(workspaceName, ownerName);
            return (Conflict[])WrapperUtils.wrap(Conflict.class, this.repository.queryConflicts(workspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items)));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public String[] queryEffectiveGlobalPermissions(String identityName) {
        try {
            return this.repository.queryEffectiveGlobalPermissions(identityName);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public String[] queryEffectiveItemPermissions(String workspaceName, String workspaceOwner, String item, String identityName) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            return this.repository.queryEffectiveItemPermissions(workspaceName, workspaceOwner, item, identityName);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public FileType[] queryFileTypes() {
        try {
            return (FileType[])WrapperUtils.wrap(FileType.class, this.repository.queryFileTypes());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Changeset[] queryHistory(String workspaceName, String workspaceOwner, ItemSpec itemSpec, VersionSpec versionItem, String user, VersionSpec versionFrom, VersionSpec versionTo, int maxCount, boolean includeFiles, boolean generateDownloadUrls, boolean slotMode, boolean sortAscending) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            return (Changeset[])WrapperUtils.wrap(Changeset.class, this.repository.queryHistory(workspaceName, workspaceOwner, itemSpec.getWebServiceObject(), versionItem != null ? versionItem.getWebServiceObject() : null, user, versionFrom != null ? versionFrom.getWebServiceObject() : null, versionTo != null ? versionTo.getWebServiceObject() : null, maxCount, includeFiles, generateDownloadUrls, slotMode, sortAscending));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ItemSet[] queryItems(String workspaceName, String workspaceOwner, ItemSpec[] items, VersionSpec version, DeletedState deletedState, ItemType itemType, boolean generateDownloadUrls, GetItemsOptions options, String[] itemPropertyFilters, String[] itemAttributeFilters) {
        if (itemPropertyFilters != null && itemPropertyFilters.length > 0 || itemAttributeFilters != null && itemAttributeFilters.length > 0 || this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyChangesNotSupported"));
            try {
                return (ItemSet[])WrapperUtils.wrap(ItemSet.class, this.repository4.queryItems(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), version.getWebServiceObject(), deletedState.getWebServiceObject(), itemType.getWebServiceObject(), generateDownloadUrls, options.toIntFlags(), itemPropertyFilters, itemAttributeFilters));
            }
            catch (ProxyException e) {
                throw VersionControlExceptionMapper.map(e);
            }
        }
        try {
            return (ItemSet[])WrapperUtils.wrap(ItemSet.class, this.repository.queryItems(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), version.getWebServiceObject(), deletedState.getWebServiceObject(), itemType.getWebServiceObject(), generateDownloadUrls, options.toIntFlags()));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Item[] queryItemsByID(int[] itemIds, int changeSet, boolean generateDownloadUrls, GetItemsOptions options) {
        try {
            return (Item[])WrapperUtils.wrap(Item.class, this.repository.queryItemsById(itemIds, changeSet, generateDownloadUrls, options.toIntFlags()));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ExtendedItem[][] queryItemsExtended(String workspaceName, String workspaceOwner, ItemSpec[] items, DeletedState deletedState, ItemType itemType, GetItemsOptions options, String[] itemPropertyFilters) {
        _ExtendedItem[][] arrays;
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        if (itemPropertyFilters != null && itemPropertyFilters.length > 0 || this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyChangesNotSupported"));
            try {
                arrays = this.repository4.queryItemsExtended(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), deletedState.getWebServiceObject(), itemType.getWebServiceObject(), options.toIntFlags(), itemPropertyFilters);
            }
            catch (ProxyException e) {
                throw VersionControlExceptionMapper.map(e);
            }
        }
        try {
            arrays = this.repository.queryItemsExtended(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), deletedState.getWebServiceObject(), itemType.getWebServiceObject(), options.toIntFlags());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        if (arrays == null) {
            return new ExtendedItem[0][0];
        }
        ExtendedItem[][] ret = new ExtendedItem[arrays.length][];
        for (int i = 0; i < arrays.length; ++i) {
            if (arrays[i] == null) {
                ret[i] = new ExtendedItem[0];
                continue;
            }
            ret[i] = (ExtendedItem[])WrapperUtils.wrap(ExtendedItem.class, arrays[i]);
            Arrays.sort(ret[i]);
        }
        return ret;
    }

    public VersionControlLabel[] queryLabels(String workspaceName, String workspaceOwner, String labelName, String labelScope, String owner, String filterItem, VersionSpec versionFilterItem, boolean includeItems, boolean generateDownloadUrls) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                return (VersionControlLabel[])WrapperUtils.wrap(VersionControlLabel.class, this.repository5.queryLabels(workspaceName, workspaceOwner, labelName, labelScope, owner, filterItem, versionFilterItem != null ? versionFilterItem.getWebServiceObject() : new _LatestVersionSpec(), includeItems, generateDownloadUrls, 399));
            }
            return (VersionControlLabel[])WrapperUtils.wrap(VersionControlLabel.class, this.repository.queryLabels(workspaceName, workspaceOwner, labelName, labelScope, owner, filterItem, versionFilterItem != null ? versionFilterItem.getWebServiceObject() : new _LatestVersionSpec(), includeItems, generateDownloadUrls));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public LocalVersion[][] queryLocalVersions(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs) {
        _LocalVersion[][] arrays;
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.QueryLocalVersionsNotSupported"));
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        try {
            arrays = this.repository.queryLocalVersions(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        if (arrays == null) {
            return new LocalVersion[0][0];
        }
        LocalVersion[][] ret = new LocalVersion[arrays.length][];
        for (int i = 0; i < arrays.length; ++i) {
            ret[i] = arrays[i] == null ? new LocalVersion[0] : (LocalVersion[])WrapperUtils.wrap(LocalVersion.class, arrays[i]);
        }
        return ret;
    }

    public MergeCandidate[] queryMergeCandidates(String workspaceName, String workspaceOwner, ItemSpec source, ItemSpec target, MergeFlags mergeFlags) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                return (MergeCandidate[])WrapperUtils.wrap(MergeCandidate.class, this.repository5.queryMergeCandidates(workspaceName, workspaceOwner, source.getWebServiceObject(), target.getWebServiceObject(), mergeFlags.toIntFlags(), 399));
            }
            return (MergeCandidate[])WrapperUtils.wrap(MergeCandidate.class, this.repository.queryMergeCandidates(workspaceName, workspaceOwner, source.getWebServiceObject(), target.getWebServiceObject(), mergeFlags.toIntFlags()));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ItemIdentifier[] queryMergeRelationships(String serverItem) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.QueryMergeRelationshipsNotSupported"));
        try {
            return (ItemIdentifier[])WrapperUtils.wrap(ItemIdentifier.class, this.repositoryExtensions.queryMergeRelationships(serverItem));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ChangesetMerge[] queryMerges(String workspaceName, String workspaceOwner, ItemSpec source, VersionSpec versionSource, ItemSpec target, VersionSpec versionTarget, VersionSpec versionFrom, VersionSpec versionTo, int maxChangesets, boolean showAll, AtomicReference<Changeset[]> changesets) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            _RepositorySoap_QueryMergesResponse response = this.repository.queryMerges(workspaceName, workspaceOwner, source != null ? source.getWebServiceObject() : null, versionSource != null ? versionSource.getWebServiceObject() : null, target.getWebServiceObject(), versionTarget.getWebServiceObject(), versionFrom != null ? versionFrom.getWebServiceObject() : null, versionTo != null ? versionTo.getWebServiceObject() : null, maxChangesets, showAll);
            changesets.set((Changeset[])WrapperUtils.wrap(Changeset.class, response.getChangesets()));
            return (ChangesetMerge[])WrapperUtils.wrap(ChangesetMerge.class, response.getQueryMergesResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ExtendedMerge[] queryMergesExtended(String workspaceName, String workspaceOwner, ItemSpec target, VersionSpec versionTarget, VersionSpec versionFrom, VersionSpec versionTo, QueryMergesExtendedOptions options) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.ExtendedMergesNotSupported"));
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        try {
            return (ExtendedMerge[])WrapperUtils.wrap(ExtendedMerge.class, this.repositoryExtensions.queryMergesExtended(workspaceName, workspaceOwner, target.getWebServiceObject(), versionTarget.getWebServiceObject(), versionFrom != null ? versionFrom.getWebServiceObject() : null, versionTo != null ? versionTo.getWebServiceObject() : null, options.toIntFlags()));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ChangesetMergeDetails queryMergesWithDetails(String workspaceName, String workspaceOwner, ItemSpec source, VersionSpec versionSource, ItemSpec target, VersionSpec versionTarget, VersionSpec versionFrom, VersionSpec versionTo, int maxChangesets, boolean showAll) {
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        try {
            return new ChangesetMergeDetails(this.repository.queryMergesWithDetails(workspaceName, workspaceOwner, source != null ? source.getWebServiceObject() : null, versionSource != null ? versionSource.getWebServiceObject() : null, target.getWebServiceObject(), versionTarget.getWebServiceObject(), versionFrom != null ? versionFrom.getWebServiceObject() : null, versionTo != null ? versionTo.getWebServiceObject() : null, maxChangesets, showAll));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public PendingChange[] queryPendingChangesByID(int[] pendingChangeIds, boolean generateDownloadUrls) {
        try {
            return (PendingChange[])WrapperUtils.wrap(PendingChange.class, this.repository.queryPendingChangesById(pendingChangeIds, generateDownloadUrls));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public PendingChange[] queryPendingChangesForWorkspace(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs, boolean generateDownloadUrls, int pageSize, String lastChange, boolean includeMergeInfo, AtomicReference<Failure[]> failures, String[] itemPropertyFilters) {
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        if (itemPropertyFilters != null && itemPropertyFilters.length > 0 || this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyChangesNotSupported"));
            try {
                _Repository4Soap_QueryPendingChangesForWorkspaceResponse response = this.repository4.queryPendingChangesForWorkspace(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls, pageSize, lastChange, includeMergeInfo, itemPropertyFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return (PendingChange[])WrapperUtils.wrap(PendingChange.class, response.getQueryPendingChangesForWorkspaceResult());
            }
            catch (ProxyException e) {
                throw VersionControlExceptionMapper.map(e);
            }
        }
        try {
            _RepositoryExtensionsSoap_QueryPendingChangesForWorkspaceResponse response = this.repositoryExtensions.queryPendingChangesForWorkspace(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls, pageSize, lastChange, includeMergeInfo);
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            return (PendingChange[])WrapperUtils.wrap(PendingChange.class, response.getQueryPendingChangesForWorkspaceResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public PendingSet[] queryPendingSets(String localWorkspaceName, String localWorkspaceOwner, String queryWorkspaceName, String ownerName, ItemSpec[] itemSpecs, boolean generateDownloadUrls, AtomicReference<Failure[]> failures, boolean includeCandidates, String[] itemPropertyFilters) {
        PendingSet[] pendingSets;
        ElementDeserializable response;
        this.playbackQueuedEdits(localWorkspaceName, localWorkspaceOwner);
        this.playbackQueuedEdits(queryWorkspaceName, ownerName);
        if (itemPropertyFilters != null && itemPropertyFilters.length > 0 || this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyChangesNotSupported"));
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                response = this.repository5.queryPendingSets(localWorkspaceName, localWorkspaceOwner, queryWorkspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls, itemPropertyFilters, 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository5Soap_QueryPendingSetsResponse)response).getFailures()));
                pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, ((_Repository5Soap_QueryPendingSetsResponse)response).getQueryPendingSetsResult());
            } else {
                response = this.repository4.queryPendingSets(localWorkspaceName, localWorkspaceOwner, queryWorkspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls, itemPropertyFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository4Soap_QueryPendingSetsResponse)response).getFailures()));
                pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, ((_Repository4Soap_QueryPendingSetsResponse)response).getQueryPendingSetsResult());
            }
        } else {
            try {
                response = this.repository.queryPendingSets(localWorkspaceName, localWorkspaceOwner, queryWorkspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_RepositorySoap_QueryPendingSetsResponse)response).getFailures()));
                pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, ((_RepositorySoap_QueryPendingSetsResponse)response).getQueryPendingSetsResult());
            }
            catch (ProxyException e) {
                throw VersionControlExceptionMapper.map(e);
            }
        }
        for (PendingSet ps : pendingSets) {
            ps.setPendingSetDetails();
        }
        return pendingSets;
    }

    public GUID queryPendingChangeSignature(String workspaceName, String ownerName) {
        this.requireServiceLevel(WebServiceLevel.TFS_2012, Messages.getString("WebServiceLayer.LocalWorkspacesNotSupported"));
        try {
            return new GUID(this.repository4.queryPendingChangeSignature(workspaceName, ownerName));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public PendingSet[] queryShelvedChanges(String localWorkspaceName, String localWorkspaceOwner, String shelvesetName, String ownerName, ItemSpec[] itemSpecs, boolean generateDownloadUrls, AtomicReference<Failure[]> failures, String[] itemPropertyFilters) {
        PendingSet[] pendingSets;
        ElementDeserializable response;
        this.playbackQueuedEdits(localWorkspaceName, localWorkspaceOwner);
        if (itemPropertyFilters != null && itemPropertyFilters.length > 0 || this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
            try {
                response = this.repository4.queryShelvedChanges(localWorkspaceName, localWorkspaceOwner, shelvesetName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls, itemPropertyFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_Repository4Soap_QueryShelvedChangesResponse)response).getFailures()));
                pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, ((_Repository4Soap_QueryShelvedChangesResponse)response).getQueryShelvedChangesResult());
            }
            catch (ProxyException e) {
                throw VersionControlExceptionMapper.map(e);
            }
        }
        try {
            response = this.repository.queryShelvedChanges(localWorkspaceName, localWorkspaceOwner, shelvesetName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), generateDownloadUrls);
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, ((_RepositorySoap_QueryShelvedChangesResponse)response).getFailures()));
            pendingSets = (PendingSet[])WrapperUtils.wrap(PendingSet.class, ((_RepositorySoap_QueryShelvedChangesResponse)response).getQueryShelvedChangesResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        for (PendingSet ps : pendingSets) {
            ps.setPendingSetDetails();
        }
        return pendingSets;
    }

    public Shelveset[] queryShelvesets(String shelvesetName, String ownerName, String[] propertyNameFilters) {
        if (null != propertyNameFilters && propertyNameFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012, Messages.getString("WebServiceLayer.ShelvesetPropertyOperationsNotSupported"));
        }
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_1.getValue()) {
                return (Shelveset[])WrapperUtils.wrap(Shelveset.class, this.repository4.queryShelvesets(shelvesetName, ownerName, propertyNameFilters));
            }
            return (Shelveset[])WrapperUtils.wrap(Shelveset.class, this.repository.queryShelvesets(shelvesetName, ownerName));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Workspace queryWorkspace(String workspaceName, String ownerName) {
        this.playbackQueuedEdits(workspaceName, ownerName);
        _Workspace workspace = null;
        try {
            workspace = this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue() ? this.repository4.queryWorkspace(workspaceName, ownerName) : this.repository.queryWorkspace(workspaceName, ownerName);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        if (workspace == null) {
            return null;
        }
        return new Workspace(workspace, this.getVersionControlClient());
    }

    public Workspace[] queryWorkspaces(String ownerName, String computer, WorkspacePermissions permissionsFilter) {
        _Workspace[] workspaces = new _Workspace[]{};
        try {
            workspaces = this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue() ? this.repository4.queryWorkspaces(ownerName, computer, permissionsFilter.toIntFlags()) : this.repository.queryWorkspaces(ownerName, computer, permissionsFilter.toIntFlags());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        Workspace[] ret = new Workspace[workspaces.length];
        for (int i = 0; i < workspaces.length; ++i) {
            ret[i] = new Workspace(workspaces[i], this.getVersionControlClient());
        }
        return ret;
    }

    public WorkspaceItemSet[] queryWorkspaceItems(String workspaceName, String workspaceOwner, ItemSpec[] items, DeletedState deletedState, ItemType itemType, boolean generateDownloadUrls, int options) {
        this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.LocalWorkspacesNotSupported"));
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        try {
            Object[] itemSets = this.repository4.queryWorkspaceItems(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), deletedState.getWebServiceObject(), itemType.getWebServiceObject(), generateDownloadUrls, options);
            return (WorkspaceItemSet[])WrapperUtils.wrap(WorkspaceItemSet.class, itemSets);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ReconcileResult reconcileLocalWorkspace(String workspaceName, String ownerName, GUID pendingChangeSignature, LocalPendingChange[] pendingChanges, ServerItemLocalVersionUpdate[] localVersionUpdates, boolean clearLocalVersionTable, boolean throwOnProjectRenamed) {
        this.requireServiceLevel(WebServiceLevel.TFS_2012, Messages.getString("WebServiceLayer.LocalWorkspacesNotSupported"));
        try {
            this.playbackQueuedEdits(workspaceName, ownerName);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                return new ReconcileResult(this.repository5.reconcileLocalWorkspace(workspaceName, ownerName, pendingChangeSignature.getGUIDString(), (_LocalPendingChange[])WrapperUtils.unwrap(_LocalPendingChange.class, pendingChanges), (_ServerItemLocalVersionUpdate[])WrapperUtils.unwrap(_ServerItemLocalVersionUpdate.class, localVersionUpdates), clearLocalVersionTable, throwOnProjectRenamed, 399));
            }
            return new ReconcileResult(this.repository4.reconcileLocalWorkspace(workspaceName, ownerName, pendingChangeSignature.getGUIDString(), (_LocalPendingChange[])WrapperUtils.unwrap(_LocalPendingChange.class, pendingChanges), (_ServerItemLocalVersionUpdate[])WrapperUtils.unwrap(_ServerItemLocalVersionUpdate.class, localVersionUpdates), clearLocalVersionTable));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void refreshIdentityDisplayName() {
        try {
            this.repository.refreshIdentityDisplayName();
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void removeLocalConflicts(String workspaceName, String ownerName, List<Conflict> conflicts, ResolveErrorOptions errorOptions, ConflictResolvedHandler onResolvedConflict, ConflictResolveErrorHandler onResolveError) throws CoreCancelException {
        this.playbackQueuedEdits(workspaceName, ownerName);
        TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
        for (Conflict conflict : conflicts) {
            if (taskMonitor.isCanceled()) {
                throw new CoreCancelException();
            }
            try {
                this.repository.removeLocalConflict(workspaceName, ownerName, conflict.getConflictID());
                onResolvedConflict.conflictResolved(conflict, null, null, null, ChangePendedFlags.UNKNOWN);
            }
            catch (RuntimeException ex) {
                if (ex instanceof ProxyException) {
                    ex = VersionControlExceptionMapper.map(ex);
                }
                if (ResolveErrorOptions.THROW_ON_ERROR.equals(errorOptions)) {
                    throw ex;
                }
                onResolveError.conflictResolveError(conflict, ex);
            }
        }
    }

    public void resolve(String workspaceName, String ownerName, Conflict[] conflicts, String[] itemAttributeFilters, String[] itemPropertyFilters, ResolveErrorOptions errorOptions, ConflictResolvedHandler onResolvedConflict, ConflictResolveErrorHandler onResolveError) throws CoreCancelException {
        if (null != itemPropertyFilters && itemPropertyFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        } else if (null != itemAttributeFilters && itemAttributeFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.AttributeOperationsNotSupported"));
        }
        this.playbackQueuedEdits(workspaceName, ownerName);
        HashSet<Integer> previouslyResolved = new HashSet<Integer>();
        for (Conflict conflict : conflicts) {
            if (TaskMonitorService.getTaskMonitor().isCanceled()) {
                throw new CoreCancelException();
            }
            try {
                ChangePendedFlags flags;
                Conflict[] resolvedConflicts;
                GetOperation[] undoOps;
                GetOperation[] getOps;
                ElementDeserializable response;
                int acceptMergeEncoding;
                if (previouslyResolved.contains(conflict.getConflictID())) continue;
                String newPath = conflict.getResolutionOptions().getNewPath() == null ? null : ItemPath.smartNativeToTFS(conflict.getResolutionOptions().getNewPath());
                int n = acceptMergeEncoding = conflict.getResolutionOptions().getAcceptMergeEncoding() == null ? -2 : conflict.getResolutionOptions().getAcceptMergeEncoding().getCodePage();
                if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                    response = this.repository5.resolve(workspaceName, ownerName, conflict.getConflictID(), conflict.getResolution().getWebServiceObject(), newPath, acceptMergeEncoding, _LockLevel.Unchanged, (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, conflict.getResolutionOptions().getAcceptMergeProperties()), itemPropertyFilters, itemAttributeFilters, 399);
                    getOps = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_Repository5Soap_ResolveResponse)response).getResolveResult());
                    undoOps = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_Repository5Soap_ResolveResponse)response).getUndoOperations());
                    resolvedConflicts = (Conflict[])WrapperUtils.wrap(Conflict.class, ((_Repository5Soap_ResolveResponse)response).getResolvedConflicts());
                    flags = new ChangePendedFlags(((_Repository5Soap_ResolveResponse)response).getChangePendedFlags());
                } else if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
                    response = this.repository4.resolve(workspaceName, ownerName, conflict.getConflictID(), conflict.getResolution().getWebServiceObject(), newPath, acceptMergeEncoding, _LockLevel.Unchanged, (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, conflict.getResolutionOptions().getAcceptMergeProperties()), itemPropertyFilters, itemAttributeFilters);
                    getOps = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_Repository4Soap_ResolveResponse)response).getResolveResult());
                    undoOps = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_Repository4Soap_ResolveResponse)response).getUndoOperations());
                    resolvedConflicts = (Conflict[])WrapperUtils.wrap(Conflict.class, ((_Repository4Soap_ResolveResponse)response).getResolvedConflicts());
                    flags = new ChangePendedFlags(((_Repository4Soap_ResolveResponse)response).getChangePendedFlags());
                } else if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
                    response = this.repositoryExtensions.resolve(workspaceName, ownerName, conflict.getConflictID(), conflict.getResolution().getWebServiceObject(), newPath, acceptMergeEncoding, _LockLevel.Unchanged, itemAttributeFilters);
                    getOps = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_RepositoryExtensionsSoap_ResolveResponse)response).getResolveResult());
                    undoOps = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_RepositoryExtensionsSoap_ResolveResponse)response).getUndoOperations());
                    resolvedConflicts = (Conflict[])WrapperUtils.wrap(Conflict.class, ((_RepositoryExtensionsSoap_ResolveResponse)response).getResolvedConflicts());
                    flags = new ChangePendedFlags(((_RepositoryExtensionsSoap_ResolveResponse)response).getChangePendedFlags());
                } else {
                    response = this.repository.resolve(workspaceName, ownerName, conflict.getConflictID(), conflict.getResolution().getWebServiceObject(), newPath, acceptMergeEncoding, _LockLevel.Unchanged);
                    getOps = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_RepositorySoap_ResolveResponse)response).getResolveResult());
                    undoOps = (GetOperation[])WrapperUtils.wrap(GetOperation.class, ((_RepositorySoap_ResolveResponse)response).getUndoOperations());
                    resolvedConflicts = (Conflict[])WrapperUtils.wrap(Conflict.class, ((_RepositorySoap_ResolveResponse)response).getResolvedConflicts());
                    flags = ChangePendedFlags.UNKNOWN;
                }
                for (Conflict resolvedConflict : resolvedConflicts) {
                    previouslyResolved.add(resolvedConflict.getConflictID());
                }
                onResolvedConflict.conflictResolved(conflict, getOps, undoOps, resolvedConflicts, flags);
            }
            catch (RuntimeException ex) {
                if (ex instanceof ProxyException) {
                    ex = VersionControlExceptionMapper.map(ex);
                }
                if (ResolveErrorOptions.THROW_ON_ERROR.equals(errorOptions)) {
                    throw ex;
                }
                onResolveError.conflictResolveError(conflict, ex);
            }
        }
    }

    public void resetCheckinDates(Calendar lastCheckinDate) {
        this.requireSupportedFeature(SupportedFeatures.CHECKIN_DATES, Messages.getString("WebServiceLayer.CheckinDatesNotSupported"));
        try {
            this.repositoryExtensions.resetCheckinDates(lastCheckinDate);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public GetOperation[] rollback(String workspaceName, String workspaceOwner, ItemSpec[] items, VersionSpec itemVersion, VersionSpec from, VersionSpec to, RollbackOptions rollbackOptions, LockLevel lockLevel, AtomicReference<Conflict[]> conflicts, AtomicReference<Failure[]> failures, String[] itemAttributeFilters, String[] itemPropertyFilters, AtomicReference<ChangePendedFlags> changePendedFlags) {
        if (null != itemPropertyFilters && itemPropertyFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        }
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            if (this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_RollbackResponse response = this.repository5.rollback(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemVersion != null ? itemVersion.getWebServiceObject() : null, from.getWebServiceObject(), to.getWebServiceObject(), rollbackOptions.toIntFlags(), lockLevel.getWebServiceObject(), itemPropertyFilters, itemAttributeFilters, 399);
                conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getRollbackResult());
            }
            if (this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
                _Repository4Soap_RollbackResponse response = this.repository4.rollback(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemVersion != null ? itemVersion.getWebServiceObject() : null, from.getWebServiceObject(), to.getWebServiceObject(), rollbackOptions.toIntFlags(), lockLevel.getWebServiceObject(), itemPropertyFilters, itemAttributeFilters);
                conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getRollbackResult());
            }
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.RollbackNotSupported"));
            _RepositoryExtensionsSoap_RollbackResponse response = this.repositoryExtensions.rollback(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemVersion != null ? itemVersion.getWebServiceObject() : null, from.getWebServiceObject(), to.getWebServiceObject(), rollbackOptions.toIntFlags(), lockLevel.getWebServiceObject(), itemAttributeFilters);
            conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
            return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getRollbackResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void setChangesetProperty(int changesetId, PropertyValue[] propertyValues) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        try {
            this.repositoryExtensions.setChangesetProperty(changesetId, (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, propertyValues));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void setFileTypes(FileType[] fileTypes) {
        try {
            this.repository.setFileTypes((_FileType[])WrapperUtils.unwrap(_FileType.class, fileTypes));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Failure[] setPendingChangeProperty(String workspaceName, String workspaceOwner, ArtifactPropertyValue[] pendingChangePropertyValues) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        try {
            return (Failure[])WrapperUtils.wrap(Failure.class, this.repositoryExtensions.setPendingChangeProperty(workspaceName, workspaceOwner, (_ArtifactPropertyValue[])WrapperUtils.unwrap(_ArtifactPropertyValue.class, pendingChangePropertyValues)));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void setVersionedItemProperty(String workspaceName, String workspaceOwner, ItemSpec[] itemSpecs, VersionSpec versionSpec, DeletedState deletedState, ItemType itemType, PropertyValue[] propertyValues) {
        if (versionSpec == null && this.serviceLevel.getValue() < WebServiceLevel.TFS_2012_2.getValue()) {
            throw new NotSupportedException(Messages.getString("WebServiceLayer.UnversionedAttributesNotSupported"));
        }
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.AttributeOperationsNotSupported"));
        this.playbackQueuedEdits(workspaceName, workspaceOwner);
        try {
            this.repositoryExtensions.setVersionedItemProperty(workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, itemSpecs), versionSpec.getWebServiceObject(), deletedState.getWebServiceObject(), itemType.getWebServiceObject(), (_PropertyValue[])WrapperUtils.unwrap(PropertyValue.class, propertyValues));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Failure[] shelve(String workspaceName, String workspaceOwner, String[] serverItems, Shelveset shelveset, boolean replace) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            if (this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                return (Failure[])WrapperUtils.wrap(Failure.class, this.repository5.shelve(workspaceName, workspaceOwner, serverItems, shelveset.getWebServiceObject(), replace, 399));
            }
            return (Failure[])WrapperUtils.wrap(Failure.class, this.repository.shelve(workspaceName, workspaceOwner, serverItems, shelveset.getWebServiceObject(), replace));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ExtendedMerge[] trackMerges(int[] sourceChangesets, ItemIdentifier sourceItem, ItemIdentifier[] targetItems, ItemSpec pathFilter, AtomicReference<String[]> partialTargetItems) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.TrackMergesNotSupported"));
        try {
            _RepositoryExtensionsSoap_TrackMergesResponse response = this.repositoryExtensions.trackMerges(sourceChangesets, sourceItem.getWebServiceObject(), (_ItemIdentifier[])WrapperUtils.unwrap(_ItemIdentifier.class, targetItems), pathFilter.getWebServiceObject());
            partialTargetItems.set(response.getPartialTargetItems());
            return (ExtendedMerge[])WrapperUtils.wrap(ExtendedMerge.class, response.getTrackMergesResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public GetOperation[] undoPendingChanges(String workspaceName, String ownerName, ItemSpec[] items, AtomicReference<Failure[]> failures, String[] itemAttributeFilters, String[] itemPropertyFilters, AtomicBoolean onlineOperation, boolean deleteAdds, AtomicReference<ChangePendedFlags> changePendedFlags) {
        onlineOperation.set(true);
        if (null != itemPropertyFilters && itemPropertyFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        } else if (null != itemAttributeFilters && itemAttributeFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.AttributeOperationsNotSupported"));
        }
        try {
            this.playbackQueuedEdits(workspaceName, ownerName);
            if (this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_UndoPendingChangesResponse response = this.repository5.undoPendingChanges(workspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemPropertyFilters, itemAttributeFilters, 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getUndoPendingChangesResult());
            }
            if (this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_2.getValue()) {
                _Repository4Soap_UndoPendingChangesResponse response = this.repository4.undoPendingChanges(workspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemPropertyFilters, itemAttributeFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getUndoPendingChangesResult());
            }
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
                _RepositoryExtensionsSoap_UndoPendingChangesResponse response = this.repositoryExtensions.undoPendingChanges(workspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemAttributeFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getUndoPendingChangesResult());
            }
            _RepositorySoap_UndoPendingChangesResponse response = this.repository.undoPendingChanges(workspaceName, ownerName, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items));
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            changePendedFlags.set(ChangePendedFlags.UNKNOWN);
            return (GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getUndoPendingChangesResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public LabelResult[] unlabelItem(String workspaceName, String workspaceOwner, String labelName, String labelScope, ItemSpec[] items, VersionSpec version, AtomicReference<Failure[]> failures) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            if (this.serviceLevel.getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_UnlabelItemResponse response = this.repository5.unlabelItem(workspaceName, workspaceOwner, labelName, labelScope, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), version.getWebServiceObject(), 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                return (LabelResult[])WrapperUtils.wrap(LabelResult.class, response.getUnlabelItemResult());
            }
            _RepositorySoap_UnlabelItemResponse response = this.repository.unlabelItem(workspaceName, workspaceOwner, labelName, labelScope, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), version.getWebServiceObject());
            failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
            return (LabelResult[])WrapperUtils.wrap(LabelResult.class, response.getUnlabelItemResult());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Shelveset unshelve(String shelvesetName, String shelvesetOwner, String workspaceName, String workspaceOwner, ItemSpec[] items, String[] itemAttributeFilters, String[] itemPropertyFilters, String[] shelvesetPropertyFilters, boolean merge, AtomicReference<Failure[]> failures, AtomicReference<GetOperation[]> getOperations, AtomicReference<Conflict[]> conflicts, AtomicReference<ChangePendedFlags> changePendedFlags) {
        if (null != itemPropertyFilters && itemPropertyFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_2, Messages.getString("WebServiceLayer.PropertyOperationsNotSupported"));
        } else if (merge) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012, Messages.getString("WebServiceLayer.UnshelveWithMergeNotSupported"));
        } else if (null != shelvesetPropertyFilters && shelvesetPropertyFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012, Messages.getString("WebServiceLayer.ShelvesetPropertyOperationsNotSupported"));
        } else if (null != itemAttributeFilters && itemAttributeFilters.length != 0) {
            this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.AttributeOperationsNotSupported"));
        }
        _Shelveset shelveset = null;
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                _Repository5Soap_UnshelveResponse response = this.repository5.unshelve(shelvesetName, shelvesetOwner, workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemPropertyFilters, itemAttributeFilters, shelvesetPropertyFilters, merge, 399);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                getOperations.set((GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getGetOperations()));
                conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                shelveset = response.getUnshelveResult();
            } else if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                _Repository4Soap_UnshelveResponse response = this.repository4.unshelve(shelvesetName, shelvesetOwner, workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemPropertyFilters, itemAttributeFilters, shelvesetPropertyFilters, merge);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                getOperations.set((GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getGetOperations()));
                conflicts.set((Conflict[])WrapperUtils.wrap(Conflict.class, response.getConflicts()));
                changePendedFlags.set(new ChangePendedFlags(response.getChangePendedFlags()));
                shelveset = response.getUnshelveResult();
            } else if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
                _RepositoryExtensionsSoap_UnshelveResponse response = this.repositoryExtensions.unshelve(shelvesetName, shelvesetOwner, workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items), itemAttributeFilters);
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                getOperations.set((GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getGetOperations()));
                conflicts.set(new Conflict[0]);
                changePendedFlags.set(ChangePendedFlags.UNKNOWN);
                shelveset = response.getUnshelveResult();
            } else {
                _RepositorySoap_UnshelveResponse response = this.repository.unshelve(shelvesetName, shelvesetOwner, workspaceName, workspaceOwner, (_ItemSpec[])WrapperUtils.unwrap(_ItemSpec.class, items));
                failures.set((Failure[])WrapperUtils.wrap(Failure.class, response.getFailures()));
                getOperations.set((GetOperation[])WrapperUtils.wrap(GetOperation.class, response.getGetOperations()));
                conflicts.set(new Conflict[0]);
                changePendedFlags.set(ChangePendedFlags.UNKNOWN);
                shelveset = response.getUnshelveResult();
            }
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
        if (shelveset == null) {
            return null;
        }
        return new Shelveset(shelveset);
    }

    public void updateBranchObject(BranchProperties branchProperties, boolean updateExisting) {
        this.requireServiceLevel(WebServiceLevel.TFS_2010, Messages.getString("WebServiceLayer.BranchObjectsNotSupported"));
        try {
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                this.repository5.updateBranchObject(branchProperties.getWebServiceObject(), updateExisting, 399);
            } else {
                this.repositoryExtensions.updateBranchObject(branchProperties.getWebServiceObject(), updateExisting);
            }
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void updateChangeset(int changeset, String comment, CheckinNote checkinNote) {
        try {
            this.repository.updateChangeset(changeset, comment, checkinNote.getWebServiceObject());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void updateCheckinNoteFieldName(String path, String existingFieldName, String newFieldName) {
        try {
            this.repository.updateCheckinNoteFieldName(path, existingFieldName, newFieldName);
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void updateLocalVersion(String workspaceName, String ownerName, LocalVersionUpdate[] updates) {
        try {
            this.playbackQueuedEdits(workspaceName, ownerName);
            this.repository.updateLocalVersion(workspaceName, ownerName, (_LocalVersionUpdate[])WrapperUtils.unwrap(_LocalVersionUpdate.class, updates));
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void updateLocalVersion(String workspaceName, String ownerName, ServerItemLocalVersionUpdate[] updates) {
        this.requireServiceLevel(WebServiceLevel.TFS_2012, Messages.getString("WebServiceLayer.LocalWorkspacesNotSupported"));
        try {
            this.playbackQueuedEdits(workspaceName, ownerName);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                this.repository5.updateLocalVersion(workspaceName, ownerName, (_ServerItemLocalVersionUpdate[])WrapperUtils.unwrap(_ServerItemLocalVersionUpdate.class, updates), 399);
            } else {
                this.repository4.updateLocalVersion(workspaceName, ownerName, (_ServerItemLocalVersionUpdate[])WrapperUtils.unwrap(_ServerItemLocalVersionUpdate.class, updates));
            }
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void updateLocalVersion(String workspaceName, String ownerName, ILocalVersionUpdate[] updates) {
        ArrayList<ServerItemLocalVersionUpdate> serverItemUpdates = new ArrayList<ServerItemLocalVersionUpdate>();
        ArrayList<LocalVersionUpdate> localVersionUpdates = new ArrayList<LocalVersionUpdate>();
        for (ILocalVersionUpdate update : updates) {
            if (!update.isSendToServer()) continue;
            if (update.getSourceServerItem() != null && update.getSourceServerItem().length() > 0 && this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012.getValue()) {
                serverItemUpdates.add(new ServerItemLocalVersionUpdate(update));
                continue;
            }
            localVersionUpdates.add(new LocalVersionUpdate(update));
        }
        if (localVersionUpdates.size() > 0) {
            this.updateLocalVersion(workspaceName, ownerName, localVersionUpdates.toArray(new LocalVersionUpdate[localVersionUpdates.size()]));
        }
        if (serverItemUpdates.size() > 0) {
            this.updateLocalVersion(workspaceName, ownerName, serverItemUpdates.toArray(new ServerItemLocalVersionUpdate[serverItemUpdates.size()]));
        }
    }

    public void updatePendingState(String workspaceName, String workspaceOwner, PendingState[] updates) {
        try {
            this.playbackQueuedEdits(workspaceName, workspaceOwner);
            if (this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2012_QU1.getValue()) {
                this.repository5.updatePendingState(workspaceName, workspaceOwner, (_PendingState[])WrapperUtils.unwrap(_PendingState.class, updates), 399);
            } else {
                this.repository.updatePendingState(workspaceName, workspaceOwner, (_PendingState[])WrapperUtils.unwrap(_PendingState.class, updates));
            }
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void updateShelveset(String shelvesetName, String shelvesetOwner, Shelveset updatedShelveset) {
        this.requireServiceLevel(WebServiceLevel.TFS_2012_1, Messages.getString("WebServiceLayer.ShelvesetPropertyOperationsNotSupported"));
        try {
            this.repository4.updateShelveset(shelvesetName, shelvesetOwner, updatedShelveset.getWebServiceObject());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public Workspace updateWorkspace(String oldWorkspaceName, String ownerName, Workspace newWorkspace, SupportedFeatures supportedFeatures) {
        this.playbackQueuedEdits(oldWorkspaceName, ownerName);
        if (this.getServiceLevel() == WebServiceLevel.PRE_TFS_2010) {
            boolean hasOneLevelMappings = false;
            for (WorkingFolder folder : newWorkspace.getFolders()) {
                if (folder.getDepth() != RecursionType.ONE_LEVEL) continue;
                hasOneLevelMappings = true;
                break;
            }
            if (hasOneLevelMappings) {
                this.requireSupportedFeature(SupportedFeatures.ONE_LEVEL_MAPPING, Messages.getString("WebServiceLayer.DepthOneMappingsNotSupported"));
            }
        }
        if (newWorkspace.getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN)) {
            this.requireServiceLevel(WebServiceLevel.TFS_2012_1, Messages.getString("WebServiceLayer.SetFileTimeNotSupported"));
        }
        try {
            return new Workspace(this.repository.updateWorkspace(oldWorkspaceName, ownerName, newWorkspace.getWebServiceObject(), supportedFeatures.toIntFlags()), this.getVersionControlClient());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public ServerSettings getServerSettings() {
        if (this.getServiceLevel().getValue() < WebServiceLevel.TFS_2012_1.getValue()) {
            return null;
        }
        try {
            return new ServerSettings(this.repository4.getServerSettings());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public void setServerSettings(ServerSettings settings) {
        this.requireServiceLevel(WebServiceLevel.TFS_2012, Messages.getString("WebServiceLayer.ServerSettingsNotSupported"));
        Check.notNull(settings, "settings");
        try {
            this.repository4.setServerSettings(settings.getWebServiceObject());
        }
        catch (ProxyException e) {
            throw VersionControlExceptionMapper.map(e);
        }
    }

    public PendingChange[] queryServerPendingChanges(Workspace workspace, String[] itemPropertyFilters) {
        return this.queryServerPendingChanges(workspace, new ItemSpec[]{new ItemSpec("$/", RecursionType.FULL)}, false, itemPropertyFilters);
    }

    public abstract PendingChange[] queryServerPendingChanges(Workspace var1, ItemSpec[] var2, boolean var3, String[] var4);

    public abstract PendingChange[] queryServerPendingChanges(Workspace var1, AtomicReference<GUID> var2);

    public abstract Workspace queryServerWorkspace(String var1, String var2);

    public abstract Workspace updateWorkspaceNoReconcile(String var1, String var2, Workspace var3, SupportedFeatures var4);

    protected Workspace getWorkspace(String workspaceName, String ownerName) {
        Workspace workspace = null;
        if (!StringUtil.isNullOrEmpty(workspaceName) && !StringUtil.isNullOrEmpty(ownerName)) {
            VersionControlClient client = this.getVersionControlClient();
            if (!ownerName.equals(".")) {
                workspace = this.runtimeWorkspaceCache.tryGetWorkspace(workspaceName, ownerName);
            }
            if (null == workspace) {
                WorkspaceInfo info = null;
                Workstation workstation = Workstation.getCurrent(client.getConnection().getPersistenceStoreProvider());
                if (!ownerName.equals(".")) {
                    info = workstation.getLocalWorkspaceInfo(client.getServerGUID(), workspaceName, ownerName);
                } else {
                    WorkspaceInfo[] matching = workstation.queryLocalWorkspaceInfo(client, workspaceName, null);
                    if (matching.length == 1) {
                        info = matching[0];
                    }
                }
                if (info != null) {
                    workspace = this.runtimeWorkspaceCache.getWorkspace(info);
                }
            }
        }
        return workspace;
    }

    protected Workspace getServerWorkspace(String workspaceName, String ownerName) {
        Workspace workspace = this.getWorkspace(workspaceName, ownerName);
        if (null != workspace && WorkspaceLocation.SERVER == workspace.getLocation() && workspace.isLocal()) {
            return workspace;
        }
        return null;
    }

    private void playbackQueuedEdits(String workspaceName, String ownerName) {
        this.playbackQueuedEdits(workspaceName, ownerName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playbackQueuedEdits(String workspaceName, String ownerName, ChangeRequest[] changeRequests) {
        block14: {
            Workspace workspace = this.getServerWorkspace(workspaceName, ownerName);
            Boolean playingBack = playingBackQueuedEdits.get();
            if (null != workspace && this.getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue() && null != workspace.getSecurityToken() && null != playingBack && !playingBack.booleanValue()) {
                playingBackQueuedEdits.set(true);
                try {
                    PersistenceStoreProvider provider = workspace.getClient().getConnection().getPersistenceStoreProvider();
                    String path = LocalPath.combine(workspace.getWorkspaceDirectory(Workstation.getConfigurationDirectory(provider).getAbsolutePath()), "queuededits");
                    File slotOne = new File(LocalMetadataTable.getSlotOnePath(path));
                    File slotTwo = new File(LocalMetadataTable.getSlotTwoPath(path));
                    if (!slotOne.exists() && !slotTwo.exists()) {
                        return;
                    }
                    try {
                        QueuedEditsTable qe = new QueuedEditsTable(path);
                        TreeSet<String> queuedEdits = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                        for (String queuedEdit : qe.getQueuedEdits()) {
                            queuedEdits.add(queuedEdit);
                        }
                        qe.close();
                        if (null != changeRequests) {
                            for (ChangeRequest request : changeRequests) {
                                if (null == request.getItemSpec() || null == request.getItemSpec().getItem()) continue;
                                queuedEdits.remove(request.getItemSpec().getItem());
                            }
                        }
                        if (queuedEdits.size() <= 0) break block14;
                        boolean removeQueuedEdits = false;
                        String[] queuedEditStrings = queuedEdits.toArray(new String[queuedEdits.size()]);
                        try {
                            workspace.pendEdit(queuedEditStrings, RecursionType.NONE, LockLevel.UNCHANGED, null, GetOptions.NONE, PendChangesOptions.FORCE_CHECK_OUT_LOCAL_VERSION);
                            removeQueuedEdits = true;
                        }
                        catch (Exception ex) {
                            this.client.getEventEngine().fireNonFatalError(new NonFatalErrorEvent(EventSource.newFromHere(), workspace, (Throwable)ex));
                            removeQueuedEdits = true;
                        }
                        if (removeQueuedEdits) {
                            qe = new QueuedEditsTable(path);
                            qe.RemoveQueuedEdits(queuedEdits);
                            qe.close();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                finally {
                    playingBackQueuedEdits.set(false);
                }
            }
        }
    }
}

