/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.httpclient;

import com.microsoft.tfs.core.config.EnvironmentVariables;
import com.microsoft.tfs.core.httpclient.HttpException;
import com.microsoft.tfs.core.httpclient.methods.multipart.FilePart;
import com.microsoft.tfs.core.httpclient.methods.multipart.PartSource;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CancellableFilePart
extends FilePart {
    private static final Log logger = LogFactory.getLog(CancellableFilePart.class);
    protected static final int DEFAULT_BUFFER_SIZE = 65536;
    protected static final int BUFFER_SIZE = CancellableFilePart.getBufferSize();

    public CancellableFilePart(String name, PartSource partSource) {
        super(name, partSource);
    }

    public CancellableFilePart(String name, File file) throws FileNotFoundException {
        super(name, file);
    }

    public CancellableFilePart(String name, String fileName, File file) throws FileNotFoundException {
        super(name, fileName, file);
    }

    public CancellableFilePart(String name, PartSource partSource, String contentType, String charset) {
        super(name, partSource, contentType, charset);
    }

    public CancellableFilePart(String name, File file, String contentType, String charset) throws FileNotFoundException {
        super(name, file, contentType, charset);
    }

    public CancellableFilePart(String name, String fileName, File file, String contentType, String charset) throws FileNotFoundException {
        super(name, fileName, file, contentType, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendData(OutputStream out) throws IOException {
        if (this.lengthOfData() == 0L) {
            return;
        }
        TaskMonitor monitor = TaskMonitorService.getTaskMonitor();
        byte[] tmp = new byte[BUFFER_SIZE];
        InputStream instream = this.getSource().createInputStream();
        try {
            int len;
            monitor.begin("", 0);
            while ((len = instream.read(tmp)) >= 0) {
                if (monitor.isCanceled()) {
                    throw new SendDataCancellationException();
                }
                out.write(tmp, 0, len);
                monitor.worked(len);
            }
            monitor.done();
        }
        finally {
            instream.close();
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    protected static int getBufferSize() {
        int bufferSize = EnvironmentVariables.getInt("TF_UPLOAD_BUFFER_SIZE", 65536);
        if (bufferSize > 0) {
            return bufferSize;
        }
        logger.warn((Object)"Wrong buffer size defined. Continue using the default value 65536");
        return 65536;
    }

    public static final class SendDataCancellationException
    extends HttpException {
    }
}

