/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.localworkspace;

import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.LocalItemExclusionEvaluator;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import java.util.Set;
import java.util.TreeSet;

public class PathWatcherReport {
    private boolean fullyInvalidated;
    private final Set<String> changedPaths;
    private static int MAX_CHANGED_PATHS = 128;

    public PathWatcherReport(boolean initiallyInvalidated) {
        this.fullyInvalidated = initiallyInvalidated;
        this.changedPaths = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    public boolean addChangedPath(String path) {
        boolean added = true;
        if (!this.fullyInvalidated && (added = this.changedPaths.add(path)) && this.changedPaths.size() > MAX_CHANGED_PATHS) {
            this.fullyInvalidate();
        }
        if (LocaleInvariantStringHelpers.caseInsensitiveEndsWith(path, LocalItemExclusionEvaluator.IGNORE_FILE_NAME_WITH_SEPARATOR_PREFIX)) {
            added = true;
            this.fullyInvalidate();
        }
        return added;
    }

    public void fullyInvalidate() {
        this.fullyInvalidated = true;
        this.changedPaths.clear();
    }

    public void unionWith(PathWatcherReport otherReport) {
        if (!this.fullyInvalidated) {
            if (otherReport.fullyInvalidated) {
                this.fullyInvalidate();
            } else {
                for (String path : otherReport.changedPaths) {
                    this.addChangedPath(path);
                    if (!this.fullyInvalidated) continue;
                    break;
                }
            }
        }
    }

    public boolean getFullyInvalidated() {
        return this.fullyInvalidated;
    }

    public boolean isNothingChanged() {
        return !this.fullyInvalidated && this.changedPaths.size() == 0;
    }

    public Iterable<String> getChangedPaths() {
        return this.changedPaths;
    }
}

